<%
' Text Based SMS Protocol
'
' Copyright (C) 2008, D&SOFT
' help@coolsms.co.kr

function tbsp_parse(tbspstr)
	dim property
	dim tbsparr
	dim line
	dim element
	dim key
	dim value

	set property = CreateObject("Scripting.Dictionary")
	
	tbsparr = split(tbspstr, vbLf, -1, 1)

	for each line in tbsparr
		element = split(line, ":", -1, 1)
		if UBound(element, 1) < 1 then
			exit for
		end if
		key = element(0)
		value = element(1)

		if key = "MESSAGE" then
			if property.Exists(key) then
				dim tmpstr
				tmpstr = property.Item(key)
				property.Remove key
				property.Add key, tmpstr & vbLf & value
			else
				property.Add key, value
			end if
		else
			property.Add key, value
		end if
	next

	set tbsp_parse = property
end function

function tbsp_build(tbsp)
	dim tbspstr
	dim key
	dim value
	dim msgarr
	dim line

	for each key in tbsp
		value = tbsp.Item(key)

		if key = "MESSAGE" then
			msgarr = split(value, vbLf, -1, 1)
			for each line in msgarr
				tbspstr = tbspstr & key & ":" & line & vbLf
			next
		else
			tbspstr = tbspstr & key & ":" & value & vbLf
		end if
	next
	tbsp_build = tbspstr
end function

dim CSCP_VERSION_SIZE
dim CSCP_BODYLEN_SIZE
CSCP_VERSION_SIZE = 7
CSCP_BODYLEN_SIZE = 6

function cscp_read(sock)
	dim version
	dim bodylen
	dim body

	version = sock.GetText(CSCP_VERSION_SIZE)
	bodylen = sock.GetText(CSCP_BODYLEN_SIZE)
	if IsNumeric(bodylen) then
		bodylen = cint(bodylen)
	else
		bodylen = 0
	end if
	body = ""
	if bodylen > 0 then
		body = sock.GetText(bodylen)
	end if
	cscp_read = body
end function

Function paddigits(n, totalDigits) 
	paddigits = Right(string(totalDigits,"0") & cstr(n), totalDigits) 
End Function 

function multibytes_length(s)
	dim pos, ch, length

	length = 0
	pos = 1

	do while (pos <= len(s))
		ch = asc(mid(s, pos, 1))
		if ch < 0 then
			length = length + 2
		else
			length = length + 1
		end if

		pos = pos + 1
	loop

	multibytes_length = length
end function

function cscp_build(cscpstr)
	dim capsule
	capsule = "CSCP1.0"
	capsule = capsule & paddigits(multibytes_length(cscpstr), 6)
	capsule = capsule & cscpstr

	cscp_build = capsule
end function
%>
