// MyStaticView.cpp : implementation file
//

#include "stdafx.h"
#include "CamPlayer.h"
#include "MyStaticView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyStaticView

CMyStaticView::CMyStaticView()
{
	m_pDrawImage = NULL;
	m_bStart = TRUE;
}

CMyStaticView::~CMyStaticView()
{
}


BEGIN_MESSAGE_MAP(CMyStaticView, CStatic)
	//{{AFX_MSG_MAP (CMyStaticView)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyStaticView message handlers

void  CMyStaticView::FillBitmap_Info( BITMAPINFO* bmi, int width, int height, int bpp )
{

    BITMAPINFOHEADER* bmih = &(bmi->bmiHeader);

    memset( bmih, 0, sizeof(*bmih));
    bmih->biSize   = sizeof(BITMAPINFOHEADER); 
    bmih->biWidth  = width;
    bmih->biHeight = -abs(height);
    bmih->biPlanes = 1; 
    bmih->biBitCount = bpp;
    bmih->biCompression = BI_RGB;

    if( bpp == 8 )
    {
        RGBQUAD* palette = bmi->bmiColors;
        int i;
        for( i = 0; i < 256; i++ )
        {
            palette[i].rgbBlue = palette[i].rgbGreen = palette[i].rgbRed = (BYTE)i;
            palette[i].rgbReserved = 0;
        }
    }
}


//////////////////////////////////////////////////////////////////////////
// ũ ̹ 
//////////////////////////////////////////////////////////////////////////

void CMyStaticView::Show_Image( IplImage * src, HDC dc, int x, int y, int w, int h,
                 int from_x, int from_y )
{
    if( src->width > 0 )
    {
        uchar buffer[sizeof(BITMAPINFOHEADER) + 1024];
        BITMAPINFO* bmi = (BITMAPINFO*)buffer;
        int bmp_w = src->width;
        int bmp_h = src->height;

        FillBitmap_Info( bmi, bmp_w, bmp_h, src->nChannels*8 );

        int sw = MAX( MIN( bmp_w - from_x, w ), 0 );
        int sh = MAX( MIN( bmp_h - from_y, h ), 0 );

        int res = SetDIBitsToDevice(
              dc,                        // handle to DC
              x,                         // x-coord of destination upper-left corner
              y,                         // y-coord of destination upper-left corner 
              sw,                        // source rectangle width
              sh,                        // source rectangle height
              from_x,                    // x-coord of source lower-left corner
              from_y,                    // y-coord of source lower-left corner
              from_y,                    // first scan line in array
              sh,                        // number of scan lines
              src->imageData + from_y*src->widthStep, // array of DIB bits
              (BITMAPINFO*)bmi,          // bitmap information
              DIB_RGB_COLORS );          // RGB or palette indexes
    }
}

void CMyStaticView::ImageDraw()
{
	IplImage *pTemp = m_pDrawImage;
	IplImage *pMainImage = NULL;

	cvFlip(pTemp,pTemp);

	CRect rect;
	GetClientRect(&rect);		
	pMainImage = ImageResize(pTemp,rect.Width(),rect.Height());

	cvRectangle(pMainImage,cvPoint(0,0),cvPoint(pMainImage->width-1,pMainImage->height-1),CV_RGB(100,100,100),1);
	cvRectangle(pMainImage,cvPoint(2,2),cvPoint(pMainImage->width-3,pMainImage->height-3),CV_RGB(200,200,200),1);
	
	CDC *pDC = GetDC();
	Show_Image(
		pMainImage,	pDC->m_hDC,			// ̹ ü , device context
		(rect.Width() - pMainImage->width)/2,	// ̹  width
		(rect.Height() - pMainImage->height)/2,	// ̹  height
		rect.right,								// ̹   ġ xǥ
		rect.bottom,							// ̹   ġ yǥ
		0,0);									// ǥ ̹   ġ

	ReleaseDC(pDC);
	cvReleaseImage(&pMainImage);
}

IplImage * CMyStaticView::ImageResize(IplImage *pInput,int width,int height)
{
	IplImage *pOutput;
	
	if(pInput->width > width || pInput->height > height)
	{
		if(((float)pInput->width/(float)width) < ((float)pInput->height/(float)height) )
		{
			float fMul = (float)pInput->height/(float)height;
			pOutput = cvCreateImage(
				cvSize((int)((float)pInput->width/fMul),(int)((float)pInput->height/fMul)),
				pInput->depth,pInput->nChannels);
			cvResize(pInput,pOutput,CV_INTER_LINEAR);
		}
		else
		{
			float fMul = (float)pInput->width/(float)width;
			pOutput = cvCreateImage(
				cvSize((int)((float)pInput->width/fMul),(int)((float)pInput->height/fMul)),
				pInput->depth,pInput->nChannels);
			cvResize(pInput,pOutput,CV_INTER_LINEAR);
		}
		return pOutput;
	}
	
	pOutput = (IplImage *)cvClone(pInput);
	return pOutput;
}

void CMyStaticView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CRect rect;
	GetClientRect(&rect);
	CBrush brush;
	brush.CreateSolidBrush(RGB(255,255,255));

	if(m_bStart == TRUE)
		FillRect(dc.m_hDC,&rect,brush);

	if(m_pDrawImage == NULL)
		return;

	ImageDraw();
	
	cvReleaseImage(&m_pDrawImage);
	m_pDrawImage = NULL;
}

void CMyStaticView::MainImageCopy(IplImage *image)
{
	if(m_pDrawImage != NULL)
		cvReleaseImage(&m_pDrawImage);
	m_pDrawImage = (IplImage *)cvClone(image);
}
