/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.dom4j;

import com.sun.xml.messaging.saaj.soap.Envelope;
import com.sun.xml.messaging.saaj.soap.dom4j.BodyImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.ElementImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.HeaderImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.NameImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.transform.Source;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class EnvelopeImpl
extends ElementImpl
implements Envelope {
    HeaderImpl header;
    BodyImpl body;

    public EnvelopeImpl() throws SOAPException {
        super(NameImpl.createEnvelopeName());
    }

    EnvelopeImpl(boolean createHeader, boolean createBody) throws SOAPException {
        this();
        if (createHeader) {
            this.addHeader();
        }
        if (createBody) {
            this.addBody();
        }
    }

    public SOAPHeader addHeader() throws SOAPException {
        NameImpl headerName = NameImpl.createHeaderName();
        HeaderImpl hdr = (HeaderImpl)this.element(headerName);
        if (hdr == null) {
            SOAPBody bdy = this.getBody();
            if (bdy != null) {
                bdy.detachNode();
            }
            this.header = (HeaderImpl)this.addChildElement(headerName);
            if (bdy != null) {
                this.add((Element)bdy);
            }
        } else {
            throw new SOAPException("Can't add a header when one is already present.");
        }
        return this.header;
    }

    protected void initializeHeader() throws SOAPException {
        HeaderImpl hdr;
        NameImpl headerName = NameImpl.createHeaderName();
        this.header = hdr = (HeaderImpl)this.element(headerName);
    }

    public SOAPHeader getHeader() throws SOAPException {
        this.initializeHeader();
        return this.header;
    }

    protected void initializeBody() throws SOAPException {
        BodyImpl bdy;
        NameImpl bodyName = NameImpl.createBodyName();
        this.body = bdy = (BodyImpl)this.element(bodyName);
    }

    public SOAPBody addBody() throws SOAPException {
        NameImpl bodyName = NameImpl.createBodyName();
        BodyImpl bdy = (BodyImpl)this.element(bodyName);
        if (bdy != null) {
            throw new SOAPException("Can't add a body when one is already present.");
        }
        this.body = (BodyImpl)this.addChildElement(bodyName);
        return this.body;
    }

    public SOAPBody getBody() throws SOAPException {
        this.initializeBody();
        return this.body;
    }

    void initDocument() {
        this.setDocument(this.getDocumentFactory().createDocument((Element)this));
    }

    public Source getContent() {
        if (this.getDocument() == null) {
            this.initDocument();
        }
        return new DocumentSource(this.getDocument());
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return NameImpl.create(localName, Namespace.get((String)prefix, (String)uri));
    }

    public Name createName(String localName, String prefix) throws SOAPException {
        Namespace ns = this.getNamespaceForPrefix(prefix);
        if (ns == null) {
            throw new SOAPException("Unable to locate namespace for prefix " + prefix);
        }
        return NameImpl.create(localName, ns);
    }

    public Name createName(String localName) throws SOAPException {
        return NameImpl.create(localName);
    }

    public void output(OutputStream out) throws IOException {
        if (this.getDocument() == null) {
            this.initDocument();
        }
        OutputFormat format = new OutputFormat();
        XMLWriter writer = new XMLWriter(out, format);
        writer.write(this.getDocument());
    }

    public void prettyPrint(OutputStream out) throws IOException {
        if (this.getDocument() == null) {
            this.initDocument();
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndentSize(2);
        format.setNewlines(true);
        format.setTrimText(true);
        format.setPadText(true);
        format.setExpandEmptyElements(false);
        XMLWriter writer = new XMLWriter(out, format);
        writer.write(this.getDocument());
    }

    public void prettyPrint(Writer out) throws IOException {
        if (this.getDocument() == null) {
            this.initDocument();
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndentSize(2);
        format.setNewlines(true);
        format.setTrimText(true);
        format.setPadText(true);
        format.setExpandEmptyElements(false);
        XMLWriter writer = new XMLWriter(out, format);
        writer.write(this.getDocument());
    }
}

