/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)X509SubjectNameResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineLookupResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can I resolve " + element.getTagName() + "?"));
        }
        Element[] x509childNodes = null;
        XMLX509SubjectName[] x509childObject = null;
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.debug((Object)"I can't");
            return null;
        }
        x509childNodes = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SubjectName");
        if (x509childNodes == null || x509childNodes.length <= 0) {
            log.debug((Object)"I can't");
            return null;
        }
        try {
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509SubjectName"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                log.info((Object)"", (Throwable)ex);
                throw ex;
            }
            x509childObject = new XMLX509SubjectName[x509childNodes.length];
            int i = 0;
            while (i < x509childNodes.length) {
                x509childObject[i] = new XMLX509SubjectName(x509childNodes[i], BaseURI);
                ++i;
            }
            while (storage.hasNext()) {
                X509Certificate cert = storage.next();
                XMLX509SubjectName certSN = new XMLX509SubjectName(element.getOwnerDocument(), cert);
                log.debug((Object)("Found Certificate SN: " + certSN.getSubjectName()));
                int i2 = 0;
                while (i2 < x509childObject.length) {
                    log.debug((Object)("Found Element SN:     " + x509childObject[i2].getSubjectName()));
                    if (certSN.equals(x509childObject[i2])) {
                        log.debug((Object)"match !!! ");
                        return cert;
                    }
                    log.debug((Object)"no match...");
                    ++i2;
                }
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            log.debug((Object)"XMLSecurityException", (Throwable)ex);
            throw new KeyResolverException("generic.EmptyMessage", ex);
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

