/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.MissingResourceFailureException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Manifest
extends SignatureElementProxy {
    static Log log = LogFactory.getLog((String)Manifest.class.getName());
    List _references;
    Element[] _referencesEl;
    private boolean[] verificationResults = null;
    HashMap _resolverProperties = null;
    List _perManifestResolvers = null;

    public Manifest(Document doc) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._references = new ArrayList();
    }

    public Manifest(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
        this._referencesEl = XMLUtils.selectDsNodes(this._constructionElement.getFirstChild(), "Reference");
        int le = this._referencesEl.length;
        if (le == 0) {
            Object[] exArgs = new Object[]{"Reference", "Manifest"};
            throw new DOMException(4, I18n.translate("xml.WrongContent", exArgs));
        }
        this._references = new ArrayList(le);
        int i = 0;
        while (i < le) {
            this._references.add(null);
            ++i;
        }
    }

    public void addDocument(String BaseURI, String referenceURI, Transforms transforms, String digestURI, String ReferenceId, String ReferenceType) throws XMLSignatureException {
        if (this._state == 0) {
            Reference ref = new Reference(this._doc, BaseURI, referenceURI, this, transforms, digestURI);
            if (ReferenceId != null) {
                ref.setId(ReferenceId);
            }
            if (ReferenceType != null) {
                ref.setType(ReferenceType);
            }
            this._references.add(ref);
            this._constructionElement.appendChild(ref.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void generateDigestValues() throws XMLSignatureException, ReferenceNotInitializedException {
        if (this._state == 0) {
            int i = 0;
            while (i < this.getLength()) {
                Reference currentRef = (Reference)this._references.get(i);
                currentRef.generateDigestValue();
                ++i;
            }
        }
    }

    public int getLength() {
        return this._references.size();
    }

    public Reference item(int i) throws XMLSecurityException {
        if (this._state == 0) {
            return (Reference)this._references.get(i);
        }
        if (this._references.get(i) == null) {
            Reference ref = new Reference(this._referencesEl[i], this._baseURI, this);
            this._references.set(i, ref);
        }
        return (Reference)this._references.get(i);
    }

    public void setId(String Id) {
        if (this._state == 0 && Id != null) {
            this._constructionElement.setAttributeNS(null, "Id", Id);
            IdResolver.registerElementById(this._constructionElement, Id);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public boolean verifyReferences() throws MissingResourceFailureException, XMLSecurityException {
        return this.verifyReferences(false);
    }

    public boolean verifyReferences(boolean followManifests) throws MissingResourceFailureException, XMLSecurityException {
        if (this._referencesEl == null) {
            this._referencesEl = XMLUtils.selectDsNodes(this._constructionElement.getFirstChild(), "Reference");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("verify " + this._referencesEl.length + " References"));
            log.debug((Object)("I am " + (followManifests ? "" : "not") + " requested to follow nested Manifests"));
        }
        boolean verify = true;
        if (this._referencesEl.length == 0) {
            throw new XMLSecurityException("empty");
        }
        this.verificationResults = new boolean[this._referencesEl.length];
        int i = 0;
        while (i < this._referencesEl.length) {
            block18: {
                Reference currentRef = new Reference(this._referencesEl[i], this._baseURI, this);
                this._references.set(i, currentRef);
                try {
                    boolean currentRefVerified = currentRef.verify();
                    this.setVerificationResult(i, currentRefVerified);
                    if (!currentRefVerified) {
                        verify = false;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The Reference has Type " + currentRef.getType()));
                    }
                    if (!verify || !followManifests || !currentRef.typeIsReferenceToManifest()) break block18;
                    log.debug((Object)"We have to follow a nested Manifest");
                    try {
                        XMLSignatureInput signedManifestNodes = currentRef.dereferenceURIandPerformTransforms(null);
                        Set nl = signedManifestNodes.getNodeSet();
                        Manifest referencedManifest = null;
                        for (Node n : nl) {
                            if (n.getNodeType() != 1 || !((Element)n).getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || !((Element)n).getLocalName().equals("Manifest")) continue;
                            try {
                                referencedManifest = new Manifest((Element)n, signedManifestNodes.getSourceURI());
                                break;
                            }
                            catch (XMLSecurityException xMLSecurityException) {
                                // empty catch block
                            }
                        }
                        if (referencedManifest == null) {
                            throw new MissingResourceFailureException("empty", currentRef);
                        }
                        referencedManifest._perManifestResolvers = this._perManifestResolvers;
                        referencedManifest._resolverProperties = this._resolverProperties;
                        boolean referencedManifestValid = referencedManifest.verifyReferences(followManifests);
                        if (!referencedManifestValid) {
                            verify = false;
                            log.warn((Object)"The nested Manifest was invalid (bad)");
                        } else {
                            log.debug((Object)"The nested Manifest was valid (good)");
                        }
                    }
                    catch (IOException ex) {
                        throw new ReferenceNotInitializedException("empty", ex);
                    }
                    catch (ParserConfigurationException ex) {
                        throw new ReferenceNotInitializedException("empty", ex);
                    }
                    catch (SAXException ex) {
                        throw new ReferenceNotInitializedException("empty", ex);
                    }
                }
                catch (ReferenceNotInitializedException ex) {
                    Object[] exArgs = new Object[]{currentRef.getURI()};
                    throw new MissingResourceFailureException("signature.Verification.Reference.NoInput", exArgs, ex, currentRef);
                }
            }
            ++i;
        }
        return verify;
    }

    private void setVerificationResult(int index, boolean verify) {
        if (this.verificationResults == null) {
            this.verificationResults = new boolean[this.getLength()];
        }
        this.verificationResults[index] = verify;
    }

    public boolean getVerificationResult(int index) throws XMLSecurityException {
        if (index < 0 || index > this.getLength() - 1) {
            Object[] exArgs = new Object[]{Integer.toString(index), Integer.toString(this.getLength())};
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(I18n.translate("signature.Verification.IndexOutOfBounds", exArgs));
            throw new XMLSecurityException("generic.EmptyMessage", e);
        }
        if (this.verificationResults == null) {
            try {
                this.verifyReferences();
            }
            catch (Exception ex) {
                throw new XMLSecurityException("generic.EmptyMessage", ex);
            }
        }
        return this.verificationResults[index];
    }

    public void addResourceResolver(ResourceResolver resolver) {
        if (resolver == null) {
            return;
        }
        if (this._perManifestResolvers == null) {
            this._perManifestResolvers = new ArrayList();
        }
        this._perManifestResolvers.add(resolver);
    }

    public void addResourceResolver(ResourceResolverSpi resolverSpi) {
        if (resolverSpi == null) {
            return;
        }
        if (this._perManifestResolvers == null) {
            this._perManifestResolvers = new ArrayList();
        }
        this._perManifestResolvers.add(new ResourceResolver(resolverSpi));
    }

    public void setResolverProperty(String key, String value) {
        if (this._resolverProperties == null) {
            this._resolverProperties = new HashMap(10);
        }
        this._resolverProperties.put(key, value);
    }

    public String getResolverProperty(String key) {
        return (String)this._resolverProperties.get(key);
    }

    public byte[] getSignedContentItem(int i) throws XMLSignatureException {
        try {
            return this.getReferencedContentAfterTransformsItem(i).getBytes();
        }
        catch (IOException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public XMLSignatureInput getReferencedContentBeforeTransformsItem(int i) throws XMLSecurityException {
        return this.item(i).getContentsBeforeTransformation();
    }

    public XMLSignatureInput getReferencedContentAfterTransformsItem(int i) throws XMLSecurityException {
        return this.item(i).getContentsAfterTransformation();
    }

    public int getSignedContentLength() {
        return this.getLength();
    }

    public String getBaseLocalName() {
        return "Manifest";
    }
}

