/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jmassmailer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import javax.mail.internet.AddressException;
import net.kldp.jmassmailer.mail.SessionHandler;

public class Configurator {
    private File confFile;
    private Properties smtpProps;
    private String smtpUsername;
    private String smtpPassword;
    private String smtpName;
    private String smtpFrom;
    private String smtpReplyto;
    private SessionHandler sessionHandler;
    private boolean sessionRead;

    public Configurator(File confFile) {
        this.confFile = confFile;
        this.read();
    }

    public Configurator(String filename) {
        this(new File(filename));
    }

    private void read() {
        try {
            FileInputStream fis = new FileInputStream(this.confFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            String host = ois.readUTF();
            String port = ois.readUTF();
            boolean needAuth = ois.readBoolean();
            boolean needTls = ois.readBoolean();
            this.smtpProps = new Properties();
            this.smtpProps.setProperty("mail.host", host);
            this.smtpProps.setProperty("mail.transport.protocol", "smtp");
            this.smtpProps.setProperty("mail.smtp.auth", needAuth ? "true" : "false");
            this.smtpProps.setProperty("mail.smtp.starttls.enable", needTls ? "true" : "false");
            this.smtpProps.setProperty("mail.smtp.port", port);
            this.smtpUsername = ois.readUTF();
            this.smtpPassword = ois.readUTF();
            this.smtpName = ois.readUTF();
            this.smtpFrom = ois.readUTF();
            this.smtpReplyto = ois.readUTF();
            this.sessionRead = true;
            ois.close();
        }
        catch (IOException e) {
            this.confFile.delete();
        }
    }

    public void write() {
        try {
            FileOutputStream fos = new FileOutputStream(this.confFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            if (this.sessionHandler.isSessionSet()) {
                oos.writeUTF(this.sessionHandler.getHost());
                oos.writeUTF(this.sessionHandler.getPort());
                oos.writeBoolean(this.sessionHandler.getNeedAuth());
                oos.writeBoolean(this.sessionHandler.getNeedTls());
                oos.writeUTF(this.sessionHandler.getUsername());
                oos.writeUTF(this.sessionHandler.getPassword());
            }
            oos.writeUTF(this.sessionHandler.getName());
            oos.writeUTF(this.sessionHandler.getFrom());
            oos.writeUTF(this.sessionHandler.getReplyTo());
            oos.close();
        }
        catch (IOException e) {
            this.confFile.delete();
        }
    }

    public void getSessionConfigure(SessionHandler model) throws IOException {
        this.setSessionHandler(model);
        if (this.isSessionRead()) {
            model.createSession(this.smtpUsername, this.smtpPassword, this.smtpProps);
            try {
                model.setFrom(this.smtpFrom, this.smtpName);
                model.setReplyTo(this.smtpReplyto);
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
    }

    public void setSessionHandler(SessionHandler model) {
        this.sessionHandler = model;
    }

    public void getOdbcConfigure() {
    }

    public boolean isSessionRead() {
        return this.sessionRead;
    }
}

