/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jmassmailer.data;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.mail.MessagingException;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import net.kldp.jmassmailer.data.DbHandler;
import net.kldp.jmassmailer.data.PeopleList;
import net.kldp.jmassmailer.data.PeopleListObserver;
import net.kldp.jmassmailer.data.Person;

public class ExcelHandler
implements DbHandler {
    private Cell[] headers;
    private Sheet sheet;
    private Workbook workBook;
    private ArrayList peopleListObservers = new ArrayList();

    public ExcelHandler(File file) throws BiffException, IOException {
        this.workBook = Workbook.getWorkbook((File)file);
        this.headers = new Cell[2];
    }

    public String[] getTables() throws SQLException {
        return this.workBook.getSheetNames();
    }

    public String[] getHeaderColumns(String table) throws SQLException {
        Sheet sheet = this.workBook.getSheet(table);
        Cell[] cells = sheet.getRow(0);
        String[] headers = new String[cells.length];
        int i = 0;
        while (i < cells.length) {
            headers[i] = cells[i].getContents();
            ++i;
        }
        return headers;
    }

    public void setNameColumn(String table, String nameCol) {
        this.sheet = this.workBook.getSheet(table);
        Cell[] cells = this.sheet.getRow(0);
        int j = 0;
        while (j < cells.length) {
            if (cells[j].getContents().equals(nameCol)) {
                this.headers[0] = cells[j];
            }
            ++j;
        }
    }

    public void setEmailColumn(String table, String emailCol) {
        this.sheet = this.workBook.getSheet(table);
        Cell[] cells = this.sheet.getRow(0);
        int j = 0;
        while (j < cells.length) {
            if (cells[j].getContents().equals(emailCol)) {
                this.headers[1] = cells[j];
            }
            ++j;
        }
    }

    public PeopleList getPeopleList() throws SQLException {
        if (this.headers == null) {
            throw new SQLException("Header Columns aren't defined");
        }
        int nameColNum = this.headers[0].getColumn();
        int emailColNum = this.headers[1].getColumn();
        int maxRow = this.sheet.getRows();
        PeopleList people = new PeopleList();
        int i = 1;
        while (i < maxRow) {
            people.add(new Person(this.sheet.getCell(nameColNum, i).getContents(), this.sheet.getCell(emailColNum, i).getContents()));
            ++i;
        }
        return people;
    }

    public void connect() throws SQLException {
    }

    public void close() throws SQLException {
    }

    public void registerObserver(PeopleListObserver o) {
        this.peopleListObservers.add(o);
    }

    public void removeObserver(PeopleListObserver o) {
        int i = this.peopleListObservers.indexOf(o);
        if (i >= 0) {
            this.peopleListObservers.remove(i);
        }
    }

    public void notifyPeopleList(PeopleList people) throws MessagingException {
        int i = 0;
        while (i < this.peopleListObservers.size()) {
            PeopleListObserver o = (PeopleListObserver)this.peopleListObservers.get(i);
            o.updatePeopleList(people);
            ++i;
        }
    }
}

