/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jmassmailer.data;

import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.swing.table.AbstractTableModel;
import net.kldp.jmassmailer.data.PeopleList;
import net.kldp.jmassmailer.data.PeopleListObserver;
import net.kldp.jmassmailer.data.Person;

public class PeopleListModel
extends AbstractTableModel
implements PeopleListObserver {
    private PeopleList people;
    private String[] columnNames = new String[]{"\uc774\ub984", "\uc774\uba54\uc77c"};
    private ArrayList peopleListObservers;

    public PeopleListModel(PeopleList people) {
        this.people = people;
        this.peopleListObservers = new ArrayList();
    }

    public int getRowCount() {
        if (this.people == null) {
            return 0;
        }
        return this.people.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        Person person = this.people.get(row);
        if (col == 0) {
            return person.getName();
        }
        return person.getEmail();
    }

    public void registerObserver(PeopleListObserver o) {
        this.peopleListObservers.add(o);
    }

    public void removeObserver(PeopleListObserver o) {
        this.peopleListObservers.remove(o);
    }

    public void notifyPeopleListObservers() {
        int i = 0;
        while (i < this.peopleListObservers.size()) {
            PeopleListObserver o = (PeopleListObserver)this.peopleListObservers.get(i);
            try {
                o.updatePeopleList(this.people);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void updatePeopleList(PeopleList people) throws MessagingException {
        this.people = people;
        this.notifyPeopleListObservers();
    }
}

