/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jmassmailer.ui;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.internet.AddressException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.kldp.jmassmailer.mail.AddressObserver;
import net.kldp.jmassmailer.mail.SessionValueReader;
import net.kldp.jmassmailer.mail.SmtpHostObserver;
import net.kldp.jmassmailer.ui.JMyDialog;

public class SmtpHostDialog
extends JMyDialog {
    private static final long serialVersionUID = -2267126819749076489L;
    private JTextField hostAddress;
    private JComboBox portNumber;
    private JCheckBox needAuth;
    private JCheckBox needTls;
    private JTextField username;
    private JPasswordField password;
    private JTextField from;
    private JTextField name;
    private JTextField replyto;
    private ArrayList smtpHostObservers = new ArrayList();
    private ArrayList addressObservers = new ArrayList();

    protected JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel panelServer = new JPanel();
        panelServer.setLayout(new GridLayout(3, 2, 3, 2));
        panelServer.setBorder(new TitledBorder(new EtchedBorder(), "\uba54\uc77c \ubcf4\ub0b4\ub294(SMTP) \uc11c\ubc84 \uc124\uc815"));
        panelServer.add(new JLabel("SMTP \ud638\uc2a4\ud2b8"));
        this.hostAddress = new JTextField(5);
        panelServer.add(this.hostAddress);
        panelServer.add(new JLabel("\ud3ec\ud2b8 \ubc88\ud638"));
        String[] ports = new String[]{new String("25"), new String("465"), new String("587"), new String("995")};
        this.portNumber = new JComboBox<String>(ports);
        panelServer.add(this.portNumber);
        this.needAuth = new JCheckBox("\uc0ac\uc6a9\uc790 \uc778\uc99d \uacfc\uc815 \ud544\uc694", true);
        this.needAuth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SmtpHostDialog.this.setAuthVisible(SmtpHostDialog.this.needAuth.isSelected());
            }
        });
        panelServer.add(this.needAuth);
        JPanel panelSecurity = new JPanel();
        panelSecurity.setBorder(new TitledBorder(new EtchedBorder(), "\ubcf4\uc548"));
        panelSecurity.setLayout(new GridLayout(1, 1, 3, 2));
        this.needTls = new JCheckBox("TLS \ubcf4\uc548 \uc0ac\uc6a9", true);
        panelSecurity.add(this.needTls);
        JPanel panelAuth = new JPanel();
        panelAuth.setBorder(new TitledBorder(new EtchedBorder(), "\uc0ac\uc6a9\uc790 \uc778\uc99d"));
        panelAuth.setLayout(new GridLayout(2, 2, 3, 2));
        panelAuth.add(new JLabel("\uc0ac\uc6a9\uc790 \uc774\ub984"));
        this.username = new JTextField(20);
        panelAuth.add(this.username);
        panelAuth.add(new JLabel("\uc554\ud638"));
        this.password = new JPasswordField(20);
        panelAuth.add(this.password);
        JPanel panelInfo = new JPanel();
        panelInfo.setBorder(new TitledBorder(new EtchedBorder(), "\ubcf4\ub0b4\ub294 \uc0ac\ub78c\uc758 \uc815\ubcf4"));
        panelInfo.setLayout(new GridLayout(3, 2, 3, 2));
        panelInfo.add(new JLabel("\ubcf4\ub0b4\ub294 \uba54\uc77c \uc8fc\uc18c"));
        this.from = new JTextField(20);
        panelInfo.add(this.from);
        panelInfo.add(new JLabel("\uc774\ub984"));
        this.name = new JTextField(20);
        panelInfo.add(this.name);
        panelInfo.add(new JLabel("\ud68c\uc2e0\ud560 \uc8fc\uc18c"));
        this.replyto = new JTextField(255);
        panelInfo.add(this.replyto);
        mainPanel.add(panelServer);
        mainPanel.add(panelSecurity);
        mainPanel.add(panelAuth);
        mainPanel.add(panelInfo);
        return mainPanel;
    }

    public void setValues(SessionValueReader ret) {
        this.from.setText(ret.getFrom());
        this.hostAddress.setText(ret.getHost());
        this.needAuth.setSelected(ret.getNeedAuth());
        this.needTls.setSelected(ret.getNeedTls());
        this.username.setText(ret.getUsername());
        this.password.setText(ret.getPassword());
        this.name.setText(ret.getName());
        this.portNumber.setSelectedItem(ret.getPort());
        this.replyto.setText(ret.getReplyTo());
        if (!this.needAuth.isSelected()) {
            this.username.setEditable(false);
            this.password.setEditable(false);
        }
    }

    private void notifySessionObservers() throws MessagingException, NoSuchProviderException {
        if (this.username.isEditable()) {
            int i = 0;
            while (i < this.smtpHostObservers.size()) {
                SmtpHostObserver o = (SmtpHostObserver)this.smtpHostObservers.get(i);
                try {
                    o.updateSessionConfiguration(this.username.getText(), new String(this.password.getPassword()), this.getProperties());
                }
                catch (MessagingException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                    throw e;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.smtpHostObservers.size()) {
                SmtpHostObserver o = (SmtpHostObserver)this.smtpHostObservers.get(i);
                o.updateSessionConfiguration(this.getProperties());
                ++i;
            }
        }
    }

    private void notifyAddressObservers() throws AddressException {
        int i = 0;
        while (i < this.addressObservers.size()) {
            AddressObserver o = (AddressObserver)this.addressObservers.get(i);
            try {
                o.updateAddress(this.from.getText(), this.name.getText(), this.replyto.getText());
            }
            catch (AddressException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                throw e;
            }
            ++i;
        }
    }

    protected void okActionPerformed() {
        boolean ok = true;
        try {
            this.notifySessionObservers();
            this.notifyAddressObservers();
        }
        catch (Exception e) {
            ok = false;
        }
        if (ok) {
            this.close();
        }
    }

    private void setAuthVisible(boolean set) {
        this.username.setEditable(set);
        this.password.setEditable(set);
    }

    protected void cancelActionPerformed() {
        this.close();
    }

    protected void setSize() {
        this.setSize(350, 400);
    }

    public Properties getProperties() throws NoSuchProviderException {
        Properties props = new Properties();
        if (this.hostAddress.getText().equals("")) {
            throw new NoSuchProviderException("SMTP \uc11c\ubc84\uac00 \uc9c0\uc815\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        props.setProperty("mail.host", this.hostAddress.getText());
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.auth", this.needAuth.isSelected() ? "true" : "false");
        props.setProperty("mail.smtp.starttls.enable", this.needTls.isSelected() ? "true" : "false");
        props.setProperty("mail.smtp.port", (String)this.portNumber.getSelectedItem());
        return props;
    }

    public void registerObserver(SmtpHostObserver o) {
        this.smtpHostObservers.add(o);
    }

    public void removeObserver(SmtpHostObserver o) {
        int i = this.smtpHostObservers.indexOf(o);
        if (i >= 0) {
            this.smtpHostObservers.remove(i);
        }
    }

    public void registerObserver(AddressObserver o) {
        this.addressObservers.add(o);
    }

    public void removeObserver(AddressObserver o) {
        int i = this.addressObservers.indexOf(o);
        if (i >= 0) {
            this.addressObservers.remove(i);
        }
    }

    public SmtpHostDialog() throws HeadlessException {
    }

    public SmtpHostDialog(Dialog arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
    }

    public SmtpHostDialog(Dialog arg0, String arg1, boolean arg2, GraphicsConfiguration arg3) throws HeadlessException {
        super(arg0, arg1, arg2, arg3);
    }

    public SmtpHostDialog(Dialog arg0, String arg1, boolean arg2) throws HeadlessException {
        super(arg0, arg1, arg2);
    }

    public SmtpHostDialog(Dialog arg0, String arg1) throws HeadlessException {
        super(arg0, arg1);
    }

    public SmtpHostDialog(Dialog arg0) throws HeadlessException {
        super(arg0);
    }

    public SmtpHostDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
    }

    public SmtpHostDialog(Frame arg0, String arg1, boolean arg2, GraphicsConfiguration arg3) {
        super(arg0, arg1, arg2, arg3);
    }

    public SmtpHostDialog(Frame arg0, String arg1, boolean arg2) throws HeadlessException {
        super(arg0, arg1, arg2);
    }

    public SmtpHostDialog(Frame arg0, String arg1) throws HeadlessException {
        super(arg0, arg1);
    }

    public SmtpHostDialog(Frame arg0) throws HeadlessException {
        super(arg0);
    }
}

