// Registry.cpp: implementation of the CRegistry class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Registry.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRegistry::CRegistry()
{
	m_hKey = NULL;
}

CRegistry::~CRegistry()
{

}

LONG CRegistry::CreateKey(HKEY hKey, LPCWSTR lpSubKey)
{
	DWORD dwDisposition = 0;
	
	ASSERT(m_hKey == NULL);

	return RegCreateKeyEx(hKey, lpSubKey, 0, NULL, 0, KEY_ALL_ACCESS,
		NULL, &m_hKey, &dwDisposition);
}

LONG CRegistry::CloseKey()
{
	ASSERT(m_hKey != NULL);

	LONG lResult = RegCloseKey(m_hKey);

	m_hKey = NULL;

	return lResult;
}

LONG CRegistry::SetValue(LPCWSTR lpValueName, LPCWSTR lpValue)
{
	ASSERT(m_hKey != NULL);

	return RegSetValueEx(m_hKey, lpValueName, NULL, REG_SZ,
		(const BYTE*) lpValue, sizeof (TCHAR) * (_tcslen(lpValue) + 1));
}

LONG CRegistry::SetValue(HKEY hKey, LPCWSTR lpSubKey, LPCWSTR lpValueName,
						 LPCWSTR lpValue)
{
	ASSERT(m_hKey == NULL);

	LONG lResult = CreateKey(hKey, lpSubKey);
	if (ERROR_SUCCESS != lResult)
		return lResult;

	lResult = SetValue(lpValueName, lpValue);
	if (ERROR_SUCCESS != lResult)
	{
		CloseKey();
		return lResult;
	}

	return CloseKey();
}

LONG CRegistry::SetValue(LPCWSTR lpValueName, DWORD dwValue)
{
	ASSERT(m_hKey != NULL);

	return RegSetValueEx(m_hKey, lpValueName, NULL, REG_DWORD,
		(const BYTE*) &dwValue, sizeof (DWORD));
}

LONG CRegistry::SetValue(HKEY hKey, LPCWSTR lpSubKey, LPCWSTR lpValueName,
						 DWORD dwValue)
{
	ASSERT(m_hKey == NULL);

	LONG lResult = CreateKey(hKey, lpSubKey);
	if (ERROR_SUCCESS != lResult)
		return lResult;

	lResult = SetValue(lpValueName, dwValue);
	if (ERROR_SUCCESS != lResult)
	{
		CloseKey();
		return lResult;
	}

	return CloseKey();
}
