/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "allowdialoginterface.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

static const unsigned char image0_data[] = {
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x1f, 0xf3, 0xff, 0x61, 0x00, 0x00, 0x03,
    0x46, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0x85, 0x93, 0xff, 0x6b, 0x94,
    0x75, 0x00, 0xc7, 0x5f, 0xf7, 0x3c, 0xcf, 0xdd, 0xcd, 0x7b, 0x6e, 0x9d,
    0xe7, 0x7d, 0xdb, 0x8d, 0xcd, 0x6d, 0xe7, 0xdc, 0xdc, 0xe6, 0x35, 0xd7,
    0x34, 0x0a, 0xc3, 0x4d, 0xa4, 0x44, 0x8d, 0x48, 0xc2, 0x88, 0x92, 0xa0,
    0x41, 0x7e, 0x01, 0x09, 0x6c, 0x0a, 0x92, 0x62, 0x6b, 0x14, 0x8b, 0xa6,
    0x46, 0xf4, 0x65, 0x54, 0x3f, 0xc4, 0x4a, 0x4a, 0x42, 0xc2, 0xe9, 0x74,
    0x4d, 0x9a, 0xc6, 0xd2, 0xdc, 0x5a, 0xad, 0x95, 0x73, 0x67, 0x18, 0xd5,
    0x6e, 0x6d, 0xed, 0x5b, 0x76, 0x9e, 0xdb, 0xdd, 0xed, 0xf9, 0xf2, 0x79,
    0xfa, 0xe1, 0xea, 0x97, 0x0a, 0x7a, 0xfd, 0x01, 0x2f, 0x78, 0xc3, 0xfb,
    0x65, 0x7b, 0xaa, 0xe1, 0x0d, 0x00, 0x74, 0x3d, 0x63, 0x25, 0x13, 0x71,
    0x52, 0xe9, 0x04, 0xb9, 0xae, 0x25, 0xe4, 0x7a, 0x97, 0x22, 0xcb, 0x0e,
    0x1b, 0xff, 0x83, 0x02, 0xb0, 0x73, 0xc7, 0x6a, 0xeb, 0x70, 0x73, 0x0b,
    0x25, 0xeb, 0x37, 0x61, 0xf9, 0xf2, 0x39, 0xd3, 0x37, 0x48, 0xf9, 0x54,
    0x3f, 0xfb, 0x0e, 0x34, 0x59, 0x77, 0xe4, 0x47, 0x98, 0xd3, 0x4c, 0xe6,
    0x17, 0x04, 0x29, 0x4d, 0x90, 0xd6, 0x4d, 0x16, 0x74, 0x93, 0x05, 0x43,
    0x10, 0x7b, 0xff, 0x63, 0x9b, 0x92, 0xc9, 0x24, 0xad, 0xc3, 0xcd, 0x2d,
    0x34, 0xbd, 0xfa, 0x1a, 0xa5, 0xc5, 0x85, 0x74, 0x8f, 0x4c, 0x90, 0x8e,
    0xde, 0xcf, 0xe9, 0x4b, 0x97, 0x69, 0x7e, 0x6e, 0x2f, 0x45, 0xe1, 0x30,
    0x86, 0x61, 0xa2, 0x4b, 0x4e, 0xf2, 0xcb, 0x6b, 0xf0, 0x47, 0x2a, 0xf1,
    0x17, 0x57, 0x61, 0x98, 0x02, 0x00, 0xb9, 0x30, 0x50, 0xd0, 0x54, 0xb3,
    0xb9, 0x9e, 0x2b, 0x1d, 0x27, 0xf1, 0xa8, 0x2a, 0xdd, 0xed, 0x6d, 0xec,
    0x7a, 0x70, 0x23, 0xd7, 0x9c, 0x79, 0x7c, 0x3b, 0x34, 0xc8, 0x93, 0xae,
    0x61, 0xd6, 0x56, 0x04, 0xf1, 0xa5, 0x6e, 0xe0, 0x9a, 0xf9, 0x9e, 0x2b,
    0x5d, 0xa7, 0xf8, 0x69, 0x7c, 0x9a, 0x50, 0xd9, 0x9d, 0x24, 0x63, 0x3f,
    0xbe, 0xa0, 0xa8, 0x8b, 0x2c, 0x2c, 0xc9, 0x01, 0xf7, 0x6e, 0xa1, 0xb6,
    0xae, 0x9e, 0xda, 0xba, 0x7a, 0x62, 0xe3, 0x73, 0x08, 0x4b, 0x60, 0xc9,
    0x76, 0x1e, 0xde, 0x7b, 0x8c, 0xc2, 0xf2, 0x3c, 0xec, 0xe9, 0x6b, 0x30,
    0x71, 0x99, 0x1d, 0x83, 0x57, 0x79, 0xf1, 0xf8, 0x59, 0xce, 0xb7, 0x4d,
    0xb2, 0x22, 0x50, 0x6b, 0x29, 0x2e, 0x5f, 0x25, 0x7d, 0x5d, 0x9d, 0x14,
    0xef, 0x3b, 0x4a, 0xeb, 0x0f, 0x1a, 0xc5, 0x0e, 0xb8, 0x9e, 0x56, 0x18,
    0x18, 0xb8, 0xc4, 0x3a, 0x69, 0x86, 0xfc, 0x22, 0x0f, 0x76, 0x69, 0x0e,
    0xdd, 0x90, 0x30, 0x17, 0x97, 0x12, 0x58, 0x67, 0xe7, 0xa8, 0x27, 0x87,
    0x86, 0xd6, 0x7e, 0x46, 0xd3, 0x32, 0x92, 0xac, 0xb8, 0x6d, 0xd1, 0x68,
    0x35, 0xbf, 0x1c, 0x69, 0x64, 0xa8, 0xfb, 0x13, 0xbe, 0xfa, 0x75, 0x8a,
    0x9e, 0x8e, 0x93, 0xdc, 0xd3, 0xdf, 0xce, 0x5b, 0xcf, 0xef, 0x42, 0xb2,
    0x3b, 0x39, 0x78, 0xa8, 0x8d, 0xd1, 0x49, 0x1b, 0x76, 0x35, 0xc2, 0x58,
    0x62, 0x31, 0x46, 0x61, 0x98, 0x3d, 0x1b, 0xf3, 0xb8, 0x39, 0x39, 0x82,
    0x04, 0xf0, 0xf8, 0xee, 0x46, 0xa2, 0xd1, 0x6a, 0xe6, 0x3f, 0x3c, 0xc2,
    0x58, 0xeb, 0x6e, 0x32, 0x1f, 0xbc, 0xcc, 0xbb, 0xcd, 0xfb, 0x89, 0x54,
    0xad, 0x61, 0x6c, 0x6c, 0x96, 0x73, 0x9f, 0x7e, 0x89, 0xa5, 0x2c, 0x41,
    0x56, 0x43, 0x34, 0x1f, 0xeb, 0xe5, 0xf3, 0xe1, 0x04, 0x15, 0x15, 0x7e,
    0x54, 0x29, 0x9d, 0x15, 0x68, 0x36, 0x07, 0x0f, 0x3d, 0xbd, 0x1f, 0xaf,
    0xcf, 0xc7, 0x7b, 0x8f, 0x04, 0x78, 0xe7, 0x60, 0x2d, 0x9e, 0xa0, 0x17,
    0xcb, 0x4c, 0xa3, 0x1b, 0x06, 0xdb, 0xb7, 0x6f, 0x23, 0xb2, 0xac, 0x84,
    0x89, 0xf8, 0x34, 0x23, 0xb1, 0x38, 0x21, 0x7f, 0x2e, 0x58, 0x20, 0x61,
    0x64, 0x05, 0x73, 0x0b, 0x26, 0x29, 0x5d, 0x60, 0xb9, 0x03, 0xdc, 0x1e,
    0x1f, 0x65, 0x43, 0x75, 0x0e, 0x5e, 0x25, 0x86, 0xd0, 0x33, 0x94, 0x16,
    0x87, 0x78, 0xf6, 0x99, 0x27, 0x10, 0xe9, 0x29, 0x64, 0x91, 0xe4, 0x50,
    0xe3, 0x06, 0x56, 0x2e, 0x5d, 0xc4, 0xec, 0x58, 0x02, 0x0d, 0x57, 0xf6,
    0x48, 0x73, 0x9a, 0xc0, 0x14, 0x16, 0xc1, 0xb2, 0x55, 0x74, 0x5f, 0x1d,
    0xa6, 0xaa, 0xec, 0x37, 0x34, 0xb9, 0x0b, 0x29, 0xf8, 0x3b, 0xd8, 0x83,
    0x08, 0x21, 0x30, 0x8d, 0x79, 0xbc, 0x6a, 0x82, 0x4d, 0xf7, 0x79, 0x60,
    0x64, 0x98, 0xf3, 0x5f, 0xcf, 0xe0, 0x0d, 0x47, 0xb3, 0x82, 0x94, 0x66,
    0x60, 0x9a, 0x16, 0xd5, 0x0f, 0x3c, 0x4a, 0xc7, 0x77, 0xfd, 0x94, 0x7c,
    0x31, 0xcd, 0x56, 0xf7, 0x1f, 0x68, 0x99, 0x5e, 0x0c, 0xd5, 0x83, 0xe4,
    0x70, 0x81, 0x30, 0x20, 0x93, 0x84, 0xc9, 0x59, 0x7a, 0x3f, 0x8b, 0xf3,
    0xf6, 0x90, 0xce, 0xca, 0xd5, 0x77, 0x21, 0xd7, 0xd4, 0x6c, 0x26, 0xb8,
    0xaa, 0xaa, 0x49, 0x33, 0x05, 0x42, 0xb2, 0x93, 0x57, 0x79, 0x37, 0x1f,
    0xf5, 0x7c, 0xc3, 0xec, 0xcf, 0x93, 0x94, 0xb9, 0x3c, 0xa8, 0xba, 0x85,
    0x2d, 0x71, 0x9b, 0x9c, 0x44, 0x8a, 0x5b, 0x37, 0x6e, 0xd1, 0xde, 0x19,
    0xe7, 0xa5, 0xde, 0x9b, 0x04, 0xd7, 0x6e, 0xc3, 0x2d, 0xfe, 0x9a, 0x90,
    0xd1, 0x05, 0xa6, 0x29, 0x30, 0x84, 0x40, 0x71, 0x7b, 0xa9, 0xdb, 0xf3,
    0x0a, 0x3d, 0xa7, 0xdb, 0x39, 0xf7, 0xfa, 0x09, 0x76, 0x6e, 0x5d, 0x0f,
    0x92, 0xc6, 0xd9, 0x81, 0x38, 0xd7, 0xc7, 0x13, 0xe4, 0x04, 0x0a, 0x58,
    0xd1, 0x70, 0x00, 0x57, 0xa8, 0x04, 0x71, 0xf1, 0xa2, 0x4d, 0xf9, 0xaf,
    0xc2, 0x24, 0xc5, 0x4e, 0xa8, 0xa8, 0x94, 0x0b, 0x9d, 0xf3, 0xb4, 0x9c,
    0xb8, 0x80, 0x2b, 0x90, 0x8f, 0x2b, 0x6f, 0x19, 0xcb, 0x1f, 0xdb, 0x42,
    0x8e, 0xbf, 0x00, 0xd9, 0xa9, 0x82, 0x2d, 0x1b, 0xaa, 0xed, 0xef, 0x9c,
    0xff, 0xc9, 0x50, 0xdf, 0x9b, 0x16, 0x80, 0x3f, 0xbc, 0x06, 0x5f, 0x60,
    0x39, 0x0e, 0xa7, 0x1b, 0x59, 0xb6, 0xff, 0x2b, 0xef, 0x3f, 0x01, 0x4b,
    0xd0, 0x53, 0x12, 0x37, 0x98, 0xa3, 0x76, 0x00, 0x00, 0x00, 0x00, 0x49,
    0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const char* const image1_data[] = {
    "216 40 134 2",
    ".f c #e0f4fd",
    ".c c #e0f4fe",
    ".a c #e0f4ff",
    ".e c #e1f3fd",
    ".b c #e1f4fd",
    ".# c #e1f4fe",
    ".j c #e2f4fc",
    "Qt c #e2f4fd",
    ".d c #e2f4fe",
    ".l c #e2f5fc",
    ".h c #e2f5fd",
    ".g c #e2f5fe",
    ".o c #e2f6fc",
    ".n c #e2f6fd",
    ".i c #e3f4fe",
    ".x c #e3f5fc",
    ".p c #e3f5fe",
    ".k c #e3f5ff",
    ".r c #e3f6fd",
    ".t c #e3f6fe",
    ".w c #e4f4fc",
    ".m c #e4f4fe",
    ".u c #e4f5fd",
    ".s c #e4f5fe",
    ".q c #e4f5ff",
    ".v c #e4f6fd",
    ".y c #e4f6fe",
    ".C c #e5f5fe",
    ".z c #e5f6fe",
    ".A c #e5f6ff",
    ".D c #e6f5fe",
    ".F c #e6f6fd",
    ".B c #e6f6fe",
    ".E c #e7f5fe",
    ".K c #e7f6fd",
    ".G c #e7f6fe",
    ".I c #e7f6ff",
    ".H c #e8f6fe",
    ".J c #e8f6ff",
    ".L c #e8f7fe",
    ".M c #e8f8fe",
    ".R c #e9f6fe",
    ".N c #e9f7fe",
    ".Q c #e9f8fe",
    ".P c #e9f8ff",
    ".T c #eaf7fe",
    ".O c #eaf7ff",
    ".U c #eaf8fe",
    ".S c #eaf8ff",
    ".W c #ebf8fe",
    ".V c #ebf8ff",
    ".Y c #ecf7ff",
    ".X c #ecf8fe",
    ".0 c #ecf8ff",
    ".Z c #edf8fe",
    ".1 c #edf9ff",
    ".2 c #eef8fe",
    ".4 c #eef9fe",
    ".3 c #eef9ff",
    ".8 c #eefafe",
    ".7 c #eefaff",
    "#b c #eff8fe",
    ".5 c #eff9fe",
    ".6 c #eff9ff",
    "## c #effafe",
    ".9 c #effaff",
    "#. c #f0f9fe",
    "#c c #f0f9ff",
    "#d c #f0fafd",
    "#a c #f0fafe",
    "#i c #f1f9fe",
    "#k c #f1fafd",
    "#h c #f1fafe",
    "#e c #f1faff",
    "#f c #f1fbfd",
    "#n c #f1fbfe",
    "#o c #f2f9fe",
    "#g c #f2f9ff",
    "#l c #f2fafe",
    "#j c #f2faff",
    "#m c #f2fbfe",
    "#p c #f2fbff",
    "#s c #f2fcfe",
    "#t c #f3fafe",
    "#r c #f3faff",
    "#q c #f3fbfe",
    "#v c #f4fafe",
    "#u c #f4fbfe",
    "#w c #f4fcfe",
    "#x c #f4fcff",
    "#B c #f5fafe",
    "#C c #f5fbfe",
    "#F c #f5fbff",
    "#G c #f5fcfe",
    "#D c #f5fcff",
    "#z c #f6fafe",
    "#y c #f6fbfe",
    "#A c #f6fbff",
    "#I c #f6fcfe",
    "#E c #f6fcff",
    "#H c #f7fcff",
    "#L c #f8fcfe",
    "#J c #f8fcff",
    "#P c #f8fdfe",
    "#N c #f8fdff",
    "#M c #f9fdfe",
    "#K c #f9fdff",
    "#R c #fafcfe",
    "#O c #fafcff",
    "#V c #fafdfe",
    "#Q c #fafdff",
    "#S c #fafefe",
    "#U c #fafeff",
    "#X c #fbfcfe",
    "#Y c #fbfdfe",
    "#T c #fbfdff",
    "#2 c #fbfefe",
    "#W c #fbfeff",
    "#1 c #fcfcfe",
    "#4 c #fcfdfe",
    "#Z c #fcfdff",
    "#6 c #fcfefe",
    "#0 c #fcfeff",
    "#5 c #fdfdff",
    "#8 c #fdfefe",
    "#3 c #fdfeff",
    "a. c #fdfffe",
    "#9 c #fefefe",
    "#7 c #fefeff",
    "a# c #fefffe",
    "aa c #feffff",
    "ad c #fffeff",
    "ac c #fffffe",
    "ab c #ffffff",
    "Qt.#.a.b.c.d.#.#.#.#.#.#.#.#.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.b.b.b.b.b.b.b.b.d.d.d.d.d.d.d.d.e.d.d.e.e.e.e.e.e.e.e.#.#.#.#.#.#.#.#.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.e.e.e.e.e.e.e.e.#.#.#.#.#.#.#.#.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.#.#.#.#.#.#.#.#.d.d.d.d.d.d.d.d.b.b.b.b.b.b.b.b.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.d.d.d.d.d.d.d.d.e.e.e.e.e.e.e.e.#.#.#.#.#.#.#.#.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.#.#.#.#.#.#.#.#.d.d.d.d.d.d.d.d.d.#.#.b.d.f.b",
    ".b.b.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.b.b.#.d.d.d.d.d.d.d.d.d.d.#.d.d.d.d.d.d.#.d.d.#.d.d.d.d.d.d.d.d.d.d.d.#.#.d.d.d.d.d.d.e.d.e.d.e.#.d.e.d.d.d.e.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.#.d.d.d.#.d.#.d.#.d.#.d.d.d.d.d.e.d.d.d.d.d.d.d.d.b.d.d.d.#.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.#.#.d.d.d.d.d.d.d.e.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.#.d.#.d.#.d.d.d.d.d.d.d.d.d.d.d.#.d.d.d.d.d",
    ".g.h.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.h.d.d.d.d.d",
    ".i.j.d.d.d.d.k.d.d.d.d.d.d.d.d.d.k.k.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.k.d.d.d.d.k.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.k.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.i.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.k.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.d.i.d.d.d.i.i.d.d.d.d.d.d.k.k.d.d.d.l.d.d.d.d.d",
    ".m.n.k.i.o.m.k.d.k.k.d.k.k.k.i.d.d.d.p.d.d.p.i.i.i.d.d.d.d.d.q.m.i.i.q.m.m.i.k.k.k.r.r.k.k.k.d.k.k.d.k.d.d.k.k.d.d.q.i.i.q.q.d.i.q.k.k.k.k.k.k.k.k.d.d.d.d.d.d.d.i.k.k.k.k.k.k.k.k.i.q.d.q.i.i.i.d.p.g.k.d.d.k.d.d.k.k.d.d.d.d.k.k.k.d.k.d.d.k.i.d.k.d.d.d.k.k.k.d.k.d.d.k.k.d.d.k.q.i.q.q.i.i.q.q.d.q.d.k.k.d.q.q.q.q.i.s.s.i.q.q.d.d.k.i.i.k.d.d.k.d.k.d.d.k.k.d.d.k.k.k.d.k.d.k.s.m.i.i.i.i.m.s.i.i.i.i.i.i.i.i.k.d.d.k.k.k.d.k.s.k.t.d.u.q.d",
    ".i.v.k.i.v.k.s.m.s.s.m.s.s.s.u.u.u.u.u.u.u.w.x.w.u.u.u.u.v.r.s.s.s.s.m.s.s.s.s.s.s.s.s.s.s.s.v.s.s.v.v.v.u.u.u.u.u.i.s.s.m.i.s.s.m.s.p.p.p.s.s.s.p.m.m.s.s.s.s.s.s.s.s.s.s.s.s.s.s.m.s.s.s.s.m.s.s.y.p.y.y.y.s.p.y.s.s.s.s.s.s.s.s.p.p.t.t.p.t.p.t.v.v.v.v.v.v.v.v.s.s.s.s.s.s.s.s.m.s.s.s.s.s.m.s.s.s.s.s.s.s.s.s.y.s.s.s.s.s.s.y.y.y.y.y.y.y.y.y.s.s.s.s.s.i.i.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.s.v.u.s.s.u.y.p",
    ".y.v.z.u.u.A.y.y.y.y.y.z.z.z.u.y.u.u.y.y.u.u.u.y.u.u.u.y.y.y.y.y.y.y.y.y.y.y.u.u.u.y.y.z.y.y.y.y.y.y.z.y.y.u.u.y.y.y.y.u.y.y.u.y.u.u.y.z.u.u.y.y.y.u.u.y.y.u.u.y.y.y.y.u.u.u.u.y.y.z.y.u.y.z.z.y.u.z.z.y.y.y.u.u.u.u.y.u.y.y.u.y.u.u.u.u.u.y.y.z.z.u.u.u.u.u.u.u.u.z.u.y.z.u.y.u.z.u.y.z.u.y.u.z.y.u.y.y.u.u.y.y.u.y.y.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.z.y.u.y.y.u.u.y.s.s.s.y.y.z.y.u.u.y.u.y.y.u.y.u.y.y.y.y.u.y.y.u.u.y.u.z.y.u.u.y.s.s.y.u.s.y",
    ".z.y.B.B.z.z.z.z.z.z.z.z.z.z.z.z.z.z.y.y.z.z.z.y.z.z.z.z.z.y.z.y.y.z.z.y.y.z.z.z.z.z.z.z.z.z.B.z.z.B.u.z.y.y.y.u.y.z.z.y.z.z.z.z.y.y.z.z.z.z.z.z.z.z.z.y.z.z.z.z.y.B.B.B.B.B.C.B.C.z.y.y.z.z.z.y.z.y.y.y.y.y.z.z.z.z.z.z.z.z.z.z.z.s.z.z.z.z.z.z.B.y.y.y.y.y.y.y.y.B.y.y.z.y.z.z.B.C.y.z.y.y.z.z.C.y.z.z.y.y.z.z.y.z.z.z.z.z.z.z.z.y.y.z.z.y.y.y.y.y.z.z.z.y.z.z.z.z.z.z.z.z.y.y.z.z.y.z.y.z.y.z.z.y.y.z.z.y.y.y.z.y.z.z.z.u.z.z.y.z.z.z.z.y.s.z",
    ".z.z.D.B.z.B.B.B.B.z.z.z.z.z.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.z.z.z.z.B.B.B.B.z.B.z.z.z.z.B.z.z.B.z.z.z.z.y.y.z.B.B.B.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.E.E.E.E.E.E.E.E.z.z.z.z.z.z.z.z.B.B.B.B.B.B.B.B.B.B.B.B.B.B.z.B.B.B.z.z.z.z.B.B.z.z.z.z.B.B.B.B.B.z.z.B.z.z.B.B.z.B.z.B.B.z.B.B.B.B.z.z.z.z.z.z.z.z.z.z.z.z.z.z.B.z.z.B.B.z.z.B.z.z.z.z.B.B.D.B.z.z.z.z.z.z.z.z.z.z.z.B.B.B.B.B.z.z.z.z.z.B.z.z.z.z.z.z.B.B.z.z.z.B.F.z.z.E.z",
    ".B.G.H.H.G.H.E.E.E.G.G.G.E.E.H.H.H.H.H.H.H.H.G.G.H.H.H.H.G.G.G.G.G.E.H.E.E.E.E.H.G.G.G.G.H.E.H.H.E.H.E.G.G.G.G.G.G.H.E.E.G.G.G.E.E.E.E.E.E.E.E.E.E.G.G.G.B.G.G.G.G.H.H.G.D.B.H.H.H.E.E.E.E.E.E.E.E.H.H.H.H.H.H.H.H.E.H.G.G.G.I.G.J.H.H.G.G.G.G.G.G.G.G.G.E.E.E.E.E.H.G.E.H.E.E.H.H.E.H.E.H.H.E.H.H.H.H.G.G.G.G.E.E.G.G.G.G.G.E.E.E.H.E.E.H.H.E.E.H.G.G.G.E.H.E.E.H.E.E.E.E.E.E.E.E.G.B.B.H.H.H.H.H.E.E.E.G.E.H.E.E.G.G.G.E.H.H.E.E.G.B.H.G.B.E.K",
    ".J.L.L.H.H.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.G.L.L.L.L.L.L.L.L.L.H.L.H.H.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.H.H.L.L.L.L.H.H.L.L.L.L.L.L.L.L.J.H.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.H.H.H.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.H.L.L.L.L.L.L.H.L.L.H.H.L.L.L.H.L.L.L.L.L.L.L.L.L.J.J.H.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.J.L.J.H.H.L",
    ".J.M.L.N.O.N.M.M.M.M.M.M.P.M.N.P.P.M.M.M.P.Q.R.L.M.L.L.M.L.L.M.P.M.M.M.P.P.M.L.P.M.M.L.L.P.M.M.P.M.M.M.M.M.M.M.M.M.N.L.M.L.L.L.L.R.P.M.L.M.P.M.M.M.N.S.P.N.S.M.N.O.L.M.M.L.L.M.M.L.M.M.L.L.M.M.M.L.H.L.H.L.L.N.L.L.M.P.P.M.M.M.P.M.M.M.L.L.M.M.L.L.M.M.L.L.L.L.M.L.L.L.M.L.L.P.M.L.P.M.P.L.M.M.L.M.P.L.Q.P.Q.M.P.M.M.M.L.M.M.M.M.M.N.N.N.H.N.H.N.N.M.M.M.M.L.L.M.M.L.L.P.P.M.M.M.M.N.N.Q.M.P.M.L.L.L.M.L.L.M.M.M.P.P.M.L.L.L.L.P.M.M.L.M.O.M.N.N",
    ".S.P.P.O.O.O.O.O.O.O.O.O.O.O.S.S.S.S.S.S.S.S.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.S.O.O.S.S.S.S.S.S.S.S.O.O.O.O.O.O.O.O.S.O.O.S.S.O.O.S.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.S.O.S.S.O.S.S.O.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.O.O.O.O.O.O.O.O.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.P.O.O.O.P.P.S.O.O.O.O.O.O.O.O.O.S.S.S.S.S.S.S.S.O.O.O.S.S.S.S.S.P.P.P.P.P.P.P.P.O.O.S.P.P.S.O.O.O.S.S.S.S.S.S.O.O.O.Q.O.O.P.O",
    ".O.S.S.T.O.O.O.S.S.O.S.O.O.O.O.O.O.O.T.T.T.U.S.O.O.S.S.O.S.O.O.O.O.U.T.O.O.O.O.O.O.O.O.O.O.O.T.O.O.T.O.O.T.T.O.O.T.S.O.O.O.S.S.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.S.S.O.O.O.S.O.O.O.O.O.O.S.S.O.O.O.O.O.S.S.T.O.S.S.O.O.S.O.O.O.O.S.O.O.O.O.S.O.O.O.O.O.O.O.O.O.O.S.S.O.O.O.S.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.S.S.O.O.O.O.O.O.O.O.O.S.U.T.T.O.U.T.T.T.T.O.O.O.O.O.S.T.T.T.S.T.T.T.T.T.T.T.U.T.O.S.S.S.O.O.S.S.O.O.O.O.O.O.O.O.S.S.U.S.S.V.O",
    ".W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.U.U.W.W.W.U.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.W.X.W.Y.W.W.W",
    ".X.X.X.Z.X.0.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.1.X.Z.X.X.X.X.X.Z.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.Z.X.Z.Z.X.X.Z.X.X.X.X.X.X.X.X.Z.X.X.Z.X.X.X.X.X.Z.X.Z.Z.X.X.X.Z.Z.X.Z.X.X.X.Z.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.Z.X.X.X.X.X.X.X.X.X.Z.X.X.X.X.Z.X.X.X.X.X.Z.X.X.X.X.X.X.Z.Z.X.Z.Z.Z.Z.Z.Z.Z.Z.X.X.Z.X.X.X.X.Z.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.X.Z.X.X.X.X.X.X.X.Z.X.Z.X.X.X.X.X.X.X.X.X.X.X.Z.W.X.Z.Z.Z.Z.X.W.X.Z.X.2.X.Z.Z",
    ".3.3.3.3.2.3.3.2.3.3.3.3.2.2.3.3.3.3.3.3.3.3.3.3.2.3.3.3.3.3.2.2.3.3.3.3.3.2.2.3.3.Z.2.Z.3.3.Z.3.3.Z.2.2.3.3.3.3.3.3.3.3.2.3.2.3.2.3.3.3.4.4.3.3.3.3.2.2.2.2.4.4.2.3.3.3.2.Z.3.2.3.2.3.3.2.2.2.3.2.3.2.3.2.2.3.2.3.3.2.3.3.3.Z.3.3.3.3.2.3.3.2.2.3.3.3.1.3.3.3.3.4.3.2.3.3.Z.2.3.3.3.3.2.2.3.3.2.3.2.2.3.2.2.3.2.3.2.Z.3.2.Z.3.3.3.3.3.3.3.3.2.2.3.3.3.3.3.3.3.3.2.Z.2.3.3.3.3.3.3.3.3.3.2.3.3.2.3.Z.2.3.3.3.3.3.2.3.3.3.2.2.3.3.3.3.3.4.3.3.2.3",
    ".5.4.4.4.4.3.3.3.3.3.3.3.3.3.6.6.3.3.3.3.3.3.7.3.3.7.3.3.6.6.3.3.3.3.3.3.3.3.3.3.3.3.3.4.3.3.3.3.3.3.3.3.4.4.3.3.3.8.3.4.4.8.3.3.4.4.4.4.4.4.4.4.4.3.3.3.3.3.4.4.4.4.4.3.3.3.3.3.3.3.3.3.3.3.3.4.4.3.6.3.3.3.3.3.6.3.3.3.3.3.3.3.3.4.3.3.8.8.3.3.4.3.3.3.3.3.3.3.4.3.3.3.4.4.4.4.3.3.3.3.3.6.6.3.3.6.6.6.3.3.3.4.4.6.6.3.3.5.6.3.3.5.5.4.4.3.4.6.5.3.3.3.9.4.3.3.3.3.3.3.3.4.4.3.3.3.4.4.4.3.3.3.4.6.3.3.3.3.6.3.3.6.3.3.3.3.3.3.3.7.5.4.6.4.3.4",
    "#..5###..5#..5#..5#..5#a#.#.#.#.#.#.#.#.#.#..5.5#..5.5#.#.#.#.#.#.#.#..5#a#.###.#.#.##.5#.#a.5#.#a.5.5.5#.#.#.#.#.###.##.5.5#a#.####.5.5.5##.5##.5.5.5#b.5.5.5.5.5#..5####.8##.5#..5.5.5.5.5#.#.#.#.#.#.#..5.5#.#.##.5####.5######.5#.#..5.5#.#..5#.#.#..5#..5.5.5#..5#..5.5#..5#.#.#######.#..5###.#.#.#a#a.5.5.5#a#a#.#.#.#.#.#.#.#..5#.#.#b#.#.###a###a.5#..5#.#.#..5.5.5#.#.#a.5.5.5.5.5.5.5.5#a.5#####.#a#####..5#a.5.5.5.5.5###.###a###c.5",
    "#a#a#a#d#.#.#a#a#a#.#a#e#a#a#a#.#a#.#a#a#a#.#a#.#a#.#a#a#a#.#a#.#.#a#a#.#.#a#.#.#.#.#.#a#a#a#a#a#a#a#a#.#.#.#.#.#a#a#.#e#a#a#e#.#a#.#a#.#a#a#.#.#.#a#a#a#a#a#e#e#a#a#a#a#a#a#a#a#a#a#.#.#a#a#a#a#e#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#a#.#.#.#a#a#.#.#a#a#a#a#a#.#a#.#a#a#.#a#.#.#.#.#.#.#.#.#a#a#.#.#.#a#a#a#.#a#a#a#a#.#.#.#.#.#.#.#.#.#.#.#.#a#.#.#.#.#.#.#.#a#a#a#a#a#a#a#a#.#a#a#.#.#a#a#.#.#.#.#a#a#.#.#.#a#a#a#a#.#a#a#.#.#.#.#.#.#a#.",
    "#f#e#g#e#e#a#a#e#e#e#e#e#e#e#e#a#e#a#e#a#e#a#e#e#a#h#e#e#e#a#h#a#a#e#e#a#a#e#e#e#e#e#e#e#e#a#e#e#a#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#a#a#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#h#h#e#e#a#a#a#e#e#e#e#e#a#e#e#e#e#e#e#e#e#i#j#e#e#a#e#e#a#e#e#e#e#e#e#e#k#e#a#e#e#e#e#a#e#e#e#a#a#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#e#a#e#e#a#a#e#a#a#e#e#e#e#e#e#e#a#e#e#e#e#e#e#e#l#.#i#a#g#e",
    "#h#j#g#m#l#g#j#j#j#l#l#l#l#l#j#e#l#l#l#j#j#e#l#l#l#l#l#j#j#l#l#j#m#n#n#m#e#j#g#g#l#l#j#j#l#m#j#l#m#j#j#l#l#l#l#j#j#l#l#l#l#l#j#j#j#l#j#l#l#l#l#j#h#l#l#j#j#j#j#l#l#l#l#l#n#n#l#l#l#m#m#l#l#l#l#l#l#e#j#j#j#h#n#m#l#m#j#j#j#n#n#l#g#l#l#l#l#l#l#l#l#l#l#l#l#l#l#l#l#l#l#l#l#j#j#j#l#j#j#j#e#e#e#j#j#o#o#j#j#j#j#o#o#l#l#j#j#g#g#l#l#l#l#l#l#l#l#l#l#j#j#j#j#j#j#j#j#l#l#l#l#l#l#l#l#l#j#j#j#j#j#j#l#j#j#l#l#j#l#l#l#l#j#j#j#j#j#j#j#j#l#g#p#l#e#e",
    "#q#r#q#s#q#q#l#q#q#q#q#q#q#q#l#l#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#t#t#q#q#l#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#u#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#t#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#l#q#q#q#q#q#q#q#q#q#q#l#q#q#q#q#q#q#q#q#q#t#q#q#q#q#q#q#q#t#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#q#t#t#q#q#q#q#s#q#q#q#q#q",
    "#u#q#v#w#x#w#w#q#q#q#q#q#q#w#q#q#q#q#w#q#w#w#u#q#q#x#q#w#w#q#v#v#q#q#q#q#q#q#u#q#x#q#x#q#q#q#q#q#q#q#q#q#q#u#q#u#u#q#w#q#q#x#q#q#w#v#q#q#q#q#q#q#v#x#q#w#u#u#q#q#q#w#q#q#q#x#w#q#w#u#w#w#q#q#w#w#q#q#q#q#q#q#q#q#q#q#x#x#q#q#w#w#w#q#w#q#q#w#q#q#q#q#w#q#w#q#w#q#q#q#q#x#q#q#q#q#q#u#q#q#q#q#q#q#u#q#w#q#x#w#q#x#q#w#w#w#w#w#w#w#w#q#q#u#u#w#q#w#u#q#q#q#q#q#q#q#q#q#q#q#w#w#w#w#w#q#q#q#w#q#w#q#q#q#q#q#q#q#q#q#q#q#q#w#w#w#w#q#w#u#w#u#q#u#q#u",
    "#y#w#z#x#A#x#B#A#A#A#A#A#A#A#A#A#A#A#A#A#C#A#A#z#x#w#w#w#w#x#x#x#A#A#A#A#A#A#x#x#x#x#x#D#E#B#D#E#B#D#x#x#x#D#A#A#A#A#A#A#A#A#A#A#A#x#A#A#y#y#A#A#x#x#F#A#z#A#A#G#w#A#A#B#A#A#B#A#A#y#y#C#C#A#A#A#C#A#A#y#y#A#A#A#y#x#x#x#x#x#w#w#w#A#A#A#A#A#A#A#A#A#A#C#A#A#A#A#A#A#A#A#A#A#A#A#A#D#D#A#A#A#A#D#D#A#A#A#C#A#A#A#A#x#x#x#x#x#x#x#x#x#z#A#A#x#x#F#A#A#A#A#A#A#A#A#A#x#x#x#x#x#x#x#x#D#x#x#x#x#x#x#D#A#C#C#A#A#A#A#A#w#w#x#x#x#x#w#w#z#x#A#D#A#u#y",
    "#y#E#y#y#H#I#A#A#y#y#y#y#E#E#A#A#E#A#A#A#y#y#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#I#H#A#I#H#A#A#A#A#E#A#A#A#I#y#y#y#y#y#y#y#E#A#y#E#A#A#A#E#E#E#A#A#y#y#A#y#E#A#y#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#A#E#y#y#y#y#A#A#A#A#y#y#y#y#y#y#y#y#E#A#A#A#A#A#A#A#y#A#A#E#E#y#E#A#A#A#A#A#A#A#A#A#A#E#y#y#y#E#A#A#A#A#A#A#A#A#E#A#y#y#A#A#A#A#A#A#y#y#y#A#y#y#y#y#A#A#E#y#y#y#y#y#y#y#A#A#A#A#y#y#y#A#y#y#y#y#A#y#A#A#A#A#E#E#y",
    "#J#H#H#H#J#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#I#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#I#H#H#H#H#H#H#H#H#H#J#H#J#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#I#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H#H",
    "#J#J#J#J#J#J#J#J#J#H#J#J#H#J#J#J#J#J#J#H#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#H#H#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#K#J#J#J#J#H#J#H#J#J#H#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#H#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#L#J#J#J#J#J#J#J#J#J#J#J#J#J#K#J#J#J#J#J#J#J#J#J#J#J#J#J#H#J#J#J#J#H#J#J#J#J#J#H#J#J#J#H#H#H#J#J#J#J#J#J#J#J#J#J#J#J#H#H#H#L#L#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J#J",
    "#J#J#M#K#M#J#M#J#K#N#N#J#K#M#J#K#K#K#J#K#J#K#N#J#N#K#J#J#K#N#J#K#J#J#J#K#K#J#K#K#K#J#J#K#K#J#J#K#J#J#J#J#J#K#J#K#N#K#K#J#L#M#K#J#J#J#K#J#J#K#K#J#J#J#J#K#J#K#K#K#K#J#J#J#J#J#J#K#K#J#K#K#J#K#K#J#K#J#K#J#J#K#K#K#K#J#K#K#J#K#J#K#J#K#K#J#K#J#K#J#J#K#J#J#J#J#K#K#K#J#K#K#K#K#K#K#N#J#J#K#K#K#K#J#J#K#J#K#J#J#K#J#J#J#K#K#K#J#K#K#K#K#J#J#K#J#J#K#M#K#J#J#K#K#K#K#N#K#K#K#K#K#K#K#J#K#K#K#K#K#K#K#K#J#K#J#K#J#J#J#K#J#J#J#K#J#J#J#K#J#K#K#J#J#J#K",
    "#K#O#P#K#M#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#M#K#K#K#K#K#K#M#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#Q#K#K#Q#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#M#M#M#M#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#M#M#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#K#M#M#K#K#K#K#M#M#K#K#K#K#K#K#K#K#M#M#M#M#K#K#K#K#K#K#K#J#J#K#K#K#K#K#K#K#K#K#K#K#K#K#K#M#R#M#Q",
    "#S#Q#S#T#U#T#U#U#S#U#U#S#S#U#V#V#U#U#U#U#V#V#V#V#U#U#T#T#T#Q#V#U#V#W#V#W#V#W#T#V#V#S#S#U#S#S#X#S#S#X#X#X#T#Q#U#U#U#R#U#U#U#U#T#S#U#V#U#V#U#U#V#U#U#T#W#U#U#Y#X#T#U#U#U#Y#U#U#S#U#W#S#U#V#U#U#S#U#V#V#V#W#W#W#W#V#V#U#S#S#S#S#S#S#U#S#U#U#V#V#T#T#X#V#U#U#S#Q#T#V#U#U#U#V#V#U#U#U#U#U#U#S#S#S#S#S#S#V#V#S#S#S#S#S#S#Y#T#T#V#V#U#U#U#U#U#U#U#U#U#U#U#R#W#V#V#U#R#W#V#U#U#V#U#U#V#U#U#X#X#X#X#V#V#V#V#T#T#S#U#S#S#X#T#S#U#U#S#U#U#V#U#S#T#R#U#Q#U#Z",
    "#Z#0#W#Z#U#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#1#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#T#0#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#0#0#Z#Z#T#U#U#0#0#Z#Z#Z#Z#Z#Z#U#W#U#Z#Z#Z#Z#Z#0#0#Z#Z#Z#U#U#U#0#Z#Z#Z#0#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#0#W#W#V#W#0#0#Z#Z#Z#Z#Z#Z#Z#Z#Z#T#U#U#0#Z#1#U#Z#Z#Z#Z#Z#Z#Z#Z#W#W#W#W#W#W#W#W#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#1#Z#0#T#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#0#0#0#Z#Z#Z#Z#0#Z#T#0#W#W#Z#Z#0#0#0#Z#Z#Z#Z#Z#U#Z#Z#U#1#U#Z",
    "#0#Z#Z#Z#2#Z#Z#0#Z#0#0#Z#0#Z#Z#3#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#Z#Z#Z#4#0#Z#4#0#Z#Z#Z#Z#0#Z#Z#Z#Z#Z#Z#0#Z#0#Z#Z#0#0#Z#Z#Z#0#Z#Z#0#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#Z#Z#0#Z#Z#0#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#Z#0#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#Z#Z#Z#Z#Z#0#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#Z#Z#Z#0#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#Z#Z#Z#Z#Z#Z#Z#Z#Z#0#Z#Z#Z#Z#Z#Z#0#0#Z#Z#Z#Z#0#Z#Z#Z#Z#Z#Z#Z#0#0#0#0#0#Z#Z#Z",
    "#3#5#0#3#6#3#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#3#3#3#3#0#0#0#0#0#0#3#3#0#3#3#0#0#0#0#0#0#0#0#3#0#0#0#3#3#3#0#0#3#3#0#0#3#3#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#3#0#0#3#3#0#0#3#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#3#Z#3#3#Z#3#0#3#3#3#3#3#3#3#3#0#0#0#Z#3#3#3#3#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#3#3#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#3#3#0#0#3#3#0#3#3#3#3#3#3#3#3#3#0#Z#0#0#3#0#Z#3#7#8#0#3#3#3",
    "#9#9a.#7a.#7#8#8#8#8#8#8#8#9#3#8#8#8#8#8#8#8#3#3#7#3#7#3#3#3#9#9#9#8#8a.#8#8#8#8#8#8#8#8#9#9#7#9#9#7#7#7#7#3#3#3#7#3#3#3#3#3#3#3#3#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#9#8#8#8#8#7#7#7#7#7#7#7#7#3#3#3#3#3#3#3#3#9#8#8#8#8#8#8#9#3#3#3#3#3#3#3#3#3#3#3#7#7#3#3#3#3#3#3#3#3#3#3#3#8#8#8#8#8#8#8#7#3#3#3#3#3#3#7#3a.a.a.a.#8#8#8#8#3#3#3#3#3#3#7#7#8#8#8#8#8#8#9#8#3#3#3#3#3#7#3#3a.a.a.a.#8#8#8#8#7#7#7#7#3#7#7#7#9#8#8#8#8#8#8#9#0a.a.#7#3a.#7",
    "a##9a##7aa#9#9#9#9#9#9#9#9#9a#ab#9#9#9a##9#9#7ab#9#9#9#7#9ab#9#9#9#9#9#9#9#9#9a##9#9#9#9#9a##9#9a##9#9a#a.a.a.#9#9aa#9#9#9#9aa#9#9#9#9#9a#a#a#a##9#9#9a##9#9#9#9#9a#a##9ab#9#9#9#9a.#9aa#9a#aaa#a#a#a##7#9#9#9#9#9aaa#ab#9#9#9#9#9#9#9#9#9#9#9#9#9#9#9#9#9#9#7#9#9ab#9a.aaaaa##9#7#9#9a##9#9a##9#9#9a#a##9#9aaaa#9#9#9#9#9aa#9#9#9#7#7#9#9#9#9#9#9#9#9#9#9a#a##9#9a#a#a#a#a#a##9#9#9#9#9#9#9#9#9#9#9#9a##9#9a##9#9#9#9#9#9ab#9#9#9#9#9#9#9a.a.#7",
    "#9#9#9#7a##9aaaa#9#7#7#9#9#9aaab#9ab#9a.#9#9#9#9#9ababab#9#9a##9#9a#a##9#9aa#9#9#9#9#9#9#9#9#9#9#9#9#9#9#9#9#9#9ab#9abababab#9abab#9#9#9#9#9#9#9#9#9#9#9#9#9#9a#a#aa#9ab#9#9abab#9aa#9ab#9#9aa#9ab#9#9ab#9abaaaaa#ab#9#9ab#9ab#9abab#9#9#9#9#9abab#9#9ab#9#9ab#9a##9#9#9a#a##9#9#9ab#9ab#9#9ab#9ab#9#9ab#9#9#9#9#9#9#9#9#9ab#9#9a##9#9#9#9#9#9#9#9ab#9#9#9#9abab#9abababab#9#9#9aba#aaaa#9#9aaaa#9#9#9#9#9#9#9#9#9#9#9#9abab#9#9#9#9aaa##9a#a##7",
    "#9#9ab#7aaababab#9ababab#9abababababababababababababababababaaaba#ab#9ab#9ababababaaababab#9#9ab#9#9#9abababab#9#9#9ababab#9ababababababababaaaaaaabababababababababababababababab#9abababababab#9ab#9ababababababababababababababababaaaaaaaaababababababababababababababababababababab#9abababab#9ababab#9#9#9abaaabababab#9ababababab#9#9ababababababababababababababababababab#9#9ab#9ababab#9aaab#9#9#9ababababaaabababab#9a#abababaaababab",
    "abababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababab",
    "acacabacaaacababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababababab#9acacacacacacabacaca#acacab#7a#acaaaba#a#adabacabababababababababa#aaacacacab"
};

static const char* const image2_data[] = {
    "40 40 562 2",
    "eH c #034968",
    "eo c #074865",
    "ep c #0c506f",
    "fR c #0d506f",
    "cK c #12475e",
    "cL c #174e67",
    "fS c #296584",
    "dU c #296585",
    "gg c #2a6585",
    "dA c #2a6685",
    "cM c #2c6886",
    "eq c #2f6a87",
    "fG c #2f7895",
    "db c #306a87",
    "da c #316f8a",
    "e. c #355b62",
    "er c #38708a",
    "gf c #39708b",
    "es c #3c738c",
    "gu c #3d738c",
    "d# c #3d87a4",
    "aD c #3f3f3f",
    "cq c #404040",
    "fD c #407f99",
    "b7 c #414141",
    "cJ c #416163",
    "en c #41666d",
    "dx c #416d7b",
    "eR c #424242",
    "ek c #426d7a",
    "c8 c #426e7c",
    "el c #427080",
    "em c #427386",
    "c9 c #42778e",
    "ex c #434343",
    "br c #444444",
    "b. c #454545",
    "fY c #454749",
    "aP c #464646",
    "bM c #47494b",
    "gG c #48829b",
    "#6 c #494949",
    "#K c #4a4a4a",
    "g. c #4a4e52",
    "fa c #4b4641",
    "cg c #4b4a47",
    "cu c #4b4b4b",
    "#v c #4c4c4c",
    "ew c #4c4d4e",
    "#e c #4d4d4d",
    "fu c #4d5053",
    "bQ c #4e4e4e",
    ".U c #4f4f4f",
    "dF c #505152",
    "eQ c #505356",
    ".z c #515151",
    "aw c #525252",
    "aq c #534e48",
    "#Q c #535353",
    ".h c #545454",
    "gy c #54595e",
    ".g c #555555",
    ".V c #555658",
    "fP c #564c42",
    ".q c #565656",
    "c4 c #575047",
    "bo c #575144",
    "bH c #57534a",
    "bD c #575552",
    ".A c #57585a",
    "bd c #595a5a",
    "bs c #596069",
    "gF c #5aa6c2",
    "aa c #5c5c5d",
    "gn c #5c656f",
    "fN c #5d6368",
    "ar c #5d646c",
    "dG c #5e5449",
    "eb c #5e6164",
    "cN c #5e8ba3",
    "dz c #5f96ac",
    ".G c #605b56",
    ".i c #606366",
    "fQ c #616d79",
    "eI c #628da1",
    "bi c #636260",
    ".f c #636669",
    "ab c #675d53",
    "f# c #676d74",
    "f9 c #6b6c6e",
    "fF c #6badc6",
    "#j c #6d7073",
    "b# c #6d7a87",
    "fZ c #6d7c8c",
    "fX c #6e5a45",
    "cp c #6f5b46",
    "b6 c #6f5c46",
    "b2 c #6f624d",
    "cF c #6f634b",
    "a5 c #6f6655",
    "bn c #6f6758",
    "a0 c #6f6e6c",
    "bL c #705c47",
    "cR c #707275",
    "#w c #707985",
    "cI c #708480",
    ".y c #716252",
    "#f c #737c87",
    ".r c #746555",
    "fn c #74b1c8",
    "gz c #758696",
    ".1 c #76797e",
    "cv c #77634e",
    "dy c #77c5e0",
    "#d c #796550",
    "be c #7a6651",
    ".e c #7a7f87",
    "g# c #7a8ca0",
    "eS c #7b6247",
    ".j c #7b838c",
    "#L c #7c8997",
    "aU c #7f8285",
    "#y c #7f8287",
    "#5 c #80674d",
    "d. c #81a4b4",
    "c# c #826a4f",
    ".p c #838a91",
    "bw c #846b51",
    "fC c #856747",
    ".B c #85909d",
    "aC c #878684",
    "go c #889eb5",
    "aO c #896c4c",
    "fl c #8dbcce",
    "fW c #8e9399",
    ".T c #8f7252",
    "fO c #906e49",
    "c5 c #927a5c",
    "cm c #927b5a",
    "dY c #92979d",
    ".2 c #937555",
    "dZ c #94724c",
    ".F c #949ca5",
    ".W c #94a0b0",
    "f0 c #96b0c9",
    "#J c #97744f",
    "#u c #987550",
    ".k c #98a5b3",
    "eK c #99d4e8",
    "#7 c #9aabbe",
    ".x c #9b7953",
    "fb c #9c754a",
    "aQ c #9cafc4",
    ".s c #9d7a55",
    "fE c #9ec3d2",
    "cl c #9f8a61",
    "bX c #9f9684",
    "bW c #9f988b",
    "af c #9f9e9c",
    ".d c #a0abb8",
    "ga c #a0bad4",
    "de c #a1a6aa",
    "ft c #a2b0be",
    "bR c #a37c51",
    "f5 c #a5c1de",
    "#R c #a67f54",
    ".H c #a78055",
    "eL c #a7c7d3",
    "#P c #abb2ba",
    "gp c #abc5e0",
    "cr c #acc4e0",
    "av c #aeb3ba",
    "b8 c #aec7e2",
    ".w c #b08454",
    "fo c #b0c8e1",
    "fH c #b0c9e1",
    "f1 c #b0c9e2",
    "gx c #b2b4b5",
    "gA c #b2cae2",
    "fv c #b3824d",
    "bN c #b4cbe4",
    "e5 c #b4cce3",
    "ey c #b5834e",
    "ec c #b5844f",
    "fT c #b5cce3",
    "c3 c #b6965f",
    "f6 c #b6cce4",
    "df c #b78550",
    "gh c #b7cce4",
    "gS c #b7cde4",
    "ax c #ba8954",
    "dV c #bad0e6",
    "#k c #bb8a55",
    "e# c #bbd0e6",
    ".t c #bc8a55",
    "f2 c #bcd1e7",
    "f4 c #bdd2e7",
    "eP c #bec7d1",
    "dB c #bed2e7",
    "bt c #bed2e8",
    "gv c #bed3e7",
    "gO c #bfd3e7",
    "f3 c #bfd3e8",
    ".C c #c0d1e5",
    "eJ c #c0d2d9",
    ".l c #c1d1e7",
    "gJ c #c1d4e8",
    ".o c #c2d0e0",
    "a6 c #c3a466",
    "a4 c #c3af88",
    "cf c #c3b69d",
    "gB c #c3d6e9",
    "as c #c3d6eb",
    "Qt c #c5d9f0",
    ".c c #c7d7ea",
    "#g c #c9daef",
    ".# c #c9ddf2",
    "gb c #cadaeb",
    "ba c #cadbed",
    "fB c #cb8f50",
    "eM c #ccdcec",
    ".a c #ccdff3",
    "fm c #cce9f3",
    "gm c #cdcece",
    "f7 c #cddded",
    ".X c #cdddf1",
    ".m c #cddef3",
    "#M c #cedef0",
    "ag c #cfcdc8",
    "f. c #cfdbe6",
    "gK c #cfdeed",
    "gq c #cfdfed",
    ".D c #cfe0f3",
    ".b c #cfe0f4",
    ".v c #d09455",
    ".u c #d09555",
    "ev c #d0d8df",
    ".0 c #d1ddec",
    "dc c #d1e0ee",
    ".n c #d2e2f4",
    "#i c #d4dfed",
    "fM c #d4e1ef",
    ".Y c #d4e2f4",
    "#8 c #d4e3f2",
    "gC c #d6e3f0",
    "aR c #d6e3f2",
    ".E c #d6e4f5",
    "a9 c #d79752",
    "cG c #d9ad74",
    ".Z c #d9e6f6",
    "gi c #dbe6f2",
    "#h c #dce8f7",
    "a# c #dde5ef",
    "cs c #dde7f3",
    "b9 c #dde7f4",
    "#N c #dde9f7",
    "bO c #dee9f4",
    "gI c #dfe9f3",
    "fs c #dfeaf3",
    "at c #dfeaf6",
    "gL c #e0eaf4",
    "#x c #e0ebf8",
    "#9 c #e1ecf7",
    "fc c #e29d52",
    "bu c #e2ebf6",
    "gr c #e2ecf5",
    "#O c #e2edf8",
    "ap c #e39e53",
    "fp c #e3ecf5",
    "fI c #e3edf5",
    ".S c #e49f54",
    "e6 c #e4edf5",
    ".I c #e59f55",
    "dE c #e5eaef",
    "fU c #e5eef5",
    "gV c #e6eef6",
    "bb c #e6eef8",
    "dW c #e6eff7",
    "a. c #e6eff9",
    "bC c #e7dfcf",
    "dC c #e7eff6",
    "ea c #e7eff7",
    "aS c #e7eff9",
    "au c #e8f0f9",
    "gc c #e9f0f7",
    "fL c #eaf1f7",
    "gQ c #ebf1f7",
    "ge c #ebf1f8",
    "gw c #ebf2f8",
    "aT c #ebf2fa",
    "gd c #ecf1f8",
    "eN c #ecf2f8",
    "cO c #ecf2f9",
    "eT c #eda354",
    "dd c #edf3f9",
    "cS c #eea454",
    "gM c #eef3f9",
    "bc c #eef4fb",
    "aV c #efa455",
    ".3 c #efa555",
    "gU c #eff4f9",
    "gj c #f0f4fa",
    "gs c #f0f6fa",
    "bv c #f0f6fb",
    "gR c #f1f5fa",
    "b1 c #f3d08b",
    "ch c #f3deb4",
    "ae c #f3f2ef",
    "e9 c #f3f6fa",
    "bP c #f3f7fc",
    "gD c #f3f8fb",
    "gP c #f4f7fb",
    "fr c #f4f8fb",
    "cP c #f4f8fc",
    "c. c #f5f8fc",
    "eO c #f5f9fc",
    "et c #f6f9fc",
    "ct c #f7fafd",
    "gN c #f8fafc",
    "gH c #f8fafd",
    "fK c #f8fbfc",
    "cQ c #f8fbfd",
    "#S c #f9aa55",
    "dg c #f9ac57",
    "bK c #f9ac58",
    "#4 c #f9ad58",
    "#t c #f9ae5b",
    "d9 c #f9af5e",
    "#l c #f9af5f",
    ".J c #f9af60",
    "gk c #f9fbfd",
    "gt c #f9fcfd",
    "dD c #f9fcfe",
    "eU c #faaf60",
    "fd c #fab162",
    "b5 c #fab164",
    "aN c #fab25c",
    "ay c #fab364",
    "#I c #fab462",
    ".R c #fab468",
    "fw c #fab469",
    ".4 c #faba75",
    "gT c #fafcfd",
    "dX c #fafcfe",
    "dH c #fbb967",
    "ez c #fbb973",
    "fA c #fbbb76",
    "#c c #fbbc75",
    "ed c #fbbe78",
    "eV c #fbc386",
    ".K c #fbc58a",
    ".Q c #fbc88f",
    "e8 c #fbfcfe",
    "eu c #fbfdfe",
    "cT c #fcb95f",
    "d0 c #fcbe71",
    "a8 c #fcc06b",
    "eg c #fcc584",
    "b4 c #fcc585",
    "c6 c #fcc689",
    "du c #fcc68a",
    "eh c #fcc68b",
    "aW c #fcc786",
    "cH c #fcc78b",
    "eC c #fcc78c",
    "eB c #fcc78d",
    "dQ c #fcc88e",
    "fz c #fcc890",
    "eD c #fcc990",
    "co c #fcc991",
    "eA c #fcca92",
    "ei c #fccc97",
    "d5 c #fccc98",
    "ac c #fccf9a",
    ".P c #fcd3a5",
    ".L c #fcd5aa",
    "dT c #fcd8b1",
    "#m c #fcd9b2",
    "e7 c #fcfdfe",
    "fq c #fcfefe",
    "bq c #fdc678",
    "ee c #fdc680",
    "dt c #fdc681",
    "cn c #fdc682",
    "dP c #fdc683",
    "ef c #fdc77d",
    "dO c #fdc77e",
    "bJ c #fdc77f",
    "d4 c #fdc87a",
    "ds c #fdc87b",
    "b3 c #fdc87c",
    "dv c #fdd1a2",
    "c7 c #fdd1a3",
    "fk c #fdd2a4",
    "dR c #fdd3a7",
    "ej c #fdd4a9",
    "eW c #fdd5ab",
    "#s c #fdd7a1",
    "eE c #fdd8af",
    "d6 c #fdd8b0",
    "eX c #fdd8b1",
    "eY c #fddab4",
    "eZ c #fdddba",
    ".O c #fddebc",
    ".M c #fddfbe",
    ".5 c #fddfbf",
    "eF c #fde0bf",
    "dw c #fde0c1",
    "e4 c #fde2c4",
    "d8 c #fde3c6",
    "fJ c #fdfefe",
    "fV c #fdfeff",
    "gE c #fdffff",
    "ao c #fec76c",
    "dh c #fec970",
    "bI c #fec976",
    "d3 c #fec977",
    "d1 c #fec978",
    "dN c #fec979",
    "dI c #feca72",
    "d2 c #feca73",
    "dM c #feca74",
    "dr c #feca75",
    "dJ c #fecb6f",
    "dq c #fecb70",
    "bp c #fecb71",
    "fy c #fed5aa",
    "fe c #fed7ae",
    "bf c #fed8a0",
    "#H c #fedda3",
    "e0 c #fee1c2",
    "dS c #fee1c3",
    "#b c #fee2bd",
    "d7 c #fee5ca",
    "e1 c #fee6cc",
    "fj c #fee7cf",
    "eG c #fee8d1",
    ".N c #fee9d3",
    "#T c #feeacf",
    "#z c #feecd6",
    "e2 c #feecd9",
    "e3 c #fef4e8",
    "f8 c #fefeff",
    "gl c #feffff",
    "a7 c #ffcc6d",
    "dL c #ffcc6e",
    "dp c #ffcd6d",
    "aM c #ffce6e",
    "di c #ffce6f",
    "dK c #ffcf6f",
    "do c #ffcf71",
    "c2 c #ffd071",
    "dj c #ffd176",
    "cE c #ffd278",
    "cU c #ffd279",
    "c1 c #ffd47e",
    "dn c #ffd580",
    "ca c #ffd585",
    "cw c #ffd683",
    "aL c #ffd684",
    "dm c #ffd686",
    "cV c #ffd786",
    "dk c #ffd787",
    "cD c #ffd788",
    "dl c #ffd889",
    "c0 c #ffd88a",
    "#3 c #ffd88f",
    "an c #ffd98c",
    "ck c #ffd98e",
    "cW c #ffda90",
    "cx c #ffda91",
    "cZ c #ffdb93",
    "cC c #ffdc96",
    "cb c #ffdd98",
    "bS c #ffdd9a",
    "aK c #ffde9c",
    "cj c #ffde9d",
    "cY c #ffdf9f",
    "bG c #ffdfa0",
    "fx c #ffdfbe",
    "b0 c #ffe0a1",
    "cX c #ffe0a2",
    "am c #ffe1a4",
    "cc c #ffe1a5",
    "cy c #ffe2a6",
    "#2 c #ffe2a9",
    "cB c #ffe3a9",
    "bx c #ffe3aa",
    "ff c #ffe3c6",
    "bm c #ffe4ae",
    "bZ c #ffe4af",
    "aJ c #ffe5b0",
    "cd c #ffe5b1",
    "fg c #ffe5ca",
    "cz c #ffe6b3",
    "ci c #ffe6b4",
    "fh c #ffe6cc",
    "cA c #ffe7b6",
    "bT c #ffe7b7",
    "al c #ffe7b8",
    "a3 c #ffe8b9",
    "ce c #ffe8ba",
    "bY c #ffe8bb",
    "fi c #ffe8d0",
    "#1 c #ffe9bd",
    "bF c #ffe9be",
    "#G c #ffeac0",
    "bU c #ffeac1",
    "aI c #ffebc2",
    "by c #ffecc5",
    "bg c #ffecc6",
    "ak c #ffedc8",
    "bE c #ffedc9",
    "bl c #ffedca",
    "#0 c #ffeecd",
    "bz c #ffefcf",
    "aH c #ffefd0",
    "#F c #fff0d1",
    "#r c #fff0d2",
    "a2 c #fff1d4",
    "bk c #fff1d5",
    "aj c #fff2d6",
    "az c #fff2d7",
    "bV c #fff2d8",
    "aX c #fff3da",
    "#Z c #fff3db",
    "aG c #fff3dc",
    "bj c #fff4dd",
    "#E c #fff4de",
    "#q c #fff5df",
    "bA c #fff5e0",
    "ai c #fff5e1",
    "aA c #fff5e2",
    "aY c #fff6e3",
    "bB c #fff6e4",
    "aF c #fff6e5",
    "#Y c #fff7e5",
    "a1 c #fff7e6",
    "ad c #fff7e7",
    "#D c #fff7e8",
    "#a c #fff8e9",
    "ah c #fff8ea",
    "aE c #fff9ec",
    "bh c #fff9ed",
    "#X c #fff9ee",
    "aB c #fffaef",
    "#C c #fffaf0",
    "## c #fffaf1",
    "#U c #fffbf2",
    "aZ c #fffbf3",
    "#W c #fffbf4",
    "#. c #fffcf6",
    "#p c #fffcf7",
    "#V c #fffdf8",
    "#A c #fffdf9",
    "#B c #fffdfa",
    ".9 c #fffefa",
    "#o c #fffefb",
    "#n c #fffefc",
    ".8 c #fffefd",
    ".7 c #fffffe",
    ".6 c #ffffff",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
    ".#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#",
    ".a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a",
    ".b.b.b.b.b.b.b.b.b.b.c.d.e.f.g.g.g.h.h.i.j.k.l.m.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b",
    ".n.n.n.n.n.n.n.n.o.p.q.q.r.s.t.u.u.v.w.x.y.z.A.B.C.D.n.n.n.n.n.n.n.n.n.n.n.n.n.n",
    ".E.E.E.E.E.E.E.F.q.G.H.I.J.K.L.M.N.O.P.Q.R.S.T.U.V.W.X.Y.E.E.E.E.E.E.E.E.E.E.E.E",
    ".Z.Z.Z.Z.Z.0.1.g.2.3.4.5.6.6.6.7.8.9#.###a#b#c.S#d#e#f#g.E.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z",
    "#h#h#h#h#i#j.g#k#l#m#n.7.6.6.6.7.8#o#p###a#q#r#s#t#u#v#w#g.Z#h#h#h#h#h#h#h#h#h#h",
    "#x#x#x#x#y.h#k#l#z#A#n.7.7.6.6.7.8#B#.#C#D#E#F#G#H#I#J#K#L#M#N#x#x#x#x#x#x#x#x#x",
    "#O#O#O#P#Q#R#S#T#U#p#B#n.7.7.7.8#o#V#W#X#Y#Z#0#1#2#3#4#5#6#7#8#9#O#O#O#O#O#O#O#O",
    "a.a.a#aaab#Sacad#X#W#V#B#n#n#naeafag##ahaiajakalamanaoapaqarasata.a.a.a.a.a.a.a.",
    "auauavawaxayazaA#aaB#W#p#V#A#AaCaDaDaEaFaGaHaIaJaKaLaMaNaOaPaQaRaSauauauauauauau",
    "aTaTaU.zaVaWaHaXaY#a#X##aZ#W#Wa0aDaDa1#Ea2aka3a4a5a6a7a8a9b.b#babbaTaTaTaTaTaTaT",
    "bcbcbdbe#Sbfbg#FaXaia1ahaEbhbhbiaDaDbjbkbl#1bmbnaDbobpbq#Sbrbsbtbubcbcbcbcbcbcbc",
    "bvbv.Ubw#Sbxa3bybzazaGbAaYbBbCaDaDbD#rbEbFaJbGbHaDaDbIbJbKbLbMbNbObvbvbvbvbvbvbv",
    "bPbPbQbR#SbSbxbTbUblaHa2azbVbWaDaDbXbybYbZb0b1aDaDb2b3b4b5b6b7b8b9bPbPbPbPbPbPbP",
    "c.c.#ec##Scacbcccdce#GbyakbEcfaDcgchcibxcjckclaDaDcmcnco#Scpcqcrcsc.c.c.c.c.c.c.",
    "ctctcucv#SaocwcxcjcybmczcAbTbTciaJcBb0cCcDcEcFaDaDcGcHcIcJcKcLcMcNcOcPctctctctct",
    "cQcQcR#KcScTaMcUcVcWcbcjb0cXb0cYbScZc0c1c2a7c3c4c5c6c7c8c9d.d#dadbdcddcQcQcQcQcQ",
    "cQcQde#6dfdgdha7didjc1aLdkdlcDdmdncUdodpdqdrdsdtdudvdwdxd..6dydzdAdBdCcQcQcQcQcQ",
    "dDdDdEdFdGcSdHbIdIdJa7dpdidKdiaMdpdLbpdMdNdOdPdQdRdSdTcJd..6dydzdUdVdWdDdDdDdDdD",
    "dXdXctdYaPdZ#Sd0b3d1bIdMd2dId2d2drd3d4dOcnc6d5d6d7d8d9e.d..6dydzdUe#eadXdXdXdXdX",
    "dXdXdXddebb.ecbKedcneedOefefefdObJdtegeheiejekelemene.eod..6dydzepeqeresesescOet",
    "eueueucQevewexey#SezeAeBcHdudueCeDeidveEeFeGeHeId.d.d.d.eJ.6eKeLd.d.d.d.eIeHeMeN",
    "eueueueueOePeQeReSeTeUeVeWd6eXeYeZe0e1e2e3e4eHeJ.6.6.6.6.6.6.6.6.6.6.6.6eJeHe5e6",
    "e7e7e7e7e8e9f.f#cqfafbfcfdfefffgfhfifjfkfdfceHfleKeKeKeKfm.6eKeKeKeKeKeKfneHfofp",
    "fqfqfqfqfqeufrfsftfuaDaDfvfwfxfyfzfA#SfBfCaDeHfDd#d#d#d#fE.6dyfFd#d#d#d#fGeHfHfI",
    "fJfJfJfJfJfJfqfKfLfMfNaDaDfB#S#SfBfOfPaDaDfQdAdAdAdAdAfRd..6dydzepfSfSdAdAdAfTfU",
    "fVfVfVfVfVfVfVfVeucPfWaDaDfPfXaDaDaDfYfZf0f1f2f3f4f4f4dbd..6dydzdUf5f6f4f4f4f7dd",
    "f8f8f8f8f8f8f8f8f8f8f9aDaDaDaDaDg.g#gaf6gbcsgcgdgegegegfd..6dydzggghgigegegegjgk",
    "glglglglglglglglglgmaDaDaDaDgngogpe#gqgrgsgtfVglglglglgud..6dydzdAgvgwglglglglgl",
    "glglglglglglglglglgxaDgygzgagAgBgCdCgDeugEglglglglglglgueIeJgFgGdAgvgwglglglglgl",
    ".6.6.6.6.6.6.6.6.6gHgIgJdBgKgLgMgNfJ.6.6.6.6.6.6.6.6.6gueHeHeHeHdAgOeN.6.6.6.6.6",
    ".6.6.6.6.6.6.6.6.6e7gPgQeNgPeugl.6.6.6.6.6.6.6.6.6.6.6gRgKgSgAgAgSgKgR.6.6.6.6.6",
    ".6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6gTgUdCgVgVdCgUgT.6.6.6.6.6",
    ".6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6",
    ".6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6",
    ".6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6",
    ".6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6",
    ".6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6"
};


/*
 *  Constructs a AllowFriendForm as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
AllowFriendForm::AllowFriendForm( QWidget* parent, const char* name, bool modal, WFlags fl )
        : QDialog( parent, name, modal, fl ),
        image1( (const char **) image1_data ),
        image2( (const char **) image2_data ) {
    KStandardDirs   *dirs   = KGlobal::dirs();
    QString         sPicsPath;
    sPicsPath = dirs->findResource( "data", QString( KGlobal::instance()->aboutData()->appName() ) + "/pics/" );

    QImage img;
    img.loadFromData( image0_data, sizeof( image0_data ), "PNG" );
    image0 = img;
    if ( !name )
        setName( "AllowFriendForm" );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 350, 250 ) );
    setMaximumSize( QSize( 350, 250 ) );
    setBaseSize( QSize( 350, 250 ) );
    setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    setIcon( image0 );
    AllowFriendFormLayout = new QVBoxLayout( this, 0, 0, "AllowFriendFormLayout");

    frame3 = new QFrame( this, "frame3" );
    frame3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, 0, 0, frame3->sizePolicy().hasHeightForWidth() ) );
    frame3->setPaletteBackgroundPixmap( image1 );
    frame3->setFrameShape( QFrame::NoFrame );
    frame3->setFrameShadow( QFrame::Plain );
    frame3Layout = new QHBoxLayout( frame3, 0, 0, "frame3Layout");
    spacer3 = new QSpacerItem( 10, 10, QSizePolicy::Fixed, QSizePolicy::Minimum );
    frame3Layout->addItem( spacer3 );

    pixmapLabel1 = new QLabel( frame3, "pixmapLabel1" );
    pixmapLabel1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, pixmapLabel1->sizePolicy().hasHeightForWidth() ) );
    pixmapLabel1->setPixmap( image2 );
    pixmapLabel1->setScaledContents( TRUE );
    frame3Layout->addWidget( pixmapLabel1 );
    spacer4 = new QSpacerItem( 10, 10, QSizePolicy::Fixed, QSizePolicy::Minimum );
    frame3Layout->addItem( spacer4 );

    useridLabel = new QLabel( frame3, "useridLabel" );
    useridLabel->setAlignment( int( QLabel::WordBreak | QLabel::AlignTop | QLabel::AlignLeft ) );
    frame3Layout->addWidget( useridLabel );
    spacer5 = new QSpacerItem( 10, 10, QSizePolicy::Fixed, QSizePolicy::Minimum );
    frame3Layout->addItem( spacer5 );
    AllowFriendFormLayout->addWidget( frame3 );

    frame4 = new QFrame( this, "frame4" );
    frame4->setFrameShape( QFrame::StyledPanel );
    frame4->setFrameShadow( QFrame::Raised );
    frame4->setMargin( 1 );
    frame4->setMidLineWidth( 1 );
    frame4Layout = new QVBoxLayout( frame4, 11, 6, "frame4Layout");

    layout5 = new QVBoxLayout( 0, 0, 6, "layout5");

    layout3 = new QHBoxLayout( 0, 0, 6, "layout3");

    textLabel1_2 = new QLabel( frame4, "textLabel1_2" );
    textLabel1_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, textLabel1_2->sizePolicy().hasHeightForWidth() ) );
    layout3->addWidget( textLabel1_2 );
    spacer2 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout3->addItem( spacer2 );
    layout5->addLayout( layout3 );

    messageLabel = new QLabel( frame4, "messageLabel" );
    messageLabel->setFrameShape( QLabel::Box );
    messageLabel->setFrameShadow( QLabel::Plain );
    messageLabel->setAlignment( int( QLabel::AlignTop | QLabel::AlignLeft ) );
    layout5->addWidget( messageLabel );
    frame4Layout->addLayout( layout5 );
    AllowFriendFormLayout->addWidget( frame4 );

    layout1 = new QHBoxLayout( 0, 0, 6, "layout1");

    profileButton = new QPushButton( this, "profileButton" );
    profileButton->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    layout1->addWidget( profileButton );
    spacer1 = new QSpacerItem( 16, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout1->addItem( spacer1 );

    acceptButton = new QPushButton( this, "acceptButton" );
    acceptButton->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    layout1->addWidget( acceptButton );

    rejectButton = new QPushButton( this, "rejectButton" );
    rejectButton->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    layout1->addWidget( rejectButton );

    cancelButton = new QPushButton( this, "cancelButton" );
    cancelButton->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    layout1->addWidget( cancelButton );
    AllowFriendFormLayout->addLayout( layout1 );
    languageChange();
    resize( QSize(350, 250).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( cancelButton, SIGNAL( clicked() ), this, SLOT( close() ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
AllowFriendForm::~AllowFriendForm() {
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void AllowFriendForm::languageChange() {
    setCaption( trUtf8( "\xec\xb9\x9c\xea\xb5\xac\x20\xec\xb6\x94\xea\xb0\x80\x20\xec\x9a\x94\xec\xb2\xad" ) );
    useridLabel->setText( tr( "textLabel1" ) );
    textLabel1_2->setText( trUtf8( "친구요청 메시지 :" ) );
    messageLabel->setText( tr( "textLabel2" ) );
    profileButton->setText( trUtf8( "프로필 보기" ) );
    acceptButton->setText( trUtf8( "수락" ) );
    rejectButton->setText( trUtf8( "거절" ) );
    cancelButton->setText( trUtf8( "취소" ) );
}

#include "allowdialoginterface.moc"

