/*ImageSubCodecDecompressCapabilities

Returned by an image decompressor component in response to ImageCodecInitialize.

struct ImageSubCodecDecompressCapabilities {
   long       recordSize;
   long       decompressRecordSize;
   Boolean    canAsync;
   UInt8      pad0;
Fields
recordSize
Discussion

The size of this structure in bytes.
decompressRecordSize
Discussion

The size of the ImageSubCodecDecompressRecord structure that your image decompressor component requires. This structure is used to pass information from ImageCodecBeginBand to ImageCodecDrawBand and ImageCodecEndBand.
canAsync
Discussion

Specifies whether your image decompressor component can perform asynchronous scheduled decompression. This should be TRUE unless your image decompressor component calls functions that cannot be called during interrupt time.
pad0
Discussion

Unused.
Discussion

The first function call that your image decompressor component receives from the base image decompressor is always a call to ImageCodecInitialize. In response to this call, your image decompressor component returns an ImageSubCodecDecompressCapabilities structure that specifies its capabilities.
Related Functions
ImageCodecInitialize 
Declared In
ImageCodec.h*/

struct ImageSubCodecDecompressCapabilities {
   long       recordSize;
   long       decompressRecordSize;
   Boolean    canAsync;
   UInt8      pad0;
 int baseCodecShouldCallDecodeBandForAllFrames; //hys
int subCodecIsMultiBufferAware; //hys
int subCodecSupportsOutOfOrderDisplayTimes; //hys
};
