#ifndef DATETIMEUTILS_H
#define DATETIMEUTILS_H



#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef UTCUTILS_H
#include <CarbonCore/UTCUtils.h>
#endif

#ifndef CFDATE_H
#include <CoreFoundation/CFDate.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*LongDateTime

typedef SInt64 LongDateTime;
Discussion

The long date-time value specifies the date and time as seconds relative to midnight, January 1, 1904. But where the standard date-time value is an unsigned, 32-bit long integer, the long date-time value is a signed, 64-bit integer in SANE comp format. This format lets you use dates and times with a much longer span—roughly 500 billion years. You can use this value to represent dates and times prior to midnight, January 1, 1904. The LongDateTime data type defines the long date-time value.

When storing a long date-time value in files, you can use a 5-byte or 6-byte format for a range of roughly 35,000 years. You should sign extend this value to restore it to a comp format. Use the LongDateCvt structure to help you in setting up a LongDateTime value. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt64 LongDateTime;

/*DateTimeRec

struct DateTimeRec {
   short year;
   short month;
   short day;
   short hour;
   short minute;
   short second;
   short dayOfWeek;
};
typedef struct DateTimeRec DateTimeRec;
Fields
year

The year, ranging from 1904 to 2040. Note that to indicate the year 1984, this field would store the integer 1984, not just 84. This field accepts input of 0 or negative values, but these values produce unpredictable results in the year, month, and day fields when you use the SecondsToDate and DateToSeconds functions. In addition, using SecondsToDate and DateToSeconds with year values greater than 2040 causes a wraparound to 1904 plus the number of years over 2040. For example, setting the year to 2045 returns a value of 1909, and the other fields in this record return unpredictable results.
month

The month of the year, where 1 represents January, and 12 represents December. Values greater than 12 cause a wraparound to a future year and month. This field accepts input of 0 or negative values, but these values produce unpredictable results in the year, month, and day fields when you use the SecondsToDate and DateToSeconds functions.
day

The day of the month, ranging from 1 to 31. Values greater than the number of days in a given month cause a wraparound to a future month and day. This feature is useful for working with leap years. For example, the 366th day of January in 1992 (1992 was a leap year) evaluates as December 31, 1992, and the 367th day of that year evaluates as January 1, 1993. 

This field accepts 0 or negative values, but when you use the SecondsToDate and DateToSeconds procedures, a value of 0 in this field returns the last day of the previous month. For example, a month value of 2 and a day value of 0 return 1 and 31, respectively. 

Using SecondsToDate and DateToSeconds with a negative number in this field subtracts that number of days from the last day in the previous month. For example, a month value of 5 and a day value of ?1 return 4 for the month and 29 for the day a month value of 2 and a day value of ?15 return 1 and 16, respectively.
hour

The hour of the day, ranging from 0 to 23, where 0 represents midnight and 23 represents 11:00 P.M. Values greater than 23 cause a wraparound to a future day and hour. This field accepts input of negative values, but these values produce unpredictable results in the month, day, hour, and minute fields you use the SecondsToDate and DateToSeconds procedures.
minute

The minute of the hour, ranging from 0 to 59. Values greater than 59 cause a wraparound to a future hour and minute. When you use the SecondsToDate and DateToSeconds procedures, a negative value in this field has the effect of subtracting that number from the beginning of the given hour. For example, an hour value of 1 and a minute value of ?10 return 0 hours and 50 minutes. However, if the negative value causes the hour value to be less than 0, for example hour = 0, minute = ?61, unpredictable results occur.
second

The second of the minute, ranging from 0 to 59. Values greater than 59 cause a wraparound to a future minute and second. When you use the SecondsToDate and DateToSeconds procedures, a negative value in this field has the effect of subtracting that number from the beginning of the given minute. For example, a minute value of 1 and a second value of ?10 returns 0 minutes and 50 seconds. However, if the negative value causes the hour value to be less than 0, for example hour = 0, minute = 0, and second = ?61, unpredictable results occur.
dayOfWeek

The day of the week, where 1 indicates Sunday and 7 indicates Saturday. This field accepts 0, negative values, or values greater than 7. When you use the SecondsToDate and DateToSeconds procedures, you get correct values because this field is automatically calculated from the values in the year, month, and day fields.
Discussion

The date-time record describes the date-time information as a date and time. The Date, Time, and Measurement Utilities use a date-time record to read and write date-time information to and from the system. 

The date-time record can be used to hold date and time values only for a Gregorian calendar. The long date-time record, LongDateRec, can be used for a Gregorian calendar as well as other calendar systems. 
Availability
Available in Mac OS X v10.0 and later.*/

struct DateTimeRec {
   short year;
   short month;
   short day;
   short hour;
   short minute;
   short second;
   short dayOfWeek;
};
typedef struct DateTimeRec DateTimeRec;

/*LongDateRec

union LongDateRec {
   struct {
      short era;
      short year;
      short month;
      short day;
      short hour;
      short minute;
      short second;
      short dayOfWeek;
      short dayOfYear;
      short weekOfYear;
      short pm;
      short res1;
      short res2;
      short res3;
   } ld;
   short list[14]
   struct {
      short eraAlt;
      DateTimeRec oldDate;
   } od;
};
typedef union LongDateRec LongDateRec;
Fields
era

The value 0 represents A.D. and -1 represents B.C
year

The year, from 30081 B.C. to 29940 A.D.
month

The month (1 = January and 12 = December).
day

The day of the month, from 1 to 31.
hour

The hour, from 0 to 23.
minute

The minute, from 0 to 59.
second

The second., from 0 to 59
dayOfWeek

The day of the week (1 through 7).
dayOfYear

The day of the year, from 1 to 365.
weekOfYear

The week of the year. from 1 through 52.
pm

The value 0 represents AM and the value 1 represents PM.
res1

Reserved.
res2

Reserved.
res3

Reserved.
list

An array [0 . . 13] whose values indicate which of the fields in a long date-time record need to be verified.
eraAlt

Indicates the era, used only for conversion from a date-time record to a long date-time record.
oldDate

Used only for conversion from a date-time record to a long date-time record.
Discussion

In addition to the date-time record, system software provides the long date-time record, which extends the date-time record format by adding several more fields. This format lets you use dates and times with a much longer span (30,000 B.C. to 30,000 A.D.). In addition, the long date-time record allows conversions to different calendar systems, such as a lunar calendar. 
Availability
Available in Mac OS X v10.0 and later.*/

union LongDateRec {
   struct {
      short era;
      short year;
      short month;
      short day;
      short hour;
      short minute;
      short second;
      short dayOfWeek;
      short dayOfYear;
      short weekOfYear;
      short pm;
      short res1;
      short res2;
      short res3;
   } ld;
   short list[14];
   struct {
      short eraAlt;
      DateTimeRec oldDate;
   } od;
};
typedef union LongDateRec LongDateRec;



//Func
/*GetDateTime

Obtains the current date-time information, expressed as the number of seconds elapsed since midnight, January 1, 1904. (Deprecated in Mac OS X v10.4. Use CFAbsoluteTimeGetCurrent instead.)

void GetDateTime (
   unsigned long * secs
);
Parameters
secs

On return, the number of seconds elapsed since midnight, January 1, 1904. 
Discussion

The low-memory copy of the date and time information is also accessible through the global variable Time.

If an application disables interrupts for longer than a second, the date-time information returned by the GetDateTime function might not be exact. The GetDateTime function is intended to provide fairly accurate time information, but not scientifically precise data. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void GetDateTime (
   unsigned long * secs
);

/*SecondsToDate

Converts a number of seconds elapsed since midnight, January 1, 1904 to a date and time. (Deprecated in Mac OS X v10.4. Use the CFCalendarRef data type and the functions that operate on it instead.)

void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d
);
Parameters
secs

The number of seconds elapsed since midnight, January 1, 1904. 
d

On return, the fields of the date-time structure that contain the date and time corresponding to the value indicated in the s parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d
);

/*LongSecondsToDate

Converts the number of seconds elapsed since midnight, January 1, 1904 to a date and time. (Deprecated in Mac OS X v10.4. Use the CFCalendarRef data type and the functions that operate on it instead.)

void LongSecondsToDate (
   const LongDateTime * lSecs,
   LongDateRec * lDate
);
Parameters
lSecs

The number of seconds elapsed since midnight, January 1, 1904. 
lDate

On return, the fields of the long date-time structure that contain the date and time corresponding to the value indicated in the lSecs parameter. For example, specifying the number of seconds 41580 results in the date and time 11:33 A.M. on January 1, 1904 being returned in this parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void LongSecondsToDate (
   const LongDateTime * lSecs,
   LongDateRec * lDate
);


#ifdef __cplusplus
}
#endif

#endif