#ifndef CFLOCALE_H
#define CFLOCALE_H


#include <CoreFoundation/CFBase.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CFLocaleRef

A reference to a CFLocale object.

typedef const struct __CFLocale *CFLocaleRef;
Availability
Available in Mac OS X v10.3 and later.
Declared In
CFLocale.h*/
typedef const struct __CFLocale *CFLocaleRef;

/*CFLocaleCopyCurrent

Returns a copy of the logical locale for the current user.

CFLocaleRef CFLocaleCopyCurrent();
Return Value

The logical locale for the current user that is formed from the settings for the current user’s chosen system locale overlaid with any custom settings the user has specified in System Preferences. May return a retained cached object, not a new object. Ownership follows the Create Rule.
Discussion

Settings you get from this locale do not change as a user's preferences are changed so that your operations are consistent. Typically you perform some operations on the returned object and then release it. Since the returned object may be cached, you do not need to hold on to it indefinitely.

Note that locale settings are independent of the user’s language setting. The language of the current locale may not correspond to the language at the first index in the AppleLanguages array from user defaults. For more details, see Locale Concepts in Locales.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CFLocale.h*/
CFLocaleRef CFLocaleCopyCurrent();

#ifdef __cplusplus
}
#endif

#endif