#ifndef CGLAYER_H
#define CGLAYER_H

#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGContext.h>

/*CGLayerRef

Defines an opaque type that represents a Quartz layer.

typedef struct CGLayer *CGLayerRef;
Discussion

In Mac OS X version 10.4 and later, CGLayerRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.4 and later.*/
typedef struct CGLayer *CGLayerRef;

/*CGLayerGetContext

Gets the graphics context associated with a CGLayer object.

CGContextRef CGLayerGetContext(
   CGLayerRef layer
);
Parameters
layer

The layer whose graphics context you want to obtain.
Return Value

The graphics context associated with the layer.
Discussion

The context that’s returned is the context for the layer itself, not the context that you specified when you created the layer.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
CGContextRef CGLayerGetContext(
   CGLayerRef layer
);

/*CGLayerRelease

Decrements the retain count of a CGLayer object.

void CGLayerRelease(CGLayerRef layer);
Parameters
layer

The layer to release.
Discussion

This function is equivalent to calling CFRelease (layer) except that it does not crash (as CFRetain does) if the layer parameter is null.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
void CGLayerRelease(CGLayerRef layer);

#endif