#ifndef  PASTEBOARD_H
#define PASTEBOARD_H

#ifndef  COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*PasteboardItemID

Defines a pasteboard item identifier.

typedef void* PasteboardItemID;
Discussion

You can use any arbitrary (but unique) ID to identify your pasteboard items when placing them on a pasteboard. For example, you may want to identify items by their internal memory address. Only the owning application should interpret its pasteboard item identifiers. 

For example, when your application’s promise keeper callback function is invoked, it receives a pasteboard item ID, and your application must be able to map that ID to the corresponding promised data. 
Availability
Available in Mac OS X v10.3 and later.*/
typedef void* PasteboardItemID;

/*PasteboardRef

Defines a reference to a global pasteboard.

typedef struct OpaquePasteboardRef *PasteboardRef;
Discussion

The structure pointed to by this reference is opaque.
Availability
Available in Mac OS X v10.3 and later.*/
typedef struct OpaquePasteboardRef *PasteboardRef;

/*PasteboardGetItemIdentifier

Obtains the item identifier for an item in a pasteboard.

OSStatus PasteboardGetItemIdentifier (
PasteboardRef inPasteboard,
UInt32 inIndex,
PasteboardItemID *outItem
Parameters
inPasteboard

The pasteboard containing the data. 
inIndex

The one-based index number of the data item whose identifier you want to obtain.
outItem

On return, outItem points to the item identifier for the data item at index inIndex.
Return Value

A result code. 
Discussion

The item index is one-based to match the convention used by the Drag Manager.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardGetItemIdentifier (
PasteboardRef inPasteboard,
UInt32 inIndex,
PasteboardItemID *outItem);

/*PasteboardCopyItemFlavorData

Obtains data from a pasteboard for the desired flavor.

OSStatus PasteboardCopyItemFlavorData (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
CFDataRef *outData
);
Parameters
inPasteboard

The pasteboard containing the data.
inItem

The identifier for the item whose flavor data you want to obtain. 
inFlavorType

The flavor of the data you want to obtain, specified as a uniform type identifier. 
outData

On return, outData points to the flavor data. You must release this data using CFRelease when you are done using it. 
Return Value

A result code.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardCopyItemFlavorData (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
CFDataRef *outData
);

#ifdef __cplusplus
}
#endif

#endif