#ifndef MENUS_H
#define MENUS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef PROCESSES_H
#include <HIServices/Processes.h>
#endif

#ifndef CARBONEVENTSCORE_H
#include <HIToolbox/CarbonEventsCore.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef HIOBJECT_H
#include <HIToolbox/HIObject.h>
#endif

#include <HYS/HIToolbox/Menus.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Menu Glyph Constants

Specify menu glyphs.

enum {
   kMenuNullGlyph = 0x00,
   kMenuTabRightGlyph = 0x02,
   kMenuTabLeftGlyph = 0x03,
   kMenuEnterGlyph = 0x04,
   kMenuShiftGlyph = 0x05,
   kMenuControlGlyph = 0x06,
   kMenuOptionGlyph = 0x07,
   kMenuSpaceGlyph = 0x09,
   kMenuDeleteRightGlyph = 0x0A,
   kMenuReturnGlyph = 0x0B,
   kMenuReturnR2LGlyph = 0x0C,
   kMenuNonmarkingReturnGlyph = 0x0D,
   kMenuPencilGlyph = 0x0F,
   kMenuDownwardArrowDashedGlyph = 0x10,
   kMenuCommandGlyph = 0x11,
   kMenuCheckmarkGlyph = 0x12,
   kMenuDiamondGlyph = 0x13,
   kMenuAppleLogoFilledGlyph = 0x14,
   kMenuParagraphKoreanGlyph = 0x15,
   kMenuDeleteLeftGlyph = 0x17,
   kMenuLeftArrowDashedGlyph = 0x18,
   kMenuUpArrowDashedGlyph = 0x19,
   kMenuRightArrowDashedGlyph = 0x1A,
   kMenuEscapeGlyph = 0x1B,
   kMenuClearGlyph = 0x1C,
   kMenuLeftDoubleQuotesJapaneseGlyph = 0x1D,
   kMenuRightDoubleQuotesJapaneseGlyph = 0x1E,
   kMenuTrademarkJapaneseGlyph = 0x1F,
   kMenuBlankGlyph = 0x61,
   kMenuPageUpGlyph = 0x62,
   kMenuCapsLockGlyph = 0x63,
   kMenuLeftArrowGlyph = 0x64,
   kMenuRightArrowGlyph = 0x65,
   kMenuNorthwestArrowGlyph = 0x66,
   kMenuHelpGlyph = 0x67,
   kMenuUpArrowGlyph = 0x68,
   kMenuSoutheastArrowGlyph = 0x69,
   kMenuDownArrowGlyph = 0x6A,
   kMenuPageDownGlyph = 0x6B,
   kMenuAppleLogoOutlineGlyph = 0x6C,
   kMenuContextualMenuGlyph = 0x6D,
   kMenuPowerGlyph = 0x6E,
   kMenuF1Glyph = 0x6F,
   kMenuF2Glyph = 0x70,
   kMenuF3Glyph = 0x71,
   kMenuF4Glyph = 0x72,
   kMenuF5Glyph = 0x73,
   kMenuF6Glyph = 0x74,
   kMenuF7Glyph = 0x75,
   kMenuF8Glyph = 0x76,
   kMenuF9Glyph = 0x77,
   kMenuF10Glyph = 0x78,
   kMenuF11Glyph = 0x79,
   kMenuF12Glyph = 0x7A,
   kMenuF13Glyph = 0x87,
   kMenuF14Glyph = 0x88,
   kMenuF15Glyph = 0x89,
   kMenuControlISOGlyph = 0x8A,
   kMenuEjectGlyph = 0x8C
};
Constants
kMenuNullGlyph

The null character. Note that this glyph has no visible representation (that is, nothing appears in the menu). 

Available in Mac OS X v10.0 and later.
kMenuTabRightGlyph

The Tab-to-the-right key. Used in left to right script systems. 

Available in Mac OS X v10.0 and later.
kMenuTabLeftGlyph

The Tab-to-the-left key. Used in right to left script systems. 

Available in Mac OS X v10.0 and later.
kMenuEnterGlyph

The Enter key.

Available in Mac OS X v10.0 and later.
kMenuShiftGlyph

The Shift key.

Available in Mac OS X v10.0 and later.
kMenuControlGlyph

The Control key.

Available in Mac OS X v10.0 and later.
kMenuOptionGlyph

The Option key. 

Available in Mac OS X v10.0 and later.
kMenuSpaceGlyph

The Space bar. Note that this glyph has no visible representation (that is, nothing appears in the menu). 

Available in Mac OS X v10.0 and later.
kMenuDeleteRightGlyph

The Delete-to-the-right key. Used in right-to-left script systems.

Available in Mac OS X v10.0 and later.
kMenuReturnGlyph

The Return key for left-to-right script systems. 

Available in Mac OS X v10.0 and later.
kMenuReturnR2LGlyph

The Return key for right-to-left script systems. 

Available in Mac OS X v10.0 and later.
kMenuNonmarkingReturnGlyph

The nonmarking Return key. Note that this glyph has no visible representation (that is, nothing appears in the menu). 

Available in Mac OS X v10.0 and later.
kMenuPencilGlyph

The Pencil key. 

Available in Mac OS X v10.0 and later.
kMenuDownwardArrowDashedGlyph

The downward dashed arrow key. 

Available in Mac OS X v10.0 and later.
kMenuCommandGlyph

The Command key.

Available in Mac OS X v10.0 and later.
kMenuCheckmarkGlyph

The Check mark key.

Available in Mac OS X v10.0 and later.
kMenuDiamondGlyph

The diamond mark.

Available in Mac OS X v10.0 and later.
kMenuAppleLogoFilledGlyph

The filled Apple logo.

Available in Mac OS X v10.0 and later.
kMenuParagraphKoreanGlyph

Unassigned. (Paragraph glyph in Korean)

Available in Mac OS X v10.0 and later.
kMenuDeleteLeftGlyph

The Delete-to-the-left key.

Available in Mac OS X v10.0 and later.
kMenuLeftArrowDashedGlyph

The dashed left arrow key.

Available in Mac OS X v10.0 and later.
kMenuUpArrowDashedGlyph

The dashed up arrow key.

Available in Mac OS X v10.0 and later.
kMenuRightArrowDashedGlyph

The dashed right arrow key. 

Available in Mac OS X v10.0 and later.
kMenuEscapeGlyph

The Escape key. 

Available in Mac OS X v10.0 and later.
kMenuClearGlyph

The Clear key. 

Available in Mac OS X v10.0 and later.
kMenuLeftDoubleQuotesJapaneseGlyph

Unassigned. (Left double quotation marks in Japanese)

Available in Mac OS X v10.0 and later.
kMenuRightDoubleQuotesJapaneseGlyph

Unassigned (Right double quotation marks in Japanese)

Available in Mac OS X v10.0 and later.
kMenuTrademarkJapaneseGlyph

Unassigned. (Trademark in Japanese)

Available in Mac OS X v10.0 and later.
kMenuBlankGlyph

The blank key.

Available in Mac OS X v10.0 and later.
kMenuPageUpGlyph

The Page Up key.

Available in Mac OS X v10.0 and later.
kMenuCapsLockGlyph

The Caps Lock key. 

Available in Mac OS X v10.0 and later.
kMenuLeftArrowGlyph

The left arrow key. 

Available in Mac OS X v10.0 and later.
kMenuRightArrowGlyph

The right arrow key. 

Available in Mac OS X v10.0 and later.
kMenuNorthwestArrowGlyph

The northwest arrow key 

Available in Mac OS X v10.0 and later.
kMenuHelpGlyph

The Help key.

Available in Mac OS X v10.0 and later.
kMenuUpArrowGlyph

The up arrow key. 

Available in Mac OS X v10.0 and later.
kMenuSoutheastArrowGlyph

The southeast arrow key. 

Available in Mac OS X v10.0 and later.
kMenuDownArrowGlyph

The down arrow key.

Available in Mac OS X v10.0 and later.
kMenuPageDownGlyph

The Page Down key.

Available in Mac OS X v10.0 and later.
kMenuAppleLogoOutlineGlyph

The outlined Apple logo. 

Available in Mac OS X v10.0 and later.
kMenuContextualMenuGlyph

The contextual menu key 

Available in Mac OS X v10.0 and later.
kMenuPowerGlyph

The power key (that is, the startup key).

Available in Mac OS X v10.0 and later.
kMenuF1Glyph

The F1 key.

Available in Mac OS X v10.0 and later.
kMenuF2Glyph

The F2 key.

Available in Mac OS X v10.0 and later.
kMenuF3Glyph

The F3 key.

Available in Mac OS X v10.0 and later.
kMenuF4Glyph

The F4 key.

Available in Mac OS X v10.0 and later.
kMenuF5Glyph

The F5 key.

Available in Mac OS X v10.0 and later.
kMenuF6Glyph

The F6 key.

Available in Mac OS X v10.0 and later.
kMenuF7Glyph

The F7 key.

Available in Mac OS X v10.0 and later.
kMenuF8Glyph

The F8 key.

Available in Mac OS X v10.0 and later.
kMenuF9Glyph

The F9 key.

Available in Mac OS X v10.0 and later.
kMenuF10Glyph

The F10 key.

Available in Mac OS X v10.0 and later.
kMenuF11Glyph

The F11 key.

Available in Mac OS X v10.0 and later.
kMenuF12Glyph

The F12 key.

Available in Mac OS X v10.0 and later.
kMenuF13Glyph

The F13 key.

Available in Mac OS X v10.0 and later.
kMenuF14Glyph

The F14 key.

Available in Mac OS X v10.0 and later.
kMenuF15Glyph

The F15 key.

Available in Mac OS X v10.0 and later.
kMenuControlISOGlyph

The ISO standard control key.

Available in Mac OS X v10.0 and later.
kMenuEjectGlyph

The Eject key (available in Mac OS X v10.2 and later).

Available in Mac OS X v10.2 and later.
Discussion

Use these constants with GetMenuItemKeyGlyph and SetMenuItemKeyGlyph.*/

enum {
   kMenuNullGlyph = 0x00,
   kMenuTabRightGlyph = 0x02,
   kMenuTabLeftGlyph = 0x03,
   kMenuEnterGlyph = 0x04,
   kMenuShiftGlyph = 0x05,
   kMenuControlGlyph = 0x06,
   kMenuOptionGlyph = 0x07,
   kMenuSpaceGlyph = 0x09,
   kMenuDeleteRightGlyph = 0x0A,
   kMenuReturnGlyph = 0x0B,
   kMenuReturnR2LGlyph = 0x0C,
   kMenuNonmarkingReturnGlyph = 0x0D,
   kMenuPencilGlyph = 0x0F,
   kMenuDownwardArrowDashedGlyph = 0x10,
   kMenuCommandGlyph = 0x11,
   kMenuCheckmarkGlyph = 0x12,
   kMenuDiamondGlyph = 0x13,
   kMenuAppleLogoFilledGlyph = 0x14,
   kMenuParagraphKoreanGlyph = 0x15,
   kMenuDeleteLeftGlyph = 0x17,
   kMenuLeftArrowDashedGlyph = 0x18,
   kMenuUpArrowDashedGlyph = 0x19,
   kMenuRightArrowDashedGlyph = 0x1A,
   kMenuEscapeGlyph = 0x1B,
   kMenuClearGlyph = 0x1C,
   kMenuLeftDoubleQuotesJapaneseGlyph = 0x1D,
   kMenuRightDoubleQuotesJapaneseGlyph = 0x1E,
   kMenuTrademarkJapaneseGlyph = 0x1F,
   kMenuBlankGlyph = 0x61,
   kMenuPageUpGlyph = 0x62,
   kMenuCapsLockGlyph = 0x63,
   kMenuLeftArrowGlyph = 0x64,
   kMenuRightArrowGlyph = 0x65,
   kMenuNorthwestArrowGlyph = 0x66,
   kMenuHelpGlyph = 0x67,
   kMenuUpArrowGlyph = 0x68,
   kMenuSoutheastArrowGlyph = 0x69,
   kMenuDownArrowGlyph = 0x6A,
   kMenuPageDownGlyph = 0x6B,
   kMenuAppleLogoOutlineGlyph = 0x6C,
   kMenuContextualMenuGlyph = 0x6D,
   kMenuPowerGlyph = 0x6E,
   kMenuF1Glyph = 0x6F,
   kMenuF2Glyph = 0x70,
   kMenuF3Glyph = 0x71,
   kMenuF4Glyph = 0x72,
   kMenuF5Glyph = 0x73,
   kMenuF6Glyph = 0x74,
   kMenuF7Glyph = 0x75,
   kMenuF8Glyph = 0x76,
   kMenuF9Glyph = 0x77,
   kMenuF10Glyph = 0x78,
   kMenuF11Glyph = 0x79,
   kMenuF12Glyph = 0x7A,
   kMenuF13Glyph = 0x87,
   kMenuF14Glyph = 0x88,
   kMenuF15Glyph = 0x89,
   kMenuControlISOGlyph = 0x8A,
   kMenuEjectGlyph = 0x8C
};


/*Menu Item Icon Type Constants

Specify types of icons to attach to menu items. 

enum {
   kMenuNoIcon = 0,
   kMenuIconType = 1,
   kMenuShrinkIconType = 2,
   kMenuSmallIconType = 3,
   kMenuColorIconType = 4,
   kMenuIconSuiteType = 5,
   kMenuIconRefType = 6,
   kMenuCGImageRefType = 7,
   kMenuSystemIconSelectorType = 8,
   kMenuIconResourceType = 9
};
Constants
kMenuNoIcon

No icon.

Available in Mac OS X v10.0 and later.
kMenuIconType

Identifies an icon of type 'ICON'.

Available in Mac OS X v10.0 and later.
kMenuShrinkIconType

Identifies a 32-by-32-pixel icon of type 'ICON', shrunk (at display time) to 16-by-16.

Available in Mac OS X v10.0 and later.
kMenuSmallIconType

Identifies an icon of type 'SICN'.

Available in Mac OS X v10.0 and later.
kMenuColorIconType

Identifies an icon of type 'cicn'.

Available in Mac OS X v10.0 and later.
kMenuIconSuiteType

Identifies an icon suite.

Available in Mac OS X v10.0 and later.
kMenuIconRefType

Identifies an icon of type IconRef. This value is supported under Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kMenuCGImageRefType

Identifies an icon of type CGImageRef.

Available in Mac OS X v10.0 and later.
kMenuSystemIconSelectorType

Identifies an OSType value that corresponds to an icon (type IconRef )registered with Icon Services under kSystemIconsCreator.

Available in Mac OS X v10.1 and later.
kMenuIconResourceType

Identifies a CFString that names an icon resource in the main bundle of the application.

Available in Mac OS X v10.1 and later.
Discussion

These constants specify the type of an icon attached to a menu item. They are passed in SetMenuItemIconHandle and obtained by GetMenuItemIconHandle. Menu item icon type constants are available with Appearance Manager 1.0 and later.*/
enum {
   kMenuNoIcon = 0,
   kMenuIconType = 1,
   kMenuShrinkIconType = 2,
   kMenuSmallIconType = 3,
   kMenuColorIconType = 4,
   kMenuIconSuiteType = 5,
   kMenuIconRefType = 6,
   kMenuCGImageRefType = 7,
   kMenuSystemIconSelectorType = 8,
   kMenuIconResourceType = 9
};

/*Menu Attribute Constants

Specify menu attributes.

typedef UInt32 MenuAttributes;
enum {
   kMenuAttrExcludesMarkColumn = (1 << 0),
   kMenuAttrAutoDisable = (1 << 2),
   kMenuAttrUsePencilGlyph = (1 << 3),
   kMenuAttrHidden = (1 << 4)
   kMenuAttrCondenseSeparators = (1 << 5)
   kMenuAttrDoNotCacheImage = (1 << 6)
   kMenuAttrDoNotUseUserCommandKeys = (1 << 7)
};
Constants
kMenuAttrExcludesMarkColumn

No column space is allocated for the mark character when this menu is drawn.

Available in Mac OS X v10.0 and later.
kMenuAttrAutoDisable

The menu title is automatically disabled when all of its menu items are disabled. 

Available in Mac OS X v10.0 and later.
kMenuAttrUsePencilGlyph

Use the pencil glyph from the Keyboard font (kMenuPencilGlyph) to draw the control modifier keys when drawing keyboard equivalents. Typically used only for Japanese input method menus. 

Available in Mac OS X v10.0 and later.
kMenuAttrHidden

Do not draw the menu title, even when the menu is inserted in the menu bar. This attribute is useful for specifying keyboard equivalent commands that don’t correspond with visible menu items. That is, you can add command key equivalents to to menu items and keep the menu itself from appearing in the menu.

Available in Mac OS X v10.2 and later.
kMenuAttrCondenseSeparators

Hides extra separators to avoid blank spaces in a menu. That is, if separators exists at the beginning or end of a menu, or if multiple contiguous separators exist, the Menu Manager marks the extra separator items as hidden. The Menu Manager checks for extra separators whenever it recalculates the menu size.

Available in Mac OS X v10.3 and later.
kMenuAttrDoNotCacheImage

Disables automatic caching of the menu image. Normally, the Menu Manager caches images of all HIView–based menus. (All standard menus are drawn using HIViews in Mac OS X v10.3 and later.) If you specify this attribute, the Menu Manager draws the menu each time it is displayed.

Available in Mac OS X v10.3 and later.
kMenuAttrDoNotUseUserCommandKeys

Disables substitution of command key equivalents from the NSUserKeysEquivalents dictionary. By default, the Menu Manager checks for matches in the dictionary for every menu item. Note that this attribute is effective only if you set it when you create the menu; After the Menu Manager searches the dictionary and sets the user command keys (which occurs in the CalcMenuSize, GetMenuItemCommandKey, GetItemCmd and before command key matching), you cannot retrieve the original command keys. Similarly, clearing this attribute does not restore the original command keys.

Available in Mac OS X v10.3 and later.
Discussion

Menu attributes control behavior of the entire menu. They are used with the ChangeMenuAttributes and GetMenuAttributes.*/
typedef UInt32 MenuAttributes;
enum {
   kMenuAttrExcludesMarkColumn = (1 << 0),
   kMenuAttrAutoDisable = (1 << 2),
   kMenuAttrUsePencilGlyph = (1 << 3),
   kMenuAttrHidden = (1 << 4),
   kMenuAttrCondenseSeparators = (1 << 5),
   kMenuAttrDoNotCacheImage = (1 << 6),
   kMenuAttrDoNotUseUserCommandKeys = (1 << 7)
};

/*MenuHandle

Abst_MenuHandle

typedef MenuPtr * MenuHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MenuPtr * MenuHandle;

/*MenuBarHandle

A handle to a menu bar header.

typedef Handle MenuBarHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle MenuBarHandle;

/*MenuRef

Defines a menu.

typedef struct OpaqueMenuRef * MenuRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueMenuRef * MenuRef;

/*MenuID

Defines a menu ID.

typedef SInt16 MenuID;typedef SInt16 MenuID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 MenuID;

/*MenuCommand

Specifies a menu item’s command ID.

typedef UInt32 MenuCommand;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 MenuCommand;

/*Menu Item Data Flags

Indicate which fields of a MenuItemDataRec structure are to be copied or set. 

enum {
   kMenuItemDataText = (1 << 0),
   kMenuItemDataMark = (1 << 1),
   kMenuItemDataCmdKey = (1 << 2),
   kMenuItemDataCmdKeyGlyph = (1 << 3),
   kMenuItemDataCmdKeyModifiers = (1 << 4),
   kMenuItemDataStyle = (1 << 5),
   kMenuItemDataEnabled = (1 << 6),
   kMenuItemDataIconEnabled = (1 << 7),
   kMenuItemDataIconID = (1 << 8),
   kMenuItemDataIconHandle = (1 << 9),
   kMenuItemDataCommandID = (1 << 10),
   kMenuItemDataTextEncoding = (1 << 11),
   kMenuItemDataSubmenuID = (1 << 12),
   kMenuItemDataSubmenuHandle = (1 << 13),
   kMenuItemDataFontID = (1 << 14),
   kMenuItemDataRefcon = (1 << 15),
   kMenuItemDataAttributes = (1 << 16),
   kMenuItemDataCFString = (1 << 17),
   kMenuItemDataProperties = (1 << 18),
   kMenuItemDataIndent = (1 << 19),
   kMenuItemDataCmdVirtualKey = (1 << 20),
   kMenuItemDataAllDataVersionOne = 0x000FFFFF,
   kMenuItemDataAllDataVersionTwo = kMenuItemDataAllDataVersionOne
| kMenuItemDataCmdVirtualKey
};
enum {
   kMenuItemDataAllData = kMenuItemDataAllDataVersionTwo
};
typedef UInt64 MenuItemDataFlags;
Constants
kMenuItemDataText

Set or return the Str255 text of a menu using the MenuItemDataRec.text field. If getting the text, the text field must be initialized with a pointer to a Str255 variable before calling CopyMenuItemData. If both kMenuItemDataText and kMenuItemCFString are set on entry to CopyMenuItemData, the API will determine whether the menu text was most recently set using a Str255 or CFString, and return only that text format; the flags value for the other format will be cleared. Valid for both menu items and the menu title (if item number is 0).

Available in Mac OS X v10.0 and later.
kMenuItemDataMark

Set or return the mark character of a menu item using the MenuItemDataRec.mark field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdKey

Set or return the command key of a menu using the MenuItemDataRec.cmdKey field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdKeyGlyph

Set or return the command key glyph of a menu using the MenuItemDataRec.cmdKeyGlyph field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdKeyModifiers

Set or return the command key modifiers of a menu using the MenuItemDataRec.cmdKeyModifiers field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataStyle

Set or return the QuickDraw text style of a menu item using the MenuItemDataRec.style field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataEnabled

Set or return the enable state of a menu using the MenuItemDataRec.enabled field. Valid for both menu items and the menu itself (if the item number is zero). 

Available in Mac OS X v10.0 and later.
kMenuItemDataIconEnabled

Set or return the enable state of the menu item icon using the MenuItemDataRec.iconEnabled field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataIconID

Set or return the icon resource ID of the menu item icon using the MenuItemDataRec.iconID field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataIconHandle

Set or return the icon handle of a menu item using the MenuItemDataRec.iconType and MenuItemDataRec.iconHandle field. You must initialize both fields if you are setting the handle; both fields are returned when obtaining the handle. 

The iconType field can contain one of the following constants: kMenuIconType, kMenuShrinkIconType, kMenuSmallIconType, kMenuColorIcontype, kMenuIconSuiteType, or kMenuIconRefType. The icon handle may be a handle to an 'ICON' resource, a 'SICN' resource, a 'cicn' resource, an icon suite, or an icon reference. Valid only for menu items. 

In Mac OS X v10.0 and later, the iconType field can also contain kMenuCGImageType, with the icon handle being of type CGImageRef.

In Mac OS X v10.1 and later, the iconType field can also contain kMenuSystemIconSelectorType or kMenuIconResource, which have icon handles of type OSType and CFStringRef respectively.

Available in Mac OS X v10.0 and later.
kMenuItemDataCommandID

Set or return the command ID of a menu using the MenuItemDataRec.cmdID field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataTextEncoding

Set or return the text encoding of a menu item using the MenuItemDataRec.encoding field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataSubmenuID

Set or return the menu ID of the submenu associated with this menu item using the MenuItemDataRec.submenuID field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataSubmenuHandle

Set or return the menu reference (MenuRef) of the submenu associated with this menu using the MenuItemDataRec.submenuHandle field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataFontID

Set or return the font ID associated with this menu item using the MenuItemDataRec.fomtID field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataRefcon

Set or return the reference constant associated with this menu item using the MenuItemDataRec.refcon field. If you specified a menu item index of 0, you can set or obtain the menu reference constant. 

Available in Mac OS X v10.0 and later.
kMenuItemDataAttributes

Set or return the attribute bits associated with this menu item using the MenuItemDataRec.attr field. If you specified a menu item index of 0, you can set or obtain a MenuAttributes bit field, not a MenuItemAttributes bit field.

Available in Mac OS X v10.0 and later.
kMenuItemDataCFString

Set or return the title of the menu item (as a Core Foundation string) using the MenuItemDataRec.cFText field. If you specified a menu item index of 0, you can set or obtain the menu title.

Available in Mac OS X v10.0 and later.
kMenuItemDataProperties

Set or return the properties of a menu using the MenuItemDataRec.properties field.

If setting properties, the properties field should contain a collection with the new properties; note that this will overwrite any existing properties with the same collection creator and tag.

If getting properties, you should set the properties field to either a valid collection or NULL. A valid collection is overwritten by the new properties. If you pass NULL, the CopyMenuItemData function allocates a new collection and returns it in the properties field. 

You can set this flag for both menu items and the menu itself (if the item number is zero).

Available in Mac OS X v10.0 and later.
kMenuItemDataIndent

Set or return the indent level of a menu item using the MenuItemDataRec.indent field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdVirtualKey

Set or return the virtual key code for this menu item using the MenuItemDataRec.cmdVirtualKey field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataAllDataVersionOne

Sets all flags, except for kMenuItemDataCmdVirtualKey.

Available in Mac OS X v10.0 and later.
kMenuItemDataAllDataVersionTwo

Sets all flags, including kMenuItemDataCmdVirtualKey.

Available in Mac OS X v10.0 and later.
Discussion

A MenuItemDataFlags value indicates which fields of a “MenuItemDataRec” structure should be used by the CopyMenuItemData or SetMenuItemData functions. All menu item data flags may be used when getting or setting the contents of a menu item; some may also be used when getting or setting information about the menu itself, if the item index given to CopyMenuItemData or SetMenuItemData is 0.*/
enum {
   kMenuItemDataText = (1 << 0),
   kMenuItemDataMark = (1 << 1),
   kMenuItemDataCmdKey = (1 << 2),
   kMenuItemDataCmdKeyGlyph = (1 << 3),
   kMenuItemDataCmdKeyModifiers = (1 << 4),
   kMenuItemDataStyle = (1 << 5),
   kMenuItemDataEnabled = (1 << 6),
   kMenuItemDataIconEnabled = (1 << 7),
   kMenuItemDataIconID = (1 << 8),
   kMenuItemDataIconHandle = (1 << 9),
   kMenuItemDataCommandID = (1 << 10),
   kMenuItemDataTextEncoding = (1 << 11),
   kMenuItemDataSubmenuID = (1 << 12),
   kMenuItemDataSubmenuHandle = (1 << 13),
   kMenuItemDataFontID = (1 << 14),
   kMenuItemDataRefcon = (1 << 15),
   kMenuItemDataAttributes = (1 << 16),
   kMenuItemDataCFString = (1 << 17),
   kMenuItemDataProperties = (1 << 18),
   kMenuItemDataIndent = (1 << 19),
   kMenuItemDataCmdVirtualKey = (1 << 20),
   kMenuItemDataAllDataVersionOne = 0x000FFFFF,
   kMenuItemDataAllDataVersionTwo = kMenuItemDataAllDataVersionOne
| kMenuItemDataCmdVirtualKey
};
enum {
   kMenuItemDataAllData = kMenuItemDataAllDataVersionTwo
};
typedef UInt64 MenuItemDataFlags;

/*MenuItemDataRec

Used with the SetMenuItemData and CopyMenuItemData functions to get or change aspects of a menu item.

struct MenuItemDataRec {
   MenuItemDataFlags whichData;
   StringPtr text;
   UniChar mark;
   UniChar cmdKey;
   UInt32 cmdKeyGlyph;
   UInt32 cmdKeyModifiers;
   Style style;
   Boolean enabled;
   Boolean iconEnabled;
   UInt8 filler1;
   SInt32 iconID;
   UInt32 iconType;
   Handle iconHandle;
   MenuCommand cmdID;
   TextEncoding encoding;
   MenuID submenuID;
   MenuRef submenuHandle;
   SInt32 fontID;
   UInt32 refcon;
   OptionBits attr;
   CFStringRef cfText;
   Collection properties;
   UInt32 indent;
   UInt16 cmdVirtualKey;
};
typedef struct MenuItemDataRec MenuItemDataRec;
typedef MenuItemDataRec * MenuItemDataPtr;
Fields
whichData

The fields to be set or obtained. You pass a bit mask as specified by “Menu Item Data Flags” to indicate which values you want to get or set. The values themselves are set or populated in the fields that follow. 
text

The menu item title, as an Str255 string. 
mark 

The menu item’s mark. 
cmdKey

The menu item’s command key. This can be either a character code or a virtual key code. 
cmdKeyGlyph

The menu item’s command key glyph.
cmdKeyModifiers

The menu item’s command key modifiers.
style

The menu item’s QuickDraw text style.
enabled

The menu item’s enable state.
iconEnabled

The enable state of the menu item icon.
filler1 

Reserved.
iconID

The icon resource ID of the menu item. 
iconHandle

The icon handle of the menu item. 
cmdID

The command ID for the menu item. 
encoding

The text encoding of the menu item.
submenuID

The menu ID of the submenu associated with this menu item. 
submenuHandle

The MenuRef of the submenu associated with this menu item. 
fontID

The font ID for the menu item.
refcon

The reference constant associated with this menu item. 
attr

The menu item’s attributes.
cfText

The menu item’s title, as a Core Foundation string. 
properties

A collection holding the menu item’s properties. 
indent

The menu item’s indent level. 
cmdVirtualKey

The menu item’s virtual key. 
Discussion

When using this structure withCopyMenuItemData or SetMenuItemData, the caller must first set the whichData field to a combination of MenuItemDataFlags indicating which specific data should be retrieved or set. Some fields also require initialization before calling CopyMenuItemData; see “Menu Item Data Flags” for details.
Availability
Available in Mac OS X v10.0 and later.*/
struct MenuItemDataRec {
   MenuItemDataFlags whichData;
   StringPtr text;
   UniChar mark;
   UniChar cmdKey;
   UInt32 cmdKeyGlyph;
   UInt32 cmdKeyModifiers;
   Style style;
   Boolean enabled;
   Boolean iconEnabled;
   UInt8 filler1;
   SInt32 iconID;
   UInt32 iconType;
   Handle iconHandle;
   MenuCommand cmdID;
   TextEncoding encoding;
   MenuID submenuID;
   MenuRef submenuHandle;
   SInt32 fontID;
   UInt32 refcon;
   OptionBits attr;
   CFStringRef cfText;
   Collection properties;
   UInt32 indent;
   UInt16 cmdVirtualKey;
};
typedef struct MenuItemDataRec MenuItemDataRec;
typedef MenuItemDataRec * MenuItemDataPtr;

/*MenuItemIndex

Specifies a particular menu item in a menu.

typedef UInt16 MenuItemIndex;
Discussion

The menu item index is one-based, so item 1 is the first menu item, item 2 is the second, and so on. Some functions allow you to pass an index of zero, which specifies the menu itself. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 MenuItemIndex;

/*MenuRef

Defines a menu.

typedef struct OpaqueMenuRef * MenuRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueMenuRef * MenuRef;

/*MenuCommand

Specifies a menu item’s command ID.

typedef UInt32 MenuCommand;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 MenuCommand;

/*Menu Item Attribute Constants

Specify attributes for menu items. 

typedef UInt32 MenuItemAttributes;
enum {
   kMenuItemAttrDisabled = (1 << 0),
   kMenuItemAttrIconDisabled = (1 << 1),
   kMenuItemAttrSubmenuParentChoosable = (1 << 2),
   kMenuItemAttrDynamic = (1 << 3),
   kMenuItemAttrNotPreviousAlternate = (1 << 4),
   kMenuItemAttrHidden = (1 << 5),
   kMenuItemAttrSeparator = (1 << 6),
   kMenuItemAttrSectionHeader = (1 << 7),
   kMenuItemAttrIgnoreMeta = (1 << 8),
   kMenuItemAttrAutoRepeat = (1 << 9),
   kMenuItemAttrUseVirtualKey = (1 << 10),
   kMenuItemAttrCustomDraw = (1 << 11),
   kMenuItemAttrIncludeInCmdKeyMatching = (1 << 12)
   kMenuItemAttrAutoDisable = (1 << 13)
   kMenuItemAttrUpdateSingleItem = (1 << 14)
};
Constants
kMenuItemAttrDisabled

This menu item is disabled.

Available in Mac OS X v10.0 and later.
kMenuItemAttrIconDisabled

This menu item’s icon is disabled. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSubmenuParentChoosable

The user can select the parent item of a submenu. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrDynamic

This menu item changes dynamically based on the state of the modifier keys. For example, holding down the command key might change the menu item from “Select widget” to “Select all widgets.”

When a menu item has alternate dynamic states, you should group them together sequentially in the menu and assign them the same command key. A collection of menu item alternates is called a dynamic group. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrNotPreviousAlternate

This item is not part of the same dynamic group as the previous item. The Menu Manager determines which menu items belong to a dynamic group by examining the command keys of each item; if a menu item has the same command key as the previous item, the Menu Manager considers it to be part of the same dynamic group. 

However, in some cases you may have sequential items with the same command key (or no command key at all) that should not be considered part of the same dynamic group. To distinguish the separation, you should set this flag for the first menu item in the new group. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrHidden

The menu item is not drawn when displaying the menu. The item is also not included in command-key matching unless the kMenuItemAttrDynamic or kMenuItemIncludeInCmdKeyMatching attribute is set. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSeparator

The menu item is a separator; any text in the item is ignored. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSectionHeader

The menu item is a menu section header; this item is disabled and not selectable. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrIgnoreMeta

Ignore the dash (-) metacharacter in this menu item. Dashes at the beginning of a menu item title traditionally signify that the menu item is a separator. However, in some cases you might want to display the dash in the title (for example, if you wanted the menu item to read “-40 degrees F.”)

Available in Mac OS X v10.0 and later.
kMenuItemAttrAutoRepeat

The IsMenuKeyEvent event function recognizes this menu item when it receives an autorepeat keyboard event. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrUseVirtualKey

When MenuEvent and IsMenuKeyEvent compare this menu item’s keyboard equivalent against a keyboard event, they use the item’s virtual keycode equivalent rather than its character code equivalent. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrCustomDraw

This is a custom menu item. Setting this attribute causes custom menu item drawing Carbon events to be sent to your application. Available in CarbonLib 1.4 and Mac OS X v10.1 and later. 

Available in Mac OS X v10.1 and later.
kMenuItemAttrIncludeInCmdKeyMatching

If this attribute is set, functions such as MenuKey, MenuEvent and IsMenuKeyEvent examine this menu item during command key matching. Typically, visible items are examined and hidden items (unless they have the kMenuItemAttrDynamic attribute set) are ignored during command key matching. However, by setting this attribute, you can force hidden items to be included in the matching. Available in CarbonLib 1.6 and Mac OS X v10.2 and later. 

Available in Mac OS X v10.2 and later.
kMenuItemAttrAutoDisable

Disables the menu item if it does not respond to the kEventCommandUpdateStatus event . That is, if no kEventCommandUpdateStatus handler is installed on this item, or if all the handlers installed for the update event return eventNotHandledErr, this item is automatically disabled. This attribute is useful if your application uses the kEventCommandUpdateStatus event to enable menu items; for example you no longer have to install an update status handler on the application target to disable menu items when there are no document windows open. 

Available in Mac OS X v10.3 and later.
kMenuItemAttrUpdateSingleItem

Update only the menu item that matches when searching available command keys. Normally when the Menu Manager does command key matching, it sends a kEventMenuEnableItems event to the menu containing the matching item and then sends a kEventCommandUpdateStatus to each item in the menu. Doing so can be inefficient, since in most cases only the item that matches needs to be updated. By setting this attribute, only the matching item receives the update event and kEventMenuEnableItems is not sent to the menu. If your application enables menu items solely through kEventCommandUpdateStatus event handlers, you should set this attribute for your menu items.

Available in Mac OS X v10.3 and later.
Discussion

Menu item attributes control behavior of individual menu items. They are used with the GetMenuItemAttributes and ChangeMenuItemAttributes APIs.*/
typedef UInt32 MenuItemAttributes;
enum {
   kMenuItemAttrDisabled = (1 << 0),
   kMenuItemAttrIconDisabled = (1 << 1),
   kMenuItemAttrSubmenuParentChoosable = (1 << 2),
   kMenuItemAttrDynamic = (1 << 3),
   kMenuItemAttrNotPreviousAlternate = (1 << 4),
   kMenuItemAttrHidden = (1 << 5),
   kMenuItemAttrSeparator = (1 << 6),
   kMenuItemAttrSectionHeader = (1 << 7),
   kMenuItemAttrIgnoreMeta = (1 << 8),
   kMenuItemAttrAutoRepeat = (1 << 9),
   kMenuItemAttrUseVirtualKey = (1 << 10),
   kMenuItemAttrCustomDraw = (1 << 11),
   kMenuItemAttrIncludeInCmdKeyMatching = (1 << 12),
   kMenuItemAttrAutoDisable = (1 << 13),
   kMenuItemAttrUpdateSingleItem = (1 << 14)
};
/*EnableMenuCommand

Enables the menu item with a specified command ID.

void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be enabled. If more than one item has this command ID, only the first will be enabled. 
Discussion

If you have access to the menu item index, in most cases you should use EnableMenuItem instead, as that function is faster and requires no searching. For example, when receiving a kEventCommandUpdateStatus event, the HICommand structure contains both the menu item’s command ID and index. If you wanted to enable the menu item, you should call EnableMenuItem.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);

/*DeleteMenuItem

Deletes an item from a menu. 

void DeleteMenuItem (
   MenuRef theMenu,
   short item
);
Parameters
theMenu

The menu from which you want to delete the menu item. 
item

The item number of the menu item to delete. If you specify 0 or a number greater than the last item in the menu, DeleteMenuItem does not delete any item from the menu. 
Discussion

The DeleteMenuItem function deletes a specified menu item from a menu. You should not delete items from an existing menu unless the user expects the menu (such as a menu that lists open documents) to change. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DeleteMenuItem (
   MenuRef theMenu,
   short item
);

/*AppendMenuItemTextWithCFString

Appends a new menu item with text from a CFString.

OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);
Parameters
menu

The menu to which to append the new item. 
inString

The text of the new item. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
outNewItem

On exit, the index of the new item. May be NULL if the caller does not need this information. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The Menu Manager will make its own copy of the CFString before returning from this function. Modifying the string after calling AppendMenuItemTextWithCFString will have no effect on the menu item's actual text. The caller may release the string after the call.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);

/*CopyMenuItemTextAsCFString

Returns a CFString containing the text of a menu item.

OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);
Parameters
menu

The menu containing the item. 
item

The item whose text you want to copy. 
outString

On exit, a CFString containing the item's text. The caller must release this string when it is no longer needed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);

/*DisableMenuItem

Disables a menu item or a menu.

void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be disabled. 
item

The index of the menu item that you wish to disable. Pass 0 to specify the menu title (disabling the entire menu). 
Discussion

The DisableMenuItem function disables a menu item (and any associated icon) so that the user cannot choose the item from the menu. 

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the EnableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Note that the implementation of Carbon on Mac OS 8.1 only supports disabling menu items less than or equal to 31.
Declared In
Menus.h*/
void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);

/*EnableMenuItem

Enables a menu item or a menu.

void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be enabled. 
item

The item number of the menu item that you wish to enable. If you pass 0, EnableMenuItem enables the menu title and all items in the menu that were not previously individually disabled. 
Discussion

The EnableMenuItem function enables a menu item so that the user can choose the item from the menu. If the menu item has an associated icon, that icon is also enabled, unless the icon was previously individually disabled with the function DisableMenuItemIcon.

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the DisableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);

/*SetMenuBar

Sets the current menu list to a specified menu list.

void SetMenuBar (
   MenuBarHandle mbar
);
Parameters
mbar

A handle to a menu list that specifies the menus for a menu bar. You should specify a handle returned by GetMenuBar or GetNewMBar. 
Discussion

The SetMenuBar function copies the given menu list to the current menu list. As with GetMenuBar , SetMenuBar doesn’t copy the menu structures, just the menu list (which contains handles to the menu structures).

You can use SetMenuBar to restore a menu list that you previously saved using GetMenuBar or to set the current menu list to a menu list created from a nib file or from GetNewMBar. 

The SetMenuBar function sets the current menu list and calls InvalMenuBar so the menu bar can be updated the next time through the event loop; if you want to redraw the menu bar immediately, call the DrawMenuBar function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void SetMenuBar (
   MenuBarHandle mbar
);

/*CountMenuItems

Obtains the number of menu items in a menu

UInt16 CountMenuItems (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose items you want to count. 
Return Value

The number of menu items in the menu.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
UInt16 CountMenuItems (
   MenuRef theMenu
);

/*ReleaseMenu

Decrements the retain count of a menu.

OSStatus ReleaseMenu (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose retain count to decrement. If the retain count falls to zero, the menu is destroyed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The reference that you pass in the theMenu parameter is not valid after DisposeMenu returns. This function is identical to DisposeMenu.
Version Notes

In Mac OS X v10.2 and later, all menus are Core Foundation CFTypes, so you can optionally call CFRelease instead of ReleaseMenu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus ReleaseMenu (
   MenuRef inMenu
);

/*CreateNewMenu

Creates a new, untitled, empty menu.

OSStatus CreateNewMenu (
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);
Parameters
inMenuID

The menu ID to use for the new menu. Note that zero is a valid ID in Carbon. 
inMenuAttributes

The menu attributes to use for the new menu. See “Menu Attribute Constants” for a list of possible values. 
outMenuRef

On exit, contains the new menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Unless you need to create new menus on-the-fly, you should not use functions like CreateNewMenu that create menus programmatically. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them.

CreateNewMenu is preferred over NewMenu because it allows you to specify the menu's attributes and it does not require you to specify a Str255-based menu title. To set the menu title, you should use SetMenuTitleWithCFString.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CreateNewMenu (
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);

/*RetainMenu

Increments the reference count of a menu.

OSStatus RetainMenu (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose reference count you want to increment. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

RetainMenu does not create a new menu. It simply adds one to the reference count. 
Version Notes

In Mac OS X v10.2 and later, all menus are Core Foundation CFTypes, so you can optionally call CFRetain instead of RetainMenu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus RetainMenu (
   MenuRef inMenu
);

/*SetMenuItemIconHandle

Sets a menu item’s icon.

OSErr SetMenuItemIconHandle (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inIconType,
   Handle inIconHandle
);
Parameters
inMenu

The menu that contains the menu item for which you wish to set an icon. 
inItem

The menu index of the item. 
inIconType

Pass a value representing the type of icon ('ICON', 'cicn', 'SICN', icon suite, or IconRef) you wish to attach; see “Menu Item Icon Type Constants” for descriptions of possible values. 
inIconHandle

Pass a handle to the icon you wish to attach to a menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The SetMenuItemIconHandle function sets the icon of a menu item with an icon handle instead of a resource ID. SetMenuItemIconHandle allows you to set icons of type 'ICON', 'cicn', 'SICN', IconRef, CGImageRef, as well as icon suites. To set resource-based icons for a menu item, call SetItemIcon. 

With the exception of types IconRef and CGImageRef,disposing of the menu will not dispose of the icon handles set by this function. The Menu Manager retains IconRef, CGImageRef icons and releases them when the menu is disposed or the menu item is removed. For all other icon types, your application should dispose of the icons when you dispose of the menu, to prevent memory leaks.

See also the function GetMenuItemIconHandle. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSErr SetMenuItemIconHandle (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inIconType,
   Handle inIconHandle
);

/*SetMenuItemProperty

Associates data with a menu item.

OSStatus SetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
);
Parameters
menu

The menu containing the item with which you wish to associate data. 
item

The index number of the menu item or 0 if the data is to be associated with the menu as a whole. 
propertyCreator

A four-character code. Pass your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and may not be used. 
propertyTag

A four-character code that identifies the property to set. You define the tag your application uses to identify the data; this code is not to be confused with the file type for the data, but may coincide if you wish.
propertySize

The size of the data. 
propertyData

A pointer to the data. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You may use the SetMenuItemProperty function to associate arbitrary data, tagged with an identifying code, with a menu item.

See also the GetMenuItemProperty and RemoveMenuItemProperty functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
);

/*GetIndMenuItemWithCommandID

Finds a menu item with a specified command ID.

OSStatus GetIndMenuItemWithCommandID (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UInt32 inItemIndex,
   MenuRef * outMenu,
   MenuItemIndex * outIndex
);
Parameters
inMenu

The menu in which to begin searching for items with the specified command ID. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID for which to search. 
inItemIndex

The 1-based index of the menu item to retrieve. In CarbonLib 1.0.x, this parameter must be 1. In CarbonLib 1.1 and Mac OS X 1.0, this parameter may vary from 1 to the number of menu items with the specified command ID. 
outMenu

On exit, the menu containing the menu item with the specified command ID.
outIndex

On exit, the item index of the menu item with the specified command ID. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

This API searches the specified menu and its submenus for the n'th menu item with the specified command ID. You often want to use this function in conjunction with CountMenuItemsWithCommandID.
Version Notes

In CarbonLib 1.1 and earlier, only the first menu item will be returned. In CarbonLib 1.2 and Mac OS X v10.0 and later, this API will iterate over all menu items with the specified command ID and return the itemIndex’th one. 

In Mac OS X v10.0 and CarbonLib 1.0 through 1.4, this function searches only top-level menus (that is, those that are visible in the menu bar) and submenus of top-level menus. It does not search hierarchical menus that are in the menu bar but are not submenus of a top-level menu. For example, it does not search menus that are inserted for use in a popup menu. In Mac OS X v10.1 and later, and CarbonLib 1.5 and later, this function also searches hierarchical menus. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus GetIndMenuItemWithCommandID (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UInt32 inItemIndex,
   MenuRef * outMenu,
   MenuItemIndex * outIndex
);

/*GetMenuItemProperty

Obtains a piece of data that has been previously associated with a menu item.

OSStatus GetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
menu

The menu containing the item to be examined for associated data. 
item

The index number of the menu item or 0 if the data is associated with the menu as a whole. 
propertyCreator

A four-character code. Pass your program’s signature (also called a creator), as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and may not be used. 
propertyTag

A four-character code. Pass the application-defined code identifying the data.
bufferSize

The size of the data to be obtained. If this is unknown, use the function GetMenuItemPropertySize to get the data’s size. If the size specified in the bufferSize parameter does not match the actual size of the property, GetMenuItemProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the actual size of the associated data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You may use the function GetMenuItemProperty to obtain a copy of data previously set with the function SetMenuItemProperty.

See also the RemoveMenuItemProperty function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);

/*SetMenuCommandMark

Locates the menu item with a specified command ID and sets its mark character.

OSStatus SetMenuCommandMark (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UniChar inMark
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be modified. If more than one item has this command ID, only the first will be modified. 
inMark

The new mark character. While this is a Unicode character, only the low byte is currently used as the mark character, and it is interpreted using the application text encoding. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If you have access to the menu item index, in most cases you should use SetItemMark instead, as that function is faster and requires no searching.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuCommandMark (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UniChar inMark
);

/*DrawMenuBar

Draws the menu bar based on the current menu list.

void DrawMenuBar ();
Discussion

The DrawMenuBar function draws (or redraws) the menu bar according to the current menu list. Note that most Menu Manager calls that affect the menu bar call InvalMenuBar so that the menu bar is redrawn the next time through the event loop; however, you can call DrawMenuBar if you want the changes to appear immediately. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DrawMenuBar ();

/*InsertMenu

Inserts an existing menu into the current menu list. 

void InsertMenu (
   MenuRef theMenu,
   MenuID beforeID
);
Parameters
theMenu

The menu to insert. 
beforeID

An integer that indicates where in the current menu list the menu should be inserted. InsertMenu inserts the menu into the current menu list before the menu whose menu ID is specified in the beforeID parameter. If the number in the beforeID parameter is 0 (or it isn’t the ID of any menu in the menu list), InsertMenu adds the new menu after all others (except before the Help menu). If the menu is already in the current menu list or the menu list is already full, InsertMenu does nothing. 

To insert a submenu into the current menu list, specify –1 or the equivalent constant kInsertHierarchicalMenu for the beforeID parameter. The submenus in the submenu portion of the menu list do not have to be currently associated with a hierarchical menu item; you can store submenus in the menu list and later specify that a menu item has a submenu if needed. However, note that during command key matching the Menu Manager scans all menus in the menu list for modifiers, including submenus that are not associated with any menu item. 

You can also specify –1 for the beforeID parameter to insert a pop-up menu into the current menu list. However, if you use the standard pop-up control definition function, the pop-up control automatically inserts the menu into the current menu list according to the needs of the pop-up control.

Discussion

Menus inserted using this function are added to a menu list attached to the current root menu. To obtain or set this root menu, call AcquireRootMenu and SetRootMenu respectively. 

Inserting a menu in the root menu (menu bar) increments its reference count; removing the menu decrements its reference count. 


To change a menu title, call SetMenuItemTextWithCFString. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void InsertMenu (
   MenuRef theMenu,
   MenuID beforeID
);


/*SetMenuItemCommandID

Sets a menu item’s command ID. 

OSErr SetMenuItemCommandID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu that contains the menu item whose command ID you want to set. 
inItem

The menu index of the item. 
inCommandID

An integer representing the command ID that you wish to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can use a menu item’s command ID as a position-independent method of signalling a specific action in an application. See Carbon Event Manager Programming Guide for more information about command IDs. 

Note that Apple reserves all command IDs that contain all lowercase letters; your application is free to use any command ID containing uppercase characters.

See also the function GetMenuItemCommandID. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemCommandID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuCommand inCommandID
);

/*GetMenuHandle

Obtains a menu reference corresponding to a menu ID. 

MenuRef GetMenuHandle (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu whose reference you want to obtain. (Note that this is not the resource ID, although you often assign the menu ID so that it matches the resource ID.) You assign a menu ID in a nib file or in the 'MENU' resource of a menu. If you do not define your menus in nib files or in ‘MENU’' resources, you can assign a menu ID using NewMenu or SetMenuID. 
Return Value

The menu corresponding to the specified ID. If the specified menu is not in the current menu list, GetMenuHandle returns NULL. See the description of the MenuRef data type.
Discussion

You can also call this function as GetMenuRef (menuID);.

Use the GetMenuHandle function to obtain the menu reference for any of your application’s pull-down menus or submenus in the current menu list, other than the Help menu. You can also use the Help Manager function HMGetHelpMenuHandle to get a handle for your application’s Help menu. 
Special Considerations

To get a menu reference for a pop-up menu that you create using the pop-up control definition function, call the Control Manager functions GetControlData and GetControlDataSize, passing the tag constant kControlPopupButtonMenuRefTag in the tagName parameter to specify the menu reference.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef GetMenuHandle (
   MenuID menuID
);


#ifdef __cplusplus
}
#endif

#endif