#ifndef IORETURN_H
#define IORETURN_H

#include <mach/error.h>

#ifdef __cplusplus
extern "C" {
#endif

/*sys_iokit

Value: 0xe0000000 (-536870912)
#define sys_iokit  
Discussion 

The sys_iokit macro is defined as sys_iokit err_system(0x38).*/
#define sys_iokit  

/*IOReturn

typedef kern_return_t IOReturn;  
Discussion 

IOReturn is the return type used for most I/O Kit functions that can return an error. 
#defines*/
typedef kern_return_t IOReturn;  

/*iokit_common_err

#define iokit_common_err(return)  
Discussion 

The iokit_common_err macro is defined as iokit_common_err(return) (sys_iokit|sub_iokit_common|return). */
#define iokit_common_err(return)  

/*iokit_family_err

#define iokit_family_err(sub,return)  
Discussion 

The iokit_family_err macro is defined as iokit_family_err(sub,return) (sys_iokit|sub|return). */
#define iokit_family_err(sub,return)  

/*iokit_vendor_specific_err

#define iokit_vendor_specific_err(return)  
Discussion 

The iokit_vendor_specific_err macro is defined as iokit_vendor_specific_err(return) (sys_iokit|sub_iokit_vendor_specific|return). */
#define iokit_vendor_specific_err(return)  

/*kIOReturnAborted


The operation has been aborted (0xe00002eb).
Value: 0xe00002eb (-536870165)
#define kIOReturnAborted   */
#define kIOReturnAborted   

/*kIOReturnBadArgument


There is an invalid argument (0xe00002c2).
Value: 0xe00002c2 (-536870206)
#define kIOReturnBadArgument  */ 
#define kIOReturnBadArgument 

/*kIOReturnBadMedia


There has been a media error (0xe00002d1).
Value: 0xe00002d1 (-536870191)
#define kIOReturnBadMedia   */
#define kIOReturnBadMedia 

/*kIOReturnBadMessageID


The sent or received message had a different message id (0xe00002c6).
Value: 0xe00002c6 (-536870202)
#define kIOReturnBadMessageID   */
#define kIOReturnBadMessageID  

/*kIOReturnBusy


The device is busy (0xe00002d5).
Value: 0xe00002d5 (-536870187)
#define kIOReturnBusy   */
#define kIOReturnBusy 

/*kIOReturnCannotLock


The lock cannot be acquired (0xe00002cc).
Value: 0xe00002cc (-536870196)
#define kIOReturnCannotLock   */
#define kIOReturnCannotLo

/*kIOReturnCannotWire


Physical memory can't be wired down (0xe00002de).
Value: 0xe00002de (-536870178)
#define kIOReturnCannotWire   */
#define kIOReturnCannotWire

/*kIOReturnDeviceError


There has been a device error (0xe00002e9).
Value: 0xe00002e9 (-536870167)
#define kIOReturnDeviceError   */
#define kIOReturnDeviceError


/*kIOReturnDMAError


There has been a DMA failure (0xe00002d4).
Value: 0xe00002d4 (-536870188)
#define kIOReturnDMAError   */
#define kIOReturnDMAError  

/*kIOReturnError


A general error (0xe00002bc).
Value: 0xe00002bc (-536870212)
#define kIOReturnError   */
#define kIOReturnError  

/*kIOReturnExclusiveAccess


The device is already open with exclusive access (0xe00002c5).
Value: 0xe00002c5 (-536870203)
#define kIOReturnExclusiveAccess   */
#define kIOReturnExclusiveAccess 

/*kIOReturnInternalError


There has been an internal error (0xe00002c9).
Value: 0xe00002c9 (-536870199)
#define kIOReturnInternalError   */
#define kIOReturnInternalError  
/*kIOReturnInvalid


The is an invalid error (should never be seen) (0xe0000001).
Value: 0xe0000001 (-536870911)
#define kIOReturnInvalid   */
#define kIOReturnInvalid 

/*kIOReturnIOError


There has been a general I/O error (0xe00002ca).
Value: 0xe00002ca (-536870198)
#define kIOReturnIOError   */
#define kIOReturnIOError

/*kIOReturnIPCError


There has been an error during IPC (inter-process communication) (0xe00002bf).
Value: 0xe00002bf (-536870209)
#define kIOReturnIPCError   */
#define kIOReturnIPCError 

/*kIOReturnIsoTooNew


The isochronous I/O request is too early (0xe00002ef).
Value: 0xe00002ef (-536870161)
#define kIOReturnIsoTooNew   */
#define kIOReturnIsoTooNew 

/*kIOReturnIsoTooOld


The isochronous I/O request is too old (0xe00002ee).
Value: 0xe00002ee (-536870162)
#define kIOReturnIsoTooOld   */
#define kIOReturnIsoTooOld  

/*kIOReturnLockedRead


The device is read locked (0xe00002c3).
Value: 0xe00002c3 (-536870205)
#define kIOReturnLockedRead   */
#define kIOReturnLockedRead 

/*kIOReturnLockedWrite


The device is write locked (0xe00002c4).
Value: 0xe00002c4 (-536870204)
#define kIOReturnLockedWrite   */
#define kIOReturnLockedWrite 

/*kIOReturnMessageTooLarge


An oversized message has been received on an interrupt port (0xe00002e1).
Value: 0xe00002e1 (-536870175)
#define kIOReturnMessageTooLarge   */
#define kIOReturnMessageTooLarg

/*kIOReturnNoBandwidth


The operation will cause bus bandwidth to be exceeded (0xe00002ec).
Value: 0xe00002ec (-536870164)
#define kIOReturnNoBandwidth   */
#define kIOReturnNoBandwidth 

/*kIOReturnNoChannels


There are no DMA channels left (0xe00002da).
Value: 0xe00002da (-536870182)
#define kIOReturnNoChannels   */
#define kIOReturnNoChannels

/*kIOReturnNoCompletion


A completion routine is required (0xe00002ea).
Value: 0xe00002ea (-536870166)
#define kIOReturnNoCompletion   */
#define kIOReturnNoCompletion 

/*kIOReturnNoDevice


There is no such device (0xe00002c0).
Value: 0xe00002c0 (-536870208)
#define kIOReturnNoDevice   */
#define kIOReturnNoDevice 

/*kIOReturnNoFrames


There are no DMA frames enqueued (0xe00002e0).
Value: 0xe00002e0 (-536870176)
#define kIOReturnNoFrames   */
#define kIOReturnNoFrames

/*kIOReturnNoInterrupt


There is no interrupt attached (0xe00002df).
Value: 0xe00002df (-536870177)
#define kIOReturnNoInterrupt   */
#define kIOReturnNoInterrupt 

/*kIOReturnNoMedia


No media is present (0xe00002e4).
Value: 0xe00002e4 (-536870172)
#define kIOReturnNoMedia   */
#define kIOReturnNoMedia

/*kIOReturnNoMemory


Memory can't be allocated (0xe00002bd).
Value: 0xe00002bd (-536870211)
#define kIOReturnNoMemory   */
#define kIOReturnNoMemory

/*kIOReturnNoPower


There is no power to the device (0xe00002e3).
Value: 0xe00002e3 (-536870173)
#define kIOReturnNoPower   */
#define kIOReturnNoPower 

/*kIOReturnNoResources


There is a resource shortage (0xe00002be).
Value: 0xe00002be (-536870210)
#define kIOReturnNoResources   */
#define kIOReturnNoResources

/*kIOReturnNoSpace


There is no space for data (0xe00002db).
Value: 0xe00002db (-536870181)
#define kIOReturnNoSpace   
kIOReturnNotAligned


There has been an alignment error (0xe00002d0).
Value: 0xe00002d0 (-536870192)
#define kIOReturnNotAligned   */
#define kIOReturnNotAligned

/*kIOReturnNotAttached


The device is not attached (0xe00002d9).
Value: 0xe00002d9 (-536870183)
#define kIOReturnNotAttached   */
#define kIOReturnNotAttached
/*kIOReturnNotFound


The data was not found (0xe00002f0).
Value: 0xe00002f0 (-536870160)
#define kIOReturnNotFound   */
#define kIOReturnNotFound   
/*kIOReturnNotOpen


The device is not open (0xe00002cd).
Value: 0xe00002cd (-536870195)
#define kIOReturnNotOpen   */
#define kIOReturnNotOpen 

/*kIOReturnNotPermitted


The operation is not permitted (0xe00002e2).
Value: 0xe00002e2 (-536870174)
#define kIOReturnNotPermitted   */
#define kIOReturnNotPermitted 

/*kIOReturnNotPrivileged


There has been a privilege violation (0xe00002c1).
Value: 0xe00002c1 (-536870207)
#define kIOReturnNotPrivileged   */
#define kIOReturnNotPrivileged 
/*kIOReturnNotReadable


Read is not supported (0xe00002ce).
Value: 0xe00002ce (-536870194)
#define kIOReturnNotReadable   */
#define kIOReturnNotReadable 

/*kIOReturnNotReady


The device is not ready (0xe00002d8).
Value: 0xe00002d8 (-536870184)
#define kIOReturnNotReady   */
#define kIOReturnNotReady 

/*kIOReturnNotResponding


The device is not responding (0xe00002ed).
Value: 0xe00002ed (-536870163)
#define kIOReturnNotResponding   */
#define kIOReturnNotResponding 

/*kIOReturnNotWritable


Write is not supported (0xe00002cf).
Value: 0xe00002cf (-536870193)
#define kIOReturnNotWritable   */
#define kIOReturnNotWritable

/*kIOReturnOffline


The device is offline (0xe00002d7).
Value: 0xe00002d7 (-536870185)
#define kIOReturnOffline   */
#define kIOReturnOffline 

/*kIOReturnOverrun


There has been a data overrun (0xe00002e8).
Value: 0xe00002e8 (-536870168)
#define kIOReturnOverrun   */
#define kIOReturnOverrun 

/*kIOReturnPortExists


The port already exists (0xe00002dd).
Value: 0xe00002dd (-536870179)
#define kIOReturnPortExists   */
#define kIOReturnPortExists

/*kIOReturnRLDError


There has been an RLD failure (0xe00002d3).
Value: 0xe00002d3 (-536870189)
#define kIOReturnRLDError   */
#define kIOReturnRLDError 

/*kIOReturnStillOpen


The device is still open (0xe00002d2).
Value: 0xe00002d2 (-536870190)
#define kIOReturnStillOpen   */
#define kIOReturnStillOpen

/*kIOReturnSuccess


Success.
#define kIOReturnSuccess KERN_SUCCESS // OK  */
#define kIOReturnSuccess KERN_SUCCESS // OK  

/*kIOReturnTimeout


The I/O has timed out (0xe00002d6).
Value: 0xe00002d6 (-536870186)
#define kIOReturnTimeout   */
#define kIOReturnTimeout 

/*kIOReturnUnderrun


There has been a data underrun (0xe00002e7).
Value: 0xe00002e7 (-536870169)
#define kIOReturnUnderrun   */
#define kIOReturnUnderrun 

/*kIOReturnUnformattedMedia


The media is not formatted (0xe00002e5).
Value: 0xe00002e5 (-536870171)
#define kIOReturnUnformattedMedia   */
#define kIOReturnUnformattedMedia 

/*kIOReturnUnsupported


This is an unsupported function (0xe00002c7).
Value: 0xe00002c7 (-536870201)
#define kIOReturnUnsupported   */
#define kIOReturnUnsupported 

/*kIOReturnUnsupportedMode


There is no such mode (0xe00002e6).
Value: 0xe00002e6 (-536870170)
#define kIOReturnUnsupportedMode   */
#define kIOReturnUnsupportedMode   

/*kIOReturnVMError


There is some sort of VM (virtual memory) failure (0xe00002c8).
Value: 0xe00002c8 (-536870200)
#define kIOReturnVMError   */
#define kIOReturnVMError   

/*sub_iokit_block_storage

Value: 0x10000 (65536)
#define sub_iokit_block_storage  */
#define sub_iokit_block_storage



#ifdef __cplusplus
}
#endif

#endif