#ifndef  CVPIXELBUFFER_H
#define CVPIXELBUFFER_H

#include <TargetConditionals.h>

#include <QuartzCore/CVImageBuffer.h>
#include <CoreFoundation/CFArray.h>


#if defined(__cplusplus)
extern "C" {
#endif

/*Pixel Buffer Attribute Keys

Specify attributes associated with a pixel buffer. 

const CFStringRef kCVPixelBufferPixelFormatTypeKey;
   const CFStringRef kCVPixelBufferMemoryAllocatorKey;
   const CFStringRef kCVPixelBufferWidthKey;
   const CFStringRef kCVPixelBufferHeightKey;
   const CFStringRef kCVPixelBufferExtendedPixelsLeftKey;
   const CFStringRef kCVPixelBufferExtendedPixelsTopKey;
   const CFStringRef kCVPixelBufferExtendedPixelsRightKey;
   const CFStringRef kCVPixelBufferExtendedPixelsBottomKey;
   const CFStringRef kCVPixelBufferBytesPerRowAlignmentKey;
   const CFStringRef kCVPixelBufferCGBitmapContextCompatibilityKey;
   const CFStringRef kCVPixelBufferCGImageCompatibilityKey;
   const CFStringRef kCVPixelBufferOpenGLCompatibilityKey;
Constants
kCVPixelBufferPixelFormatTypeKey

The pixel format for this buffer (type CFNumber, or type CFArray containing an array of CFNumber types (actually type OSType)). For a listing of common pixel formats, see the QuickTime Ice Floe Dispatch 20.

Available in Mac OS X v10.3 and later.
kCVPixelBufferMemoryAllocatorKey

The allocator used with this buffer (type CFAllocatorRef). 

Available in Mac OS X v10.3 and later.
kCVPixelBufferWidthKey

The width of the pixel buffer (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferHeightKey

The height of the pixel buffer (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferExtendedPixelsLeftKey

The number of pixels padding the left of the image (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferExtendedPixelsTopKey

The number of pixels padding the top of the image (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferExtendedPixelsRightKey

The number of pixels padding the right of the image (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferExtendedPixelsBottomKey

The number of pixels padding the bottom of the image (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferBytesPerRowAlignmentKey

Indicates the number of bytes per row in the pixel buffer (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferCGBitmapContextCompatibilityKey

Indicates whether the pixel buffer is compatible with Core Graphics bitmap contexts (type CFBoolean).

Available in Mac OS X v10.3 and later.
kCVPixelBufferCGImageCompatibilityKey

Indicates whether the pixel buffer is compatible with CGImage types (type CFBoolean).

Available in Mac OS X v10.3 and later.
kCVPixelBufferOpenGLCompatibilityKey

Indicates whether the pixel buffer is compatible with OpenGL contexts (type CFBoolean).

Available in Mac OS X v10.3 and later.
Discussion

You specify these keys in a Core Foundation dictionary when calling functions such as CVPixelBufferCreate*/
const CFStringRef kCVPixelBufferPixelFormatTypeKey;
   const CFStringRef kCVPixelBufferMemoryAllocatorKey;
   const CFStringRef kCVPixelBufferWidthKey;
   const CFStringRef kCVPixelBufferHeightKey;
   const CFStringRef kCVPixelBufferExtendedPixelsLeftKey;
   const CFStringRef kCVPixelBufferExtendedPixelsTopKey;
   const CFStringRef kCVPixelBufferExtendedPixelsRightKey;
   const CFStringRef kCVPixelBufferExtendedPixelsBottomKey;
   const CFStringRef kCVPixelBufferBytesPerRowAlignmentKey;
   const CFStringRef kCVPixelBufferCGBitmapContextCompatibilityKey;
   const CFStringRef kCVPixelBufferCGImageCompatibilityKey;
   const CFStringRef kCVPixelBufferOpenGLCompatibilityKey;

/*CVPixelBufferRef

Defines a Core Video pixel buffer. 

typedef CVImageBufferRef CVPixelBufferRef;
Discussion

The pixel buffer stores an image in main memory.
Availability
Available in Mac OS X v10.3 and later.*/
typedef CVImageBufferRef CVPixelBufferRef;

/*CVPixelBufferUnlockBaseAddress

Unlocks the base address of the pixel buffer. 

CVReturn CVPixelBufferUnlockBaseAddress (
   CVPixelBufferRef pixelBuffer,
   CVOptionFlags unlockFlags
   );
Parameters
pixelBuffer

The pixel buffer whose base address you want to unlock.
unlockFlags

No options currently defined; pass 0.
Return Value

A Core Video result code. See “Result Codes” for possible values.
Discussion

Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/

CVReturn CVPixelBufferUnlockBaseAddress (
   CVPixelBufferRef pixelBuffer,
   CVOptionFlags unlockFlags
   );

/*CVPixelBufferLockBaseAddress

Locks the base address of the pixel buffer. 

CVReturn CVPixelBufferLockBaseAddress (
   CVPixelBufferRef pixelBuffer,
   CVOptionFlags lockFlags
   );
Parameters
pixelBuffer

The pixel buffer whose base address you want to lock.
lockFlags

No options currently defined; pass 0.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/

CVReturn CVPixelBufferLockBaseAddress (
   CVPixelBufferRef pixelBuffer,
   CVOptionFlags lockFlags
   );



/*CVPixelBufferGetBytesPerRow

Returns the number of bytes per row of the pixel buffer.

size_t CVPixelBufferGetBytesPerRow (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose bytes-per-row value you want to obtain.
Return Value

The number of bytes per row of the image data. For planar buffers this function returns a rowBytes value such that bytesPerRow * height covers the entire image including all planes.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/
size_t CVPixelBufferGetBytesPerRow (
   CVPixelBufferRef pixelBuffer
);

/*CVPixelBufferGetBaseAddress

Returns the base address of the pixel buffer.

void * CVPixelBufferGetBaseAddress (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose base address you want to obtain.
Return Value

The base address of the pixels. For chunky buffers, this returns a pointer to the pixel at (0,0) in the buffer For planar buffers this returns a pointer to a PlanarComponentInfo structure (as defined by QuickTime in ImageCodec.h).
Discussion

Retrieving the base address for a pixel buffer requires that the buffer base address be locked via a successful call to CVPixelBufferLockBaseAddress. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/
void * CVPixelBufferGetBaseAddress (
   CVPixelBufferRef pixelBuffer
);

/*CVPixelBufferGetWidth

Returns the width of the pixel buffer.

size_t CVPixelBufferGetWidth (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose width you want to obtain.
Return Value

The width of the buffer, in pixels.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/
size_t CVPixelBufferGetWidth (
   CVPixelBufferRef pixelBuffer
);

/*CVPixelBufferGetHeight

Returns the height of the pixel buffer.

size_t CVPixelBufferGetHeight (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose height you want to obtain.
Return Value

The buffer height, in pixels.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/

size_t CVPixelBufferGetHeight (
   CVPixelBufferRef pixelBuffer
);

#ifdef __cplusplus
}
#endif
#endif