#import <AppKit/NSImage.h>

@implementation NSImage (ADD)
/*drawInRect:fromRect:operation:fraction:

Draws all or part of the image in the specified rectangle in the current coordinate system. 

- (void)drawInRect:(NSRect)dstRect fromRect:(NSRect)srcRect operation:(NSCompositingOperation)op fraction:(float)delta
Parameters
dstRect

The rectangle in which to draw the image, specified in the current coordinate system. 
srcRect

The source rectangle specifying the portion of the image you want to draw. The coordinates of this rectangle must be specified using the image's own coordinate system. If you pass in NSZeroRect, the entire image is drawn. 
op

The compositing operation to use when drawing the image. See the NSCompositingOperation constants.
delta

The opacity of the image, specified as a value from 0.0 to 1.0. Specifying a value of 0.0 draws the image as fully transparent while a value of 1.0 draws the image as fully opaque. Values greater than 1.0 are interpreted as 1.0.
Discussion

If the srcRect and dstRect rectangles have different sizes, the source portion of the image is scaled to fit the specified destination rectangle. The image is otherwise positioned and oriented using the current coordinate system.

Unlike the compositeToPoint:fromRect:operation: and compositeToPoint:fromRect:operation:fraction: methods, this method checks the rectangle you pass to the srcRect parameter and makes sure it does not lie outside the image bounds. 
Availability
Available in Mac OS X v10.0 and later.
See Also
– dissolveToPoint:fraction:
– drawAtPoint:fromRect:operation:fraction:*/
- (void)drawInRect:(NSRect)dstRect fromRect:(NSRect)srcRect operation:(NSCompositingOperation)op fraction:(float)delta{}


@end