#include <AppKit/NSWindow.h>

@implementation NSWindow (ADD)

/*graphicsContext

Returns the graphics context associated with the receiver for the current thread.

- (NSGraphicsContext*)graphicsContext
Availability
Available in Mac OS X v10.4 and later.*/
- (NSGraphicsContext*)graphicsContext{}

/*removeChildWindow:

Detaches childWin from the receiver.

- (void)removeChildWindow:(NSWindow *)childWin
Availability
Available in Mac OS X v10.2 and later.
See Also
– addChildWindow:ordered:
– childWindows
– parentWindow
– setParentWindow:*/
- (void)removeChildWindow:(NSWindow *)childWin{}

/*addChildWindow:ordered:

childWin is ordered either above (NSWindowAbove) or below (NSWindowBelow) the receiver, and maintained in that relative place for subsequent ordering operations involving either window.

- (void)addChildWindow:(NSWindow *)childWin ordered:(NSWindowOrderingMode)place
Discussion

While this attachment is active, moving childWin will not cause the receiver to move (as in sliding a drawer in or out), but moving the receiver will cause childWin to move.

Note that you should not create cycles between parent and child windows. For example, you should not add window B as child of window A, then add window A as a child of window B.
Availability
Available in Mac OS X v10.2 and later.
See Also
– removeChildWindow:
– childWindows
– parentWindow
– setParentWindow:*/
- (void)addChildWindow:(NSWindow *)childWin ordered:(NSWindowOrderingMode)place{}

/*setParentWindow:

For use by subclasses when setting the parent window in the receiver.

- (void)setParentWindow:(NSWindow *)window
Discussion

You should call super if overriding.
Availability
Available in Mac OS X v10.2 and later.
See Also
– removeChildWindow:
– childWindows
– parentWindow
– addChildWindow:ordered:*/
- (void)setParentWindow:(NSWindow *)window{}

@end