#include <CoreGraphics/CoreGraphics.h>

void CPSEnableForegroundOperation( void* psn ){
//TODO
}; 

/*CGPostKeyboardEvent

Synthesizes a low-level keyboard event on the local machine.

CGError CGPostKeyboardEvent (
   CGCharCode keyChar,
   CGKeyCode virtualKey,
   boolean_t keyDown
);
Parameters
keyChar

The value of the character to generate, or 0 to specify that the system should guess an appropriate value based on the default key mapping.
virtualKey

The virtual key code for the event. See CGKeyCode.
keyDown

Pass true to specify that the key position is down; otherwise, pass false.
Return Value

A result code. See Quartz Display Services Result Codes. 
Discussion

This function is not recommended for general use because of undocumented special cases and undesirable side effects. The recommended replacement for this function is CGEventCreateKeyboardEvent, which allows you to create a keyboard event and customize the event before posting it to the event system. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGRemoteOperation.h*/
CGError CGPostKeyboardEvent (
   CGCharCode keyChar,
   CGKeyCode virtualKey,
   boolean_t keyDown){
//TODO
};


/*CGRectIntegral

Returns a rectangle with integer values for its origin and size.

CGRect CGRectIntegral (
   CGRect rect
);
Parameters
rect

The source rectangle. 
Return Value

The rectangle with smallest integer values for its origin and size that contains the source rectangle. That is, given a rectangle with fractional origin or size values, CGRectIntegral rounds the rectangle’s origin downward and its size upward to the nearest whole integers, such that the result contains the original rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectIntegral (
   CGRect rect){
//TODO
};


/*CGRectIntersection

Returns the intersection of two rectangles.

CGRect CGRectIntersection (
   CGRect rect1,
   CGRect rect2
);
Parameters
rect1

The first source rectangle.
rect2

The second source rectangle.
Return Value

A rectangle that is the intersection of the two specified rectangles. If the two rectangles do not intersect, returns the null rectangle. To check for this condition, use CGRectIsNull. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

CGRect CGRectIntersection (
   CGRect rect1,
   CGRect rect2){
//TODO
};


/*CGRectInset

Returns a rectangle that is smaller or larger than the source rectangle, with the same center point.

CGRect CGRectInset (
   CGRect rect,
   float dx,
   float dy
);
Parameters
rect

The source rectangle. 
dx

The value by which to adjust the x-coordinates of the source rectangle. To create an inset rectangle, specify a positive value. To create a larger, encompassing rectangle, specify a negative value.
dy

The value by which to adjust the y-coordinates of the source rectangle. To create an inset rectangle, specify a positive value. To create a larger, encompassing rectangle, specify a negative value.
Return Value

A rectangle with its origin offset in the x-axis by the distance specified by the dx parameter and in the y-axis by the distance specified by the dy parameter, and its size adjusted by (2*dx,2*dy), relative to the source rectangle. If dx and dy are positive values, then the rectangle’s size is decreased. If dx and dy are negative values, the rectangle’s size is increased.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectInset (
   CGRect rect,
   float dx,
   float dy){
//TODO
};


/*CGRectGetHeight

Returns the height of a rectangle.

float CGRectGetHeight (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The height of the specified rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetHeight (
   CGRect rect){
//TODO
};


/*CGRectGetWidth

Returns the width of a rectangle.

float CGRectGetWidth (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The width of the specified rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetWidth (
   CGRect rect){
//TODO
};


/*CGContextDrawImage

Draws an image into a graphics context.

void CGContextDrawImage (
   CGContextRef context,
   CGRect rect,
   CGImageRef image
);
Parameters
context

The graphics context in which to draw the image. 
rect

The location and dimensions in user space of the bounding box in which to draw the image. 
image

The image to draw. 
Discussion

Quartz scales the image—disproportionately, if necessary—to fit the bounds specified by the rect parameter.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/void CGContextDrawImage (
   CGContextRef context,
   CGRect rect,
   CGImageRef image){
//TODO
};


/*CGImageRelease

Decrements the retain count of a Quartz image.

void CGImageRelease (
   CGImageRef image
);
Parameters
image

The image to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the image parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
void CGImageRelease (
   CGImageRef image){
//TODO
};



/*CGColorSpaceCreateWithPlatformColorSpace

Creates a platform-specific color space.

CGColorSpaceRef CGColorSpaceCreateWithPlatformColorSpace(
   void *platformColorSpace
);
Parameters
platformColorSpace

A generic pointer to a platform-specific color space. In Mac OS X, pass a CMProfileRef—a ColorSync profile. Quartz uses this pointer (and the underlying information) only during the function call.
Return Value

A new color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateWithPlatformColorSpace(
   void *platformColorSpace){
//TODO
};


/*CGColorSpaceRelease

Decrements the retain count of a color space.

void CGColorSpaceRelease (
   CGColorSpaceRef cs
);
Parameters
cs

The Quartz color space to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the cs parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
void CGColorSpaceRelease (
   CGColorSpaceRef cs){
//TODO
};

/*CGRectMake

Returns a rectangle structure constructed from coordinate and dimension values you provide.

CGRect CGRectMake (
   float x,
   float y,
   float width,
   float height
);
Parameters
x

The x-coordinate of the rectangle’s origin point.
y

The y-coordinate of the rectangle’s origin point.
width

The width of the rectangle.
height

The height of the rectangle.
Return Value

Returns a rectangle with the specified location and dimensions. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectMake (
   float x,
   float y,
   float width,
   float height){
//TODO
};


/*CGRectIsInfinite

Checks whether a rectangle is infinite.

bool CGRectIsInfinite (
   CGRect rect
);
Parameters
rect

The rectangle to examine.
Return Value

Returns true if the specified rectangle is infinite, false otherwise.
Discussion

An infinite rectangle is one that has no defined bounds. Infinite rectangles can be created as output from a tiling filter. For example, the Core Image framework perspective tile filter creates an image whose extent is described by an infinite rectangle.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGGeometry.h*/
bool CGRectIsInfinite (
   CGRect rect){
//TODO
};


/*CGMainDisplayID

Returns the display ID of the main display. 

CGDirectDisplayID CGMainDisplayID (void);
Return Value

The display ID assigned to the main display. For more information about this data type, see CGDirectDisplayID.
Discussion

The main display is the display with its screen location at (0,0) in global coordinates. In a system without display mirroring, the display with the menu bar is typically the main display.

If mirroring is enabled, and the menu bar appears on more than one display, this function provides a reliable way to find the main display. 

In case of hardware mirroring, the drawable display becomes the main display. In case of software mirroring, the display with the highest resolution and deepest pixel depth typically becomes the main display.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDirectDisplay.h*/
CGDirectDisplayID CGMainDisplayID (void){
//TODO
};


/*CGRectGetMinY

Returns the y-axis coordinate that establishes the bottom edge of a rectangle.

float CGRectGetMinY (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The y-coordinate of the bottom-left corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMinY (
   CGRect rect){
//TODO
};

/*CGRectGetMaxY

Returns the y-axis coordinate that establishes the top edge of a rectangle.

float CGRectGetMaxY (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The y-coordinate of the top-right corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMaxY (
   CGRect rect){
//TODO
};

/*CGContextAddRect

Adds a new subpath, consisting of a single rectangle, to a graphics context.

void CGContextAddRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context to which to add the rectangular subpath. 
rect

A CGRect value that specifies, in the user space, the dimensions and location of the rectangle to create. 
Discussion

This function adds a subpath consisting of a single rectangle to the specified context’s path. You can add multiple rectangular subpaths at the same time using the function CGContextAddRects. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddRect (
   CGContextRef context,
   CGRect rect){};


/*CGContextSetGrayFillColor

Sets the current fill color to a value in the DeviceGray color space.

void CGContextSetGrayFillColor (
   CGContextRef context,
   float gray,
   float alpha
);
Parameters
context

The graphics context for which to set the current fill color. 
gray

A value that specifies the desired gray level. The DeviceGray color space permits the specification of a value ranging from 0.0 (absolute black) to 1.0 (absolute white). Values outside this range are clamped to 0.0 or 1.0.
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current fill color space to DeviceGray.
Quartz sets the current fill color to the value you specify in the gray and alpha parameters.

See also CGContextSetGrayStrokeColor. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetGrayFillColor (
   CGContextRef context,
   float gray,
   float alpha
){}

;/*CGColorSpaceCreateDeviceGray

Creates a device-dependent grayscale color space.

CGColorSpaceRef CGColorSpaceCreateDeviceGray (void);
Return Value

A device-dependent gray color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

In Mac OS X v10.4 and later, this color space is no longer device-dependent and is replaced by the generic counterpart—kCGColorSpaceGenericGray—described in “Generic Color Spaces”. If you use this function in Mac OS X v10.4 and later, colors are mapped to the generic color spaces. If you want to bypass color matching, use the colorspace of the destination context.

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateDeviceGray (void){};

/*CGContextRestoreGState

Sets the current graphics state to the state most recently saved.

void CGContextRestoreGState (
   CGContextRef context
);
Parameters
context

The graphics context to modify.
Discussion

When you call CGContextRestoreGState, Quartz removes the most recently saved graphics state from the top of the stack and uses that state’s saved settings for the current graphics state. See CGContextSaveGState.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRestoreGState (
   CGContextRef context
){}

;
/*CGContextStrokePath

Paints a line along the current path.

void CGContextStrokePath (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to stroke.
Discussion

This function strokes the current path. See also CGContextDrawPath, CGContextEOFillPath, and CGContextFillPath.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextStrokePath (
   CGContextRef context
){}

;
/*CGContextFillPath

Paints the area within the current path, using the nonzero winding number rule.

void CGContextFillPath (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to fill. 
Discussion

When you fill the current path, Quartz fills each subpath independently. Any subpath that has not been explicitly closed is closed implicitly by the fill routines. 

There are two different methods of filling paths. The CGContextFillPath function uses the nonzero winding number rule. The function CGContextEOFillPath uses the even-odd rule to fill a path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextFillPath (
   CGContextRef context
){}
/*CGContextAddArc

Adds an arc of a circle to the current path, using a center point, radius, and end point.

void CGContextAddArc (
   CGContextRef context,
   float x,
   float y,
   float radius,
   float startAngle,
   float endAngle,
   int clockwise
);
Parameters
context

The graphics context to which to add the arc.
x

The x-coordinate of the user space for the center of the arc.
y

The y-coordinate of the user space for the center of the arc.
radius

The radius of the arc, in user space coordinates.
startAngle

The angle to the starting point of the arc, measured in radians from the positive x-axis.
endAngle

The angle to the end point of the arc, measured in radians from the positive x-axis.
clockwise

Pass 1 if the arc is to be drawn clockwise; 0 otherwise.
Discussion

When you call this function, Quartz builds an arc of a circle centered on the point you provide. The arc is of the specified radius and extends between the start and end point. (You can also use CGContextAddArc as a convenient way to draw a circle, by setting the start point to 0 and the end point to 2*Pi.)

If the current path already contains a subpath, Quartz additionally appends a straight line segment from the current point to the starting point of the arc. If the current path is empty, Quartz creates a new subpath for the arc and does not add the initial straight line segment.

After adding the arc, the current point is reset to the end point of arc (the second tangent point).

See also CGContextAddArcToPoint. 
Availability
Available in Mac OS X version 10.0 and later.*/
void CGContextAddArc (
   CGContextRef context,
   float x,
   float y,
   float radius,
   float startAngle,
   float endAngle,
   int clockwise
){};


/*CGContextBeginPath

Creates a new empty path in a graphics context.

void CGContextBeginPath (
   CGContextRef context
);
Parameters
context

The graphics context in which to begin a new path.
Discussion

A graphics context can have only a single path in use at any time. Therefore, if the specified context already contains a current path when you call this function, Quartz replaces the previous current path with the new path. In this case, Quartz discards the old path and any data associated with it.

The current path is not part of the graphics state. Consequently, saving and restoring the graphics state has no effect on the current path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextBeginPath (
   CGContextRef context
){};





/*CGContextSetRGBStrokeColor

Sets the current stroke color to a value in the DeviceRGB color space.

void CGContextSetRGBStrokeColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
);
Parameters
context

The graphics context for which to set the current stroke color. 
red

The red intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
green

The green intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
blue

The blue intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current stroke color space to DeviceRGB.
Quartz sets the current stroke color to the value specified by the red, green, blue, and alpha parameters.

See also CGContextSetRGBFillColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetRGBStrokeColor (CGContextRef context,float red,float green,float blue,float alpha){
//TODO
};


/*CGContextSetLineWidth

Sets the line width for a graphics context.

void CGContextSetLineWidth (
   CGContextRef context,
   float width
);
Parameters
context

The graphics context for which to set the line width parameter of the current graphics state. 
width

The new line width to be used, in user space units. The value must be greater than 0.
Discussion

The line width is the total width of the line, expressed in units of the user space. The line surrounds the center of the path, with half of the total width on either side. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSetLineWidth (
   CGContextRef context,
   float width){};


/*CGContextSaveGState

Pushes a copy of the current graphics state on the top of a context’s graphics state stack.

void CGContextSaveGState (
   CGContextRef context
);
Parameters
context

The graphics context for which to save the current graphics state. 
Discussion

Each graphics context maintains a stack of graphics states. When you call CGContextSaveGState, Quartz saves the current graphics state to the top of the context’s graphics state stack.

Note that not all aspects of the current drawing environment are elements of the graphics state. For example, the current path is not considered part of the graphics state and is therefore not saved when you call the CGContextSaveGState function. The graphics state parameters that are saved are:
CTM (current transformation matrix) 
clip region
image interpolation quality 
line width 
line join 
miter limit 
line cap 
line dash 
flatness 
should anti-alias 
rendering intent 
fill color space 
stroke color space 
fill color 
stroke color 
alpha value 
font 
font size 
character spacing 
text drawing mode
shadow parameters
the pattern phase
the font smoothing parameter
blend mode

To restore your drawing environment to a previously saved state, you can use the function CGContextRestoreGState. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSaveGState (
   CGContextRef context){};



/*CGImageRetain

Increments the retain count of a Quartz image.

CGImageRef CGImageRetain (
   CGImageRef image
);
Parameters
image

The image to retain. 
Return Value

The same image you passed in as the image parameter.
Discussion

This function is equivalent to CFRetain, except that it does not cause an error if the image parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
CGImageRef CGImageRetain (
   CGImageRef image){
//TODO
};

/*CGImageCreate

Creates a Quartz bitmap image.

CGImageRef CGImageCreate (
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bitsPerPixel,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo,
   CGDataProviderRef provider,
   const float decode[],
   int shouldInterpolate,
   CGColorRenderingIntent intent
);
Parameters
width

The width, in pixels, of the required image.
height

The height, in pixels, of the required image
bitsPerComponent

The number of bits for each component in a source pixel. For example, if the source image uses the RGBA-32 format, you would specify 8 bits per component.
bitsPerPixel

The total number of bits in a source pixel. This value must be at least bitsPerComponent times the number of components per pixel.
bytesPerRow

The number of bytes of memory for each horizontal row of the bitmap.
colorspace

The color space for the image. Quartz retains the color space you pass in; on return, you may safely release it.
bitmapInfo

A CGBitmapInfo constant that specifies whether the bitmap should contain an alpha channel and its relative location in a pixel, along with whether the components are floating-point or integer values. 
provider

The source of data for the bitmap. For information about supported data formats, see the discussion below. Quartz retains this object; on return, you may safely release it.
decode

The decode array for the image. If you do not want to allow remapping of the image’s color values, pass NULL for the decode array.
shouldInterpolate

A Boolean value that specifies whether interpolation should occur. The interpolation setting specifies whether Quartz should apply a pixel-smoothing algorithm to the image.
intent

A CGColorRenderingIntent constant that specifies how Quartz should handle colors that are not located within the gamut of the destination color space of a graphics context.
Return Value

A new Quartz bitmap image. You are responsible for releasing this object by calling CGImageRelease.
Discussion

The data provider should provide raw data that matches the format specified by the other input parameters. To use encoded data (for example, from a file specified by a URL-based data provider), see CGImageCreateWithJPEGDataProvider and CGImageCreateWithPNGDataProvider. In Mac OS X version 10.3 and later, you can also use the QuickTime function GraphicsImportCreateCGImage to decode an image file in any supported format and create a CGImage, in a single operation.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
CGImageRef CGImageCreate (
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bitsPerPixel,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo,
   CGDataProviderRef provider,
   const float decode[],
   int shouldInterpolate,
   CGColorRenderingIntent intent){};



/*CGDataProviderRelease

Decrements the retain count of a data provider.

void CGDataProviderRelease (
   CGDataProviderRef provider
);
Parameters
provider

The data provider to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the provider parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGDataProvider.h*/
void CGDataProviderRelease (
   CGDataProviderRef provider){
//TODO
};


/*CGColorSpaceCreateDeviceRGB

Creates a device-dependent RGB color space.

CGColorSpaceRef CGColorSpaceCreateDeviceRGB (void);
Return Value

A device-dependent RGB color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

In Mac OS X v10.4 and later, this color space is no longer device-dependent and is replaced by the generic counterpart—kCGColorSpaceGenericRGB—described in “Generic Color Spaces”. If you use this function in Mac OS X v10.4 and later, colors are mapped to the generic color spaces. If you want to bypass color matching, use the colorspace of the destination context.

Colors in a device-dependent color space are not transformed or otherwise modified when displayed on an output device—that is, there is no attempt to maintain the visual appearance of a color. As a consequence, colors in a device color space often appear different when displayed on different output devices. For this reason, device color spaces are not recommended when color preservation is important.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateDeviceRGB (void){
//TODO
};


/*CGBitmapContextCreate

Creates a bitmap graphics context.

CGContextRef CGBitmapContextCreate (
   void * data,
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo
);
Parameters
data

A pointer to the destination in memory where the drawing is to be rendered. The size of this memory block should be at least (bytesPerRow*height) bytes.
width

The width, in pixels, of the required bitmap.
height

The height, in pixels, of the required bitmap.
bitsPerComponent

The number of bits to use for each component of a pixel in memory. For example, for a 32-bit pixel format and an RGB color space, you would specify a value of 8 bits per component. For more information about supported pixel formats, see Quartz 2D Programming Guide.
bytesPerRow

The number of bytes of memory to use per row of the bitmap.
colorspace

The color space to use for the bitmap context. Note that indexed color spaces are not supported for bitmap graphics contexts.
bitmapInfo

A CGBitmapInfo constant that specifies whether the bitmap should contain an alpha channel and its relative location in a pixel, along with whether the components are floating-point or integer values. See CGImage Reference for a description of CGBitmapInfo constants. 
Return Value

A new bitmap context, or NULL if a context could not be created. You are responsible for releasing this object using CGContextRelease.
Discussion

When you call this function, Quartz creates a bitmap drawing environment—that is, a bitmap context—to your specifications. When you draw into this context, Quartz renders your drawing as bitmapped data in the specified block of memory.

The pixel format for a new bitmap context is determined by three parameters—the number of bits per component, the color space, and an alpha option (expressed as a CGBitmapInfo constant). The alpha value determines the opacity of a pixel when it is drawn.

For more information see, Creating a Bitmap Graphics Context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGBitmapContext.h*/

CGContextRef CGBitmapContextCreate (
   void * data,
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo){
//TODO
};



/*CGContextSetRGBFillColor

Sets the current fill color to a value in the DeviceRGB color space.

void CGContextSetRGBFillColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
);
Parameters
context

The graphics context for which to set the current fill color. 
red

The red intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
green

The green intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
blue

The blue intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current fill color space to DeviceRGB. 
Quartz sets the current fill color to the value specified by the red, green, blue, and alpha parameters.

See also CGContextSetRGBStrokeColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetRGBFillColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha){
//TODO
};

/*CGContextFillRect

Paints the area contained within a rectangle.

void CGContextFillRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context in which to paint the rectangle.
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint. 
Discussion

This function paints the area contained within the specified rectangle, using the fill color specified in the current graphics state. As a side effect when you call this function, Quartz clears the current path.

See also CGContextFillRects.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextFillRect (
   CGContextRef context,
   CGRect rect){};


/*CGBitmapContextCreateImage

Creates an image that is a copy of a bitmap graphics context.

CGImageRef CGBitmapContextCreateImage(
   CGContextRef c
);
Parameters
c

A bitmap graphics context.
Return Value

A CGImage object that contains a snapshot of the bitmap graphics context or NULL if the image is not created.
Discussion

The CGImage object returned by this function is created by a copy operation. Subsequent changes to the bitmap graphics context do not affect the contents of the returned image. In some cases the copy operation actually follows copy-on-write semantics, so that the actual physical copy of the bits occur only if the underlying data in the bitmap graphics context is modified. As a consequence, you may want to use the resulting image and release it before you perform additional drawing into the bitmap graphics context. In this way, you can avoid the actual physical copy of the data.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGBitmapContext.h*/
CGImageRef CGBitmapContextCreateImage(
   CGContextRef c){};


/*CGContextRelease

Decrements the retain count of a graphics context.

void CGContextRelease (
   CGContextRef context
);
Parameters
context

The graphics context to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the context parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRelease (
   CGContextRef context
){}

;/*CGDataProviderCreateWithData

Creates a Quartz direct-access data provider that uses data your program supplies.

CGDataProviderRef CGDataProviderCreateWithData (
   void *info,
   const void *data,
   size_t size,
   void (*releaseData)(void *info, const void *data, size_t size)
);
Parameters
info

A pointer to data of any type, or NULL. When Quartz calls the function specified in the releaseData parameter, Quartz sends it this pointer as its first argument.
data

A pointer to the array of data that the provider contains.
size

A value that specifies the number of bytes that the data provider contains.
releaseData

A pointer to a release callback for the data provider, or NULL. Your release function is called when Quartz frees the data provider. For more information, see CGDataProviderReleaseDataCallback.
Return Value

A new data provider. You are responsible for releasing this object using CGDataProviderRelease.
Discussion

You use this function to create a direct-access data provider that uses callback functions to read data from your program an entire block at one time. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGDataProvider.h*/
CGDataProviderRef CGDataProviderCreateWithData (
   void *info,
   const void *data,
   size_t size,
   void (*releaseData)(void *info, const void *data, size_t size)
){};

/*CGContextMoveToPoint

Begins a new subpath at the point you specify.

void CGContextMoveToPoint (
   CGContextRef context,
   float x,
   float y
);
Parameters
context

A graphics context. 
x

A value for the x-coordinate of the user space at which to begin the subpath.
y

A value for the y-coordinate of the user space at which to begin the subpath.
Discussion

The CGContextMoveToPoint function begins a new subpath starting at the point you specify. This point is defined to be the “current” point, and it defines the starting point of the next line segment.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextMoveToPoint (
   CGContextRef context,
   float x,
   float y
){};


/*CGContextAddCurveToPoint

Appends a cubic Bézier curve from the current point, using control points and an end point you specify.

void CGContextAddCurveToPoint (
   CGContextRef context,
   float cp1x,
   float cp1y,
   float cp2x,
   float cp2y,
   float x,
   float y
);
Parameters
context

The graphics context to which to add the curve. The context’s path must not be empty.
cp1x

The x-coordinate of the user space for the first control point of the curve.
cp1y

The y-coordinate of the user space for the first control point of the curve.
cp2x

The x-coordinate of the user space for the second control point of the curve.
cp2y

The y-coordinate of the user space for the second control point of the curve.
x

The x-coordinate of the user space at which to end the curve.
y

The y-coordinate of the user space at which to end the curve.
Discussion

This function appends a cubic curve to the current path. After adding the segment, the current point is reset from the beginning of the new segment to the end point of that segment.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddCurveToPoint (
   CGContextRef context,
   float cp1x,
   float cp1y,
   float cp2x,
   float cp2y,
   float x,
   float y
){}

;/*CGContextAddLineToPoint

Appends a straight line segment from the current point to the point you specify.

void CGContextAddLineToPoint (
   CGContextRef context,
   float x,
   float y
);
Parameters
context

The graphics context to which to add a line segment. The context’s path must not be empty.
x

A value for the x-coordinate of the user space at which to end the line segment.
y

A value for the y-coordinate of the user space at which to end the line segment.
Discussion

This function appends a single straight line segment to the current subpath. After adding the line segment, the current point is reset from the beginning of the new line segment to the endpoint of that line segment. You can add a subpath consisting of multiple straight line segments using the function CGContextAddLines.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddLineToPoint (
   CGContextRef context,
   float x,
   float y
){};


/*CGRectGetMidY

Returns the y-axis coordinate that establishes the center of a rectangle.

float CGRectGetMidY (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The y-coordinate of the center of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMidY (
   CGRect rect){};



/*CGContextSetLineCap

Sets the style for the endpoints of lines in a graphics context.

void CGContextSetLineCap (
   CGContextRef context,
   CGLineCap cap
);
Parameters
context

The graphics context for which to set the line cap parameter of the current graphics state. 
cap

A CGLineCap value that specifies the line cap style to be used. For a discussion of the available line cap styles, see Line Cap Styles.
Discussion

The line cap style specifies how Quartz draws the endpoint of a line. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetLineCap (
   CGContextRef context,
   CGLineCap cap){};



/*CGRectUnion

Returns the smallest rectangle that contains two other specified rectangles.

CGRect CGRectUnion (
   CGRect r1,
   CGRect r2
);
Parameters
r1

The first source rectangle. 
r2

The second source rectangle.
Return Value

The smallest rectangle that completely contains both of the source rectangles. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectUnion (
   CGRect r1,
   CGRect r2){};


/*CGContextClipToMask

Maps a mask into the specified rectangle and intersects it with the current clipping area of the graphics context.

void CGContextClipToMask(
CGContextRef c,
CGRect rect,
CGImageRef mask
);
Parameters
c

A graphics context. 
rect

The rectangle to map the mask parameter to.
mask

An image or an image mask. If mask is an image, then it must be in the DeviceGray color space, may not have an alpha component, and may not be masked by an image mask or masking color.
Discussion

If the mask parameter is an image mask, then Quartz clips in a manner identical to the behavior seen with the function CGContextDrawImage—the mask indicates an area to be left unchanged when drawing. The source samples of the image mask determine which points of the clipping area are changed, acting as an "inverse alpha" value. If the value of a source sample in the image mask is S, then the corresponding point in the current clipping area is multiplied by an alpha value of (1–S). For example, if S is 1 then the point in the clipping area becomes transparent. If S is 0, the point in the clipping area is unchanged.

If the mask parameter is an image, then mask acts like an alpha mask and is blended with the current clipping area. The source samples of mask determine which points of the clipping area are changed. If the value of the source sample in mask is S, then the corresponding point in the current clipping area is multiplied by an alpha of S. For example, if S is 0, then the point in the clipping area becomes transparent. If S is 1, the point in the clipping area is unchanged.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGContext.h*/
void CGContextClipToMask(
CGContextRef c,
CGRect rect,
CGImageRef mask
){};



/*CGImageGetWidth

Returns the width of a bitmap image.

size_t CGImageGetWidth (
   CGImageRef image
);
Parameters
image

The image to examine. 
Return Value

The width, in pixels, of the specified bitmap image (or image mask).
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
size_t CGImageGetWidth (
   CGImageRef image
){};



/*CGImageGetHeight

Returns the height of a bitmap image.

size_t CGImageGetHeight (
   CGImageRef image
);
Parameters
image

The image to examine. 
Return Value

The height in pixels of the bitmap image (or image mask).
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
size_t CGImageGetHeight (
   CGImageRef image
){};


/*CGAffineTransformMake

Returns an affine transformation matrix constructed from values you provide. 

CGAffineTransform CGAffineTransformMake (
   float a,
   float b,
   float c,
   float d,
   float tx,
   float ty
);
Parameters
a

The value at position [1,1] in the matrix.
b

The value at position [1,2] in the matrix.
c

The value at position [2,1] in the matrix.
d

The value at position [2,2] in the matrix.
tx

The value at position [3,1] in the matrix.
ty

The value at position [3,2] in the matrix.
Return Value

A new affine transform matrix constructed from the values you specify.
Discussion

This function creates a CGAffineTransform structure that represents a new affine transformation matrix, which you can use (and reuse, if you want) to transform a coordinate system. The matrix takes the following form:




If you want only to transform an object to be drawn, it is not necessary to construct an affine transform to do so. The most direct way to transform your drawing is by calling the appropriate CGContext function to adjust the current transformation matrix.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformMake (
   float a,
   float b,
   float c,
   float d,
   float tx,
   float ty
){};
/*CGImageGetColorSpace

Return the color space for a bitmap image.

CGColorSpaceRef CGImageGetColorSpace (
   CGImageRef image
);
Parameters
image

The image to examine. 
Return Value

The source color space for the specified bitmap image, or NULL if the image is an image mask. You are responsible for retaining and releasing the color space as necessary.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
CGColorSpaceRef CGImageGetColorSpace (
   CGImageRef image
){};


/*CGContextConcatCTM

Transforms the user coordinate system in a context using a specified matrix.

void CGContextConcatCTM (
   CGContextRef context,
   CGAffineTransform transform
);
Parameters
context

A graphics context. 
transform

The transformation matrix to apply to the specified context’s current transformation matrix. 
Discussion

When you call the function CGContextConcatCTM, it concatenates (that is, it combines) two matrices, by multiplying them together. The order in which matrices are concatenated is important, as the operations are not commutative. When you call CGContextConcatCTM, the resulting CTM in the context is: CTMnew = transform * CTMcontext.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextConcatCTM (
   CGContextRef context,
   CGAffineTransform transform
){};


/*CGContextRotateCTM

Rotates the user coordinate system in a context.

void CGContextRotateCTM (
   CGContextRef context,
   float angle
);
Parameters
context

A graphics context. 
angle

The angle, in radians, by which to rotate the coordinate space of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRotateCTM (
   CGContextRef context,
   float angle
){};

/*CGContextScaleCTM

Changes the scale of the user coordinate system in a context.

void CGContextScaleCTM (
   CGContextRef context,
   float sx,
   float sy
);
Parameters
context

A graphics context. 
sx

The factor by which to scale the x-axis of the coordinate space of the specified context.
sy

The factor by which to scale the y-axis of the coordinate space of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextScaleCTM (
   CGContextRef context,
   float sx,
   float sy
){};






/*CGContextTranslateCTM

Changes the origin of the user coordinate system in a context.

void CGContextTranslateCTM (
   CGContextRef context,
   float tx,
   float ty
);
Parameters
context

A graphics context. 
tx

The amount to displace the x-axis of the coordinate space, in units of the user space, of the specified context.
ty

The amount to displace the y-axis of the coordinate space, in units of the user space, of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextTranslateCTM (
   CGContextRef context,
   float tx,
   float ty
){};

/*CGLayerGetContext

Gets the graphics context associated with a CGLayer object.

CGContextRef CGLayerGetContext(
   CGLayerRef layer
);
Parameters
layer

The layer whose graphics context you want to obtain.
Return Value

The graphics context associated with the layer.
Discussion

The context that’s returned is the context for the layer itself, not the context that you specified when you created the layer.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
CGContextRef CGLayerGetContext(
   CGLayerRef layer
){};


/*CGLayerRelease

Decrements the retain count of a CGLayer object.

void CGLayerRelease(CGLayerRef layer);
Parameters
layer

The layer to release.
Discussion

This function is equivalent to calling CFRelease (layer) except that it does not crash (as CFRetain does) if the layer parameter is null.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
void CGLayerRelease(CGLayerRef layer){};

/*CGContextClearRect

Paints a transparent rectangle.

void CGContextClearRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context in which to paint the rectangle. 
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint transparently. 
Discussion

If the specified context is a window or bitmap context, Quartz effectively “clears” the rectangle. For other types of context, Quartz fills the rectangle in a device-dependent manner.
Special Considerations

The use of this function is not recommended in contexts other than window or bitmap contexts.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextClearRect (
   CGContextRef context,
   CGRect rect
){};


/*CGColorSpaceCreateWithName

Creates a specified type of Quartz color space.

CGColorSpaceRef CGColorSpaceCreateWithName (
CFStringRef name
);
Parameters
name

A color space name. See “Generic Color Spaces” for a list of the valid Quartz-defined names.
Return Value

A new generic color space. You are responsible for releasing this object by calling CGColorSpaceRelease. If unsuccessful, returns NULL.
Discussion

You can use this function to create a generic color space. For more information, see “Generic Color Spaces”.

Prior to Mac OS X v10.4, you could pass this function one of the constants defined in “Named Color Spaces (Deprecated)”. As of Mac OS X v10.4, this function returns a generic color space even if you pass is one of the deprecated named color spaces. 
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGColorSpace.h*/
CGColorSpaceRef CGColorSpaceCreateWithName (
CFStringRef name
){};

/*CGPointMake

Returns a point structure constructed from coordinate values you provide.

CGPoint CGPointMake (
   float x,
   float y
);
Parameters
x

The x-coordinate of the point to construct.
y

The y-coordinate of the point to construct.
Return Value

Returns a CGPoint structure, representing a single (x,y) coordinate pair. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGPoint CGPointMake (
   float x,
   float y
){};




/*CGRectGetMidX

Returns the x-axis coordinate that establishes the center of a rectangle.

float CGRectGetMidX (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The x-coordinate of the center of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetMidX (
   CGRect rect
){};


;/*CGRectGetMinX

Returns the x-axis coordinate that establishes the left edge of a rectangle.

float CGRectGetMinX (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The x-coordinate of the bottom-left corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMinX (
   CGRect rect
){};



/*CGContextSetGrayStrokeColor

Sets the current stroke color to a value in the DeviceGray color space.

void CGContextSetGrayStrokeColor (
   CGContextRef context,
   float gray,
   float alpha
);
Parameters
context

The graphics context for which to set the current stroke color. 
gray

A value that specifies the desired gray level. The DeviceGray color space permits the specification of a value ranging from 0.0 (absolute black) to 1.0 (absolute white). Values outside this range are clamped to 0.0 or 1.0.
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current stroke color space to DeviceGray. The DeviceGray color space is a single-dimension space in which color values are specified solely by the intensity of a gray value (from absolute black to absolute white). 
Quartz sets the current stroke color to the value you specify in the gray and alpha parameters.

See also CGContextSetGrayFillColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetGrayStrokeColor (
   CGContextRef context,
   float gray,
   float alpha
){};


/*CGContextStrokeRect

Paints an outline of a rectangle.

void CGContextStrokeRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context in which to paint the rectangle.
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint. 
Discussion

This function paints a line along the path of the specified rectangle, using the current attributes of the graphics state. As a side effect when you call this function, Quartz clears the current path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextStrokeRect (
   CGContextRef context,
   CGRect rect
){};


/*CGRectContainsPoint

Indicates whether a rectangle contains a specified point.

int CGRectContainsPoint (
   CGRect rect,
   CGPoint point
);
Parameters
rect

The rectangle to examine. 
point

The point to examine. 
Return Value

Returns 1 if the specified point is located within the specified rectangle; otherwise, 0. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
int CGRectContainsPoint (
   CGRect rect,
   CGPoint point
){};



/*CGDataProviderCreateWithURL

Creates a Quartz direct-access data provider that uses a URL to supply data.

CGDataProviderRef CGDataProviderCreateWithURL (
   CFURLRef url
);
Parameters
url

A CFURL object to use for the data provider. When you supply Quartz data via the provider, it reads the data from the URL address. 
Return Value

A new data provider. You are responsible for releasing this object using CGDataProviderRelease.
Discussion

You use this function to create a direct-access data provider that supplies data from a URL. When you supply Quartz with a direct-access data provider, Quartz obtains data from your program in a single entire block.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGDataProvider.h*/

CGDataProviderRef CGDataProviderCreateWithURL (
   CFURLRef url
){};
/*CGImageCreateWithPNGDataProvider

Creates a Quartz bitmap image using PNG-encoded data.

CGImageRef CGImageCreateWithPNGDataProvider (
   CGDataProviderRef source,
   const float decode[],
   bool shouldInterpolate,
   CGColorRenderingIntent intent
);
Parameters
source

A data provider supplying PNG-encoded data.
decode

The decode array for the image. Typically a decode array is unnecessary, and you should pass NULL.
shouldInterpolate

A Boolean value that specifies whether interpolation should occur. The interpolation setting specifies whether Quartz should apply a pixel-smoothing algorithm to the image.
intent

A CGColorRenderingIntent constant that specifies how Quartz should handle colors that are not located within the gamut of the destination color space of a graphics context.
Return Value

A new Quartz bitmap image. You are responsible for releasing this object by calling CGImageRelease.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGImage.h*/

CGImageRef CGImageCreateWithPNGDataProvider (
   CGDataProviderRef source,
   const float decode[],
   bool shouldInterpolate,
   CGColorRenderingIntent intent
){};

/*CGContextGetTextPosition

Returns the location at which text is drawn.

CGPoint CGContextGetTextPosition (
   CGContextRef context
);
Parameters
context

The graphics context from which to obtain the current text position. 
Return Value

Returns a CGPoint value that specifies the x and y values at which text is to be drawn, in user space coordinates. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

CGPoint CGContextGetTextPosition (
   CGContextRef context
){};


/*CGContextSetTextDrawingMode

Sets the current text drawing mode.

void CGContextSetTextDrawingMode (
   CGContextRef context,
   CGTextDrawingMode mode
);
Parameters
context

The graphics context for which to set the text drawing mode. 
mode

A CGTextDrawingMode value that specifies the text drawing mode to use. For possible values, see Text Drawing Modes.
Discussion

Text drawing modes determine how Quartz renders individual glyphs in a graphics context. For more information, see Text Drawing Modes.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetTextDrawingMode (
   CGContextRef context,
   CGTextDrawingMode mode
){};

/*CGContextSelectFont

Sets the font and font size in a graphics context.

void CGContextSelectFont (
   CGContextRef context,
   const char * name,
   float size,
   CGTextEncoding textEncoding
);
Parameters
context

The graphics context for which to set the font and font size. 
name

A null-terminated string that contains the PostScript name of the font to set.
size

A value that specifies the font size to set, in text space units.
textEncoding

A CGTextEncoding value that specifies the encoding used for the font. For a description of the available values, see Text Encodings.
Discussion

For information about when to use this function, see CGFontCreateWithPlatformFont.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSelectFont (
   CGContextRef context,
   const char * name,
   float size,
   CGTextEncoding textEncoding
){};


/*CGContextShowTextAtPoint

Displays a character string at a position you specify.

void CGContextShowTextAtPoint (
   CGContextRef context,
   float x,
   float y,
   const char * bytes,
   size_t length
);
Parameters
context

The graphics context in which to display the text. 
x

A value for the x-coordinate of the text space at which to display the text.
y

A value for the y-coordinate of the text space at which to display the text.
bytes

An array of characters to draw.
length

The length of the array specified in the bytes parameter.
Discussion

This function displays a character array at the position in the text space that you specify. Quartz use font data provided by ATS (Apple Type Services) to map each byte of the array through the encoding vector of the current font to obtain the glyph to display. Note that the font must have been set using CGContextSelectFont; CGContextShowTextAtPoint should not be used in conjunction with CGContextSetFont.

See also CGContextShowText, CGContextShowGlyphs, CGContextShowGlyphsAtPoint, and CGContextShowGlyphsWithAdvances.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextShowTextAtPoint (
   CGContextRef context,
   float x,
   float y,
   const char * bytes,
   size_t length
){};

/*CGContextFlush

Forces all pending drawing operations in a window context to be rendered immediately to the destination device.

void CGContextFlush (
   CGContextRef context
);
Parameters
context

The window context to flush. If you pass a PDF context or a bitmap context, this function does nothing.
Discussion

When you call this function, Quartz immediately flushes the current drawing to the destination device (for example, a screen). Because the system software flushes a context automatically at the appropriate times, calling this function could have an adverse effect on performance. Under normal conditions, you do not need to call this function.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextFlush (
   CGContextRef context
){};



/*CGAffineTransformScale

Returns an affine transformation matrix constructed by scaling an existing affine transform.

CGAffineTransform CGAffineTransformScale (
   CGAffineTransform t,
   float sx,
   float sy
);
Parameters
t

An existing affine transform. 
sx

The value by which to scale x values of the affine transform.
sy

The value by which to scale y values of the affine transform.
Return Value

A new affine transformation matrix.
Discussion

You use this function to create a new affine transformation matrix by adding scaling values to an existing affine transform. The resulting structure represents a new affine transform, which you can use (and reuse, if you want) to scale a coordinate system. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformScale (
   CGAffineTransform t,
   float sx,
   float sy
){};











