#include <Security/Security.h>

/*AuthorizationCopyRights

Authorizes and preauthorizes rights.

OSStatus AuthorizationCopyRights (
   AuthorizationRef authorization,
   const AuthorizationRights *rights,
   const AuthorizationEnvironment *environment,
   AuthorizationFlags flags,
   AuthorizationRights **authorizedRights
);
Parameters
authorization

An authorization reference referring to the authorization session. 
rights

A pointer to a set of authorization rights you create. Pass NULL if the application requires no rights at this time. 
environment

Data used when authorizing or preauthorizing rights. Not used in Mac OS X v10.2 and earlier. In Mac OS X v10.3 and later, you can pass icon or prompt data to be used in the authentication dialog box. In Mac OS X v10.4 and later, you can also pass a user name and password in order to authorize a user without displaying the authentication dialog box. Possible values for this parameter are listed in Security.framework/Headers/AuthorizationTags.h. The data passed in this parameter is not stored in the authorization reference; it is used only during authorization. If you are not passing any data in this parameter, pass the constant kAuthorizationEmptyEnvironment.
flags

A bit mask for specifying authorization options. Use the following option sets.
Pass the constant kAuthorizationFlagDefaults if no options are necessary.
Specify the kAuthorizationFlagExtendRights mask to request rights. You can also specify the kAuthorizationFlagInteractionAllowed mask to allow user interaction.
Specify the kAuthorizationFlagPartialRights and kAuthorizationFlagExtendRights masks to request partial rights. You can also specify the kAuthorizationFlagInteractionAllowed mask to allow user interaction.
Specify the kAuthorizationFlagPreAuthorize and kAuthorizationFlagExtendRights masks to preauthorize rights.
Specify the kAuthorizationFlagDestroyRights mask to prevent the Security Server from preserving the rights obtained during this call.
authorizedRights

A pointer to a newly allocated AuthorizationRights structure. On return, this structure contains the rights granted by the Security framework. If you do not require this information, pass NULL. If you specify the kAuthorizationFlagPreAuthorize mask in the flags parameter, the method returns all the requested rights, including those not granted, but the flags of the rights that could not be preauthorized include the kAuthorizationFlagCanNotPreAuthorize bit.

Free the memory associated with this set by calling the function AuthorizationFreeItemSet.
Return Value

A result code. See “Authorization Services Result Codes”.
Discussion

There are three main reasons to use this function. The first reason is to preauthorize rights by specifying the kAuthorizationFlagPreAuthorize, kAuthorizationFlagInteractionAllowed, and kAuthorizationFlagExtendRights masks as authorization options. Preauthorization is most useful when a right has a zero timeout. For example, you can preauthorize in the application and if it succeeds, call the helper tool and request authorization. This eliminates calling the helper tool if the Security Server cannot later authorize the specified rights.

The second reason to use this function is to authorize rights before performing a privileged operation by specifying the kAuthorizationFlagInteractionAllowed, and kAuthorizationFlagExtendRights masks as authorization options.

The third reason to use this function is to authorize partial rights. By specifying the kAuthorizationFlagPartialRights, kAuthorizationFlagInteractionAllowed, and kAuthorizationFlagExtendRights masks as authorization options, the Security Server grants all rights it can authorize. On return, the authorized set contains all the rights.

If you do not specify the kAuthorizationFlagPartialRights mask and the Security Server denies at least one right, then the status of this function on return is errAuthorizationDenied.

If you do not specify the kAuthorizationFlagInteractionAllowed mask and the Security Server requires user interaction, then the status of this function on return is errAuthorizationInteractionNotAllowed.

If you specify the kAuthorizationFlagInteractionAllowed mask and the user cancels the authentication process, then the status of this function on return is errAuthorizationCanceled.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AuthorizationCopyRights (
   AuthorizationRef authorization,
   const AuthorizationRights *rights,
   const AuthorizationEnvironment *environment,
   AuthorizationFlags flags,
   AuthorizationRights **authorizedRights){
//TODO
};


/*AuthorizationRightSet

Creates or updates a right entry in the policy database.

OSStatus AuthorizationRightSet(
   AuthorizationRef authRef,
   const char *rightName,
   CFTypeRef rightDefinition,
   CFStringRef descriptionKey,
   CFBundleRef bundle,
   CFStringRef localeTableName);
Parameters
authRef

A valid authorization reference used to authorize modifications.
rightName

An ASCII character string representing the right name. The policy database does not accept wildcard right names.
rightDefinition

Either a CFDictionary containing keys defining the rules or a CFString representing the name of another right whose rules you wish to duplicate. See Policy Database Constants for some possible values.
descriptionKey

A CFString reference used as a key for looking up localized descriptions. If no localization is found, this is the description itself. This parameter is optional; pass NULL if you do not require it.
bundle

A bundle to get localizations from if not the main bundle. This parameter is optional; pass NULL if you do not require it.
localeTableName

A CFString representing a table name from which to get localizations. This parameter is optional; pass NULL if you have no localizations or you wish to use the localizations available in Localizable.strings.
Return Value

A result code. See “Authorization Services Result Codes”.
Discussion

The right you create must be an explicit right with no wildcards. Wildcard rights are for use by system administrators for site configuration.

You can use this function to create a new right or modify an existing right. For example,AuthorizationRightSet(NULL, "com.ifoo.ifax.send",
CFSTR(kAuthorizationRuleIsAdmin), CFSTR("Authorize sending  of a fax"), NULL, NULL);


adds a rule for letting administrators send faxes. This example creates a right named “com.ifoo.ifax.send” and sets the rules to require the user to be an administrator by using the kAuthorizationRuleIsAdmin constant. This example also sets a comment to let the system administrator know that the right authorizes administrators to send a fax.

To specify additional attributes for the right, you can pass an CFDictionary type in the rightDefinition parameter as shown in the following example.CFStringRef keys[2] = {CFSTR(kRightRule), CFSTR(kRightComment)};
CFStringRef values[2] = {CFSTR(kAuthorizationRuleIsAdmin), CFSTR("authorizes  sending of 1 fax message")};
CFDictionaryRef aDict;
aDict = CFDictionaryCreate(NULL, (void *)keys, (void *)values, 2,  &kCFCopyStringDictionaryKeyCallBacks, &kCFTypeDictionaryValueCallBacks);
AuthorizationRightSet(NULL, "com.ifoo.ifax.send", aDict,  CFSTR("Authorize sending  of a fax"), NULL, NULL);
CFRelease(aDict);


This call creates the same right as before, but adds a specific right comment to the rules definition.

When you specify comments, you should be specific about what you need to authorize. For example, the means of proof required for kAuthorizationRuleAuthenticateAsAdmin (a username and password) should not be included here since that rule might be configured differently.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus AuthorizationRightSet(
   AuthorizationRef authRef,
   const char *rightName,
   CFTypeRef rightDefinition,
   CFStringRef descriptionKey,
   CFBundleRef bundle,
   CFStringRef localeTableName){
//TODO
};

/*AuthorizationRightGet

Retrieves a right definition as a dictionary.

OSStatus AuthorizationRightGet(
const char *rightName,
CFDictionaryRef *rightDefinition);
Parameters
rightName

An ASCII character string representing the rightname. Wildcard right names are valid.
rightDefinition

A reference to a dictionary. On return, this points to a dictionary of keys that define the right. Passing NULL checks if the right is defined. You should release the memory used by the returned dictionary.
Return Value

A result code. See “Authorization Services Result Codes”.
Discussion

You do not need an authorization reference to use this function because the policy database is world readable.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus AuthorizationRightGet(
const char *rightName,
CFDictionaryRef *rightDefinition){
//TODO
};
/*AuthorizationCreate

Creates a new authorization reference and provides an option to authorize or preauthorize rights.

OSStatus AuthorizationCreate (
   const AuthorizationRights *rights,
   const AuthorizationEnvironment *environment,
   AuthorizationFlags flags,
   AuthorizationRef *authorization
);
Parameters
rights

A pointer to a set of authorization rights you create. Pass NULL if the application requires no rights at this time. 
environment

Data used when authorizing or preauthorizing rights. Not used in Mac OS X v10.2 and earlier. In Mac OS X v10.3 and later, you can pass icon or prompt data to be used in the authentication dialog box. In Mac OS X v10.4 and later, you can also pass a user name and password in order to authorize a user without user interaction. Possible values for this parameter are listed in Security.framework/Headers/AuthorizationTags.h. The data passed in this parameter is not stored in the authorization reference; it is used only during authorization. If you are not passing any data in this parameter, pass the constant kAuthorizationEmptyEnvironment. 
flags

A bit mask for specifying authorization options. Use the following option sets.
Pass the constant kAuthorizationFlagDefaults if no options are necessary.
Specify the kAuthorizationFlagExtendRights mask to request rights. You can also specify the kAuthorizationFlagInteractionAllowed mask to allow user interaction.
Specify the kAuthorizationFlagPartialRights and kAuthorizationFlagExtendRights masks to request partial rights. You can also specify the kAuthorizationFlagInteractionAllowed mask to allow user interaction.
Specify the kAuthorizationFlagPreAuthorize and kAuthorizationFlagExtendRights masks to preauthorize rights.
Specify the kAuthorizationFlagDestroyRights mask to prevent the Security Server from preserving the rights obtained during this call.
authorization

A pointer to an authorization reference. On return, this parameter refers to the authorization session the Security Server creates. Pass NULL if you require a function result but no authorization reference.
Return Value

A result code. See “Authorization Services Result Codes”.
Discussion

The primary purpose of this function is to create the opaque authorization reference structure associated with the authorization reference. You use the authorization reference in other authorization functions.

You can use this function to authorize all or partial rights. Authorizing rights with this function is most useful for applications that require a one-time authorization. By passing NULL to the authorization parameter, the Security Server attempts to authorize the requested rights and returns the appropriate result code without actually granting the rights. If you are not going to call any other authorization functions, use this method to determine if a user has authorization without granting any rights.

You can also use this function to preauthorize rights by specifying the kAuthorizationFlagPreAuthorize mask. Preauthorization is most useful when a right has a zero timeout. For example, you can preauthorize in the application and if it succeeds, call the helper tool and request authorization. This eliminates calling the helper tool if the user cannot later authorize the specified rights.

If you do not specify the kAuthorizationFlagPartialRights mask and the Security Server denies at least one right, then the status of this function on return is errAuthorizationDenied.

If you do not specify the kAuthorizationFlagInteractionAllowed mask and the Security Server requires user interaction, then the status of this function on return is errAuthorizationInteractionNotAllowed.

If you specify the kAuthorizationFlagInteractionAllowed mask and the user cancels the authentication process, then the status of this function on return is errAuthorizationCanceled.

When your application no longer needs the authorization reference, use the function AuthorizationFree to free the memory associated with it.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AuthorizationCreate (
   const AuthorizationRights *rights,
   const AuthorizationEnvironment *environment,
   AuthorizationFlags flags,
   AuthorizationRef *authorization){
//TODO
};


