#include <SpeechSynthesis/SpeechSynthesis.h>
/*CountVoices

Determines how many voices are available.

OSErr CountVoices (
   short * numVoices
);
Parameters
numVoices

On exit, a pointer to the number of voices that the application can use. 
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The CountVoices function returns, in the numVoices parameter, the number of voices available. The application can then use this information to call the GetIndVoice function to obtain voice specification structures for one or more of the voices.

Each time CountVoices is called, the Speech Synthesis Manager searches for new voices. 
Special Considerations

Because the CountVoices function moves memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr CountVoices (
   short * numVoices
){};


/*NewSpeechChannel

Creates a new speech channel.

OSErr NewSpeechChannel (
   VoiceSpec * voice,
   SpeechChannel * chan
);
Parameters
voice

A pointer to the voice specification structure corresponding to the voice to be used for the new speech channel. Pass NULL to create a speech channel using the system default voice. 
chan

On return, a pointer to a valid speech channel.
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The NewSpeechChannel function allocates memory for a speech channel structure and sets the speech channel variable pointed to by the chan parameter to point to this speech channel structure. The Speech Synthesis Manager automatically locates and opens a connection to the proper synthesizer for the voice specified by the voice parameter.

There is no predefined limit to the number of speech channels an application can create. However, system constraints on available RAM, processor loading, and number of available sound channels limit the number of speech channels actually possible.

Your application should not attempt to manipulate the data pointed to by a variable of type SpeechChannel. The internal format that the Speech Synthesis Manager uses for speech channel data is not documented and may change in future versions of system software. 
Special Considerations

Because the NewSpeechChannel function allocates memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr NewSpeechChannel (
   VoiceSpec * voice,
   SpeechChannel * chan
){};


/*DisposeSpeechChannel

Disposes of an existing speech channel.

OSErr DisposeSpeechChannel (
   SpeechChannel chan
);
Parameters
chan

The speech channel to dispose of.
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The DisposeSpeechChannel function disposes of the speech channel specified in the chan parameter and releases all memory the channel occupies. If the speech channel specified is producing speech, then the DisposeSpeechChannel function immediately stops speech before disposing of the channel. If you have defined a text-done callback function or a speech-done callback function, the function will not be called before the channel is disposed of.

The Speech Synthesis Manager releases any speech channels that have not been explicitly disposed of by an application when the application quits. In general, however, your application should dispose of any speech channels it has created whenever it receives a suspend event. This ensures that other applications can take full advantage of Speech Synthesis Manager and Sound Manager capabilities. 
Special Considerations

Because the DisposeSpeechChannel function might purge memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr DisposeSpeechChannel (
   SpeechChannel chan
){};


/*SetSpeechPitch

Sets the speech pitch on a designated speech channel.

OSErr SetSpeechPitch (
   SpeechChannel chan,
   Fixed pitch
);
Parameters
chan

The speech channel whose pitch you wish to set.
pitch

The new pitch for the speech channel, expressed as a fixed-point frequency value.
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The SetSpeechPitch function changes the current speech pitch on the speech channel specified by the chan parameter to the pitch specified by the pitch parameter. Typical voice frequencies range from around 90 hertz for a low-pitched male voice to perhaps 300 hertz for a high-pitched child’s voice. These frequencies correspond to approximate pitch values in the ranges of 30.000 to 40.000 and 55.000 to 65.000, respectively. Although fixed-point values allow you to specify a wide range of pitches, not all synthesizers will support the full range of pitches. If your application specifies a pitch that a synthesizer cannot handle, it may adjust the pitch to fit within an acceptable range. 
Special Considerations

You can call the SetSpeechPitch function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr SetSpeechPitch (
   SpeechChannel chan,
   Fixed pitch
){};

/*SpeakText

Speaks a buffer of text.

OSErr SpeakText (
   SpeechChannel chan,
   const void * textBuf,
   unsigned long textBytes
);
Parameters
chan

The speech channel through which speech is to be spoken.
textBuf

A pointer to the first byte of text to spoken. 
textBytes

The number of bytes of text to spoken. 
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

Like SpeakString, the SpeakText function also generates speech, but through a speech channel through which you can exert control over the generated speech.

The SpeakText function converts the text stream specified by the textBuf and textBytes parameters into speech using the voice and control settings for the speech channel chan, which should be created with the NewSpeechChannel function. The speech is generated asynchronously. This means that control is returned to your application before the speech has finished (and probably even before it has begun). The maximum length of the text buffer that can be spoken is limited only by the available RAM.

If SpeakText is called while the channel is currently busy speaking the contents of a prior text buffer, it immediately stops speaking from the prior buffer and begins speaking from the new text buffer as soon as possible. If you pass a zero-length string (or, in C, a null pointer) to SpeakText, the Speech Synthesis Manager stops all speech currently being synthesized by the speech channel specified in the chan parameter without generating additional speech.

The text buffer must be locked in memory and must not move while the Speech Synthesis Manager processes it. This buffer is read at interrupt time, and moving it could cause a system crash. If your application defines a text-done callback function, then it can move the text buffer or dispose of it once the callback function is executed. 
Special Considerations

Because the SpeakText function moves memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr SpeakText (
   SpeechChannel chan,
   const void * textBuf,
   unsigned long textBytes
){};
/*GetIndVoice

Obtains a voice specification structure for a voice by passing an index to the GetIndVoice function.

OSErr GetIndVoice (
   short index,
   VoiceSpec * voice
);
Parameters
index

The index of the voice for which to obtain a voice specification structure. This number must range from 1 to the total number of voices, as returned by the CountVoices function. 
voice

A pointer to the voice specification structure whose fields are to be filled in. 
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The GetIndVoice function returns, in the voice specification structure pointed to by the voice parameter, a specification of the voice whose index is provided in the index parameter. Your application should make no assumptions about the order in which voices are indexed.

Your application should not add, remove, or modify a voice and then call the GetIndVoice function with an index value other than 1. To allow the Speech Synthesis Manager to update its information about voices, your application should always either call the CountVoices function or call the GetIndVoice function with an index value of 1 after adding, removing, or modifying a voice or after a time at which the user might have done so.

If you specify an index value beyond the number of available voices, the GetIndVoice function returns a voiceNotFound error. 
Special Considerations

Because the GetIndVoice function moves memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr GetIndVoice (
   short index,
   VoiceSpec * voice
){};


/*GetVoiceDescription

Obtains a description of a voice by using the GetVoiceDescription function.

OSErr GetVoiceDescription (
   const VoiceSpec * voice,
   VoiceDescription * info,
   long infoLength
);
Parameters
voice

A pointer to the voice specification structure identifying the voice to be described, or NULL to obtain a description of the system default voice. 
info

A pointer to a voice description structure. If this parameter is NULL, the function does not fill in the fields of the voice description structure; instead, it simply determines whether the voice parameter specifies an available voice and, if not, returns a voiceNotFound error. 
infoLength

The length, in bytes, of the voice description structure. In the current version of the Speech Synthesis Manager, the voice description structure contains 362 bytes. However, you should always use the SizeOf function to determine the length of this structure. 
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The GetVoiceDescription function fills out the voice description structure pointed to by the info parameter with the correct information for the voice specified by the voice parameter. It fills in the length field of the voice description structure with the number of bytes actually copied. This value will always be less than or equal to the value that your application passes in infoLength before calling GetVoiceDescription. This scheme allows applications targeted for the current version of the Speech Synthesis Manager to work on future versions that might have longer voice description structures; it also allows you to write code for future versions of the Speech Synthesis Manager that will also run on computers that support only the current version.

If the voice specification structure does not identify an available voice, GetVoiceDescription returns a voiceNotFound error. 
Special Considerations

Because the GetVoiceDescription function moves memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr GetVoiceDescription (
   const VoiceSpec * voice,
   VoiceDescription * info,
   long infoLength
){};

/*SetSpeechInfo

Changes a setting of a particular speech channel.

OSErr SetSpeechInfo (
   SpeechChannel chan,
   OSType selector,
   const void * speechInfo
);
Parameters
chan

The speech channel for which your application wishes to change a setting.
selector

A speech information selector that indicates the type of information being changed.

For a complete list of speech information selectors, see “Speech Information Constants”. This list indicates how your application should set the speechInfo parameter for each selector and indicates which selectors might cause memory to be moved or purged.
speechInfo

A pointer whose meaning depends on the speech information selector specified in the selector parameter. 
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The SetSpeechInfo function changes the type of setting indicated by the selector parameter in the speech channel specified by the chan parameter, based on the data your application provides via the speechInfo parameter.

The format of the data structure specified by the speechInfo parameter depends on the selector you choose. Ordinarily, a selector requires that speechInfo be a pointer to a data structure that specifies a new setting for the speech channel. 
Special Considerations

You can call the SetSpeechInfo function at interrupt time only if the speech information selector specified in the selector parameter does not move or purge memory.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr SetSpeechInfo (
   SpeechChannel chan,
   OSType selector,
   const void * speechInfo
){};

/*TextToPhonemes

Converts textual data into phonemic data.

OSErr TextToPhonemes (
   SpeechChannel chan,
   const void * textBuf,
   unsigned long textBytes,
   Handle phonemeBuf,
   long * phonemeBytes
);
Parameters
chan

A speech channel whose associated synthesizer and voice are to be used for the conversion process.
textBuf

A pointer to a buffer of text to be converted. 
textBytes

The number of bytes of text to be converted. 
phonemeBuf

A handle to a buffer to be used to store the phonemic data. The TextToPhonemes function may resize the relocatable block referenced by this handle.
phonemeBytes

On return, a pointer to the number of bytes of phonemic data written to the handle. 
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

Converting textual data into phonetic data is particularly useful during application development, when you might wish to adjust phrases that your application generates to produce smoother speech. By first converting the target phrase into phonemes, you can see what the synthesizer will try to speak. Then you need correct only the parts that would not have been spoken the way you want.

The TextToPhonemes function converts the textBytes bytes of textual data pointed to by the textBuf parameter to phonemic data, which it writes into the relocatable block specified by the phonemeBuf parameter. If necessary, TextToPhonemes resizes this relocatable block. The TextToPhonemes function sets the phonemeBytes parameter to the number of bytes of phonetic data actually written.

If the textual data is contained in a relocatable block, a handle to that block must be locked before the TextToPhonemes function is called. 

The data returned by TextToPhonemes corresponds precisely to the phonemes that would be spoken had the input text been sent to SpeakText instead. All current mode settings for the speech channel specified by chan are applied to the converted speech. No callbacks are generated while the TextToPhonemes function is generating its output. 
Special Considerations

Because the TextToPhonemes function might move memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr TextToPhonemes (
   SpeechChannel chan,
   const void * textBuf,
   unsigned long textBytes,
   Handle phonemeBuf,
   long * phonemeBytes
){};


/*PauseSpeechAt

Pauses speech on a speech channel.

OSErr PauseSpeechAt (
   SpeechChannel chan,
   long whereToPause
);
Parameters
chan

The speech channel on which speech is to be paused.
whereToPause

A constant indicating when speech processing should be paused. Pass the constant kImmediate to pause immediately, even in the middle of a word. Pass kEndOfWord or kEndOfSentence to pause speech at the end of the current word or sentence, respectively. 
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The PauseSpeechAt function makes speech production pause at a specified point in the text. PauseSpeechAt returns immediately, although speech output will continue until the specified point.

You can determine whether your application has paused speech output on a speech channel by obtaining a speech status information structure through the GetSpeechInfo function. While a speech channel is paused, the speech status information structure indicates that outputBusy and outputPaused are both TRUE.

If the end of the input text buffer is reached before the specified pause point, speech output pauses at the end of the buffer.

The PauseSpeechAt function differs from the StopSpeech and StopSpeechAt functions in that a subsequent call to ContinueSpeech, described next, causes the contents of the current text buffer to continue being spoken.

If you plan to continue speech synthesis from a paused speech channel, the text buffer being processed must remain available at all times and must not move while the channel is in a paused state. 
Special Considerations

Because the PauseSpeechAt function might move or purge memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/

OSErr PauseSpeechAt (
   SpeechChannel chan,
   long whereToPause
){};


/*UseDictionary

Installs a designated dictionary into a speech channel.

OSErr UseDictionary (
   SpeechChannel chan,
   Handle dictionary
);
Parameters
chan

The speech channel into which a dictionary is to be installed.
dictionary

A handle to the dictionary data. This is often a handle to a resource of type 'dict'.
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The UseDictionary function attempts to install the dictionary data referenced by the dictionary parameter into the speech channel referenced by the chan parameter. The synthesizer will use whatever elements of the dictionary resource it considers useful to the speech conversion process. Some speech synthesizers might ignore certain types of dictionary entries.

After the UseDictionary function returns, your application is free to release any storage allocated for the dictionary handle. The search order for application-provided dictionaries is last-in, first-searched.

All details of how an application-provided dictionary is represented within the speech synthesizer are dependent on the specific synthesizer implementation and are private to the synthesizer.

Pronunciation dictionaries allow your application to override the default Speech Synthesis Manager pronunciations of individual words, such as names with quirky spellings.
Special Considerations

Because the UseDictionary function might move memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr UseDictionary (
   SpeechChannel chan,
   Handle dictionary
){};

/*SpeechManagerVersion

Determines the current version of the Speech Synthesis Manager installed in the system.

NumVersion SpeechManagerVersion ();
Return Value

The version of the Speech Synthesis Manager installed in the system, in the format of the first 4 bytes of a 'vers' resource. 
Discussion

Use this call to determine whether your program can access features of the Speech Synthesis Manager that are included in some Speech Synthesis Manager releases but not in earlier ones.
Special Considerations

You can call the SpeechManagerVersion function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
NumVersion SpeechManagerVersion (){};


/*GetSpeechInfo

Obtains information about a designated speech channel.

OSErr GetSpeechInfo (
   SpeechChannel chan,
   OSType selector,
   void * speechInfo
);
Parameters
chan

The speech channel about which information is being requested.
selector

A speech information selector that indicates the type of information being requested.

For a complete list of speech information selectors, see “Speech Information Constants”. This list indicates how your application should set the speechInfo parameter for each selector and indicates which selectors might cause memory to be moved or purged.
speechInfo

A pointer whose meaning depends on the speech information selector specified in the selector parameter. 
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The GetSpeechInfo function returns, in the data structure pointed to by the speechInfo parameter, the type of information requested by the selector parameter as it applies to the speech channel specified in the chan parameter.

The format of the data structure specified by the speechInfo parameter depends on the selector you choose. For example, a selector might require that your application allocate a block of memory of a certain size and pass a pointer to that block. Another selector might require that speechInfo be set to the address of a handle variable. In this case, the GetSpeechInfo function would allocate a relocatable block of memory and change the handle variable specified to reference the block. 
Special Considerations

You can call the GetSpeechInfo function at interrupt time only if the speech information selector specified in the selector parameter does not move or purge memory.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr GetSpeechInfo (
   SpeechChannel chan,
   OSType selector,
   void * speechInfo
){};

/*GetSpeechPitch

Determines a speech channel’s current speech pitch.

OSErr GetSpeechPitch (
   SpeechChannel chan,
   Fixed * pitch
);
Parameters
chan

The speech channel whose pitch you wish to determine.
pitch

On return, a pointer to the current pitch of the voice in the speech channel, expressed as a fixed-point frequency value.
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

Typical voice frequencies range from around 90 hertz for a low-pitched male voice to perhaps 300 hertz for a high-pitched child’s voice. These frequencies correspond to approximate pitch values in the ranges of 30.000 to 40.000 and 55.000 to 65.000, respectively. For information about the mathematical relationship between pitches and frequencies expressed in hertz. 
Special Considerations

You can call the GetSpeechPitch function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr GetSpeechPitch (
   SpeechChannel chan,
   Fixed * pitch
){};


/*StopSpeechAt

Terminates speech delivery on a specified channel either immediately or at the end of the current word or sentence.

OSErr StopSpeechAt (
   SpeechChannel chan,
   long whereToStop
);
Parameters
chan

The speech channel on which speech is to be stopped.
whereToStop

A constant indicating when speech processing should stop. Pass the constant kImmediate to stop immediately, even in the middle of a word. Pass kEndOfWord or kEndOfSentence to stop speech at the end of the current word or sentence, respectively. 
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The StopSpeechAt function halts the production of speech on the channel specified by chan at a specified point in the text. This function returns immediately, although speech output continues until the specified point has been reached.

If you call the StopSpeechAt function before the Speech Synthesis Manager finishes processing input text, then the function might return before some input text has yet to be spoken. Thus, before disposing of the text buffer, your application should wait until its text-done callback function has been called (if one has been defined), or until it can determine (by, for example obtaining a speech status information structure) that the Speech Synthesis Manager is no longer processing input text.

If the end of the input text buffer is reached before the specified stopping point, the speech synthesizer stops at the end of the buffer without generating an error. 
Special Considerations

Because the StopSpeechAt function might move or purge memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr StopSpeechAt (
   SpeechChannel chan,
   long whereToStop
){};


/*ContinueSpeech

Resumes speech paused by the PauseSpeechAt function.

OSErr ContinueSpeech (
   SpeechChannel chan
);
Parameters
chan

The paused speech channel on which speech is to be resumed.
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

At any time after the PauseSpeechAt function is called, the ContinueSpeech function can be called to continue speaking from the beginning of the word in which speech paused. Calling ContinueSpeech on a channel that is not currently in a paused state has no effect on the speech channel or on future calls to the PauseSpeechAt function. If you call ContinueSpeech on a channel before a pause is effective, ContinueSpeech cancels the pause.

If the PauseSpeechAt function stopped speech in the middle of a word, the Speech Synthesis Manager will start speaking that word from the beginning when you call ContinueSpeech. 
Special Considerations

Because the ContinueSpeech function moves memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr ContinueSpeech (
   SpeechChannel chan
){};




/*StopSpeech

Terminates speech immediately on a specified channel.

OSErr StopSpeech (
   SpeechChannel chan
);
Parameters
chan

The speech channel on which speech is to be stopped.
Return Value

A result code. See “Speech Synthesis Manager Result Codes”.
Discussion

The StopSpeech function immediately terminates speech on the channel specified by the chan parameter. After returning from StopSpeech, your application can safely release any text buffer that the speech synthesizer has been using. You can call StopSpeech for an already idle channel without ill effect.

You can also stop speech by passing a zero-length string (or, in C, a null pointer) to one of the SpeakString, SpeakText, or SpeakBuffer functions. Doing this stops speech only in the specified speech channel (or, in the case of SpeakString, in the speech channel managed internally by the Speech Synthesis Manager).

Before calling the StopSpeech function, you can use the SpeechBusy function, which is described in SpeechBusy, to determine if a synthesizer is still speaking. If you are working with multiple speech channels, you can use the status selector with the function GetSpeechInfo which is described in GetSpeechInfo, to determine if a specific channel is still speaking. 
Special Considerations

Because the StopSpeech function might move or purge memory, you should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when Text to Speech 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechSynthesis.h*/
OSErr StopSpeech (
   SpeechChannel chan
){};













