#import <HYS/AppKit/NSWindow.h>

@interface NSWindow (hys)

/*frameRectForContentRect:

Returns the receiver’s frame rectangle with a given content rectangle.

- (NSRect)frameRectForContentRect:(NSRect)windowContent
Parameters
windowContent

Content rectangle for the window expressed in screen coordinates.
Return Value

The receiver’s frame rectangle, expressed in screen coordinates, with windowContent.
Discussion

The receiver uses its current style mask in computing the frame rectangle. See “Constants” for a list of style mask values. The major advantage of this instance-method counterpart to frameRectForContentRect:styleMask: is that it allows you to take toolbars into account when converting between content and frame rectangles. (The toolbar is included in the frame rectangle but not the content rectangle.)
Availability
Available in Mac OS X v10.3 and later.
See Also
– contentRectForFrameRect:
+ frameRectForContentRect:styleMask:*/
- (NSRect)frameRectForContentRect:(NSRect)windowContent;

/*setDisplaysWhenScreenProfileChanges:

Sets whether the window context should be updated when the screen profile changes.

- (void)setDisplaysWhenScreenProfileChanges:(BOOL)flag
Discussion

If flag is NO, the screen profile information for the window context never changes. This is the default setting. If flag is YES, the window context may be changed in the following situations:
A majority of the window is moved to a different screen whose profile is different than the previous screen.
The ColorSync profile of the current screen changes.

After the window context is updated, the window is told to display itself. If you need to update offscreen caches for the window, you should register to receive the NSWindowDidChangeScreenProfileNotification.
Availability
Available in Mac OS X v10.4 and later.
See Also
– displaysWhenScreenProfileChanges*/
- (void)setDisplaysWhenScreenProfileChanges:(BOOL)flag;

@end