#ifndef COMPONENTS_H
#define COMPONENTS_H

#ifndef HYS_H
#include <HYS/hys.h>
#endif


#ifndef MACERRORS_H
#include <CarbonCore/MacErrors.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif

#include <HYS/CarbonCore/Components.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

#include <AvailabilityMacros.h>

/*Data Structures
struct ComponentDescription {
   OSType         componentType;          /type/
   OSType         componentSubType;       /subtype/
   OSType         componentManufacturer;  /manufacturer/
   unsigned long  componentFlags;         /control flags/
   unsigned long  componentFlagsMask;     /mask for control flags /
                                          / (reserved when registering /
                                          / a component)/
};
typedef struct ComponentDescription ComponentDescription;
struct ResourceSpec {
   OSType         ResType;                /resource type/
   short          ResID;                  /resource ID/
};
typedef struct ResourceSpec ResourceSpec;
struct ComponentResource {
   ComponentDescription cd;               /registration information/
   ResourceSpec         component;        /code resource/
   ResourceSpec         componentName;    /name string resource/
   ResourceSpec         componentInfo;    /info string resource/
   ResourceSpec         componentIcon;    /icon resource/
};
typedef struct ComponentResource ComponentResource;
typedef ComponentResource ComponentResourcePtr, ComponentResourceHandle;
/optional extension to component resource/
struct ComponentResourceExtension {
   long           componentVersion;       /version number/
   long           componentRegisterFlags; /additional flags/
   short          componentIconFamily;    /resource ID of icon family/
};
typedef struct ComponentResourceExtension ComponentResourceExtension;
/structure received by component/
struct ComponentParameters {
   unsigned char flags;       /reserved/
   unsigned char paramSize;   /size in bytes of actual parameters passed /
                              / to this routine/
   short        what;         /request code, negative for requests /
                              / defined by Component Mgr/
   long         params[1];    /actual parameters for the indicated /
                              / routine/
};
typedef struct ComponentParameters ComponentParameters;
/component identifier/
typedef struct privateComponentRecord Component;
/component instance/
typedef struct privateComponentInstanceRecord *ComponentInstance;

typedef long ComponentResult;

typedef pascal ComponentResult (*ComponentRoutine)
      (ComponentParameters *cp, Handle componentStorage);
typedef pascal ComponentResult (*ComponentFunction)();
#define ComponentCallNow(callNumber, paramSize) \
         {0x2F3C, paramSize, callNumber, 0x7000, 0xA82A}*/

#define ComponentCallNow(callNumber, paramSize) \
         {0x2F3C, paramSize, callNumber, 0x7000, 0xA82A}


/*Bevel Button Behavior Constants

enum {
   kControlBehaviorPushbutton = 0,
   kControlBehaviorToggles = 0x0100,
   kControlBehaviorSticky = 0x0200,
   kControlBehaviorSingleValueMenu = 0,
   kControlBehaviorMultiValueMenu = 0x4000,
   kControlBehaviorOffsetContents = 0x8000
};
Constants
kControlBehaviorPushbutton

Push button (momentary) behavior. The bevel button pops up after being clicked.

Available in Mac OS X v10.0 and later.
kControlBehaviorToggles

Toggle behavior. The bevel button toggles state automatically when clicked.

Available in Mac OS X v10.0 and later.
kControlBehaviorSticky

Sticky behavior. Once clicked, the bevel button stays down until your application sets the control’s value to 0. This behavior is useful in tool palettes and radio groups. 

Available in Mac OS X v10.0 and later.
kControlBehaviorMultiValueMenu

If this bit is set, the menus are multi-valued. The bevel button does not maintain the menu value as it normally would (requiring that only one item is selected at a time). This allows the user to toggle entries in a menu and have multiple items checked. In this mode, the menu value accessed with the kControlMenuLastValueTag will return the value of the last menu item selected.

Available in Mac OS X v10.0 and later.
kControlBehaviorOffsetContents

Bevel button contents are offset (one pixel down and to the right) when button is pressed.

Available in Mac OS X v10.0 and later.
Discussion

You can pass the bevel button behavior constants in the high byte of the minimumValue parameter of NewControl to create a bevel button with a specific behavior. 

You can pass the bevel button menu constant, kControlBehaviorMultiValueMenu, in the high byte of the minimumValue parameter of NewControl to create a bevel button with a menu of a certain behavior. Bevel buttons with menus have two values: the value of the button and the value of the menu. You can specify the direction of the pop-up menu arrow (down or right) by using the kControlBevelButtonMenuOnRight bevel button variant. 

The bevel button behavior constants and the bevel button menu constant are available with Appearance Manager 1.0 and later.*/
enum {
   kControlBehaviorPushbutton = 0,
   kControlBehaviorToggles = 0x0100,
   kControlBehaviorSticky = 0x0200,
   kControlBehaviorSingleValueMenu = 0,
   kControlBehaviorMultiValueMenu = 0x4000,
   kControlBehaviorOffsetContents = 0x8000
};

/*Request Codes


enum {
   kComponentOpenSelect = -1,
   kComponentCloseSelect = -2,
   kComponentCanDoSelect = -3,
   kComponentVersionSelect = -4,
   kComponentRegisterSelect = -5,
   kComponentTargetSelect = -6,
   kComponentUnregisterSelect = -7,
   kComponentGetMPWorkFunctionSelect = -8,
   kComponentExecuteWiredActionSelect = -9,
   kComponentGetPublicResourceSelect = -10
};
Constants
kComponentOpenSelect

A request to open a connection. Your component must respond to this request code.

Available in Mac OS X v10.0 and later.
kComponentCloseSelect

A request to close a connection. Your component must respond to this request code.

Available in Mac OS X v10.0 and later.
kComponentCanDoSelect

A request to determine whether your component supports a particular request. Your component must respond to this request code

Available in Mac OS X v10.0 and later.
kComponentVersionSelect

A request to return your component’s version number. Your component must respond to this request code.

Available in Mac OS X v10.0 and later.
kComponentRegisterSelect

A request to determine whether your component can operate in the current environment. Your component may or may not respond to this request code.

Available in Mac OS X v10.0 and later.
kComponentTargetSelect

A request to call another component whenever your component would call itself. Your component may or may not respond to this request code.

Available in Mac OS X v10.0 and later.
kComponentUnregisterSelect

A request to perform any operations necessary as a result of your component being unregistered. Your component may or may not respond to this request code

Available in Mac OS X v10.0 and later.
kComponentGetMPWorkFunctionSelect

Available in Mac OS X v10.0 and later.
kComponentExecuteWiredActionSelect

Available in Mac OS X v10.0 and later.
kComponentGetPublicResourceSelect

Available in Mac OS X v10.0 and later.
Discussion

These values are used in the ComponentParameters structure to specify the type of a request to a component. Apple has defined these request codes: 
Special Considerations*/

enum {
   kComponentOpenSelect = -1,
   kComponentCloseSelect = -2,
   kComponentCanDoSelect = -3,
   kComponentVersionSelect = -4,
   kComponentRegisterSelect = -5,
   kComponentTargetSelect = -6,
   kComponentUnregisterSelect = -7,
   kComponentGetMPWorkFunctionSelect = -8,
   kComponentExecuteWiredActionSelect = -9,
   kComponentGetPublicResourceSelect = -10
};


/*kAnyComponentType


enum {
   kAnyComponentType = 0,
   kAnyComponentSubType = 0,
   kAnyComponentManufacturer = 0,
   kAnyComponentFlagsMask = 0
};
Constants
kAnyComponentType

Available in Mac OS X v10.0 and later.
kAnyComponentSubType

Available in Mac OS X v10.0 and later.
kAnyComponentManufacturer

Available in Mac OS X v10.0 and later.
kAnyComponentFlagsMask

Available in Mac OS X v10.0 and later.
Special Considerations*/
enum {
   kAnyComponentType = 0,
   kAnyComponentSubType = 0,
   kAnyComponentManufacturer = 0,
   kAnyComponentFlagsMask = 0
};



/*ComponentParameters


struct ComponentParameters {
   UInt8 flags;
   UInt8 paramSize;
   short what;
   long params[1];
};
typedef struct ComponentParameters ComponentParameters;
Fields
flags

Reserved for use by Apple. 
paramSize

Specifies the number of bytes of parameter data for this request. The actual parameters are stored in the params field.
what

Specifies the type of request. Component designers define the meaning of positive values and assign them to requests that are supported by components of a given type. Negative values are reserved for definition by Apple. See “Result Codes” for Apple-defined request code values.
params

An array that contains the parameters specified by the application that called your component. You can use the CallComponentRoutine or CallComponentRoutineWithStorage function to convert this array into a Pascal-style invocation of a subroutine in your component.
Discussion

The Component Manager uses the component parameters structure to pass information to your component about a request from an application. Functions which use this data type are CallComponentFunction , CallComponentFunctionWithStorage , and DelegateComponentCall.The information in this structure completely defines the request. Your component services the request as appropriate.

The ComponentParameters data type defines the component parameters structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ComponentParameters {
   UInt8 flags;
   UInt8 paramSize;
   short what;
   long params[1];
};
typedef struct ComponentParameters ComponentParameters;

/*kAppleManufacturer


enum {
   kAppleManufacturer = 'appl',
   kComponentResourceType = 'thng',
   kComponentAliasResourceType = 'thga'
};
Constants
kAppleManufacturer

Available in Mac OS X v10.0 and later.
kComponentResourceType

Available in Mac OS X v10.0 and later.
kComponentAliasResourceType

Available in Mac OS X v10.0 and later.
Special Considerations*/
enum {
   kAppleManufacturer = 'appl',
   kComponentResourceType = 'thng',
   kComponentAliasResourceType = 'thga'
};

/*cmpIsMissing


enum {
   cmpIsMissing = 1L << 29,
   cmpWantsRegisterMessage = 1L << 31
};
Constants
cmpIsMissing

Available in Mac OS X v10.0 and later.
cmpWantsRegisterMessage

The setting of the cmpWantsRegisterMessage bit determines whether the Component Manager calls this component during registration. Set this bit to 1 if your component should be called when it is registered; otherwise, set this bit to 0.

Available in Mac OS X v10.0 and later.
Discussion

These values are used by the componentFlags field of the ComponentDescription structure to provide additional information about a component. 
Special Considerations*/
enum {
   cmpIsMissing = 1L << 29,
   cmpWantsRegisterMessage = 1L << 31
};

/*ComponentRecord


struct ComponentRecord {
   long data[1];
};
typedef struct ComponentRecord ComponentRecord;
typedef ComponentRecord * Component;
Fields
data
Availability
Available in Mac OS X v10.0 and later.*/
struct ComponentRecord {
   long data[1];
};
typedef struct ComponentRecord ComponentRecord;
typedef ComponentRecord * Component;

/*ComponentDescription


struct ComponentDescription {
   OSType componentType;
   OSType componentSubType;
   OSType componentManufacturer;
   unsigned long componentFlags;
   unsigned long componentFlagsMask;
};
typedef struct ComponentDescription ComponentDescription;
Fields
componentType

A four-character code that identifies the type of component. All components of a particular type must support a common set of interface functions. For example, drawing components all have a component type of 'draw'.

If you are developing an application which uses components, you can use this field to search for components of a given type by specifying the component type in this field of the component description structure you supply to the FindNextComponent function or the CountComponents function. A value of 0 operates as a wildcard.

If you are developing a component, it must support all of the standard functions for the component type specified by this field. Type codes with all lowercase characters are reserved for definition by Apple. You can define your own component type code as long as you register it with Apple’s Component Registry Group.

componentSubType

A four-character code that identifies the subtype of the component. Different subtypes of a component type may support additional features or provide interfaces that extend beyond the standard functions for a given component type. For example, the subtype of drawing components indicates the type of object the component draws. Drawing components that draw ovals have a subtype of 'oval'.

If you are developing an application which uses components, you can use the componentSubType field to perform a more specific lookup operation than is possible using only the componentType field. By specifying particular values for both fields in the component description structure that you supply to the FindNextComponent or CountComponents function, your application retrieves information about only those components that meet both of these search criteria. A value of 0 operates as a wildcard.

If you are developing a component, you may use this field to indicate more specific information about the capabilities of the component. There are no restrictions on the content you assign to this field. If no additional information is appropriate for your component type, you may set the componentSubType field to 0.
componentManufacturer

A four-character code that identifies the manufacturer of the component. This field allows for further differentiation between individual components. For example, components made by a specific manufacturer may support an extended feature set. Components provided by Apple use a manufacturer value of 'appl'.

If you are developing an application which uses components, you can use this field to find components from a certain manufacturer. Specify the appropriate manufacturer code in this field of the component description structure you supply to the FindNextComponent or CountComponents function. A value of 0 operates as a wildcard.

If you are developing a component, you obtain your manufacturer code, which can be the same as your application signature, from Apple’s Component Registry Group.
componentFlags

A 32-bit field that provides additional information about a particular component.

The high-order 8 bits are reserved for definition by the Component Manager. If you are developing an application, you should usually set these bits to 0.

The low-order 24 bits are specific to each component type. These flags can be used to indicate the presence of features or capabilities in a given component.

If you are developing an application which uses components, you can use these flags to further narrow the search criteria applied by the FindNextComponent or CountComponents function. If you use the componentFlags field in a component search, you use the componentFlagsMask field to indicate which flags are to be considered in the search.

If you are developing a component, you can use these flags to indicate any special capabilities or features of your component. You may use all 24 bits, as appropriate to its component type. You must set all unused bits to 0.
componentFlagsMask

A 32-bit field that indicates which flags in the componentFlags field are relevant to a particular component search operation. 

If you are developing an application which uses components, your application should set each bit which corresponds to a flag in the componentFlags field that is to be considered as a search criterion by the FindNextComponent or CountComponents function to 1. The Component Manager considers only these flags during the search. You specify the desired flag value (either 0 or 1) in the componentFlags field. 

For example, to look for a component with a specific control flag that is set to 0, set the appropriate bit in the ComponentFlags field to 0 and the same bit in the ComponentFlagsMask field to 1. To look for a component with a specific control flag that is set to 1, set the bit in the ComponentFlags field to 1 and the same bit in the ComponentFlagsMask field to 1. To ignore a flag, set the bit in the ComponentFlagsMask field to 0.

If you are developing a component, your component must set the componentFlagsMask field in its component description structure to 0.
Discussion

The ComponentDescription structure identifies the characteristics of a component, including the type of services offered by the component and its manufacturer.

Applications and components use component description structures in different ways. An application that uses components specifies the selection criteria for a component in a component description structure. The functions FindNextComponent , CountComponents , and GetComponentInfo all use the component description structure to specify the criteria for their search.

A component uses the component description structure to specify its registration information and capabilities and identify itself to the Component Manager. If your component is stored in a component resource, the information in the component description structure must be part of that resource. See the description of the component ‘thng’ resource. If you have developed an application that registers your component, that application must supply a component description structure to the RegisterComponent function. See “Registering Components” for information about registering components.

The ComponentDescription data type defines the component description structure. Note that the valid values of fields in the component description structure are determined by the component type specification. For example, all image compressor components must use the componentSubType field to specify the compression algorithm used by the compressor. 
Special Considerations
Availability
Available in Mac OS X v10.0 and later.*/
struct ComponentDescription {
   OSType componentType;
   OSType componentSubType;
   OSType componentManufacturer;
   unsigned long componentFlags;
   unsigned long componentFlagsMask;
};
typedef struct ComponentDescription ComponentDescription;

/*ComponentInstanceRecord


struct ComponentInstanceRecord {
   long data[1];
};
typedef struct ComponentInstanceRecord ComponentInstanceRecord;
typedef ComponentInstanceRecord * ComponentInstance;
Fields
data
Special Considerations
Availability
Available in Mac OS X v10.0 and later.
Components.h*/


struct ComponentInstanceRecord {
   long data[1];
};
typedef struct ComponentInstanceRecord ComponentInstanceRecord;
typedef ComponentInstanceRecord * ComponentInstance;



/*ComponentResult

Abst_ComponentResult

typedef long ComponentResult;
Availability
Available in Mac OS X v10.0 and later
Components.h.*/

typedef long ComponentResult;

/*ComponentRoutineProcPtr

Defines a pointer to your component callback function, which serves as the main entry point into your component and performs the component’s services. 

typedef ComponentResult (*ComponentRoutineProcPtr)
(
   ComponentParameters * cp,
   Handle componentStorage
);

If you name your function MyComponentRoutineProc, you would declare it like this:

ComponentResult ComponentRoutineProcPtr
(
   ComponentParameters * cp,
   Handle componentStorage
);
Parameters
cp

A ComponentParameters structure. The what field of the component parameters structure indicates the action your component should perform. The parameters that the client invoked your function with are contained in the params field of the component parameters structure. Your component can use the CallComponentFunction or CallComponentFunctionWithStorage function to extract the parameters from this structure. 
componentStorage

A handle to any memory that your component has associated with the connection. Typically, upon receiving an open request, your component allocates memory and uses the SetComponentInstanceStorage function to associate the allocated memory with the component connection. 
Return Value

Your component should return a value of type ComponentResult. If your component does not return error information as its function result, it should indicate errors using the SetComponentInstanceError function. See the description of the ComponentResult data type.
Discussion

You pass a pointer to your component callback function to the Component Manager when you register your component. The Component Manager can then call your component when another application or component requests its services. When your component receives a request, it should perform the action specified in the what field of the component parameters structure.

The pointer which you pass to the Component Manager should be a universal procedure pointer (UPP). The definition of the UPP data type for your component function is as follows:typedef (ComponentRoutineProcPtr) ComponentRoutineUPP;


Before using your component function, you must first create a UPP for your callback function, using the NewComponentRoutineUPP function, as shown here:ComponentRoutineUPP MyComponentRoutineUPP;
MyComponentRoutineUPP =             NewComponentRoutineUPP(&MyComponentRoutineProc)


You then pass MyComponentRoutineUPP to the Component Manager when you register your component. The Component Manager will call your function each time your component receives a request. If you wish to call your component function yourself, you can use the InvokeComponentRoutineUPP function.result = InvokeComponentRoutineUPP &myParams, myStorage,              MyComponentRoutineUPP)


When you are finished with your component callback function, you should dispose of the universal procedure pointer associated with it, using the DisposeComponentRoutineUPP function.DisposeComponentRoutineUPP(MyComponentRoutineUPP);


To provide a component, you define a component function and supply the appropriate registration information. You store your component function in a code resource and typically store your component’s registration information as resources in a component file. 
Special Considerations*/
typedef ComponentResult (*ComponentRoutineProcPtr)
(
   ComponentParameters * cp,
   Handle componentStorage
);


/*ComponentRoutineUPP


typedef ComponentRoutineProcPtr ComponentRoutineUPP;
Discussion

For more information, see the description of the ComponentRoutineUPP () callback function.*/
typedef ComponentRoutineProcPtr ComponentRoutineUPP;

/*ComponentFunctionUPP


typedef UniversalProcPtr ComponentFunctionUPP;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UniversalProcPtr ComponentFunctionUPP;

/*ComponentMPWorkFunctionHeaderRecord


struct ComponentMPWorkFunctionHeaderRecord {
   UInt32 headerSize;
   UInt32 recordSize;
   UInt32 workFlags;
   UInt16 processorCount;
   UInt8 unused;
   UInt8 isRunning;
};
typedef struct ComponentMPWorkFunctionHeaderRecord ComponentMPWorkFunctionHeaderRecord;
typedef ComponentMPWorkFunctionHeaderRecord * ComponentMPWorkFunctionHeaderRecordPtr;
Fields
headerSize
recordSize
workFlags
processorCount
unused
isRunning
Special Considerations
Availability
Available in Mac OS X v10.0 and later.*/

struct ComponentMPWorkFunctionHeaderRecord {
   UInt32 headerSize;
   UInt32 recordSize;
   UInt32 workFlags;
   UInt16 processorCount;
   UInt8 unused;
   UInt8 isRunning;
};
typedef struct ComponentMPWorkFunctionHeaderRecord ComponentMPWorkFunctionHeaderRecord;
typedef ComponentMPWorkFunctionHeaderRecord * ComponentMPWorkFunctionHeaderRecordPtr;



/*ComponentMPWorkFunctionProcPtr


typedef ComponentResult (*ComponentMPWorkFunctionProcPtr)
(
   void * globalRefCon,
   ComponentMPWorkFunctionHeaderRecordPtr header
);

If you name your function MyComponentMPWorkFunctionProc, you would declare it like this:

ComponentResult MyComponentMPWorkFunctionProc
(
   void * globalRefCon,
   ComponentMPWorkFunctionHeaderRecordPtr header
);
Parameters
header
Return Value

See the description of the ComponentResult data type.
Special Considerations*/

typedef ComponentResult (*ComponentMPWorkFunctionProcPtr)
(
   void * globalRefCon,
   ComponentMPWorkFunctionHeaderRecordPtr header
);


/*ComponentMPWorkFunctionUPP


typedef ComponentMPWorkFunctionProcPtr ComponentMPWorkFunctionUPP;
Discussion

For more information, see the description of the ComponentMPWorkFunctionUPP () callback function.*/
typedef ComponentMPWorkFunctionProcPtr ComponentMPWorkFunctionUPP;

/*Set Default Component Flags


enum {
   defaultComponentIdentical = 0,
   defaultComponentAnyFlags = 1,
   defaultComponentAnyManufacturer = 2,
   defaultComponentAnySubType = 4,
   defaultComponentAnyFlagsAnyManufacturer = (defaultComponentAnyFlags
+ defaultComponentAnyManufacturer),
   defaultComponentAnyFlagsAnyManufacturerAnySubType = (defaultComponentAnyFlags
+ defaultComponentAnyManufacturer + defaultComponentAnySubType)
};
Constants
defaultComponentIdentical

The Component Manager places the component specified in the call to SetDefaultComponent in front of all other components that have the same component description.

Available in Mac OS X v10.0 and later.
defaultComponentAnyFlags

The Component Manager ignores the value of the componentFlags field during the reorder operation.

Available in Mac OS X v10.0 and later.
defaultComponentAnyManufacturer

The Component Manager ignores the value of the componentManufacturer field during the reorder operation.

Available in Mac OS X v10.0 and later.
defaultComponentAnySubType

The Component Manager ignores the value of the componentSubType field during the reorder operation.

Available in Mac OS X v10.0 and later.
defaultComponentAnyFlagsAnyManufacturer

Available in Mac OS X v10.0 and later.
defaultComponentAnyFlagsAnyManufacturerAnySubType

Available in Mac OS X v10.0 and later.
Discussion

The SetDefaultComponent function uses these values in the flags parameter to control which component description fields the Component Manager examines during the reorder operation. 
Special Considerations*/
enum {
   defaultComponentIdentical = 0,
   defaultComponentAnyFlags = 1,
   defaultComponentAnyManufacturer = 2,
   defaultComponentAnySubType = 4,
   defaultComponentAnyFlagsAnyManufacturer = (defaultComponentAnyFlags\
+ defaultComponentAnyManufacturer),
   defaultComponentAnyFlagsAnyManufacturerAnySubType = (defaultComponentAnyFlags\
+ defaultComponentAnyManufacturer + defaultComponentAnySubType)
};


//function


/*CloseComponent

Terminates your applications connection to a component. 

OSErr CloseComponent (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection you wish to close. Your application obtains the component instance from the OpenComponent function or the OpenDefaultComponent function. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

A result code. See Component Manager Result Codes.
Discussion

This function closes only a single connection. If your application has several connections to a single component, you must call it once for each connection. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/


OSErr CloseComponent (
   ComponentInstance aComponentInstance
);

/*OpenDefaultComponent

Opens a connection to a registered component of the component type and subtype specified by your application. 

ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType
);
Parameters
componentType

The type of the component. All components of a particular type support a common set of interface functions. Use this parameter to search for components of a given type. 
componentSubType

The subtype of the component. Different subtypes of a component type may support additional features or provide interfaces that extend beyond the standard functions for a given component type. For example, the subtype of an image compressor component indicates the compression algorithm employed by the compressor.

Your application can use the componentSubType parameter to perform a more specific lookup operation than is possible using only the componentType parameter. For example, you may want your application to use only components of a certain component type ('draw') that also have a specific subtype ('oval'). Set this parameter to 0 to select a component with any subtype value.
Return Value

A component instance that identifies the connection opened to the component which matches your search criteria. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If more than one component in the list of registered components meets the search criteria, the function opens the first one that it finds in its list. If it cannot open the specified component, it returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. This function searches for a component by type and subtype. You do not have to supply a component description structure or call the FindNextComponent function to use this function. If you want to exert more control over the selection process, you can use the FindNextComponent and OpenComponent functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType
);

/*OpenADefaultComponent


OSErr OpenADefaultComponent (
   OSType componentType,
   OSType componentSubType,
   ComponentInstance * ci
);
Parameters
componentType
componentSubType
ci
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr OpenADefaultComponent (
   OSType componentType,
   OSType componentSubType,
   ComponentInstance * ci
);

/*OpenComponent

Opens a connection to the component with the component identifier specified by your application.

ComponentInstance OpenComponent (
   Component aComponent
);
Parameters
aComponent

The component you wish to open. Your application obtains this identifier from the FindNextComponent function. If your application registers a component, it can also obtain a component identifier from the RegisterComponent function or the RegisterComponentResource function. 
Return Value

A component instance which identifies your application’s connection to the component. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If it cannot open the specified component, the function returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. To use this function, you must already have obtained a component identifier. Alternatively, you can use the OpenDefaultComponent function to open a component without calling FindNextComponent. 

Note that your application may maintain several connections to a single component, or it may have connections to several components at the same time. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

ComponentInstance OpenComponent (
   Component aComponent
);

/*FindNextComponent

Returns the component identifier for the next registered component that meets the selection criteria specified by your application. 

Component FindNextComponent (
   Component aComponent,
   ComponentDescription * looking
);
Parameters
aComponent

The starting point for the search. Set this field to 0 to start the search at the beginning of the component list. If you are continuing a search, you can specify a component identifier previously returned by this function. The function then searches the remaining components. 
looking

A pointer to a ComponentDescription structure. Your application specifies the criteria for the component search in the fields of this structure.

The Component Manager ignores fields in the component description structure that are set to 0. For example, if you set all the fields to 0, all components meet the search criteria. In this case, your application can retrieve information about all of the components that are registered in the system by repeatedly calling FindNextComponent and GetComponentInfo until the search is complete. Similarly, if you set all fields to 0 except for the componentManufacturer field, the Component Manager searches all registered components for a component supplied by the manufacturer you specify. Note that this function does not modify the contents of the component description structure you supply. To retrieve detailed information about a component, you need to use the GetComponentInfo function to get the component description structure for each returned component.

Return Value

The component identifier of a component that meets the search criteria or 0 when there are no more matching components. Your application can use the component identifier returned by this function to get more information about the component, using GetComponentInfo, or to open the component, using either the OpenDefaultComponent function or the OpenComponent function. See the description of the Component data type.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
Component FindNextComponent (
   Component aComponent,
   ComponentDescription * looking
);

/*GetComponentInfo

Returns to your application the registration information for a component. 

OSErr GetComponentInfo (
   Component aComponent,
   ComponentDescription * cd,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
);
Parameters
aComponent

The component about which you wish to obtain information. Your application obtains a component identifier from the FindNextComponent function. If your application registers a component, it can also obtain a component identifier from the RegisterComponent or RegisterComponentResource function.

You may supply a component instance rather than a component identifier to this function, but you must coerce the data type appropriately. Your application can obtain a component instance from the OpenComponent or OpenDefaultComponent functions.

cd

A pointer to a ComponentDescription structure. The function returns information about the specified component in this structure. 
componentName

On return, a handle to the component’s name. If the component does not have a name, an empty handle. Set this field to NULL if you do not want to receive the component’s name. 
componentInfo

On return, a handle to the component’s information string. If the component does not have an information string, an empty handle. Set this field to NULL if you do not want to receive the component’s information string.
componentIcon

On return, a handle to the component’s icon. If the component does not have an icon, an empty handle. Set this field to NULL if you do not want to receive the component’s icon. To get a handle to the component’s icon suite, if it provides one, use the GetComponentIconSuite function.
Return Value

A result code. See “Component Manager Result Codes”.
Discussion

For information on registering components, see “Registering Components”. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr GetComponentInfo (
   Component aComponent,
   ComponentDescription * cd,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
);

/*OpenAComponent


OSErr OpenAComponent (
   Component aComponent,
   ComponentInstance * ci
);
Parameters
aComponent
ci
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr OpenAComponent (
   Component aComponent,
   ComponentInstance * ci
);

/*SetComponentInstanceStorage

Allows your component to associate memory with a connection. 

void SetComponentInstanceStorage (
   ComponentInstance aComponentInstance,
   Handle theStorage
);
Parameters
aComponentInstance

The connection to associate with the allocated memory. The Component Manager provides a component instance to your component when the connection is opened. You can use a component identifier here, but you must coerce the data type appropriately. 
theStorage

A handle to the memory that your component has allocated for the connection. Your component must allocate this memory in the current heap. The Component Manager saves this handle and provides it to your component, along with other parameters, in subsequent requests to this connection. 
Discussion

When an application or component opens a connection to your component, the Component Manager sends your component an open request. In response to this open request, your component should set up an environment to service the connection. Typically, your component should allocate some memory for the connection. Your component can then use that memory to maintain state information appropriate to the connection.

Your component should dispose of any allocated memory for the connection only in response to the close request. Note that whenever an open request fails, the Component Manager always issues the close request. Furthermore, the value stored with this function is always passed to the close request, so it must be valid or NULL. If the open request tries to dispose of its allocated memory before returning, it should call this function again with a NULL handle to keep the Component Manager from passing an invalid handle to the close request. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
void SetComponentInstanceStorage (
   ComponentInstance aComponentInstance,
   Handle theStorage
);

/*ComponentSetTarget

Calls a component’s target request function and informs a component that it has been targeted by another component. 

long ComponentSetTarget (
   ComponentInstance ci,
   ComponentInstance target
);
Parameters
ci

The component instance to which to send a target request (the component that has been targeted). You can use a component identifier here, but you must coerce the data type appropriately. 
target

The component instance issuing the target request.
Return Value

The value that the targeted component instance returns in response to the target request, or badComponentSelector if the targeted component does not support the target request. 
Discussion

Your component can target a component instance without capturing the component or your component can first capture the component and then target a specific instance of the component. 

You should not target a component instance if the component does not support the target request. Before calling this function, you should issue a can do request to the component instance you want to target to verify that the component supports the target request. After receiving a target request, the targeted component instance should call the component instance that targeted it whenever the targeted component instance would normally call one of its defined functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
long ComponentSetTarget (
   ComponentInstance ci,
   ComponentInstance target
);

/*RegisterComponent

Registers a component stored in memory.

Component RegisterComponent (
   ComponentDescription * cd,
   ComponentRoutineUPP componentEntryPoint,
   short global,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
);
Parameters
cd

A pointer to a ComponentDescription structure that describes the component to be registered. You must correctly fill in the fields of this structure before calling this function. When applications search for components using the FindNextComponent function, the Component Manager compares the attributes you specify here with those specified by the application. If the attributes match, the Component Manager returns the component identifier to the application. 
componentEntryPoint

A universal procedure pointer (UPP) to your component’s main entry point. The function referred to by this parameter receives all requests for the component. See the ComponentRoutineProcPtr callback for more information on creating a component function. 
global

A set of flags that control the scope of component registration. See “Register Component Resource flags” for a description of the flags. 
componentName

A handle to the component’s name. Set this parameter to NULL if you do not want to assign a name to the component. 
componentInfo

A handle to the component’s information string. Set this parameter to NULL if you do not want to assign an information string to the component.
componentIcon

A handle to the component’s icon (a 32-by-32 pixel black-and-white icon). Set this parameter to NULL if you do not want to supply an icon for this component. Note that this icon is not used by the Finder you supply an icon only so that other components or applications can display your component’s icon if needed.
Return Value

The unique component identifier assigned to the component by the Component Manager or, if it cannot register the component, NULL. See the description of the Component data type.
Discussion

Before a component can be used by an application, the component must be registered with the Component Manager. Applications can then find and open the component using the standard Component Manager functions. 

Components you register with the RegisterComponent function must be in memory when you call this function. If you want to register a component that is stored in the resource fork of a file, use the RegisterComponentResource function. Use the RegisterComponentResourceFile function to register all components in the resource fork of a file. The Component Manager automatically registers component resources stored in files with file types of 'thng' that are stored in the Extensions folder. See “Resources” for more information on component resource files.

Note that a component residing in your application heap remains registered until your application unregisters it or quits. When an application quits, the Component Manager automatically closes any component connections to that application. In addition, if the application has registered components that reside in its heap space, the Component Manager automatically unregisters those components. A component residing in the system heap and registered by your application remains registered until your application unregisters it or until the computer is shut down. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
Component RegisterComponent (
   ComponentDescription * cd,
   ComponentRoutineUPP componentEntryPoint,
   short global,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
);

/*NewComponentRoutineUPP

Creates a new universal procedure pointer (UPP) to a component routine callback function.

ComponentRoutineUPP NewComponentRoutineUPP (
   ComponentRoutineProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ComponentRoutineUPP data type.
Discussion

See the ComponentRoutineProcPtr callback for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

ComponentRoutineUPP NewComponentRoutineUPP (
   ComponentRoutineProcPtr userRoutine
);

/*GetComponentResource


OSErr GetComponentResource (
   Component aComponent,
   OSType resType,
   short resID,
   Handle * theResource
);
Parameters
aComponent
resType
theResource
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 3.0 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

OSErr GetComponentResource (
   Component aComponent,
   OSType resType,
   short resID,
   Handle * theResource
);

/*CountComponents

Returns the number of registered components that meet the selection criteria specified by your application. 

long CountComponents (
   ComponentDescription * looking
);
Parameters
looking

A pointer to a ComponentDescription structure. Your application specifies the criteria for the component search in the fields of this structure.

The Component Manager ignores fields in the component description structure that are set to 0. For example, if you set all the fields to 0, the Component Manager returns the number of components registered in the system. Similarly, if you set all fields to 0 except for the componentManufacturer field, the Component Manager returns the number of registered components supplied by the manufacturer you specify.

Return Value

The number of components that meet the specified search criteria. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
long CountComponents (
   ComponentDescription * looking
);


/*GetComponentVersion

Returns the version number of a component to your application. 

long GetComponentVersion (
   ComponentInstance ci
);
Parameters
ci

The component instance from which you want to retrieve version information. Your application obtains the component instance from the OpenDefaultComponent function or the OpenComponent function. 
Return Value

The version number of the component you specify. The high-order 16 bits represent the major version, and the low-order 16 bits represent the minor version. The major version specifies the component specification level the minor version specifies a particular implementation’s version number. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long GetComponentVersion (
   ComponentInstance ci
);

/*GetComponentRefcon

Retrieves the value of the reference constant for your component. 

long GetComponentRefcon (
   Component aComponent
);
Parameters
aComponent

The component whose reference constant you wish to get. You can use a component instance here, but you must coerce the data type appropriately. 
Return Value

The reference constant for the specified component. 
Discussion

There is one reference constant for each component, regardless of the number of connections to that component. When your component is registered, the Component Manager sets this reference constant to 0.

The reference constant is a 4-byte value that your component can use in any way you decide. For example, you might use the reference constant to store the address of a data structure that is shared by all connections maintained by your component. You should allocate shared structures in the system heap. Your component should deallocate the structure when its last connection is closed or when it is unregistered. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long GetComponentRefcon (
   Component aComponent
);

/*SetComponentRefcon

Sets the reference constant for your component.

void SetComponentRefcon (
   Component aComponent,
   long theRefcon
);
Parameters
aComponent

The component whose reference constant you wish to set. You can use a component instance here, but you must coerce the data type appropriately. 
theRefcon

The reference constant value that you want to set for your component. Your component can retrieve the reference constant using the GetComponentRefcon function. 
Discussion

There is one reference constant for each component, regardless of the number of connections to that component. When your component is registered, the Component Manager sets this reference constant to 0.

The reference constant is a 4-byte value that your component can use in any way you decide. For example, you might use the reference constant to store the address of a data structure that is shared by all connections maintained by your component. You should allocate shared structures in the system heap. Your component should deallocate the structure when its last connection is closed or when it is unregistered. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
void SetComponentRefcon (
   Component aComponent,
   long theRefcon
);

/*GetComponentInstanceA5

Retrieves the value of the A5 register for a specified connection.

Unsupported

SInt32 GetComponentInstanceA5 (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection for which to retrieve the A5 value. The Component Manager provides a component instance to your component when the connection is opened. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

The value of the A5 register for the connection. 
Discussion

Your component sets the A5 register by calling the SetComponentInstanceA5 function. 
Carbon Porting Notes

Because there is no A5 world in Carbon, you cannot use the functions GetComponentInstanceA5 and SetComponentInstanceA5 to access A5 information.
Declared In
Components.ComponentFunctionUPP


typedef UniversalProcPtr ComponentFunctionUPP;
Availability
Available in Mac OS X v10.0 and later.h*/
SInt32 GetComponentInstanceA5 (
   ComponentInstance aComponentInstance
);


/*OpenComponentResFile

Allows your component to gain access to its resource file. 

short OpenComponentResFile (
   Component aComponent
);
Parameters
aComponent

The component whose resource file you wish to open. Applications that register components may obtain this identifier from the RegisterComponentResource function. You can use a component instance here, but you must coerce the data type appropriately. 
Return Value

A reference number that your component can use to read data from the appropriate resource file. If the specified component does not have an associated resource file or if the Component Manager cannot open the resource file, the function returns 0 or a negative number. 
Discussion

This function opens the resource file with read-only permission. The Component Manager adds the resource file to the current resource chain. Your component must close the resource file with the CloseComponentResFile function before returning to the calling application. Note that there is only one resource file associated with a component.

Your component can use FSpOpenResFile or equivalent Resource Manager functions to open other resource files, but you must use this function to open your component’s resource file.

If you store your component in a component resource but register the component with the RegisterComponent function, rather than with the RegisterComponentResource or RegisterComponentResourceFile function, your component cannot access its resource file with this function.

Note that when working with resources, your component should always first save the current resource file, perform any resource operations, then restore the current resource file to its previous value before returning. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
short OpenComponentResFile (
   Component aComponent
);

/*CloseComponentResFile

Closes the resource file that your component opened previously with the OpenComponentResFile function. 

OSErr CloseComponentResFile (
   short refnum
);
Parameters
refnum

The reference number that identifies the resource file to be closed. Your component obtains this value from the OpenComponentResFile function. Your component must close any open resource files before returning to the calling application. 
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

OSErr CloseComponentResFile (
   short refnum
);

/*GetComponentInstanceStorage

Allows your component to retrieve a handle to the memory associated with a connection. 

Handle GetComponentInstanceStorage (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection for which to retrieve the associated memory. The Component Manager provides a component instance to your component when the connection is opened. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

A handle to the memory associated with the specified connection. 
Discussion

Typically, your component does not need to use this function, because the Component Manager provides this handle to your component each time the client application requests service from this connection.

Your component tells the Component Manager about the memory associated with a connection by calling the SetComponentInstanceStorage function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

Handle GetComponentInstanceStorage (
   ComponentInstance aComponentInstance
);

/*NewComponentFunctionUPP


ComponentFunctionUPP NewComponentFunctionUPP (
   ProcPtr userRoutine,
   ProcInfoType procInfo
);
Parameters
procInfo
Return Value

See the description of the ComponentFunctionUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

ComponentFunctionUPP NewComponentFunctionUPP (
   ProcPtr userRoutine,
   ProcInfoType procInfo
);

/*CallComponentFunction

Invokes the specified function of your component.

long CallComponentFunction (
   ComponentParameters * params,
   ComponentFunctionUPP func
);
Parameters
params

A pointer to the ComponentDescription structure that your component received from the Component Manager. These are the parameters originally provided by the application that called your component. 
func

A universal procedure pointer to the component function that is to handle the request. The Component Manager calls the function referred to by the func parameter, using Pascal calling conventions, with the parameters that were originally provided by the application that called your component. The function referred to by this parameter must return a function result of type ComponentResult indicating the success or failure of the operation. See the ComponentRoutineProcPtr callback for more information on component functions. 
Return Value

The value that is returned by the function referred to by the func parameter. Your component should use this value to set the current error for this connection. You can use the SetComponentInstanceError function to set the current error. 
Discussion

When an application requests service from your component, your component receives a component parameters structure containing the parameters that the application provided when it called your component. Your component can use this structure to access the parameters directly. Alternatively, you can use either this function or CallComponentFunctionWithStorage to extract those parameters and pass them to a subroutine of your component. By taking advantage of these functions, you can simplify the structure of your component code. 

If your component subroutine does not need global data, your component should use this function. If your component subroutine requires memory in which to store global data for the component, your component must use CallComponentFunctionWithStorage. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

long CallComponentFunction (
   ComponentParameters * params,
   ComponentFunctionUPP func
);

/*DisposeComponentFunctionUPP


void DisposeComponentFunctionUPP (
   ComponentFunctionUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

void DisposeComponentFunctionUPP (
   ComponentFunctionUPP userUPP
);

/*CallComponentFunctionWithStorage

Invokes the specified function of your component. 

long CallComponentFunctionWithStorage (
   Handle storage,
   ComponentParameters * params,
   ComponentFunctionUPP func
);
Parameters
storage

A handle to the memory associated with the current connection. The Component Manager provides this handle to your component along with the request. 
params

A pointer to the ComponentParameters structure that your component received from the Component Manager. These are the parameters originally provided by the application that called your component. 
func

A universal procedure pointer to the component function that is to handle the request. The Component Manager calls the function referred to by the func parameter, using Pascal calling conventions, with the parameters that were originally provided by the application that called your component. These parameters are preceded by a handle to the memory associated with the current connection. The function referred to by the func parameter must return a function result of type ComponentResult indicating the success or failure of the operation. See the ComponentRoutineProcPtr callback for more information on component functions. 
Return Value

The value that is returned by the function referred to by the func parameter. Your component should use this value to set the current error for this connection. Use the SetComponentInstanceError function to set the current error for a connection. 
Discussion

When an application requests service from your component, your component receives a component parameters structure containing the parameters that the application provided when it called your component. Your component can use this structure to access the parameters directly. Alternatively, you can use either the CallComponentFunction function or this function to extract those parameters and pass them to a subroutine of your component. By taking advantage of these functions, you can simplify the structure of your component code. 

If your component subroutine requires a handle to the memory associated with the connection, you must use this function. You allocate the memory for a given connection each time your component is opened. You inform the Component Manager that a connection has memory associated with it by calling the SetComponentInstanceError function.

Subroutines of a component that don’t need global data should use CallComponentFunction instead. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long CallComponentFunctionWithStorage (
   Handle storage,
   ComponentParameters * params,
   ComponentFunctionUPP func
);

/*CountComponentInstances

Determines the number of open connections being managed by a specified component. 

long CountComponentInstances (
   Component aComponent
);
Parameters
aComponent

The component for which you want a count of open connections. You can use a component instance here, but you must coerce the data type appropriately. 
Return Value

The number of open connections for the specified component. 
Discussion

This function can be useful if you want to restrict the number of connections for your component or if your component needs to perform special processing based on the number of open connections. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
long CountComponentInstances (
   Component aComponent
);

/*CallComponentCanDo


ComponentResult CallComponentCanDo (
   ComponentInstance ci,
   short ftnNumber
);
Parameters
ci
Return Value

See the description of the ComponentResult data type.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentResult CallComponentCanDo (
   ComponentInstance ci,
   short ftnNumber
);

/*DelegateComponentCall

Allows your component to pass on a request to a specified component. 

long DelegateComponentCall (
   ComponentParameters * originalParams,
   ComponentInstance ci
);
Parameters
originalParams

A pointer to the ComponentParameters structure provided to your component by the Component Manager. 
ci

The component instance that is to process the request. The Component Manager provides a component instance to your component when it opens a connection to another component with the OpenComponent or OpenDefaultComponent function. You must specify a component instance; this function does not accept a component identifier. 
Return Value

The component result returned by the specified component. 
Discussion

Your component may supplement its capabilities by using the services of another component to directly satisfy application requests using this function. For example, you might want to create two similar components that provide different levels of service to applications. Rather than completely implementing both components, you could design one to rely on the capabilities of the other. In this manner, you have to implement only that portion of the more capable component that provides additional services.

You may also invoke the services of another component using the standard mechanisms used by applications. The Component Manager then passes the requests to the appropriate component, and your component receives the results of those requests.

Your component must open a connection to the component to which the requests are to be passed. Your component must close that connection when it has finished using the services of the other component.

Your component should never use this function with open or close requests from the Component Manager—always use the OpenComponent and CloseComponent functions to manage connections with other components. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long DelegateComponentCall (
   ComponentParameters * originalParams,
   ComponentInstance ci
);

/*CallComponentTarget


ComponentResult CallComponentTarget (
   ComponentInstance ci,
   ComponentInstance target
);
Parameters
ci
target
Return Value

See the description of the ComponentResult data type.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentResult CallComponentTarget (
   ComponentInstance ci,
   ComponentInstance target
);

/*GetComponentIndString


OSErr GetComponentIndString (
   Component aComponent,
   Str255 theString,
   short strListID,
   short index
);
Parameters
aComponent
theString
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 3.0 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr GetComponentIndString (
   Component aComponent,
   Str255 theString,
   short strListID,
   short index
);

/*RegisterComponentResource

Registers a component stored in a resource file.

Component RegisterComponentResource (
   ComponentResourceHandle cr,
   short global
);
Parameters
cr

A handle to a component resource that describes the component to be registered. The component resource contains all the information required to register the component. Components you register with this function must be stored in a resource file as a component resource. The Component Manager automatically registers component resources stored in files with file types of 'thng' that are stored in the Extensions folder. See “Resources” for more information on component resource files. 
global

A set of flags that controls the scope of component registration. See “Register Component Resource flags” for a description of the flags. 
Return Value

The unique component identifier assigned to the component by the Component Manager, or NULL if the function could not register the component. See the description of the Component data type.
Discussion

Before a component can be used by an application, the component must be registered with the Component Manager. Applications can then find and open the component using the standard Component Manager functions. 

If you want to register a component that is in memory, use the RegisterComponent function.

This function does not actually load the code specified by the component resource into memory. Rather, the Component Manager loads the component code the first time an application opens the component. If the code is not in the same file as the component resource or if the Component Manager cannot find the file, the open request fails.

Note that a component registered locally by your application remains registered until your application unregisters it or quits. When an application quits, the Component Manager automatically closes any component connections to that application. In addition, if the application has registered components that reside in its heap space, the Component Manager automatically unregisters those components. A component registered globally by your application remains registered until your application unregisters it or until the computer is shut down. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

Component RegisterComponentResource (
   ComponentResourceHandle cr,
   short global
);

/*SetDefaultComponent

Changes the search order for registered components. 

OSErr SetDefaultComponent (
   Component aComponent,
   short flags
);
Parameters
aComponent

The component which you wish moved to the front of the search chain. The order of the search chain influences which component the Component Manager selects in response to an application’s use of the OpenDefaultComponent and FindNextComponent functions. You can use a component instance here, but you must coerce the data type appropriately. 
flags

A value specifying the control information governing the operation. The value of this parameter controls which component description fields the Component Manager examines during the reorder operation. Set the appropriate flags to 1 to define the fields that are examined during the reorder operation. See “Set Default Component Flags” for a description of the values you can use here. 
Return Value

A result code. See “Component Manager Result Codes”.
Discussion

Note that this function changes the search order for all applications. As a result, you should use this function carefully. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr SetDefaultComponent (
   Component aComponent,
   short flags
);


#ifdef __cplusplus
}
#endif
#endif