#ifndef CFMESSAGEPORT_H
#define  CFMESSAGEPORT_H


#include <CoreFoundation/CFString.h>
#include <CoreFoundation/CFRunLoop.h>
#include <CoreFoundation/CFData.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CFMessagePortSendRequest Error Codes

Error codes for CFMessagePortSendRequest.

enum {
   kCFMessagePortSuccess = 0,
   kCFMessagePortSendTimeout = -1,
   kCFMessagePortReceiveTimeout = -2,
   kCFMessagePortIsInvalid = -3,
   kCFMessagePortTransportError = -4
};
Constants
kCFMessagePortSuccess

The message was successfully sent and, if a reply was expected, a reply was received.

Available in Mac OS X v10.0 and later.
kCFMessagePortSendTimeout

The message could not be sent before the send timeout.

Available in Mac OS X v10.0 and later.
kCFMessagePortReceiveTimeout

No reply was received before the receive timeout.

Available in Mac OS X v10.0 and later.
kCFMessagePortIsInvalid

The message could not be sent because the message port is invalid.

Available in Mac OS X v10.0 and later.
kCFMessagePortTransportError

An error occurred trying to send the message.

Available in Mac OS X v10.0 and later.*/

enum {
   kCFMessagePortSuccess = 0,
   kCFMessagePortSendTimeout = -1,
   kCFMessagePortReceiveTimeout = -2,
   kCFMessagePortIsInvalid = -3,
   kCFMessagePortTransportError = -4
};


/*CFMessagePortContext

A structure that contains program-defined data and callbacks with which you can configure a CFMessagePort objects behavior.

struct CFMessagePortContext {
   CFIndex version; 
   void *info; 
   CFAllocatorRetainCallBack retain; 
   CFAllocatorReleaseCallBack release; 
   CFAllocatorCopyDescriptionCallBack copyDescription;
};
typedef struct CFMessagePortContext CFMessagePortContext;
Fields
version

Version number of the structure. Must be 0.
info

An arbitrary pointer to program-defined data, which can be associated with the message port at creation time. This pointer is passed to all the callbacks defined in the context.
retain

A retain callback for your program-defined info pointer. Can be NULL. 
release

A release callback for your program-defined info pointer. Can be NULL. 
copyDescription

A copy description callback for your program-defined info pointer. Can be NULL.*/
struct CFMessagePortContext {
   CFIndex version; 
 void *info; 
   CFAllocatorRetainCallBack retain; 
   CFAllocatorReleaseCallBack release; 
   CFAllocatorCopyDescriptionCallBack copyDescription;
};
typedef struct CFMessagePortContext CFMessagePortContext;


/* CFMessagePortRef

A reference to a message port object.

typedef struct __CFMessagePort *CFMessagePortRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct __CFMessagePort *CFMessagePortRef;


/*CFMessagePortCallBack

Callback invoked to process a message received on a CFMessagePort object.

typedef CFDataRef (*CFMessagePortCallBack) (
   CFMessagePortRef local, 
   SInt32 msgid, 
   CFDataRef data, 
   void *info
);

If you name your function MyCallBack, you would declare it like this:

CFDataRef MyCallBack (
   CFMessagePortRef local, 
   SInt32 msgid, 
   CFDataRef data, 
   void *info
);
Parameters
local

The local message port that received the message. 
msgid

An arbitrary integer value assigned to the message by the sender.
data

The message data. 
info

The info member of the CFMessagePortContext structure that was used when creating local.
Return Value

Data to send back to the sender of the message. The system releases the returned CFData object. Return NULL if you want an empty reply returned to the sender. 
Discussion

If you want the message data to persist beyond this callback, you must explicitly create a copy of data rather than merely retain it; the contents of data will be deallocated after the callback exits.*/

typedef CFDataRef (*CFMessagePortCallBack) (
   CFMessagePortRef local, 
   SInt32 msgid, 
   CFDataRef data, 
   void *info
);

/*CFMessagePortCreateRemote

Returns a CFMessagePort object connected to a remote port.

CFMessagePortRef CFMessagePortCreateRemote (
   CFAllocatorRef allocator,
   CFStringRef name
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
name

The name of the remote message port to which to connect. 
Return Value

The new CFMessagePort object, or NULL on failure. If a message port has already been created for the remote port, the pre-existing object is returned. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFMessagePortRef CFMessagePortCreateRemote (
   CFAllocatorRef allocator,
   CFStringRef name
);

/*CFMessagePortSendRequest

Sends a message to a remote CFMessagePort object.

SInt32 CFMessagePortSendRequest (
   CFMessagePortRef remote,
   SInt32 msgid,
   CFDataRef data,
   CFTimeInterval sendTimeout,
   CFTimeInterval rcvTimeout,
   CFStringRef replyMode,
   CFDataRef *returnData
);
Parameters
remote

The message port to which data should be sent.
msgid

An arbitrary integer value that you can send with the message.
data

The data to send to remote.
sendTimeout

The time to wait for data to be sent.
rcvTimeout

The time to wait for a reply to be returned.
replyMode

The run loop mode in which the function should wait for a reply. If the message is a oneway (so no response is expected), then replyMode should be NULL. If replyMode is non-NULL, the function runs the run loop waiting for a reply, in that mode. replyMode can be any string name of a run loop mode, but it should be one with input sources installed. You should use the kCFRunLoopDefaultMode constant unless you have a specific reason to use a different mode.
returnData

Upon return, contains a CFData object containing the reply data. Ownership follows the Create Rule. 
Return Value

Error code indicating success or failure. See “CFMessagePortSendRequest Error Codes” for the possible return values.
Availability
Available in Mac OS X v10.0 and later.*/

SInt32 CFMessagePortSendRequest (
   CFMessagePortRef remote,
   SInt32 msgid,
   CFDataRef data,
   CFTimeInterval sendTimeout,
   CFTimeInterval rcvTimeout,
   CFStringRef replyMode,
   CFDataRef *returnData
);


/*CFMessagePortCreateLocal

Returns a local CFMessagePort object.

CFMessagePortRef CFMessagePortCreateLocal (
   CFAllocatorRef allocator,
   CFStringRef name,
   CFMessagePortCallBack callout,
   CFMessagePortContext *context,
   Boolean *shouldFreeInfo
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
name

The name with which to register the port. name can be NULL. 
callout

The callback function invoked when a message is received on the message port. 
context

A structure holding contextual information for the message port. The function copies the information out of the structure, so the memory pointed to by context does not need to persist beyond the function call. 
shouldFreeInfo

A flag set by the function to indicate whether the info member of context should be freed. The flag is set to true on failure or if a local port named name already exists, false otherwise. shouldFreeInfo can be NULL. 
Return Value

The new CFMessagePort object, or NULL on failure. If a local port is already named name, the function returns that port instead of creating a new object; the context and callout parameters are ignored in this case. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFMessagePortRef CFMessagePortCreateLocal (
   CFAllocatorRef allocator,
   CFStringRef name,
   CFMessagePortCallBack callout,
   CFMessagePortContext *context,
   Boolean *shouldFreeInfo
);

/*CFMessagePortCreateRunLoopSource

Creates a CFRunLoopSource object for a CFMessagePort object.

CFRunLoopSourceRef CFMessagePortCreateRunLoopSource (
   CFAllocatorRef allocator,
   CFMessagePortRef ms,
   CFIndex order
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
ms

The message port for which to create a run loop source. 
order

A priority index indicating the order in which run loop sources are processed. order is currently ignored by CFMessagePort object run loop sources. Pass 0 for this value. 
Return Value

The new CFRunLoopSource object for ms. Ownership follows the Create Rule.
Discussion

The run loop source is not automatically added to a run loop. To add the source to a run loop, use CFRunLoopAddSource.
Availability
Available in Mac OS X v10.0 and later.*/

CFRunLoopSourceRef CFMessagePortCreateRunLoopSource (
   CFAllocatorRef allocator,
   CFMessagePortRef ms,
   CFIndex order
);


#ifdef __cplusplus
}
#endif


#endif