#ifndef CGPDFDICTIONARY_H
#define CGPDFDICTIONARY_H


#include <CoreGraphics/CGDataProvider.h> 
#include <CoreGraphics/CGGeometry.h> 
#include <CoreGraphics/CGPDFPage.h> 
#include <CoreFoundation/CFURL.h>

/*CGPDFDocumentRef

Defines an opaque type that encapsulates PDF drawing information.

typedef struct CGPDFDocument * CGPDFDocumentRef;
Discussion

CGPDFDocumentRef defines an opaque type Quartz uses to represent PDF (Portable Document Format) documents. 

Note that PDF documents may be encrypted, and that some operations may be restricted until a valid password is supplied—see the functions listed in “Managing Encryption”.

In Mac OS X version 10.2 and later, CGPDFDocumentRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct CGPDFDocument * CGPDFDocumentRef;

//function

/*CGPDFDocumentCreateWithProvider

Creates a Quartz PDF document using a data provider.

CGPDFDocumentRef CGPDFDocumentCreateWithProvider (
CGDataProviderRef provider
);
Parameters
provider

A data provider that supplies the PDF document data. 
Return Value

A new Quartz PDF document, or NULL if a document could not be created. You are responsible for releasing the object using CGPDFDocumentRelease. 
Discussion

For information about drawing a PDF document in a graphics context, see CGContextDrawPDFDocument.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGPDFDocument.h*/

CGPDFDocumentRef CGPDFDocumentCreateWithProvider (
CGDataProviderRef provider
);

/*CGPDFDocumentGetPage

Returns a page from a Quartz PDF document.

CGPDFPageRef CGPDFDocumentGetPage (
   CGPDFDocumentRef document,
   size_t pageNumber
);
Parameters
document

A PDF document.
pageNumber

The number of the page requested.
Return Value

Return the PDF page corresponding to the specified page number, or NULL if no such page exists in the document. Pages are numbered starting at 1.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGPDFDocument.h*/

CGPDFPageRef CGPDFDocumentGetPage (
   CGPDFDocumentRef document,
   size_t pageNumber
);

#endif