
#ifndef  DRCOREDEVICE_H
#define DRCOREDEVICE_H

#if PRAGMA_ONCE
#pragma once
#endif

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef DRCOREOBJECT_H
#include <DiscRecordingEngine/DRCoreObject.h>
#endif

#ifndef  AVAILABILITYMACROS_H
#include <AvailabilityMacros.h>
#endif

#ifndef MATH_H
#include <math.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef IOKITLIB_H
#include <IOKit/IOKitLib.h>
#endif

/*kDRDeviceCanWriteDVDRAMKey

extern const CFStringRef kDRDeviceCanWriteDVDRAMKey;  
Discussion 

A key for the kDRDeviceWriteCapabilitiesKey dictionary in the device info dictionary. The value is a reference to a CFBoolean object indicating whether the device can write to DVD-RAM media. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRDeviceCanWriteDVDRAMKey;  

/*kDRDeviceWriteCapabilitiesKey

extern const CFStringRef kDRDeviceWriteCapabilitiesKey;  
Discussion 

A key for the dictionary object returned by DRDeviceCopyInfo . The value of this key is a reference to a CFString object describing the capabilities the drive has for writing to different media. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRDeviceWriteCapabilitiesKey;  

/*kDRDeviceProductNameKey

extern const CFStringRef kDRDeviceProductNameKey;  
Discussion 

A key for the dictionary object returned by DRDeviceCopyInfo . The value of this key is a reference to a CFString object containing the product name extracted from the device. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRDeviceProductNameKey;  

/*kDRDeviceVendorNameKey

extern const CFStringRef kDRDeviceVendorNameKey;  
Discussion 

A key for the dictionary object returned by DRDeviceCopyInfo . The value of this key is a reference to a CFString object containing the vendor name extracted from the device. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRDeviceVendorNameKey;  

/*DRDeviceRef

typedef struct __DRDevice* DRDeviceRef;  
Discussion 

This is the type of a reference to DRDevices.*/
typedef struct __DRDevice* DRDeviceRef;  

//func

/*DRDeviceCopyInfo


Returns information about the device. 
extern CFDictionaryRef DRDeviceCopyInfo(
    DRDeviceRef device) ;  
Parameters
device
The device to query.
Return Value

A CFDictionary object identifying the device and its capabilities. 
Discussion 

This function returns information that identifies the device and describes its capabilites. The information includes the vendor's name, the product identifier, whether the device can burn CDs or DVDs, and so on. 
Availability
Introduced in Mac OS X v10.2*/
extern CFDictionaryRef DRDeviceCopyInfo(
    DRDeviceRef device) ;  


#ifdef __cplusplus
}
#endif

#endif 
