#ifndef AXATTRIBUTECONSTANTS_H
#define AXATTRIBUTECONSTANTS_H

/*kAXSizeAttribute

#define kAXSizeAttribute CFSTR(
    "AXSize") 
Discussion 

The vertical and horizontal dimensions of the element. 

Required for all elements that are visible on the screen, which is virtually all elements. 

Writable: 

Generally no. However, some elements that can be resized by the user through direct manipulation (like windows) should offer a writable size attribute.

Value: 

An AXValueRef with type kAXValueCGSizeType. Units are pixels.*/
#define kAXSizeAttribute CFSTR( "AXSize") 


/*kAXPositionAttribute

#define kAXPositionAttribute CFSTR(
    "AXPosition") 
Discussion 

The global screen position of the top-left corner of an element. 

Required for all elements that are visible on the screen, which is virtually all elements. 

Writable: 

Generally no. However, some elements that can be moved by the user through direct manipulation (like windows) should offer a writable position attribute.

Value: 

An AXValueRef with type kAXValueCGPointType. 0,0 is the top-left corner of the screen that displays the menu bar. The value of the horizontal axis increases to the right. The value of the vertical axis increases downward. Units are pixels.*/

#define kAXPositionAttribute CFSTR( "AXPosition") 

/*kAXParentAttribute

#define kAXParentAttribute CFSTR(
    "AXParent") 
Discussion 

Indicates the element's container element in the visual element hierarchy. A push button's kAXParentElement might be a window element or a group. A sheet's kAXParentElement will be a window element. A window's kAXParentElement will be the application element. A menu item's kAXParentElement will be a menu element. 

Required for every element except the application. Everything else in the visual element hierarchy must have a parent. 

Writable: 

No

Value: 

An AXUIElementRef*/
#define kAXParentAttribute CFSTR("AXParent") 

/*kAXRoleAttribute


Identifies the basic type of an element.
#define kAXRoleAttribute CFSTR(
    "AXRole") 
Discussion 

Required for all elements. Even in the worst case scenario where an element cannot figure out what its basic type is, it can still supply the value kAXUnknownRole. 

Writable: 

No 


Value: 

A CFStringRef of one of the role strings defined in this header, or a new role string of your own invention. The string should not be localized, and it does not need to be human-readable. Instead of inventing new role strings, see if a custom element can be identified by an existing role string and a new subrole. See kAXSubroleAttribute. 


Carbon Accessorization Notes: 

If your HIObjectClass or Carbon Event handler provides the kAXRoleAttribute, it must also provide the kAXRoleDescriptionAttribute.*/
#define kAXRoleAttribute CFSTR( \
    "AXRole") 

/*kAXTitleAttribute

#define kAXTitleAttribute CFSTR(
    "AXTitle") 
Discussion 

The localized, human-readable string that is displayed as part of the element's normal visual interface. For example, an OK button's kAXTitleElement is the string "OK", and a menu item's kAXTitleElement is the text of the menu item. 

Required if the element draws a string as part of its normal visual interface. 

Writable: 

No 


Value: 

A localized, human-readable CFStringRef*/
#define kAXTitleAttribute CFSTR(    "AXTitle") 

#endif