#ifndef HIOBJECT_H
#define HIOBJECT_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef  CARBONEVENTSCORE_H
#include <HIToolbox/CarbonEventsCore.h>
#endif


#include <HYS/HIToolbox/HIObject.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*HIObject Base Class Events

Define the base-class functionality of HIObjects.

enum{
   kEventClassHIObject = 'hiob',
   kEventHIObjectConstruct = 1,
   kEventHIObjectInitialize = 2,
   kEventHIObjectDestruct = 3,
   kEventHIObjectIsEqual = 4,
   kEventHIObjectPrintDebugInfo = 5,
   kEventHIObjectEncode = 6
};
Constants
kEventClassHIObject

The event class for HIObject events.

Available in Mac OS X v10.2 and later.
kEventHIObjectConstruct

Your object is being constructed. When your event handler is called with this event, it is being called directly and not through the normal event dispatching mechanism. This means that the EventHandlerCallRef passed to your handler is NULL and CallNextEventHandler does not work. You are passed the actual HIObjectRef of your base class for you to record in your instance data. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventHIObjectInitialize

Your object is being initialized. Your handler should pass this onto the superclass first before handling this event. This is done by calling CallNextEventHandler with the event. When that function returns, you should make sure the result is noErr. If not, you should not continue to initialize your object. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventHIObjectDestruct

Your object is being destroyed. This is your chance to dispose of anything you might have allocated for your object. Do not call through with CallNextEventHandler. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventHIObjectIsEqual

HIObjectIsEqual has been called, and you are being asked to determine whether your object is equivalent to the one being passed to your handler. If your object is equivalent, you should place true in the kEventParamResult parameter in the event; if your object is not equivalent, place false in the kEventParamResult parameter. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventHIObjectPrintDebugInfo

HIObjectPrintDebugInfo has been called, and you are being asked to print your information to stdout. This event is sent to all handlers and you should not call CallNextEventHandler. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventHIObjectEncode

HIArchiveEncodeHIObject has been called on your HIObject, and you are being asked to encode your object into an archive. Before handling this event, your handler should pass this event to the superclass by calling CallNextEventHandler with the event. If CallNextEventHandler does not return noErr, you should not continue to encode your instance data. (Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
Discussion

You only need to be aware of these events if you are implementing a subclass. 
Table 1  Parameter names and types for HIObject base class events
Event kind	
Parameter name	
Parameter type

kEventHIObjectConstruct	
kEventParamHIObjectInstance	
typeHIObjectRef

kEventHIObjectInitialize	
kEventParamHIArchive	
typeCFTypeRef

kEventHIObjectDestruct	
	


kEventHIObjectIsEqual	
kEventParamDirectObject	
typeHIObjectRef

	
kEventParamResult	
typeBoolean

kEventHIObjectPrintDebugInfo	
	


kEventHIObjectEncode	
kEventParamHIArchive	
typeCFTypeRef*/
enum{
   kEventClassHIObject = 'hiob',
   kEventHIObjectConstruct = 1,
   kEventHIObjectInitialize = 2,
   kEventHIObjectDestruct = 3,
   kEventHIObjectIsEqual = 4,
   kEventHIObjectPrintDebugInfo = 5,
   kEventHIObjectEncode = 6
};


/*HIObject Base Class Event Parameters

Define constants for HIObject base class event parameters.

enum {
   kEventParamHIObjectInstance = 'hioi',
   kEventParamHIArchive = 'hiac',
   typeHIObjectRef = 'hiob'
};
Constants
kEventParamHIObjectInstance

On entry, the HIObject reference for your object. This parameter is currently only used for the kEventHIObjectConstruct event. Typically, you read this parameter from the event and store it in your instance data so that when your instance needs to call HIObject APIs, your instance can use this HIObjectRef. On exit, the value of this parameter is typeVoidPtr and is a pointer to the instance data you have written into the event using SetEventParameter. After your event handler returns, the HIToolbox reads your instance data pointer from the event, and installs the event handlers that were passed to HIObjectRegisterClassSubclass on the new object. The HIToolbox uses the instance data pointer as the refcon for the event handlers it installed so that your event handlers can retrieve your instance data pointer from the reference constant (the third parameter to an EventHandlerProcPtr).(Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventParamHIArchive

An HIArchive used to store or retrieve the HIObject. This parameter is passed in the following cases:
In the kEventHIObjectInitialize event when the HIObject is requested to initialize itself from a decoded archive. If the HIObject is to be initialized normally (that is, not from an archive), the initialize event does not contain kEventParamHIArchive .
In the kEventHIObjectEncode event, which is sent to request that the HIObject encode itself within an archive. 

(Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.*/
enum {
   kEventParamHIObjectInstance = 'hioi',
   kEventParamHIArchive = 'hiac',
   typeHIObjectRef = 'hiob'
};

/*HIObjectGetEventTarget

Obtains the event target of an HIObjectRef. 

EventTargetRef HIObjectGetEventTarget (
   HIObjectRef inObject
);
Parameters
inObject

The object whose target you want.
Return Value

An EventTargetRef.
Availability
Available in Mac OS X v10.2 and later.*/
EventTargetRef HIObjectGetEventTarget (
   HIObjectRef inObject
);

/*HIObjectRegisterSubclass

Registers an HIObject subclass.

OSStatus HIObjectRegisterSubclass (
   CFStringRef inClassID,
   CFStringRef inBaseClassID,
   OptionBits inOptions,
   EventHandlerUPP inConstructProc,
   UInt32 inNumEvents,
   const EventTypeSpec* inEventList,
   void * inConstructData,
   HIObjectClassRef* outClassRef
);
Parameters
inClassID

The class ID of your class. It should be unique. We recommend using Java-style com.company.foo naming conventions to avoid collisions.
inBaseClassID

The class ID of the class you derive from. Passing NULL indicates you want to subclass HIObject (the base class) directly.
inOptions

Any special options for your class. Currently you must pass 0 for this parameter.
inConstructProc

A universal procedure pointer to the event handler for this subclass. You pass the address of an event handler into this parameter. This handler is called directly, rather than through the normal event-dispatching mechanism. This means that the EventHandlerCallRef passed in will be NULL, and you cannot use it for calls like CallNextEventHandler. Other than that, you should return a result as usual. After your object is constructed, this procedure is installed as the event handler for the remaining events specified in the inEventList parameter. In Mac OS X v10.4 and later, passing NULL creates an “abstract class” that cannot be instantiated but can still be used as a base class for subclasses. If you pass NULL, HIObjectCreate on the class ID will return hiObjectClassIsAbstractErr.
inNumEvents

The number of events you are installing.
inEventList

The events your handler wants to receive. You must handle the kEventHIObjectConstruct and kEventHIObjectDestruct event. If these events are not specified, an error is returned.
inConstructData

Pass any info you want passed into your event handler here. For a C++ hierarchy based on HIObjects, you might actually pass a static method to construct your object here, and the base class event handler to do construction as your event handler.
outClassRef

The newly created class reference. Pass NULL if you don’t care.
Return Value

A result code. See “HIObject Result Codes”.
Availability
Available in Mac OS X version 10.2 (v10.2) and later.*/
OSStatus HIObjectRegisterSubclass (
   CFStringRef inClassID,
   CFStringRef inBaseClassID,
   OptionBits inOptions,
   EventHandlerUPP inConstructProc,
   UInt32 inNumEvents,
   const EventTypeSpec* inEventList,
   void * inConstructData,
   HIObjectClassRef* outClassRef
);

/*HIObjectCreate

Creates an object derived from HIObject.

OSStatus HIObjectCreate (
   CFStringRef inClassID,
   EventRef inConstructData,
   HIObjectRef* outObject
);
Parameters
inClassID

The class ID of the class of object you want to instantiate.
inConstructData

If your class (or any class you derive from) accepts creation parameters, you need to pass an event into this parameter. The class must be kEventClassHIObject, and the kind should be kEventHIObjectInitialize. Any other parameters should be added as necessary. Specific subclasses of HIObject which require initialization parameters will specify those parameters in the appropriate headers.
outObject

The instance of the object you create.
Return Value

A result code. See “HIObject Result Codes”.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIObjectCreate (
   CFStringRef inClassID,
   EventRef inConstructData,
   HIObjectRef* outObject
);

/*HIObjectDynamicCast

Obtains the instance data for a specific class of an HIObject. 

void* HIObjectDynamicCast (
   HIObjectRef inObject,
   CFStringRef inClassID
);
Parameters
inObject

The object whose class ID you want to check.
inClassID

The class ID to get the instance data for.
Return Value

A void * result containing the instance data for the object, or NULL if the object is not an instance of the class.
Discussion

The instance data returned is the same instance data the class’s construction event handler returns in the instance data parameter. This is stored off with the class reference so that it can be fetched later for use by this function. It allows your subclass to easily get at the data it created, if your subclass needs that data outside of an event handler. (Inside an event handler, your subclass can get at its instance data via the userData parameter to the event handler.) 
Availability
Available in Mac OS X v10.2 and later.*/

void* HIObjectDynamicCast (
   HIObjectRef inObject,
   CFStringRef inClassID
);


#ifdef __cplusplus
}
#endif

#endif