#ifndef MACTEXTEDITOR_H
#define MACTEXTEDITOR_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef DRAG_H
#include <HIToolbox/Drag.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#ifndef HIVIEW_H
#include <HIToolbox/HIView.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Initialization Option Bits

Specify initialization options for MLTE. 

enum {
   kTXNWantMoviesBit = 0,
   kTXNWantSoundBit = 1,
   kTXNWantGraphicsBit = 2,
   kTXNAlwaysUseQuickDrawTextBit = 3,
   kTXNUseTemporaryMemoryBit = 4
};
Constants
kTXNWantMoviesBit

When this bit is set, it specifies that movie data is supported in a text object.

Available in Mac OS X v10.0 and later.
kTXNWantSoundBit

When this bit is set, it specifies that sound data is supported in a text object.

Available in Mac OS X v10.0 and later.
kTXNWantGraphicsBit

When this bit is set, it specifies that graphics data is supported in a text object.

Available in Mac OS X v10.0 and later.
kTXNAlwaysUseQuickDrawTextBit

When this bit is set, it specifies that MLTE should use QuickDraw for imaging even if ATSUI is available. This is often the best choice for applications that need speed and efficient memory usage.

Available in Mac OS X v10.0 and later.
kTXNUseTemporaryMemoryBit

When this bit is set, it specifies that MLTE should use temporary memory for all memory allocations.

Available in Mac OS X v10.0 and later.*/

enum {
   kTXNWantMoviesBit = 0,
   kTXNWantSoundBit = 1,
   kTXNWantGraphicsBit = 2,
   kTXNAlwaysUseQuickDrawTextBit = 3,
   kTXNUseTemporaryMemoryBit = 4
};


/*Frame Option Bits

Specify frame options for a text object.

enum {
   kTXNDrawGrowIconBit = 0,
   kTXNShowWindowBit = 1,
   kTXNWantHScrollBarBit = 2,
   kTXNWantVScrollBarBit = 3,
   kTXNNoTSMEverBit = 4,
   kTXNReadOnlyBit = 5,
   kTXNNoKeyboardSyncBit = 6,
   kTXNNoSelectionBit = 7,
   kTXNSaveStylesAsSTYLResourceBit = 8,
   kOutputTextInUnicodeEncodingBit = 9,
   kTXNDoNotInstallDragProcsBit = 10,
   kTXNAlwaysWrapAtViewEdgeBit = 11,
   kTXNDontDrawCaretWhenInactiveBit = 12,
   kTXNDontDrawSelectionWhenInactiveBit = 13,
   kTXNSingleLineOnlyBit = 14,
   kTXNDisableDragAndDropBit = 15,
   kTXNUseQDforImagingBit = 16,
   kTXNMonostyledTextBit = 17
};
Constants
kTXNDrawGrowIconBit

When this bit is set, it indicates the frame will have a size box. The presence of a size box in the lower right corner of an MLTE pane is only useful for resizing an MLTE pane if the MLTE pane occupies the entire window (a full-window MLTE object). In this case your application would look for a mouse-down event in the size box and call the function TXNGrowWindow as appropriate. Note that the size box is not supported as a means of resizing MLTE panes using TXNGrowWindow for MLTE pane objects. 

Passing the kTXNDrawGrowIconMask constant to the function TXNNewObject only causes a size box to be drawn in the lower right corner of the MLTE pane. Passing this constant does not create a size box control in the window. The window will not contain an actual size box control. This means the window will not receive events that indicate a mouse-down event in the grow region. For this to happen, when you create the window that contains the MLTE pane, you must create the window to have a size box.

In summary, although you may pass the constants kTXNDrawGrowIconMask to the function TXNNewObject when you create an MLTE object in a window, this action only causes the visual appearance of a size box in the lower right corner of the MLTE pane. If you want to detect mouse-down events in the size box, you must also provide a size box in the window through the appropriate Window Manager functions or other tools.

Available in Mac OS X v10.0 and later.
kTXNShowWindowBit

When this bit is set, it indicates MLTE should display a window when a text object is created. If this bit is set, your application no longer needs to call the ShowWindow function from the Window Manager; MLTE will do this for you.

Available in Mac OS X v10.0 and later.
kTXNWantHScrollBarBit

When this bit is set, it indicates the frame should have a horizontal scroll bar.

Available in Mac OS X v10.0 and later.
kTXNWantVScrollBarBit

When this bit is set, it indicates the frame should have a vertical scroll bar.

Available in Mac OS X v10.0 and later.
kTXNNoTSMEverBit


When this bit is set, it indicates not to use Text Services Manager. You cannot use this bit when your application accepts Unicode input. (Deprecated. You can no longer set this because in Mac OS X, MLTE always uses the Text Services Manager.)

Available in Mac OS X v10.0 and later.
kTXNReadOnlyBit

When this bit is set, it indicates the text object is read-only. If you set this bit when you call the function TXNNewObject, the text object is put into a state that does not allow user input. However, your application can put data into the text object by calling the function TXNSetData. If you want the text object set into a more restrictive read-only state that does not allow user input or your application to put data into the text object programmatically you need to call the function TXNSetTXNObjectControls, passing the tag kTXNIOPrivilegesTag.

Available in Mac OS X v10.0 and later.
kTXNNoKeyboardSyncBit

When this bit is set, it indicates no keyboard synchronization.

Available in Mac OS X v10.0 and later.
kTXNNoSelectionBit

When this bit is set, it indicates MLTE should not show the insertion point.

Available in Mac OS X v10.0 and later.
kTXNSaveStylesAsSTYLResourceBit

When this bit is set, it indicates text style should be saved as a kTXNMultipleStylesPerTextDocumentResType resource. You can set this to assure compatibility with SimpleText. If you use kTXNMultipleStylesPerTextDocumentResType resources to save style info, your documents can have as many styles as you’d like. However tabs are not saved. If you don’t set this bit, plain text files are saved as kTXNSingleStylePerTextDocumentResType resources, and only the first style in the document is saved. (Your application is expected to apply all style changes to the entire document.) If you save files with a kTXNSingleStylePerTextDocumentResType resource, their output is similar to those output by CodeWarrior, BBEdit, and MPW.

Available in Mac OS X v10.0 and later.
kOutputTextInUnicodeEncodingBit

When this bit is set, it indicates plain text should be saved as Unicode.

Available in Mac OS X v10.0 and later.
kTXNDoNotInstallDragProcsBit

When this bit is set, it indicates you want to call your own drag handlers.

Available in Mac OS X v10.0 and later.
kTXNAlwaysWrapAtViewEdgeBit

When this bit is set, it indicates line wrap at the edge of the view rectangle.

Available in Mac OS X v10.0 and later.
kTXNDontDrawCaretWhenInactiveBit


When this bit is set, it indicates the caret should not be drawn when the object does not have focus. (Deprecated. In Mac OS X v10.4, MLTE never draws the caret when the text object does not have focus.)

Available in Mac OS X v10.0 and later.
kTXNDontDrawSelectionWhenInactiveBit

When this bit is set, it indicates the selection should not be drawn when the object does not have focus.

Available in Mac OS X v10.0 and later.
kTXNSingleLineOnlyBit

When this bit is set, it indicates that the text object will not scroll vertically. Horizontal scrolling will stop when the end of the text is visible, and there will be no limit to the width of the text. In addition, a line break character typed, pasted, or dropped into the text object will be translated into a hyphen (-).

Available in Mac OS X v10.1 and later.
kTXNDisableDragAndDropBit

When this bit is set, it indicates that drag and drop will not be allowed in the text object.

Available in Mac OS X v10.1 and later.
kTXNUseQDforImagingBit


When this bit is set, it indicates that QuickDraw will be used for imaging instead of the Quartz (CoreGraphics) which is the default. Available in Mac OS X only. (Deprecated. You can no longer set the imaging system to use; MLTE always uses Quartz imaging.)

Available in Mac OS X v10.1 and later.
kTXNMonostyledTextBit

When this bit is set, it indicates that the text object will have a single style no matter what kind of changes are made to the object.

Available in Mac OS X v10.2 and later.*/
enum {
   kTXNDrawGrowIconBit = 0,
   kTXNShowWindowBit = 1,
   kTXNWantHScrollBarBit = 2,
   kTXNWantVScrollBarBit = 3,
   kTXNNoTSMEverBit = 4,
   kTXNReadOnlyBit = 5,
   kTXNNoKeyboardSyncBit = 6,
   kTXNNoSelectionBit = 7,
   kTXNSaveStylesAsSTYLResourceBit = 8,
   kOutputTextInUnicodeEncodingBit = 9,
   kTXNDoNotInstallDragProcsBit = 10,
   kTXNAlwaysWrapAtViewEdgeBit = 11,
   kTXNDontDrawCaretWhenInactiveBit = 12,
   kTXNDontDrawSelectionWhenInactiveBit = 13,
   kTXNSingleLineOnlyBit = 14,
   kTXNDisableDragAndDropBit = 15,
   kTXNUseQDforImagingBit = 16,
   kTXNMonostyledTextBit = 17
};


/*Supported File Types

Represents a file type.

typedef OSType TXNFileType;
enum {
   kTXNTextensionFile = 'txtn',
   kTXNTextFile = 'TEXT',
   kTXNPictureFile = 'PICT',
   kTXNMovieFile = 'MooV',
   kTXNSoundFile = 'sfil',
   kTXNAIFFFile = 'AIFF',
   kTXNUnicodeTextFile = 'utxt'
};
Constants
kTXNTextensionFile

A file that contains Unicode or Mac OS text. By default, it contains Unicode text. Files are saved in a private format.

Available in Mac OS X v10.0 and later.
kTXNTextFile

A file that contains plain text data. 

Available in Mac OS X v10.0 and later.
kTXNPictureFile

A file that contains graphics data in PICT format.

Available in Mac OS X v10.0 and later.
kTXNMovieFile

A file that contains movie data in 'MooV' format.

Available in Mac OS X v10.0 and later.
kTXNSoundFile

A file that contains sound data in 'sfil' format.

Available in Mac OS X v10.0 and later.
kTXNAIFFFile

A file that contains sound data in 'aiff' format.

Available in Mac OS X v10.0 and later.
kTXNUnicodeTextFile

A file that contains Unicode text data.

Available in Mac OS X v10.0 and later.*/
typedef OSType TXNFileType;
enum {
   kTXNTextensionFile = 'txtn',
   kTXNTextFile = 'TEXT',
   kTXNPictureFile = 'PICT',
   kTXNMovieFile = 'MooV',
   kTXNSoundFile = 'sfil',
   kTXNAIFFFile = 'AIFF',
   kTXNUnicodeTextFile = 'utxt'
};

/*Supported Data Types

Specifies the type of data being requested from or passed to an MLTE function.

typedef OSType TXNDataType;
enum {
   kTXNTextData = 'TEXT',
   kTXNPictureData = 'PICT',
   kTXNMovieData = 'moov',
   kTXNSoundData = 'snd ',
   kTXNUnicodeTextData = 'utxt'
};
Constants
kTXNTextData

Text data.

Available in Mac OS X v10.0 and later.
kTXNPictureData

Graphics (PICT) data.

Available in Mac OS X v10.0 and later.
kTXNMovieData

Movie or sound data.

Available in Mac OS X v10.0 and later.
kTXNSoundData

Sound data.

Available in Mac OS X v10.0 and later.
kTXNUnicodeTextData

Unicode text data.

Available in Mac OS X v10.0 and later.
Discussion

Used in the TXNGetDataEncoded function.*/
typedef OSType TXNDataType;
enum {
   kTXNTextData = 'TEXT',
   kTXNPictureData = 'PICT',
   kTXNMovieData = 'moov',
   kTXNSoundData = 'snd ',
   kTXNUnicodeTextData = 'utxt'
};

/*Data Offsets

Specifies offsets to use when manipulating data in a text object. Offsets in MLTE are always character offsets.

typedef UInt32 TXNOffset;
enum {
   kTXNUseCurrentSelection = 0xFFFFFFFF,
   kTXNStartOffset = 0,
   kTXNEndOffset = 0x7FFFFFFF
};
Constants
kTXNUseCurrentSelection

Use the current selection.

Available in Mac OS X v10.0 and later.
kTXNStartOffset

The first offset of the text in a text object.

Available in Mac OS X v10.0 and later.
kTXNEndOffset

The last offset of the text in a text object.

Available in Mac OS X v10.0 and later.
Discussion

These constants can be passed and returned in functions that have the parameter of type TXNOffset.*/
typedef UInt32 TXNOffset;
enum {
   kTXNUseCurrentSelection = 0xFFFFFFFF,
   kTXNStartOffset = 0,
   kTXNEndOffset = 0x7FFFFFFF
};

/*TXNObject

Contains private variables and functions necessary to represent text and handle text formatting at a document level. 

typedef struct OpaqueTXNObject * TXNObject;
Discussion

You obtain a structure of type TXNObject from the TXNNewObject function. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueTXNObject * TXNObject;

/*Frame Option Masks

Represents information about frame behavior (such as whether there are scroll bars and a size box). 

typedef OptionBits TXNFrameOptions;
enum {
   kTXNDrawGrowIconMask = 1L << kTXNDrawGrowIconBit,
   kTXNShowWindowMask = 1L << kTXNShowWindowBit,
   kTXNWantHScrollBarMask = 1L << kTXNWantHScrollBarBit,
   kTXNWantVScrollBarMask = 1L << kTXNWantVScrollBarBit,
   kTXNNoTSMEverMask = 1L << kTXNNoTSMEverBit,
   kTXNReadOnlyMask = 1L << kTXNReadOnlyBit,
   kTXNNoKeyboardSyncMask = 1L << kTXNNoKeyboardSyncBit,
   kTXNNoSelectionMask = 1L << kTXNNoSelectionBit,
   kTXNSaveStylesAsSTYLResourceMask = 1L <<                 kTXNSaveStylesAsSTYLResourceBit,
   kOutputTextInUnicodeEncodingMask = 1L <<             kOutputTextInUnicodeEncodingBit,
   kTXNDoNotInstallDragProcsMask = 1L << kTXNDoNotInstallDragProcsBit,
   kTXNAlwaysWrapAtViewEdgeMask = 1L << kTXNAlwaysWrapAtViewEdgeBit,
   kTXNDontDrawCaretWhenInactiveMask = 1L <<             kTXNDontDrawCaretWhenInactiveBit,
   kTXNDontDrawSelectionWhenInactiveMask = 1L <<             kTXNDontDrawSelectionWhenInactiveBit,
   kTXNSingleLineOnlyMask = 1L << kTXNSingleLineOnlyBit,
   kTXNDisableDragAndDropMask = 1L << kTXNDisableDragAndDropBit,
   kTXNUseQDforImagingMask = 1L << kTXNUseQDforImagingBit,
   kTXNMonostyledTextMask = 1L << kTXNMonostyledTextBit
};
Constants
kTXNDrawGrowIconMask

Use to set or test for the kTXNDrawGrowIconBit bit.

Available in Mac OS X v10.0 and later.
kTXNShowWindowMask

Use to set or test for the kTXNShowWindowBit bit.

Available in Mac OS X v10.0 and later.
kTXNWantHScrollBarMask

Use to set or test for the kTXNWantHScrollBarBit bit.

Available in Mac OS X v10.0 and later.
kTXNWantVScrollBarMask

Use to set or test for the kTXNWantVScrollBarBit bit.

Available in Mac OS X v10.0 and later.
kTXNNoTSMEverMask


Use to set or test for the kTXNNoTSMEverBit bit. (Deprecated. You can no longer set this because in Mac OS X, MLTE always uses the Text Services Manager.)

Available in Mac OS X v10.0 and later.
kTXNReadOnlyMask

Use to set or test for the kTXNReadOnlyBit bit.

Available in Mac OS X v10.0 and later.
kTXNNoKeyboardSyncMask

Use to set or test for the kTXNNoKeyboardSyncBit bit.

Available in Mac OS X v10.0 and later.
kTXNNoSelectionMask

Use to set or test for the kTXNNoSelectionBit bit.

Available in Mac OS X v10.0 and later.
kTXNSaveStylesAsSTYLResourceMask

Use to set or test for the kTXNXNSaveStylesAsSTYLResourceBit bit.

Available in Mac OS X v10.0 and later.
kOutputTextInUnicodeEncodingMask

Use to set or test for the kOutputTextInUnicodeEncodingBit bit.

Available in Mac OS X v10.0 and later.
kTXNDoNotInstallDragProcsMask

Use to set or test for the kTXNDoNotInstallDragProcsBit bit.

Available in Mac OS X v10.0 and later.
kTXNAlwaysWrapAtViewEdgeMask

Use to set or test for the kTXNAlwaysWrapAtViewEdgeBit bit.

Available in Mac OS X v10.0 and later.
kTXNDontDrawCaretWhenInactiveMask


Use to set or test for the kTXNDontDrawCaretWhenInactiveBit bit. (Deprecated. In Mac OS Xv10.4 and later, MLTE never draws the caret when the text object does not have focus.)

Available in Mac OS X v10.0 and later.
kTXNDontDrawSelectionWhenInactiveMask

Use to set or test for the kTXNDontDrawSelectionWhenInactiveBit bit.

Available in Mac OS X v10.0 and later.
kTXNSingleLineOnlyMask

Use to set or test for the kTXNSingleLineOnlyBit bit.

Available in Mac OS X v10.1 and later.
kTXNDisableDragAndDropMask

Use to set or test for the kTXNDisableDragAndDropBit bit.

Available in Mac OS X v10.1 and later.
kTXNUseQDforImagingMask


Use to set or test for the kTXNUseQDforImagingBit bit. (Deprecated. You can no longer set the imaging system; MLTE always uses Quartz imaging.)

Available in Mac OS X v10.1 and later.
kTXNMonostyledTextMask

Use to set or test for the kTXNMonostyledTextBit bit.

Available in Mac OS X v10.2 and later.
Discussion

See Frame Option Bits.*/

typedef OptionBits TXNFrameOptions;
enum {
   kTXNDrawGrowIconMask = 1L << kTXNDrawGrowIconBit,
   kTXNShowWindowMask = 1L << kTXNShowWindowBit,
   kTXNWantHScrollBarMask = 1L << kTXNWantHScrollBarBit,
   kTXNWantVScrollBarMask = 1L << kTXNWantVScrollBarBit,
   kTXNNoTSMEverMask = 1L << kTXNNoTSMEverBit,
   kTXNReadOnlyMask = 1L << kTXNReadOnlyBit,
   kTXNNoKeyboardSyncMask = 1L << kTXNNoKeyboardSyncBit,
   kTXNNoSelectionMask = 1L << kTXNNoSelectionBit,
   kTXNSaveStylesAsSTYLResourceMask = 1L <<                 kTXNSaveStylesAsSTYLResourceBit,
   kOutputTextInUnicodeEncodingMask = 1L <<             kOutputTextInUnicodeEncodingBit,
   kTXNDoNotInstallDragProcsMask = 1L << kTXNDoNotInstallDragProcsBit,
   kTXNAlwaysWrapAtViewEdgeMask = 1L << kTXNAlwaysWrapAtViewEdgeBit,
   kTXNDontDrawCaretWhenInactiveMask = 1L <<             kTXNDontDrawCaretWhenInactiveBit,
   kTXNDontDrawSelectionWhenInactiveMask = 1L <<             kTXNDontDrawSelectionWhenInactiveBit,
   kTXNSingleLineOnlyMask = 1L << kTXNSingleLineOnlyBit,
   kTXNDisableDragAndDropMask = 1L << kTXNDisableDragAndDropBit,
   kTXNUseQDforImagingMask = 1L << kTXNUseQDforImagingBit,
   kTXNMonostyledTextMask = 1L << kTXNMonostyledTextBit
};


/*TXNMacOSPreferredFontDescription

Contains information about the preferred font, font size, and style for a given text encoding.

struct TXNMacOSPreferredFontDescription {
   UInt32 fontID;
   Fixed pointSize;
   TextEncoding encoding;
   Style fontStyle;
};
typedef struct TXNMacOSPreferredFontDescription  TXNMacOSPreferredFontDescription;
Fields
fontID

The ID of the preferred font. 
pointSize

The point size of the preferred font. 
encoding

The text encoding of the preferred font. 
fontStyle

The font style of the preferred font. 
Discussion

Used in the functions TXNInitTextension, TXNSetFontDefaults, and TXNGetFontDefaults. 
Availability
Available in Mac OS X v10.0 and later.*/

struct TXNMacOSPreferredFontDescription {
   UInt32 fontID;
   Fixed pointSize;
   TextEncoding encoding;
   Style fontStyle;
};
typedef struct TXNMacOSPreferredFontDescription TXNMacOSPreferredFontDescription;

/*TXNMacOSPreferredFontDescription;

Initialization Option Masks

Represents MLTE initialization options.

typedef OptionBits TXNInitOptions;
enum {
   kTXNWantMoviesMask = 1L << kTXNWantMoviesBit,
   kTXNWantSoundMask = 1L << kTXNWantSoundBit,
   kTXNWantGraphicsMask = 1L << kTXNWantGraphicsBit,
   kTXNAlwaysUseQuickDrawTextMask = 1L << kTXNAlwaysUseQuickDrawTextBit,
   kTXNUseTemporaryMemoryMask = 1L << kTXNUseTemporaryMemoryBit
};
Constants
kTXNWantMoviesMask

Use to set or test for the kTXNWantMoviesBit bit.

Available in Mac OS X v10.0 and later.
kTXNWantSoundMask

Use to set or test for the kTXNWantSoundBit bit.

Available in Mac OS X v10.0 and later.
kTXNWantGraphicsMask

Use to set or test for the kTXNWantGraphicsBit bit.

Available in Mac OS X v10.0 and later.
kTXNAlwaysUseQuickDrawTextMask

Use to set or test for the kTXNAlwaysUseQuickDrawTextBit bit. 

Available in Mac OS X v10.0 and later.
kTXNUseTemporaryMemoryMask

Use to set or test for the kTXNUseTemporaryMemoryBit bit.

Available in Mac OS X v10.0 and later.
Discussion

Used in the iUsageFlags parameter of the TXNInitTextension function.*/
typedef OptionBits TXNInitOptions;
enum {
   kTXNWantMoviesMask = 1L << kTXNWantMoviesBit,
   kTXNWantSoundMask = 1L << kTXNWantSoundBit,
   kTXNWantGraphicsMask = 1L << kTXNWantGraphicsBit,
   kTXNAlwaysUseQuickDrawTextMask = 1L << kTXNAlwaysUseQuickDrawTextBit,
   kTXNUseTemporaryMemoryMask = 1L << kTXNUseTemporaryMemoryBit
};


//function

/*TXNRevert

Reverts to the last saved version of a document. 

OSStatus TXNRevert (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNRevert function with files that contain only text as well as files that were created using MLTE. If the file was not previously saved, the document reverts to an empty document. To revert to data that is embedded in a private file type, use the TXNSetSelection function to select all of the current data and then use the TXNSetDataFromFile function to read in the old data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNRevert (
   TXNObject iTXNObject
);

/*TXNPageSetup

Displays the Page Setup dialog for the current default printer and manages changes, such as reformatting the text, in response to page layout changes.

OSStatus TXNPageSetup (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPageSetup (
   TXNObject iTXNObject
);

/*TXNPrint

Prints the document so it is formatted to fit the page size selected for the printer. 

OSStatus TXNPrint (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the document you want to print. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPrint (
   TXNObject iTXNObject
);

/*TXNGetDataEncoded

Copies the text in a specified range, and if necessary, translates the text to match your application’s preferred encoding. 

OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);
Parameters
iTXNObject

The text object that contains the data you want to copy.
iStartOffset

The absolute offset from which data copying should begin. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The absolute offset at which data copying should end. You can use the TXNGetSelection function to get the absolute offsets of the current selection.
oDataHandle

A pointer to a handle. On return, a handle to the requested data. TXNGetDataEncoded allocates the handle as necessary. Your application must dispose of the handle. If there is no text in the range specified, the returned handle is NULL, and the function returns noErr.
encoding

The type of data to be encoded. See Supported Data Types for a full description of possible values. You should specify either the kTXNTextData or kTXNUnicodeTextData constant. If the iEncoding parameter specifies an encoding different from that used to store the text data internally, the Conversion Manager translates the data to the specified type (text or Unicode). If the iEncoding parameter is not recognized, the data is returned in the current encoding. On systems that do not use ATSUI version 1.1 or later, the current encoding is the Mac OS encoding. Otherwise, the current encoding is Unicode. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);

/*HITextViewGetTXNObject

Obtains the text object associated with an HITextView.

TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView)
);
Parameters
inTextView

The HITextView associated with the text object you want to retrieve.
Return Value

Returns the text object associated with the given view.
Discussion

You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. See HITextViewCreate for a list of the functions that return an error if you pass a text object that comes from an HITextView.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView);

/*TXNSetData

Replaces a range of data (text, graphics, and so forth).

OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data.
iDataType

The type of the replacement data. See Supported Data Types for a description of possible values. 
iDataPtr

A pointer to the data that will replace the data that is in the range specified by the iStartOffset and iEndOffset parameters.
iDataSize

The size of the data (in bytes) to which iDataPtr points.
iStartOffset

The beginning of the range of data to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The end of the range to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. If you want to insert text, the ending and starting offsets should be the same value.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

If you have a text object that has word wrap disabled, and you want to avoid horizontal scrolling, you can try the following. After you call the function TXNSetData, call TXNSetSelection with the value of the ending offset set to what it was before you called TXNSetData. Then, call the function TXNShowSelection to scroll the text back into view.

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);

/*TXNSetDataFromCFURLRef

Replaces a range of data with the contents of a file. (Deprecated in Mac OS X v10.4. Use TXNReadFromCFURL instead.)

Not recommended.

OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iURL

A reference to the Core Foundation URL that specifies the file which contains the data you want to add to the object. 
iStartOffset

The starting position at which to insert the file into the document. If you want to replace the current selection, set the iStartOffset parameter to kTXNCurrentSelection. If you want to replace the entire document, set the iStartOffset parameter to 0. Offsets in MLTE are always character offsets.
iEndOffset

The ending position of the range being replaced by the file. You can use the TXNGetSelection function to get the absolute offsets of the current selection. Offsets in MLTE are always character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Your application must open the file and set the iStartOffset parameter to the appropriate value before you call the TXNSetDataFromCFURLRef function. If you want to embed MLTE data within private data or other MLTE data, you must set the file position to the appropriate position.

In the (now deprecated) function TXNNewObject your could pass a file reference and MLTE supported functionality to revert back to the original file reference. When you call the function TXNSetDataFromURLRef, MLTE saves the CFURLRef. If you change the contents of the text object and then call the function TXNRevert, the document reverts to the contents specified by the saved CFURLRef.
Availability
Available in Mac OS X v10.3 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);

/*TXNSetSelection

Specifies the selection range or the position of the insertion point. 

OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set the selection range or insertion point position. 
iStartOffset

The new starting offset. Offset values are character offsets. 
iEndOffset

The new ending offset. Offset values are character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNSetSelection function to highlight an initial default value in a document, such as a data-entry form, or to position the insertion point at the start of the field where you want the user to enter a value. To position the insertion point, specify the same value for the iStartOffset and iEndOffset parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);

/*TXNShowSelection

Scrolls the current selection into view.

void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);
Parameters
iTXNObject

The text object for the current text area. 
iShowEnd

A Boolean value. If you set this to true, the end of the selection is scrolled into view. Otherwise, the beginning of the selection is scrolled into view. 
Discussion

You can use this to scroll text into view after you have called the TXNFind function and the matching text is not in the current view of the text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);

/*TXNWriteRangeToCFURL

Writes a range of a text object to a file or to a special file bundle.

OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
);
Parameters
iTXNObject

The text object having a range that is to be written.
iStartOffset

The offset in iTXNObject at which to start writing data to iFileURL.
iEndOffset

The offset in iTXNObject at which to stop writing data to iFileURL. 
iDataOptions

A CFDictionaryRef that specifies options for writing out the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is written out using MLTE’s native format.
iDocumentAttributes

The document attributes that are to be embedded in the data stream. This parameter is only supported when writing out the data using one of the following formats: RTF and MLTE native format. Only the key / values defined in Document Attribute Keys are written out. The content of the dictionary is ignored for any other format. If the dictionary is NULL, no attributes are added to the data stream.
iFileURL

CFURLRef for an existing file or directory, whichever is appropriate for the file type. On return, iFileURL contains a copy of the data in the given range for the iTXNObject with the format and encoding specified by iDataOptions. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function writes a range of a text object to a file or a special file bundle (directory). It supports several document formats and encodings, which can be specified in the data options dictionary. Clients can specify additional document attributes when data is written out using a file format, such as RTF and native MLTE file format) that supports such attributes.
Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
);

/*TXNReadFromCFURL

Reads data from a CFURLRef into a TXNObject.

OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
);
Parameters
iTXNObject

The text object into which data read from iFileURL is to be added.
iStartOffset

The offset in iTXNObject at which to start placing data read from iFileURL.
iEndOffset

The offset in iTXNObject at which to stop placing data read from iFileURL. 
iDataOptions

Options for reading the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is read in using MLTE’s native format.
iFileURL

A CFURLRef to the data that is to be added to the text object specified by inTXNObject.
oDocumentAttributes

A value of type CFDictionary that, on return, contains the document attributes present in the data stream, if the file format supports them; otherwise this parameter is NULL. The native MLTE file format and RTF support embedded document attributes. See Document Attribute Keys for a list of supported attributes. If this parameter is NULL, no document attributes are written out.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function reads data from a file or a special file bundle (directory) into a text object. Offset parameters are used to specify whether the new data is inserted, appended or replaces an existing data range in the text object. Clients can specify the document format and encoding of the data using the iDataOptions parameter. This functions also returns the document attributes present in the data stream. Document attributes are supported only for the rich text file formats supported by MLTE, which are RTF and MLTE native file format.

If the caller passes a pointer to a CFDictionaryRef, this function returns a reference to a dictionary of attributes, if there is one, that the caller is responsible for releasing. In all other cases, this function sets the reference to NULL. Here is some sample code:CFDictionaryRef oDocumentAttributes = NULL;
status = TXNReadFromCFRUL (....,&oDocumentAttributes);
if (oDocumentAttributes != NULL) ::CFReleases(oDocumentAttributes);

Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
);

/*HITextViewCreate

Creates an HITextView that is initially invisible.

OSStatus HITextViewCreate(
   const HIRect    *inBoundsRect,
   OptionBits      inOptions,
   TXNFrameOptions inTXNFrameOptions,
   HIViewRef       *outTextView
);
Parameters
inBoundsRect

The bounding box of the view. Pass NULL, if you want to initialize the bounds of the view to 0.
inOptions

Reserved for future use; you must pass 0.
inTXNFrameOptions

The frame options you want to set for the text view. 
outTextView

On output, points to the newly-created text view. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

An HITextView is an MLTE text view that can be embedded in the HIView hierarchy. The view can be embedded in an HIScrollView if you want scroll bars and can also be used in a composited window. For more information on HIView, see the document Introducing HIView, available from the Apple Developer Documentation website.

When you call the function HITextViewCreate to create a text view, an MLTE text object (TXNObject) is allocated and attached to the text view. You can extract the text object by calling the function HITextViewGetTXNObject. You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. 

The following MLTE functions return an error if you pass a text object that comes from an HITextView:
TXNAttachObjectToWindowRef
TXNGetWindowRef
TXNDrawObject
TXNSetScrollbarState
TXNGrowWindow
TXNZoomWindow
TXNResizeFrame
TXNSetFrameBounds
TXNSetViewRect
TXNDraw
TXNFocus
TXNUpdate
TXNForceUpdate
TXNPageSetup
TXNPrint
TXNIdle
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
OSStatus HITextViewCreate(
   const HIRect    *inBoundsRect,
   OptionBits      inOptions,
   TXNFrameOptions inTXNFrameOptions,
   HIViewRef       *outTextView
);

/*TXNInitTextension

Initializes MLTE. 

OSStatus TXNInitTextension (
   const TXNMacOSPreferredFontDescription iDefaultFonts[],
   ItemCount iCountDefaultFonts,
   TXNInitOptions iUsageFlags
);
Parameters
iDefaultFonts

An array of TXNMacOSPreferredFontDescription structures. You use this to specify a table of font information that includes the font family ID, point size, style, and script code. The table can be NULL or can have an entry for any script for which you would like to designate a default font. To designate that MLTE should use the default settings for a specified script, you need to supply a valid script code value in the TextEncoding field of the font description structure and a value of kTXNUseScriptDefaultValue in all other fields of the structure. In Mac OS X, the default settings are read from the Theme settings. In Mac OS 9, the default settings are read from the Script Manager.
iCountDefaultFonts

The number of scripts for which you are designating a default font in the iDefaultFonts array. 
iUsageFlags

A value that specifies whether embedded objects should be supported. You can also specify whether MLTE should use QuickDraw as the imaging system and whether temporary memory should be used. See Initialization Option Masks for a description of possible values. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

For systems prior to Mac OS X v10.3, you should call this function along with any other initialization calls you make when your application starts up. If you call this function a second time, it has no effect; the defaults you set up the first time you called the TXNInitTextension function are in effect until you call the TXNTerminateTextension function.

For Mac OS X v10.3 and later, you do not have to call this function. However, you may want to call this function to set default fonts that are different from the system default font or to enable multimedia support.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/

OSStatus TXNInitTextension (
   const TXNMacOSPreferredFontDescription iDefaultFonts[],
   ItemCount iCountDefaultFonts,
   TXNInitOptions iUsageFlags
);


#ifdef __cplusplus
}
#endif
#endif