#ifndef OPENTRANSPORT_H
#define OPENTRANSPORT_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef MACERRORS_H
#include <CarbonCore/MacErrors.h>
#endif

#ifdef __cplusplus
#include <stddef.h>
#endif

#include <asm-generic/errno-base.h> //hys
#include <asm-generic/errno.h> //hys

#include <HYS/OSServices/OpenTransport.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*OTLink

Allows any data structure to be used in an Open Transport list.

struct OTLink {
   OTLink * fNext;
};
typedef struct OTLink OTLink;
Fields
fNext

A pointer to the next entry in the linked list. 
Discussion

All of Open Transport’s list utilities use the linked list structure, which may be embedded in any data structure that you want to use in an Open Transport list. A linked list structure is defined by the OTLink data type.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OTLink OTLink;

struct OTLink {
   OTLink * fNext;
};



/*kOTInvalidRef


enum {
   kOTInvalidRef = 0,
   kOTInvalidProviderRef = 0,
   kOTInvalidEndpointRef = 0,
   kOTInvalidMapperRef = 0
};
Constants
kOTInvalidRef

Available in Mac OS X v10.0 and later.
kOTInvalidProviderRef

Available in Mac OS X v10.0 and later.
kOTInvalidEndpointRef

Available in Mac OS X v10.0 and later.
kOTInvalidMapperRef

Available in Mac OS X v10.0 and later.*/
enum {
   kOTInvalidRef = 0,
   kOTInvalidProviderRef = 0,
   kOTInvalidEndpointRef = 0,
   kOTInvalidMapperRef = 0
};


/*kOTNetbufDataIsOTBufferStar


enum {
   kOTNetbufDataIsOTBufferStar = 0xFFFFFFFD
};
Constants
kOTNetbufDataIsOTBufferStar

Available in Mac OS X v10.0 and later.*/

enum {
   kOTNetbufDataIsOTBufferStar = 0xFFFFFFFD
};



/*Event Codes

Define the constant names that provider functions can use for event codes, or define port-related events Open Transport can send to an client application.

typedef UInt32 OTEventCode;
enum {
   T_LISTEN = 0x0001,
   T_CONNECT = 0x0002,
   T_DATA = 0x0004,
   T_EXDATA = 0x0008,
   T_DISCONNECT = 0x0010,
   T_ERROR = 0x0020,
   T_UDERR = 0x0040,
   T_ORDREL = 0x0080,
   T_GODATA = 0x0100,
   T_GOEXDATA = 0x0200,
   T_REQUEST = 0x0400,
   T_REPLY = 0x0800,
   T_PASSCON = 0x1000,
   T_RESET = 0x2000,
   kPRIVATEEVENT = 0x10000000,
   kCOMPLETEEVENT = 0x20000000,
   T_BINDCOMPLETE = 0x20000001,
   T_UNBINDCOMPLETE = 0x20000002,
   T_ACCEPTCOMPLETE = 0x20000003,
   T_REPLYCOMPLETE = 0x20000004,
   T_DISCONNECTCOMPLETE = 0x20000005,
   T_OPTMGMTCOMPLETE = 0x20000006,
   T_OPENCOMPLETE = 0x20000007,
   T_GETPROTADDRCOMPLETE = 0x20000008,
   T_RESOLVEADDRCOMPLETE = 0x20000009,
   T_GETINFOCOMPLETE = 0x2000000A,
   T_SYNCCOMPLETE = 0x2000000B,
   T_MEMORYRELEASED = 0x2000000C,
   T_REGNAMECOMPLETE = 0x2000000D,
   T_DELNAMECOMPLETE = 0x2000000E,
   T_LKUPNAMECOMPLETE = 0x2000000F,
   T_LKUPNAMERESULT = 0x20000010,
   kOTSyncIdleEvent = 0x20000011,
   kSTREAMEVENT = 0x21000000,
   kOTReservedEvent1 = 0x21000001,
   kGetmsgEvent = 0x21000002,
   kStreamReadEvent = 0x21000003,
   kStreamWriteEvent = 0x21000004,
   kStreamIoctlEvent = 0x21000005,
   kOTReservedEvent2 = 0x21000006,
   kStreamOpenEvent = 0x21000007,
   kPollEvent = 0x21000008,
   kOTReservedEvent3 = 0x21000009,
   kOTReservedEvent4 = 0x2100000A,
   kOTReservedEvent5 = 0x2100000B,
   kOTReservedEvent6 = 0x2100000C,
   kOTReservedEvent7 = 0x2100000D,
   kOTReservedEvent8 = 0x2100000E,
   kSIGNALEVENT = 0x22000000,
   kPROTOCOLEVENT = 0x23000000,
   kOTProviderIsDisconnected = 0x23000001,
   kOTProviderIsReconnected = 0x23000002,
   kOTProviderWillClose = 0x24000001,
   kOTProviderIsClosed = 0x24000002,
   kOTPortDisabled = 0x25000001,
   kOTPortEnabled = 0x25000002,
   kOTPortOffline = 0x25000003,
   kOTPortOnline = 0x25000004,
   kOTClosePortRequest = 0x25000005,
   kOTYieldPortRequest = 0x25000005,
   kOTNewPortRegistered = 0x25000006,
   kOTPortNetworkChange = 0x25000007,
   kOTConfigurationChanged = 0x26000001,
   kOTSystemSleep = 0x26000002,
   kOTSystemShutdown = 0x26000003,
   kOTSystemAwaken = 0x26000004,
   kOTSystemIdle = 0x26000005,
   kOTSystemSleepPrep = 0x26000006,
   kOTSystemShutdownPrep = 0x26000007,
   kOTSystemAwakenPrep = 0x26000008,
   kOTStackIsLoading = 0x27000001,
   kOTStackWasLoaded = 0x27000002,
   kOTStackIsUnloading = 0x27000003
};
   
/*  The following event codes are used internally by Open Transport.*
enum {
   kOTDisablePortEvent = 0x21000001,
   kStreamCloseEvent = 0x21000006,
   kBackgroundStreamEvent = 0x21000009,
   kIoctlRecvFdEvent = 0x2100000A,
   kOTTryShutdownEvent = 0x2100000B,
   kOTScheduleTerminationEvent = 0x2100000C,
   kOTEnablePortEvent = 0x2100000D,
   kOTNewPortRegisteredEvent = 0x2100000E,
   kOTPortOfflineEvent = 0x2100000F,
   kOTPortOnlineEvent = 0x21000010,
   kOTPortNetworkChangeEvent = 0x21000011
};
Constants
T_LISTEN

A connection request has arrived. Call the OTListen function to read the request.

Available in Mac OS X v10.0 and later.
T_CONNECT

The passive peer has accepted a connection that you requested using the OTConnect function. Call the OTRcvConnect function to retrieve any data or option information that the passive peer has specified when accepting the connection or to retrieve the address to which you are actually connected. The cookie parameter to the notifier function is the sndCall parameter that you specified when calling the OTConnect function. 

Available in Mac OS X v10.0 and later.
T_DATA

Normal data has arrived. Depending on the type of service of the endpoint you are using, you can call the OTRcvUData function or the OTRcv function to read it. Continue reading data until the function returns with the kOTNoDataErr result; you will not get another indication that data has arrived until you have read all the data and got this error.

Available in Mac OS X v10.0 and later.
T_EXDATA

Expedited data has arrived. Use the OTRcv function to read it. Continue reading data by calling the OTRcv function until the function returns with the kOTNoDataErr result; you will not get another indication that data has arrived until you have read all the data and got this error.

Available in Mac OS X v10.0 and later.
T_DISCONNECT

A connection has been torn down or rejected. Use the OTRcvDisconnect function to clear the event.

If the event is used to signify that a connection has been terminated, the cookie parameter to the notifier is NULL.

If the event indicates a rejected connection request, the cookie parameter to the notification routine is the same as the sndCall parameter that you passed to the OTConnect function.

Available in Mac OS X v10.0 and later.
T_ERROR

Obsolete.

Available in Mac OS X v10.0 and later.
T_UDERR

The provider was not able to send the data you specified using the OTSndUData function even though the function returned successfully. You must call the OTRcvUDErr function to clear this event and determine why the function failed.

Available in Mac OS X v10.0 and later.
T_ORDREL

The remote client has called the OTSndOrderlyDisconnect function to initiate an orderly disconnect. You must call the OTRcvOrderlyDisconnect function to acknowledge receiving the event.

Available in Mac OS X v10.0 and later.
T_GODATA

Flow-control restrictions have been lifted. You can now send normal data.

Available in Mac OS X v10.0 and later.
T_GOEXDATA

Flow-control restrictions have been lifted. You can now send expedited data.

Available in Mac OS X v10.0 and later.
T_REQUEST

A request has arrived. Depending on the type of service for the endpoint you are using, you can call the OTRcvRequest function or the OTRcvURequest function to receive it. You must continue to call the function until it returns with the kOTNoDataErr result. 

Available in Mac OS X v10.0 and later.
T_REPLY

A response to a request has arrived. Depending on the type of service of the endpoint you are using, you can call the OTRcvReply function or OTRcvUReply function to receive it. You must continue to call the function until it returns with the kOTNoDataErr result.

Available in Mac OS X v10.0 and later.
T_PASSCON

When the OTAccept function completes, the endpoint provider passes this event to the endpoint receiving the connection (whether that endpoint is the same as or different from the endpoint that calls the OTAccept function). The cookie parameter contains the resRef parameter to the OTAccept function.

Available in Mac OS X v10.0 and later.
T_RESET

A connection-oriented endpoint has received a reset from the remote end and has flushed all unread and unsent data. This only occurs for some types of endpoints, and it generally leaves the endpoint in an unknown state.

Available in Mac OS X v10.0 and later.
kPRIVATEEVENT

Available in Mac OS X v10.0 and later.
kCOMPLETEEVENT

Available in Mac OS X v10.0 and later.
T_BINDCOMPLETE

The OTBind function has completed. The cookie parameter contains the retAddr parameter of the bind call.

Available in Mac OS X v10.0 and later.
T_UNBINDCOMPLETE

The OTUnbind function has completed. The cookie parameter is meaningless.

Available in Mac OS X v10.0 and later.
T_ACCEPTCOMPLETE

The OTAccept function has completed. The cookie parameter contains the resRef parameter to the OTAccept function. 

Available in Mac OS X v10.0 and later.
T_REPLYCOMPLETE

The OTSndUReply or OTSndReply functions have completed. The cookie parameter contains the sequence number used in the OTSndUReply or OTSndReply call. 

Available in Mac OS X v10.0 and later.
T_DISCONNECTCOMPLETE

The OTSndDisconnect function has completed. The cookie parameter contains the call parameter of the OTSndDisconnect function.

Available in Mac OS X v10.0 and later.
T_OPTMGMTCOMPLETE

The OTOptionManagement function has completed. The cookie parameter contains the ret parameter that you passed to the function.

Available in Mac OS X v10.0 and later.
T_OPENCOMPLETE

An asynchronous call to open a provider has completed. The cookie parameter contains the provider reference.

Available in Mac OS X v10.0 and later.
T_GETPROTADDRCOMPLETE

The OTGetProtAddress function has completed. The cookie parameter contains the peerAddr parameter that you passed to the OTGetProtocolAddress function. If you passed NULL for that parameter, the cookie parameter contains the address passed in the boundAddr parameter.

Available in Mac OS X v10.0 and later.
T_RESOLVEADDRCOMPLETE

The OTResolveAddress function has completed. The cookie parameter contains the retAddr parameter of the OTResolveAddress function.

Available in Mac OS X v10.0 and later.
T_GETINFOCOMPLETE

The OTGetEndpointInfo function has completed. The cookie parameter contains the info parameter of the OTGetEndpointInfo function.

Available in Mac OS X v10.0 and later.
T_SYNCCOMPLETE

The OTSync function has completed. The cookie parameter is meaningless.

Available in Mac OS X v10.0 and later.
T_MEMORYRELEASED

You are using an asynchronous endpoint that acknowledges sends and Open Transport is done using the buffers containing the data you are sending. If you called the OTSnd function, the cookie parameter contains the buf parameter. If you called the OTSndUData function, the cookie parameter contains the udata parameter. The result parameter contains the number of bytes that were sent. This might be less than the number you meant to send due to flow-control or memory restrictions.

You should not wait for the T_MEMORYRELEASED event from a previous send operation to trigger more sends. The exact time this event occurs depends on how the underlying provider is implemented. It might hold on to memory until the next send occurs, or behave in some other way which causes it to delay releasing memory.

Note that T_MEMORYRELEASED events can reenter your notifier. See OTAckSendsfor more information.

Available in Mac OS X v10.0 and later.
T_REGNAMECOMPLETE

The OTRegisterName function has completed. The cookie parameter is the reply parameter, unless it was NULL. In this case, it is the req parameter.

Available in Mac OS X v10.0 and later.
T_DELNAMECOMPLETE

The OTDeleteName function or the OTDeleteNameByID function has completed. The cookie parameter contains the name parameter or the nameId parameter of the function, respectively. 

Available in Mac OS X v10.0 and later.
T_LKUPNAMECOMPLETE

The OTLookupName function has completed. The cookie parameter contains the reply parameter of the OTLookUpName function.

Available in Mac OS X v10.0 and later.
T_LKUPNAMERESULT

An OTLookupName function has found a name and is returning it, but the lookup is not yet complete. The cookie parameter contains the reply parameter passed to the OTLookupName function.

Available in Mac OS X v10.0 and later.
kOTSyncIdleEvent

A synchronous call is waiting to complete.

Available in Mac OS X v10.0 and later.
kSTREAMEVENT

Available in Mac OS X v10.0 and later.
kOTReservedEvent1

Available in Mac OS X v10.0 and later.
kGetmsgEvent

Available in Mac OS X v10.0 and later.
kStreamReadEvent

Available in Mac OS X v10.0 and later.
kStreamWriteEvent

Available in Mac OS X v10.0 and later.
kStreamIoctlEvent

Available in Mac OS X v10.0 and later.
kOTReservedEvent2

Available in Mac OS X v10.0 and later.
kStreamOpenEvent

Available in Mac OS X v10.0 and later.
kPollEvent

Available in Mac OS X v10.0 and later.
kOTReservedEvent3

Available in Mac OS X v10.0 and later.
kOTReservedEvent4

Available in Mac OS X v10.0 and later.
kOTReservedEvent5

Available in Mac OS X v10.0 and later.
kOTReservedEvent6

Available in Mac OS X v10.0 and later.
kOTReservedEvent7

Available in Mac OS X v10.0 and later.
kOTReservedEvent8

Available in Mac OS X v10.0 and later.
kSIGNALEVENT

Available in Mac OS X v10.0 and later.
kPROTOCOLEVENT

Available in Mac OS X v10.0 and later.
kOTProviderIsDisconnected

Your provider was bound with a qlen parameter value greater than 0 and it has been disconnected (is no longer listening). You receive this event after a port has accepted a request to temporarily yield ownership of a port to another provider, which causes this provider to be disconnected from the port in question. This currently only happens with serial ports, but could also happen with other connection-oriented drivers that have characteristics similar to serial ports. You get a kOTProviderIsReconnected message when the port reverts back to this provider’s ownership.

Available in Mac OS X v10.0 and later.
kOTProviderIsReconnected

Your provider has been reconnected, that is, the cause for its disconnection has been relieved.

Available in Mac OS X v10.0 and later.
kOTProviderWillClose

When you return from the notifier function, Open Transport will close the provider whose reference is contained in the cookie parameter. The result parameter contains a result code specifying the reason why the provider had to close. For example, the user may have decided to switch links using the TCP/IP or AppleTalk control panel. The result codes that can be returned are in the range –3280 through –3285; these are documented in “Open Transport Result Codes”.

You can only get this event at system task time. Consequently, you are allowed to set the endpoint to synchronous mode (from within the notifier function) and call functions synchronously before you return from the notifier, at which point the provider is closed. After this, any calls other than OTCloseProvider will fail with a kOTOutStateErr error.

Available in Mac OS X v10.0 and later.
kOTProviderIsClosed

The provider has closed. The reason for being closed can be found in the OTResult value passed to your notifier. The reasons typically are kOTPortHasDiedErr, kOTPortWasEjectedErr, or kOTPortLostConnectionErr. At this point, any calls other than OTCloseProvider will fail with a kOTOutStateErr error.

Available in Mac OS X v10.0 and later.
kOTPortDisabled

A port has gone off line, as when the user removes a PCMCIA card while the computer is running. The OTResult parameter specifies the reason, if known, and the cookie parameter provides the port reference of the port that went off line. A port going off line often results in providers getting kOTProviderIsClosed events. There is no guarantee in Open Transport as to which of these events will be received first.

Available in Mac OS X v10.0 and later.
kOTPortEnabled

A port that had previously been disabled is now reenabled, as when the user reinserts a previously removed PCMCIA card while the computer is running. The cookie parameter is the port reference of the port that is now enabled.

Available in Mac OS X v10.0 and later.
kOTPortOffline

The port is now offline.

Available in Mac OS X v10.0 and later.
kOTPortOnline

A request has been made to close or yield this port.

Available in Mac OS X v10.0 and later.
kOTClosePortRequest

You currently are using a provider that is using a port that some other application wants to use. The OTResult parameter is the reason for the request (normally kOTNoError or kOTUserRequestedErr), and the cookie parameter is a pointer to an OTPortCloseStruct structure. 

Available in Mac OS X v10.0 and later.
kOTYieldPortRequest

Available in Mac OS X v10.0 and later.
kOTNewPortRegistered

A new port has been registered with Open Transport, as when the user inserts a new PCMCIA card. The cookie parameter is the port reference of the new port. Your provider receives this event the first time a new port is enabled. Subsequently, if a port is reenabled after being disabled, you receive the kOTPortEnabled event instead. 

Available in Mac OS X v10.0 and later.
kOTPortNetworkChange

Available in Mac OS X v10.0 and later.
kOTConfigurationChanged

Available in Mac OS X v10.0 and later.
kOTSystemSleep

Available in Mac OS X v10.0 and later.
kOTSystemShutdown

Available in Mac OS X v10.0 and later.
kOTSystemAwaken

Available in Mac OS X v10.0 and later.
kOTSystemIdle

Available in Mac OS X v10.0 and later.
kOTSystemSleepPrep

Available in Mac OS X v10.0 and later.
kOTSystemShutdownPrep

Available in Mac OS X v10.0 and later.
kOTSystemAwakenPrep

Available in Mac OS X v10.0 and later.
kOTStackIsLoading

Available in Mac OS X v10.0 and later.
kOTStackWasLoaded

Available in Mac OS X v10.0 and later.
kOTStackIsUnloading

Available in Mac OS X v10.0 and later.
kOTDisablePortEvent

Available in Mac OS X v10.0 and later.
kStreamCloseEvent

Available in Mac OS X v10.0 and later.
kBackgroundStreamEvent

Available in Mac OS X v10.0 and later.
kIoctlRecvFdEvent

Available in Mac OS X v10.0 and later.
kOTTryShutdownEvent

Available in Mac OS X v10.0 and later.
kOTScheduleTerminationEvent

Available in Mac OS X v10.0 and later.
kOTEnablePortEvent

Available in Mac OS X v10.0 and later.
kOTNewPortRegisteredEvent

Available in Mac OS X v10.0 and later.
kOTPortOfflineEvent

Available in Mac OS X v10.0 and later.
kOTPortOnlineEvent

Available in Mac OS X v10.0 and later.
kOTPortNetworkChangeEvent

Available in Mac OS X v10.0 and later.*/


typedef UInt32 OTEventCode;
enum {
   T_LISTEN = 0x0001,
   T_CONNECT = 0x0002,
   T_DATA = 0x0004,
   T_EXDATA = 0x0008,
   T_DISCONNECT = 0x0010,
   T_ERROR = 0x0020,
   T_UDERR = 0x0040,
   T_ORDREL = 0x0080,
   T_GODATA = 0x0100,
   T_GOEXDATA = 0x0200,
   T_REQUEST = 0x0400,
   T_REPLY = 0x0800,
   T_PASSCON = 0x1000,
   T_RESET = 0x2000,
   kPRIVATEEVENT = 0x10000000,
   kCOMPLETEEVENT = 0x20000000,
   T_BINDCOMPLETE = 0x20000001,
   T_UNBINDCOMPLETE = 0x20000002,
   T_ACCEPTCOMPLETE = 0x20000003,
   T_REPLYCOMPLETE = 0x20000004,
   T_DISCONNECTCOMPLETE = 0x20000005,
   T_OPTMGMTCOMPLETE = 0x20000006,
   T_OPENCOMPLETE = 0x20000007,
   T_GETPROTADDRCOMPLETE = 0x20000008,
   T_RESOLVEADDRCOMPLETE = 0x20000009,
   T_GETINFOCOMPLETE = 0x2000000A,
   T_SYNCCOMPLETE = 0x2000000B,
   T_MEMORYRELEASED = 0x2000000C,
   T_REGNAMECOMPLETE = 0x2000000D,
   T_DELNAMECOMPLETE = 0x2000000E,
   T_LKUPNAMECOMPLETE = 0x2000000F,
   T_LKUPNAMERESULT = 0x20000010,
   kOTSyncIdleEvent = 0x20000011,
   kSTREAMEVENT = 0x21000000,
   kOTReservedEvent1 = 0x21000001,
   kGetmsgEvent = 0x21000002,
   kStreamReadEvent = 0x21000003,
   kStreamWriteEvent = 0x21000004,
   kStreamIoctlEvent = 0x21000005,
   kOTReservedEvent2 = 0x21000006,
   kStreamOpenEvent = 0x21000007,
   kPollEvent = 0x21000008,
   kOTReservedEvent3 = 0x21000009,
   kOTReservedEvent4 = 0x2100000A,
   kOTReservedEvent5 = 0x2100000B,
   kOTReservedEvent6 = 0x2100000C,
   kOTReservedEvent7 = 0x2100000D,
   kOTReservedEvent8 = 0x2100000E,
   kSIGNALEVENT = 0x22000000,
   kPROTOCOLEVENT = 0x23000000,
   kOTProviderIsDisconnected = 0x23000001,
   kOTProviderIsReconnected = 0x23000002,
   kOTProviderWillClose = 0x24000001,
   kOTProviderIsClosed = 0x24000002,
   kOTPortDisabled = 0x25000001,
   kOTPortEnabled = 0x25000002,
   kOTPortOffline = 0x25000003,
   kOTPortOnline = 0x25000004,
   kOTClosePortRequest = 0x25000005,
   kOTYieldPortRequest = 0x25000005,
   kOTNewPortRegistered = 0x25000006,
   kOTPortNetworkChange = 0x25000007,
   kOTConfigurationChanged = 0x26000001,
   kOTSystemSleep = 0x26000002,
   kOTSystemShutdown = 0x26000003,
   kOTSystemAwaken = 0x26000004,
   kOTSystemIdle = 0x26000005,
   kOTSystemSleepPrep = 0x26000006,
   kOTSystemShutdownPrep = 0x26000007,
   kOTSystemAwakenPrep = 0x26000008,
   kOTStackIsLoading = 0x27000001,
   kOTStackWasLoaded = 0x27000002,
   kOTStackIsUnloading = 0x27000003
};
   
/*   The following event codes are used internally by Open Transport.*/
enum {
   kOTDisablePortEvent = 0x21000001,
   kStreamCloseEvent = 0x21000006,
   kBackgroundStreamEvent = 0x21000009,
   kIoctlRecvFdEvent = 0x2100000A,
   kOTTryShutdownEvent = 0x2100000B,
   kOTScheduleTerminationEvent = 0x2100000C,
   kOTEnablePortEvent = 0x2100000D,
   kOTNewPortRegisteredEvent = 0x2100000E,
   kOTPortOfflineEvent = 0x2100000F,
   kOTPortOnlineEvent = 0x21000010,
   kOTPortNetworkChangeEvent = 0x21000011
};


/*OTSequence


typedef SInt32 OTSequence;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 OTSequence;

/*OTQLen


typedef UInt32 OTQLen;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTQLen;

/*OTAddressType


typedef UInt16 OTAddressType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 OTAddressType;

/*No-Copy Receive Buffer Structure

Receives data without copying it.

struct OTBuffer {
   void * fLink;
   void * fLink2;
   OTBuffer * fNext;
   UInt8 * fData;
   ByteCount fLen;
   void * fSave;
   UInt8 fBand;
   UInt8 fType;
   UInt8 fPad1;
   UInt8 fFlags;
};
typedef struct OTBuffer OTBuffer;
Fields
fLink

Reserved.
fLink2

Reserved.
fNext

A pointer to the next OTBuffer structure in the linked chain. By tracing the chain of fNext pointers, you can access all of the data associated with the message. 
fData

A pointer to the data portion of this OTBuffer structure.
fLen

The length of data pointed to by the fData field.
fSave

Reserved.
fBand

The band used for the data transmission. It must be a value between 0 and 255.
fType

The type of the data (normally M_DATA, M_PROTO, or M_PCPROTO).
fPad1

Reserved.
fFlags

The flags associated with the data (MSGMARK, MSGDELIM).
Discussion

You use the no-copy receive buffer structure when you wish to receive data without copying it with the OTRcvUData function, the OTRcvURequest function, the OTRcvUReply function, the OTRcv function, the OTRcvRequest function, and the OTRcvReply function. 

If you are familiar with STREAMS mblk_t data structures, you can see that the no-copy receive buffer structure is just a slight modification of the mblk_t structure.

You can only use this buffer for data; you cannot use it for the address or options that may be associated with the incoming data. For example, in the case of an incoming TUnitData structure, you can only no-copy receive the udata portion, not the addr or opt fields. 
Special Considerations

Under no circumstance write to this data structure. It is read-only. If you write to it, you can crash the system.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OTBuffer OTBuffer;

struct OTBuffer {
   void * fLink;
   void * fLink2;
   OTBuffer * fNext;
   UInt8 * fData;
   ByteCount fLen;
   void * fSave;
   UInt8 fBand;
   UInt8 fType;
   UInt8 fPad1;
   UInt8 fFlags;
};



/*OTEventCode


typedef UInt32 OTEventCode;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTEventCode;

/*kT_UNSPEC


enum {
   kT_UNSPEC = 0xFFFFFFFD,
   T_ALLOPT = 0
};
Constants
kT_UNSPEC

Available in Mac OS X v10.0 and later.
T_ALLOPT

Available in Mac OS X v10.0 and later*/
enum {
   kT_UNSPEC = 0xFFFFFFFD,
   T_ALLOPT = 0
};


/*OTXTIName


typedef UInt32 OTXTIName;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTXTIName;

/*OTXTILevel


typedef UInt32 OTXTILevel;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTXTILevel;

/*OTResult


typedef SInt32 OTResult;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 OTResult;

/*EPERM


enum {
   EPERM = 1,
   ENOENT = 2,
   ENORSRC = 3,
   EINTR = 4,
   EIO = 5,
   ENXIO = 6,
   EBADF = 9,
   EAGAIN = 11,
   ENOMEM = 12,
   EACCES = 13,
   EFAULT = 14,
   EBUSY = 16,
   EEXIST = 17,
   ENODEV = 19,
   EINVAL = 22,
   ENOTTY = 25,
   EPIPE = 32,
   ERANGE = 34,
   EDEADLK = 35,
   EWOULDBLOCK = 35,
   EALREADY = 37,
   ENOTSOCK = 38,
   EDESTADDRREQ = 39,
   EMSGSIZE = 40,
   EPROTOTYPE = 41,
   ENOPROTOOPT = 42,
   EPROTONOSUPPORT = 43,
   ESOCKTNOSUPPORT = 44,
   EOPNOTSUPP = 45,
   EADDRINUSE = 48,
   EADDRNOTAVAIL = 49,
   ENETDOWN = 50,
   ENETUNREACH = 51,
   ENETRESET = 52,
   ECONNABORTED = 53,
   ECONNRESET = 54,
   ENOBUFS = 55,
   EISCONN = 56,
   ENOTCONN = 57,
   ESHUTDOWN = 58,
   ETOOMANYREFS = 59,
   ETIMEDOUT = 60,
   ECONNREFUSED = 61,
   EHOSTDOWN = 64,
   EHOSTUNREACH = 65,
   EPROTO = 70,
   ETIME = 71,
   ENOSR = 72,
   EBADMSG = 73,
   ECANCEL = 74,
   ENOSTR = 75,
   ENODATA = 76,
   EINPROGRESS = 77,
   ESRCH = 78,
   ENOMSG = 79,
   ELASTERRNO = 79
};
Constants
EPERM

Available in Mac OS X v10.0 and later.
ENOENT

Available in Mac OS X v10.0 and later.
ENORSRC

Available in Mac OS X v10.0 and later.
EINTR

Available in Mac OS X v10.0 and later.
EIO

Available in Mac OS X v10.0 and later.
ENXIO

Available in Mac OS X v10.0 and later.
EBADF

Available in Mac OS X v10.0 and later.
EAGAIN

Available in Mac OS X v10.0 and later.
ENOMEM

Available in Mac OS X v10.0 and later.
EACCES

Available in Mac OS X v10.0 and later.
EFAULT

Available in Mac OS X v10.0 and later.
EBUSY

Available in Mac OS X v10.0 and later.
EEXIST

Available in Mac OS X v10.0 and later.
ENODEV

Available in Mac OS X v10.0 and later.
EINVAL

Available in Mac OS X v10.0 and later.
ENOTTY

Available in Mac OS X v10.0 and later.
EPIPE

Available in Mac OS X v10.0 and later.
ERANGE

Available in Mac OS X v10.0 and later.
EDEADLK

Available in Mac OS X v10.0 and later.
EWOULDBLOCK

Available in Mac OS X v10.0 and later.
EALREADY

Available in Mac OS X v10.0 and later.
ENOTSOCK

Available in Mac OS X v10.0 and later.
EDESTADDRREQ

Available in Mac OS X v10.0 and later.
EMSGSIZE

Available in Mac OS X v10.0 and later.
EPROTOTYPE

Available in Mac OS X v10.0 and later.
ENOPROTOOPT

Available in Mac OS X v10.0 and later.
EPROTONOSUPPORT

Available in Mac OS X v10.0 and later.
ESOCKTNOSUPPORT

Available in Mac OS X v10.0 and later.
EOPNOTSUPP

Available in Mac OS X v10.0 and later.
EADDRINUSE

Available in Mac OS X v10.0 and later.
EADDRNOTAVAIL

Available in Mac OS X v10.0 and later.
ENETDOWN

Available in Mac OS X v10.0 and later.
ENETUNREACH

Available in Mac OS X v10.0 and later.
ENETRESET

Available in Mac OS X v10.0 and later.
ECONNABORTED

Available in Mac OS X v10.0 and later.
ECONNRESET

Available in Mac OS X v10.0 and later.
ENOBUFS

Available in Mac OS X v10.0 and later.
EISCONN

Available in Mac OS X v10.0 and later.
ENOTCONN

Available in Mac OS X v10.0 and later.
ESHUTDOWN

Available in Mac OS X v10.0 and later.
ETOOMANYREFS

Available in Mac OS X v10.0 and later.
ETIMEDOUT

Available in Mac OS X v10.0 and later.
ECONNREFUSED

Available in Mac OS X v10.0 and later.
EHOSTDOWN

Available in Mac OS X v10.0 and later.
EHOSTUNREACH

Available in Mac OS X v10.0 and later.
EPROTO

Available in Mac OS X v10.0 and later.
ETIME

Available in Mac OS X v10.0 and later.
ENOSR

Available in Mac OS X v10.0 and later.
EBADMSG

Available in Mac OS X v10.0 and later.
ECANCEL

Available in Mac OS X v10.0 and later.
ENOSTR

Available in Mac OS X v10.0 and later.
ENODATA

Available in Mac OS X v10.0 and later.
EINPROGRESS

Available in Mac OS X v10.0 and later.
ESRCH

Available in Mac OS X v10.0 and later.
ENOMSG

Available in Mac OS X v10.0 and later.
ELASTERRNO

Available in Mac OS X v10.0 and later.*/
//enum {
  // EPERM =  1, //defined  asm-generic/errno-base.h
   //ENOENT = 2,//defined  asm-generic/errno-base.h
   //ENORSRC = 3,
   //EINTR = 4,//defined  asm-generic/errno-base.h
   //EIO = 5,
   //ENXIO = 6,
   //EBADF = 9,
   //EAGAIN = 11,
   //ENOMEM = 12,
   //EACCES = 13,
   //EFAULT = 14,
   //EBUSY = 16,
   //EEXIST = 17,
   //ENODEV = 19,
   //EINVAL = 22,
   //ENOTTY = 25,
   //EPIPE = 32,
   //ERANGE = 34,
   //EDEADLK = 35,
   //EWOULDBLOCK = 35,
   //EALREADY = 37,
   //ENOTSOCK = 38,
   //EDESTADDRREQ = 39,
   //EMSGSIZE = 40,
   //EPROTOTYPE = 41,
   //ENOPROTOOPT = 42,
   //EPROTONOSUPPORT = 43,
   //ESOCKTNOSUPPORT = 44,
   //EOPNOTSUPP = 45,
   //EADDRINUSE = 48,
   //EADDRNOTAVAIL = 49,
   //ENETDOWN = 50,
   //ENETUNREACH = 51,
   //ENETRESET = 52,
   //ECONNABORTED = 53,
   //ECONNRESET = 54,
    //ENOBUFS = 55
   //EISCONN = 56,
   //ENOTCONN = 57,
   //ESHUTDOWN = 58,
   //ETOOMANYREFS = 59,
   //ETIMEDOUT = 60,
   //ECONNREFUSED = 61,
   //EHOSTDOWN = 64,
   //EHOSTUNREACH = 65,
   //EPROTO = 70,
   //ETIME = 71,
   //ENOSR = 72,
   //EBADMSG = 73,
   //ECANCEL = 74,
   //ENOSTR = 75,
   //ENODATA = 76,
   //EINPROGRESS = 77,
   //ESRCH = 78,
   //ENOMSG = 79,
   //ELASTERRNO = 79
//};


/*Open Transport Flags and Status Codes

Specify information about data transmitted with the OTSnd or OTRcv functions, or specify options for the OTOptionManagement function, or indicate the result status of an option negotiation.

typedef UInt32 OTFlags;
/   These flags are used when sending and receiving data.The constants
defined are masks./
enum {
   T_MORE = 0x0001,
   T_EXPEDITED = 0x0002,
   T_ACKNOWLEDGED = 0x0004,
   T_PARTIALDATA = 0x0008,
   T_NORECEIPT = 0x0010,
   T_TIMEDOUT = 0x0020
};
   
/ These flags are used in the TOptMgmt structure to request services./
enum {
   T_NEGOTIATE = 0x0004,
   T_CHECK = 0x0008,
   T_DEFAULT = 0x0010,
   T_CURRENT = 0x0080
};
   
/   These flags are used in the TOptMgmt and TOption structures
to   return results./
enum {
   T_SUCCESS = 0x0020,
   T_FAILURE = 0x0040,
   T_PARTSUCCESS = 0x0100,
   T_READONLY = 0x0200,
   T_NOTSUPPORT = 0x0400
};
Constants
T_MORE

There is more data for the current TSDU or ETSDU. The next send or receive operation will handle additional data for this TSDU or ETSDU.

Available in Mac OS X v10.0 and later.
T_EXPEDITED

On sends, the data is sent as expedited data if the endpoint supports expedited data. On receives, the flag indicates that expedited data was sent.

Available in Mac OS X v10.0 and later.
T_ACKNOWLEDGED

The transaction must be acknowledged before the send or receive function can complete.

Available in Mac OS X v10.0 and later.
T_PARTIALDATA

There is more data for the current TSDU or ETSDU. Unlike T_MORE, T_PARTIALDATA does not guarantee that the next send or receive operation will handle additional data for this TSDU or ETSDU.

Available in Mac OS X v10.0 and later.
T_NORECEIPT

There is no need to send a T_REPLY_COMPLETE event to complete the transaction. If you don’t need to know when the transaction is actually done, you can set this flag to improve performance.

Available in Mac OS X v10.0 and later.
T_TIMEDOUT

The reply timed out. If a protocol such as ATP loses the acknowledgment for a transaction that needs to be acknowledged, the transaction will eventually time out. Since the reply didn’t really fail (it just timed out), Open Transport can send a T_REPLY_COMPLETE event to complete the transaction and set this flag to explain what happened.

Available in Mac OS X v10.0 and later.
T_NEGOTIATE

Negotiate the option values specified in the opt.buf field of the req parameter.

The overall result of the negotiation is specified by the flags field of the ret parameter. The opt.buf field of the ret parameter points to a buffer where negotiated values for each option are placed.

Available in Mac OS X v10.0 and later.
T_CHECK

Verify whether the endpoint supports the options referenced by the opt.buf field of the req parameter. The overall result of the verification is specified by the flags field of the ret parameter. Specific verification results are returned in the opt.buf field of the ret parameter.

Available in Mac OS X v10.0 and later.
T_DEFAULT

Retrieve the default value for those options in the buffer referenced by the req->opt.buf field. To retrieve default values for all the options supported by an endpoint, include just the option T_ALLOPT in the options buffer.Option values are returned in the opt.buf field of the ret parameter.

Available in Mac OS X v10.0 and later.
T_CURRENT

Retrieve the current value for those options that the endpoint supports and that are specified in the buffer referenced by the req->opt.buf field. To retrieve current values for all the options that an endpoint supports, include just the option T_ALLOPT in the options buffer.Option values are returned in the opt.buf field of the ret parameter.

Available in Mac OS X v10.0 and later.
T_SUCCESS

The requested value was negotiated.

Available in Mac OS X v10.0 and later.
T_FAILURE

The negotiation failed.

Available in Mac OS X v10.0 and later.
T_PARTSUCCESS

A lower requested value was negotiated.

Available in Mac OS X v10.0 and later.
T_READONLY

The option was read-only.

Available in Mac OS X v10.0 and later.
T_NOTSUPPORT

The endpoint does not support the requested value.

Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTFlags;
/*   These flags are used when sending and receiving data.The constants
defined are masks.*/
enum {
   T_MORE = 0x0001,
   T_EXPEDITED = 0x0002,
   T_ACKNOWLEDGED = 0x0004,
   T_PARTIALDATA = 0x0008,
   T_NORECEIPT = 0x0010,
   T_TIMEDOUT = 0x0020
};
   
/* These flags are used in the TOptMgmt structure to request services.*/
enum {
   T_NEGOTIATE = 0x0004,
   T_CHECK = 0x0008,
   T_DEFAULT = 0x0010,
   T_CURRENT = 0x0080
};
   
/*   These flags are used in the TOptMgmt and TOption structures
to   return results.*/
enum {
   T_SUCCESS = 0x0020,
   T_FAILURE = 0x0040,
   T_PARTSUCCESS = 0x0100,
   T_READONLY = 0x0200,
   T_NOTSUPPORT = 0x0400
};


/*ProviderRef


typedef struct OpaqueProviderRef * ProviderRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueProviderRef * ProviderRef;

/*Endpoint Service Types

Contains values that Open Transport can return in the servtype field of the TEndpointInfo structure.

typedef UInt32 OTServiceType;
enum {
   T_COTS = 1,
   T_COTS_ORD = 2,
   T_CLTS = 3,
   T_TRANS = 5,
   T_TRANS_ORD = 6,
   T_TRANS_CLTS = 7
};
Constants
T_COTS

Connection-oriented transactionless service without orderly release.

Available in Mac OS X v10.0 and later.
T_COTS_ORD

Connection-oriented transactionless service with optional orderly release.

Available in Mac OS X v10.0 and later.
T_CLTS

Connectionless transactionless service.

Available in Mac OS X v10.0 and later.
T_TRANS

Connection-oriented transaction-based service without orderly release.

Available in Mac OS X v10.0 and later.
T_TRANS_ORD

Connection-oriented transaction-based service with optional orderly release.

Available in Mac OS X v10.0 and later.
T_TRANS_CLTS

Connectionless transaction-based service.

Available in Mac OS X v10.0 and later.*/

typedef UInt32 OTServiceType;
enum {
   T_COTS = 1,
   T_COTS_ORD = 2,
   T_CLTS = 3,
   T_TRANS = 5,
   T_TRANS_ORD = 6,
   T_TRANS_CLTS = 7
};


/*OTDataSize


typedef SInt32 OTDataSize;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 OTDataSize;

/*EndpointRef


typedef struct OpaqueEndpointRef * EndpointRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueEndpointRef * EndpointRef;

/*OTClientContextPtr


typedef struct OpaqueOTClientContextPtr * OTClientContextPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueOTClientContextPtr * OTClientContextPtr;

/*OTInitializationFlags


typedef UInt32 OTInitializationFlags;
enum {
   kInitOTForApplicationMask = 1,
   kInitOTForExtensionMask = 2
};
Constants
kInitOTForApplicationMask

Available in Mac OS X v10.0 and later.
kInitOTForExtensionMask

Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTInitializationFlags;
enum {
   kInitOTForApplicationMask = 1,
   kInitOTForExtensionMask = 2
};

/*OTConfigurationRef


typedef struct OTConfiguration * OTConfigurationRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OTConfiguration * OTConfigurationRef;

/*OTOpenFlags


typedef UInt32 OTOpenFlags;
enum {
   kO_ASYNC = 0x01,
   kO_NDELAY = 0x04,
   kO_NONBLOCK = 0x04
};
Constants
kO_ASYNC

Available in Mac OS X v10.0 and later.
kO_NDELAY

Available in Mac OS X v10.0 and later.
kO_NONBLOCK

Available in Mac OS X v10.0 and later.*/

typedef UInt32 OTOpenFlags;
enum {
   kO_ASYNC = 0x01,
   kO_NDELAY = 0x04,
   kO_NONBLOCK = 0x04
};

/*TEndpointInfo

Describes the initial characteristics of an endpoint that you opened by calling the OTOpenEndpointInContext function; returned by calling OTGetEndpointInfo.

struct TEndpointInfo {
   OTDataSize addr;
   OTDataSize options;
   OTDataSize tsdu;
   OTDataSize etsdu;
   OTDataSize connect;
   OTDataSize discon;
   OTServiceType servtype;
   UInt32 flags;
};
typedef struct TEndpointInfo TEndpointInfo;
Fields
addr
options

A value greater than or equal to 0 indicates the maximum number of bytes needed to store the protocol-specific options that this endpoint supports, if any. A value of T_INVALID (-2) indicates that this endpoint has no protocol-specific options that you can set; they are read-only. A value of -3 specifies that the provider does not support any options. 
tsdu

For a transactionless endpoint, a positive value indicates the maximum number of bytes in a transport service data unit (TSDU) for this endpoint. A value of T_INFINITE (-1) indicates that there is no limit to the size of a TSDU. A value of 0 indicates that the provider does not support the concept of a TSDU. This means that you cannot send data with logical boundaries preserved across a connection. A value of T_INVALID indicates that this endpoint cannot transfer normal data (as opposed to expedited data). 

For a transaction-based endpoint, this field indicates the maximum number of bytes in a response. 

etsdu

For a transactionless endpoint, a positive value indicates the maximum number of bytes in an expedited transport service data unit (ETSDU) for this endpoint. A value of T_INFINITE indicates that there is no limit to the size of a ETSDU. A value of 0 indicates that this endpoint does not support the concept of an ETSDU. This means that you must not send expedited data with logical boundaries preserved across a connection. A value of T_INVALID indicates that this endpoint cannot transfer expedited data.

For a transaction-based endpoint, this field indicates the maximum number of bytes in a request. 

connect

For a connection-oriented endpoint, a value greater than or equal to 0 indicates the maximum amount of data (in bytes) that you can send with the OTConnect function or the OTAccept function. A value of T_INVALID indicates that this endpoint does not let you send data with these functions. This field is meaningless for other types of endpoints.
discon

For a connection-oriented endpoint, a value greater than or equal to 0 indicates the maximum amount of data (in bytes) that you can send using the OTSndDisconnect function. A value of T_INVALID indicates that this endpoint does not let you send data with disconnection requests. This field is meaningless for other types of endpoints.
servtype

A constant that indicates what kind of service the endpoint provides. Possible values are given by the “Endpoint Service Types” enumeration.
flags

A bit FIeld that provides additional information about the endpoint. Possible values are given by the “Endpoint Flags” enumeration.
Availability
Available in Mac OS X v10.0 and later.*/
struct TEndpointInfo {
   OTDataSize addr;
   OTDataSize options;
   OTDataSize tsdu;
   OTDataSize etsdu;
   OTDataSize connect;
   OTDataSize discon;
   OTServiceType servtype;
   UInt32 flags;
};
typedef struct TEndpointInfo TEndpointInfo;

/*OTByteCount


typedef ByteCount OTByteCount;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ByteCount OTByteCount;

/*TNetbuf

Specifies the location and size of a buffer that contains an address, option information, or user data.

struct TNetbuf {
   ByteCount maxlen;
   ByteCount len;
   UInt8 * buf;
};
typedef struct TNetbuf TNetbuf;
Fields
maxlen

The size (in bytes) of the buffer to which the buf field points. You must set the maxlen field before passing a TNetbuf structure to a provider function as an output parameter. Open Transport ignores this field if you pass the TNetbuf structure as an input parameter.
len

The actual length (in bytes) of the information in the buffer to which the buf field points. If you are using the TNetbuf structure as an input parameter, you must set this field.

If you pass the TNetbuf structure as an output parameter, on return the provider function sets this field to the number of bytes the function has actually placed in the buffer referenced by the buf field.
buf

A pointer to a buffer. You must make sure that the buf field points to a valid buffer and that the buffer is large enough to store the information for which it is intended.
Discussion

You use a TNetbuf structure to specify the location and size of a buffer that contains an address, option information, or user data. Provider functions use TNetbuf structures both as input parameters and output parameters. If you use a TNetbuf structure as an input parameter, you specify the location and size of a buffer containing information you want to send. If you use a TNetbuf structure as an output parameter, you specify the location and the maximum size of the buffer used to hold information when the function returns.

You use a TNetbuf structure to describe the location and size of contiguous data. Open Transport allows you to describe noncontiguous data with the OTData structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TNetbuf {
   ByteCount maxlen;
   ByteCount len;
   UInt8 * buf;
};
typedef struct TNetbuf TNetbuf;


/*The Option Management Structure

Manages the req and ret parameters of the OTOptionManagement function

struct TOptMgmt {
   TNetbuf opt;
   OTFlags flags;
};
typedef struct TOptMgmt TOptMgmt;
Fields
opt

A TNetbuf structure describing the buffer containing option information. The opt.maxlen field specifies the maximum size of the buffer. The opt.len field specifies the actual size of the buffer, and the opt.buf field contains the address of the buffer.

On input, as part of the req parameter, the buffer contains TOption structures describing the options to be negotiated or verified, or contains the names of options whose default or current values you are interested in. You must allocate this buffer, place in it the structures describing the options of interest, and set the opt.len field to the size of the buffer.

On output, as part of the ret parameter, the buffer contains the actual values of the options you described in the req parameter. You must allocate a buffer to hold the option information when the function returns and set the opt.maxlen field to the maximum length of this buffer. When the function returns, the opt.len field is set to the actual length of the buffer.

flags

For the req parameter, the flags field indicates the action to be taken as defined by the action flags enumeration (page 570). For the ret parameter, the flags field indicates the overall success or failure of the operation performed by the OTOptionManagement function, as defined by the “Open Transport Flags and Status Codes” enumeration. 
Discussion

The option management structure is used for the req and ret parameters of the OTOptionManagement function. The req parameter is used to verify or negotiate option values. The ret parameter returns information about an endpoint’s default, current, or negotiated values. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TOptMgmt {
   TNetbuf opt;
   OTFlags flags;
};
typedef struct TOptMgmt TOptMgmt;

/*The TOption Structure

Stores information about a single option in a buffer.

struct TOption {
   ByteCount len;
   OTXTILevel level;
   OTXTIName name;
   UInt32 status;
   UInt32 value[1];
};
typedef struct TOption TOption;
Fields
len

The size (in bytes) of the option information, including the header. 
level

The protocol for which the option is defined. 
name

The name of the option. 
status

A status code specifying whether the negotiation has succeeded or failed. Possible values are given by the “Open Transport Flags and Status Codes” enumeration 
value

The option value. To have the endpoint select an appropriate value, you can specify the constant T_UNSPEC.
Discussion

The TOption structure stores information about a single option in a buffer. All functions that you use to change or verify option values use a buffer containing TOption structures to store option information. For each option in the buffer, the TOption structure specifies the total length occupied by the option, the protocol level of the option, the option name, the status of a negotiated value, and the value of the option.

You use the TOption structure with the OPT_NEXTHDR macro, the OTCreateOptionString function, the OTNextOption function, and the OTFindOption function.
Availability
Available in Mac OS X v10.0 and later.*/
struct TOption {
   ByteCount len;
   OTXTILevel level;
   OTXTIName name;
   UInt32 status;
   UInt32 value[1];
};
typedef struct TOption TOption;

/*The TOptionHeader Structure

Stores information about options in a buffer.

struct TOptionHeader {
   ByteCount len;
   OTXTILevel level;
   OTXTIName name;
   UInt32 status;
};
typedef struct TOptionHeader TOptionHeader;
Fields
len

The size (in bytes) of the option information, including the header. 
level

The protocol affected. 
name

The option name. 
status

The status value. Possible values are given by the “Open Transport Flags and Status Codes”.
Availability
Available in Mac OS X v10.0 and later.*/
struct TOptionHeader {
   ByteCount len;
   OTXTILevel level;
   OTXTIName name;
   UInt32 status;
};
typedef struct TOptionHeader TOptionHeader;


/*kOTOptionHeaderSize


enum {
   kOTOptionHeaderSize = sizeof(TOptionHeader),
   kOTBooleanOptionDataSize = sizeof(UInt32),
   kOTBooleanOptionSize = kOTOptionHeaderSize + kOTBooleanOptionDataSize,
   kOTOneByteOptionSize = kOTOptionHeaderSize + 1,
   kOTTwoByteOptionSize = kOTOptionHeaderSize + 2,
   kOTFourByteOptionSize = kOTOptionHeaderSize + sizeof(UInt32)
};
Constants
kOTOptionHeaderSize

Available in Mac OS X v10.0 and later.
kOTBooleanOptionDataSize

Available in Mac OS X v10.0 and later.
kOTBooleanOptionSize

Available in Mac OS X v10.0 and later.
kOTOneByteOptionSize

Available in Mac OS X v10.0 and later.
kOTTwoByteOptionSize

Available in Mac OS X v10.0 and later.
kOTFourByteOptionSize

Available in Mac OS X v10.0 and later.*/
enum {
   kOTOptionHeaderSize = sizeof(TOptionHeader),
   kOTBooleanOptionDataSize = sizeof(UInt32),
   kOTBooleanOptionSize = kOTOptionHeaderSize + kOTBooleanOptionDataSize,
   kOTOneByteOptionSize = kOTOptionHeaderSize + 1,
   kOTTwoByteOptionSize = kOTOptionHeaderSize + 2,
   kOTFourByteOptionSize = kOTOptionHeaderSize + sizeof(UInt32)
};

/*OTNotifyProcPtr


typedef void (*OTNotifyProcPtr) (
   void *contextPtr,
   OTEventCode code,
   OTResult result,
   void *cookie
);

If you name your function MyOTNotifyProc, you would declare it like this:

void MyOTNotifyProc (
   void *contextPtr,
   OTEventCode code,
   OTResult result,
   void *cookie
);
Parameters
contextPtr
code
result
cookie
Carbon Porting Notes

This is a function type for a callback. Use the type OTNotifyUPP instead.*/

typedef void (*OTNotifyProcPtr) (
   void *contextPtr,
   OTEventCode code,
   OTResult result,
   void *cookie
);


/*OTNotifyUPP


typedef OTNotifyProcPtr OTNotifyUPP;
Discussion

For more information, see the description of the OTNotifyUPP () callback function.*/
typedef OTNotifyProcPtr OTNotifyUPP;

/*Buffer Information Structure

A convenience structure for keeping track of where your application left off in an OTBuffer structure.

struct OTBufferInfo {
   OTBuffer * fBuffer;
   ByteCount fOffset;
   UInt8 fPad;
};
typedef struct OTBufferInfo OTBufferInfo;
Fields
fBuffer

A pointer to the no-copy receive buffer. 
fOffset

An offset indicating how far into the buffer you have read.
fPad

Reserved.
Discussion

The buffer information structure is provided for your convenience in keeping track of where you last left off in an OTBuffer structure. Because the no-copy receive buffer structure (OTBuffer) is read-only, you may need to copy the data in sections as you progress through the no-copy receive buffer. The utility function OTReadBuffer is used with this structure to easily copy the data out of an OTBuffer structure.
Availability
Available in Mac OS X v10.0 and later.*/
struct OTBufferInfo {
   OTBuffer * fBuffer;
   ByteCount fOffset;
   UInt8 fPad;
};
typedef struct OTBufferInfo OTBufferInfo;

/*TBind

Describes the protocol address to which an endpoint is currently bound or connected, or specifies the protocol address to which you wish to bind or connect the endpoint.

struct TBind {
   TNetbuf addr;
   OTQLen qlen;
};
typedef struct TBind TBind;
Fields
addr

A TNetbuf structure that contains information about an address. The addr.maxlen field specifies the maximum size of the address, the addr.len field specifies the actual length of the address, and the addr.buf field points to the buffer containing the address. 

When specifying an address, you must allocate a buffer for the address and initialize it; you must set the addr.buf field to point to this buffer; and you must set the addr.len field to the size of the address.

When requesting an address, you must allocate a buffer in which the address is to be placed; you must set the addr.buf field to point to this buffer; and you must set the addr.maxlen field to the maximum size of the address that is being returned. You determine this value by examining the addr field of the TEndpointInfo structure for the endpoint.

qlen

For a connection-oriented endpoint, the maximum number of connection requests that can be concurrently outstanding for this endpoint. For more information, see the description of the OTBind function. For connectionless endpoints, this field has no meaning. 
Discussion

The TBind structure describes the protocol address to which an endpoint is currently bound or connected, or specifies the protocol address to which you wish to bind or connect the endpoint. For a connection-oriented endpoint, the TBind structure also specifies the actual or desired number of connection requests that can be concurrently outstanding for the endpoint. 

You pass the TBind structure as a parameter to the OTBind function, the OTGetProtAddress function, and the OTResolveAddress function. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TBind {
   TNetbuf addr;
   OTQLen qlen;
};
typedef struct TBind TBind;

/*TCall

Specifies the options and data associated with establishing a connection.

struct TCall {
   TNetbuf addr;
   TNetbuf opt;
   TNetbuf udata;
   OTSequence sequence;
};
typedef struct TCall TCall;
Fields
addr

A TNetbuf structure that specifies the location and size of an address buffer 
opt

A TNetbuf structure that specifies the location and size of an options buffer. 
udata

A TNetbuf structure that specifies the location and size of a buffer for data associated with a connection or disconnection request. 
sequence

A 32-bit value used by the OTListen and OTAccept functions to specify the connection ID. 
Discussion

You use the TCall structure to specify the options and data associated with establishing a connection. You pass a pointer to this structure as a parameter to the OTConnect function, the OTRcvConnect function, the OTListen function, and the OTAccept function.

If you are using the TCall structure to send information, you must allocate a buffer and initialize it to contain the information. Set the .buf field of each TNetbuf to point to the buffer, and then specify the size of the buffer using the .len field. Set this field to 0 if you are not sending data.

If you are using the TCall structure to receive information, you must allocate a buffer into which the function can place the information when it returns. Then set the .buf field of all the TNetbufs to point to this buffer, and set the .maxlen field to the maximum size of the information. Set this field to 0 if you are not interested in receiving information.
Availability
Available in Mac OS X v10.0 and later.*/
struct TCall {
   TNetbuf addr;
   TNetbuf opt;
   TNetbuf udata;
   OTSequence sequence;
};
typedef struct TCall TCall;

/*Timestamp Data Type

Contains an Open Transport timestamp.

typedef UnsignedWide OTTimeStamp;
Discussion

The timestamp data type is a 64-bit value that contains an Open Transport timestamp. The timestamp has unspecified units; you must use one of the timestamp manipulation functions described in “Timestamp Utility Functions” to convert the timestamp to known quantities. The timestamp data type is defined by the OTTimeStamp data type.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UnsignedWide OTTimeStamp;


/*LIFO List Structure

Supports last-in, first-out lists in Open Transport.

struct OTLIFO {
   OTLink * fHead;
};
typedef struct OTLIFO OTLIFO;
Fields
fHead

A pointer to the first entry in the linked list. Set this to nil to initialize the structure before using it. 
Discussion

Open Transport LIFO (last-in, first-out) lists use the LIFO list structure. You must initialize this structure by setting the structure’s fHead field to NULL before using the LIFO list. Most Open Transport LIFO list operations are atomic.
Availability
Available in Mac OS X v10.0 and later.*/
struct OTLIFO {
   OTLink * fHead;
};
typedef struct OTLIFO OTLIFO;


//function

/*InitOpenTransportInContext

Initializes the parts of Open Transport for use by the application or code resource. (Deprecated in Mac OS X v10.4.)

OSStatus InitOpenTransportInContext (
   OTInitializationFlags flags,
   OTClientContextPtr * outClientContext
);
Parameters
flags

Tells Open Transport whether your code is an application or a plug-in.
outClientContext

Returns the client context pointer. 
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

In Carbon, the InitOpenTransportInContext function acts like the pre-Carbon InitOpenTransport function, except that it takes parameters that specify initialization context explicitly.

Use the flags parameter to tell Open Transport whether your code is an application or some other target (for example, a plug-in that runs in an application context but is not the application itself). The second parameter returns the client context pointer, which you must pass to other asset-creation routines. For more information, see Understanding Open Transport Asset Tracking at http://developer.apple.com/technotes/tn/tn1173.html.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus InitOpenTransportInContext (
   OTInitializationFlags flags,
   OTClientContextPtr * outClientContext
);

/*OTOpenEndpointInContext

Opens an endpoint that operates synchronously. (Deprecated in Mac OS X v10.4.)

EndpointRef OTOpenEndpointInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   TEndpointInfo * info,
   OSStatus * err,
   OTClientContextPtr clientContext
);
Parameters
config
oflag
info
err
clientContext
Return Value

See the description of the EndpointRef data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
EndpointRef OTOpenEndpointInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   TEndpointInfo * info,
   OSStatus * err,
   OTClientContextPtr clientContext
);

/*OTCreateConfiguration

Creates a structure defining a provider’s configuration. (Deprecated in Mac OS X v10.4.)

Modified

OTConfigurationRef OTCreateConfiguration (
   const char * path
);
Parameters
path

A pointer to a character string describing the provider.
Return Value

See the description of the OTConfigurationRef data type.
Discussion

The OTCreateConfiguration function creates a configuration structure that defines the software modules, hardware ports, and options that Open Transport is to use when you call a function to open a provider. This is a private structure, defined by the OTConfiguration data type . To create one, you use the path parameter to pass the OTCreateConfiguration function a string describing the provider service desired.

The simplest possible value of the path parameter is a single protocol module name of the highest-level protocol you want to use; for example, “tcp.” If you do not specify a complete communications path, the Open Transport software uses default settings to construct the rest of the path. For example, if you specify “adsp” for the path parameter, Open Transport defaults to using the AppleTalk DataStream Protocol (ADSP) protocol module layered above the Datagram Delivery Protocol (DDP) protocol module and with LocalTalk on the default port, which is the printer port.

If you want to identify a particular port in the configuration string, you use the port name to do so (described in the section “About Port Information,” beginning on page 6-5). More typically, however, you leave this value blank— for example, using a string with only “adsp” or “adsp, ddp,” which configures the provider with whatever port is specified in the control panel.

To specify more than one protocol module, separate the module names with commas. You can also specify values for options by putting them in parentheses after the protocol name; for example, “adsp, ddp (Checksum=1)” specifies that ADSP is to run on top of DDP and that the checksum option is enabled.

If Open Transport cannot parse the list that you pass in the path parameter, the OTCreateConfiguration function returns ((OTConfiguration*)-1L). If there is insufficient memory to create an OTConfiguration structure, the OTCreateConfiguration function returns NULL.

The OTCreateConfiguration function returns a pointer to the configuration structure it creates. You pass this pointer as a parameter to the open-provider functions such as the OTOpenEndpoint or OTOpenMapper functions.
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Passing inline options to OTCreateConfiguration-for example, OTCreateConfiguration("tcp(NoDelay=1)")-is not supported on Mac OS X. Instead, you should explicitly set any options using the function OTOptionManagement.

Declared In
OpenTransport.h*/

OTConfigurationRef OTCreateConfiguration (
   const char * path
);

/*OTCloseProvider

Closes a provider of any type—endpoint, mapper, or service provider. (Deprecated in Mac OS X v10.4.)

OSStatus OTCloseProvider (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTCloseProvider function closes the provider that you specify in the ref parameter. Closing the provider deletes all memory reserved for it in the system heap, deletes its resources, and cancels any provider functions that are currently executing.

Open Transport does not guarantee that all outstanding functions have completed before it closes the provider. It is ultimately your responsibility to make sure that all provider functions that you care about have finished executing, before you close and delete a provider.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTCloseProvider (
   ProviderRef ref
);

/*CloseOpenTransportInContext

Unregisters your application or code resource connection to Open Transport. (Deprecated in Mac OS X v10.4.)

void CloseOpenTransportInContext (
   OTClientContextPtr clientContext
);
Parameters
clientContext
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

The CloseOpenTransportinContext function acts like the pre-Carbon CloseOpenTransport function except that it takes an additional parameter, an OTClientContextPtr, which can be NULL for applications. Other types of clients must provide a valid client context pointer.
Declared In
OpenTransport.h*/
void CloseOpenTransportInContext (
   OTClientContextPtr clientContext
);

/*OTGetEndpointInfo

Obtains information about an endpoint that has been opened. (Deprecated in Mac OS X v10.4.)

OSStatus OTGetEndpointInfo (
   EndpointRef ref,
   TEndpointInfo * info
);
Parameters
ref
info
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTGetEndpointInfo function returns information about
the maximum size of buffers used to specify an endpoint’s address and option values
the maximum size of normal and expedited data you can transfer using this endpoint or, for transaction-based endpoints, the maximum size of requests and replies
the size of data you can transfer when initiating or tearing down a connection
the services supported by the endpoint
any additional characteristics of this endpoint
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTGetEndpointInfo (
   EndpointRef ref,
   TEndpointInfo * info
);

/*OTAllocMemInContext

Allocates memory using an explicit client context. (Deprecated in Mac OS X v10.4.)

void * OTAllocMemInContext (
   OTByteCount size,
   OTClientContextPtr clientContext
);
Parameters
size
clientContext
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void * OTAllocMemInContext (
   OTByteCount size,
   OTClientContextPtr clientContext
);

/*OTOptionManagement

Determines an endpoint’s current or default option values or changes these values. (Deprecated in Mac OS X v10.4.)

OSStatus OTOptionManagement (
   EndpointRef ref,
   TOptMgmt * req,
   TOptMgmt * ret
);
Parameters
ref
req
ret
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

To use the OTOptionManagement function, you must have opened an endpoint using the OTOpenEndpoint or OTAsyncOpenEndpoint functions.

You use the OTOptionManagement function to negotiate, retrieve, or verify an endpoint’s protocol options. If the endpoint is in asynchronous mode and you have not installed a notifier function, it is not possible to determine when the function completes.

The action taken by the OTOptionManagement function is determined by the setting of the req->flags field. The following bulleted items describe the different operations that you can perform and the flag settings that you use to specify these operations.
To negotiate values for the endpoint, you must call the OTOptionManagement function, specifying T_NEGOTIATE for the req->flags field. The endpoint provider evaluates the requested options, negotiates the values, and returns the resulting values in the option management structure pointed to by the ret->opt.buf field. The status field of each returned option is set to a constant that indicates the result of the negotiation. These constants are described by the “Open Transport Flags and Status Codes” enumeration.

For any protocol specified, you can negotiate for the default values of all options supported by the endpoint by specifying the value T_ALLOPT for the name field of the TOption structure. This might be useful if you want to change current settings or if negotiations for other values have failed. The success of the negotiations depends partly on the state of the endpoint—that is, simply because these are default values does not guarantee a completely successful negotiation. When the function returns, the resulting values are returned, option by option, in the buffer pointed to by the ret->opt.buf field.
To retrieve an endpoint’s default option values, call the OTOptionManagement function, specifying T_DEFAULT for the req->flags field. You must also specify the name of the option (but not its value) in the TOption structure that you create for each of the options you are interested in.

When the function returns, it passes the default values for the options back to you in the buffer pointed to by the ret->opt.buf field. For each option, the status field contains T_NOTSUPPORT if the protocol does not support the option, T_READONLY if the option is read-only, and T_SUCCESS in all other cases. The overall result of the request is returned in the ret->flags field. The meaning of this result is described by the Open Transport Flags and Status Codes enumeration.

When getting an endpoint’s default option values, you can specify T_ALLOPT for the option name. This returns all supported options for the specified level with their default values. In this case, you must set the opt.maxlen field to the maximum size required to hold an endpoint’s option information. The info.opt field of the TEndpointInfo structure specifies the maximum size of a buffer used to hold option information for an endpoint.
To retrieve an endpoint’s current option values, call the OTOptionManagement function, specifying T_CURRENT for the req->flags field. For each option in the buffer referenced by the req->opt.buf field, specify the name of the option you are interested in. The function ignores any option valuesyou specify.

When the function returns, it passes the current values for the options back to you in the buffer referenced by the ret->opt.buf field. For each option, the status field contains T_NOTSUPPORT if the protocol does not support the option, T_READONLY if the option is read-only, and T_SUCCESS in all other cases. The overall result of the request is returned in the ret->flags field. The meaning of this result is described by the “Open Transport Flags and Status Codes” enumeration.

When retrieving an endpoint’s current option values, you can specify T_ALLOPT for the option name. The function returns all supported options for the specified protocol, with their current values. In this case, you must set the opt.maxlen field to the maximum size required to hold an endpoint’s option information. The info.opt field of the TEndpointInfo structure specifies the maximum size of a buffer used to hold option information for an endpoint.
To check whether an endpoint provider supports certain options or option values, you must call the OTOptionManagement function, specifying T_CHECK for the req->flags field. Checking options or their values does not change the current settings of an endpoint’s options.
To check whether an option is supported, set the name field of the TOption structure to the option name, but do not specify an option value. When the function returns, the status field for the corresponding TOption structure in the buffer pointed to by the ret->opt.buf field is set to T_SUCCESS if the option is supported, T_NOTSUPPORT if it is not supported or needs additional client privileges, and T_READONLY if it is read-only.
To check whether an option value is supported, set the name field of the TOption structure to the option name, and set the value field to the value you want to check. When the function returns, the status field for the corresponding TOption structure in the buffer pointed to by the ret->opt.buf field is set as it would be if you had specified the T_NEGOTIATE flag. The overall result of the option checks is returned in the ret->flags field, which contains the single worst result of the option checks. The meaning of this result is described by the Open Transport Flags and Status Codes enumeration.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTOptionManagement (
   EndpointRef ref,
   TOptMgmt * req,
   TOptMgmt * ret
);

/*OTFreeMem

Frees memory allocated with the OTAllocMem function. (Deprecated in Mac OS X v10.4.)

void OTFreeMem (
   void * mem
);
Parameters
mem
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTFreeMem (
   void * mem
);

/*OTNextOption

Locates the next TOption structure in a buffer. (Deprecated in Mac OS X v10.4.)

OSStatus OTNextOption (
   UInt8 * buffer,
   UInt32 buflen,
   TOption ** prevOptPtr
);
Parameters
buffer

A pointer to the buffer containing the option to be found.
buflen

A long specifying the size of the buffer containing the option to be found.
prevOptPtr
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTNextOption function allows you to parse through a buffer containing TOption structures describing an endpoint’s option values. Within the buffer, TOption structures are aligned to long-word boundaries. This function takes into account this padding when it calculates the beginning address of the next TOption structure and it returns that address in the prevOptPtr parameter.

The first time you call the option, set the prevOptPtr parameter to the beginning address of the buffer. When the function returns, the prevOptPtr parameter points to the next (second) option in the buffer. You can continue this process, specifying the value returned for the prevOptPtr parameter by the previous invocation of the function, each time you call the function to obtain the beginning address of each option in the buffer.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTNextOption (
   UInt8 * buffer,
   UInt32 buflen,
   TOption ** prevOptPtr
);

/*OTStrLength

Returns the length of a C string. (Deprecated in Mac OS X v10.4.)

OTByteCount OTStrLength (
   const char * str
);
Parameters
str
Return Value

See the description of the OTByteCount data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTByteCount OTStrLength (
   const char * str
);

/*OTInstallNotifier

Installs a notifier function. (Deprecated in Mac OS X v10.4.)

OSStatus OTInstallNotifier (
   ProviderRef ref,
   OTNotifyUPP proc,
   void * contextPtr
);
Parameters
ref
proc

For C++ applications, the proc parameter must point to either a C function or a static member function. See OTNotifyUPP data type.
contextPtr

A context pointer for your use. The provider passes this value unchanged to your notifier function when it calls the function.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTInstallNotifier function installs a notifier function for the provider that you specify. Changing a provider’s mode of execution does not affect the notifier function. The notifier function remains installed until you remove it using the OTRemoveNotifier function or until you close the provider.

Before calling the OTInstallNotifier function, you must open the provider for which you want to install the notifier. If you open a provider asynchronously (for example, with the OTAsyncOpenEndpoint function), you must pass a pointer to a notifier function as a parameter to the function used to open the provider. In this case, you don’t need to call the OTInstallNotifier function unless you want to install a different notifier function. If you do, you must call the OTRemoveNotifier function before calling the OTInstallNotifier function.

Opening a provider synchronously (for example, with the OTOpenEndpoint function) opens the provider but does not install a notifier function for it. If you need a notifier function for a provider opened synchronously, you must call the OTInstallNotifier function. This notifier would not return completion events, but would return asynchronous events advising you of the arrival of data, of changes in flow-control restrictions, and so on.

Call the OTInstallNotifier function only when no provider functions are executing for the provider that you specify. Otherwise, the OTInstallNotifier function returns the result code kOTStateChangeErr.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTInstallNotifier (
   ProviderRef ref,
   OTNotifyUPP proc,
   void * contextPtr
);

/*OTSetSynchronous

Sets a provider’s mode of execution to synchronous. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetSynchronous (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetSynchronous function causes all provider functions to run synchronously when using the provider that you specify.

Changing a provider’s mode of execution does not affect its notifier function, if any is installed for this provider; the notifier function remains installed.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetSynchronous (
   ProviderRef ref
);

/*OTSetNonBlocking

Disallows a provider from waiting if it cannot currently complete a function that sends or receives data. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetNonBlocking (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetNonBlocking function causes provider functions to return a result code immediately, instead of waiting for a function that sends or receives data to complete. When you open a provider, its mode of operation is set to nonblocking by default.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetNonBlocking (
   ProviderRef ref
);

/*OTUseSyncIdleEvents

Allows synchronous idle events to be sent to your notifier. (Deprecated in Mac OS X v10.4.)

OSStatus OTUseSyncIdleEvents (
   ProviderRef ref,
   Boolean useEvents
);
Parameters
ref
useEvents
Return Value

A result code. See “Open Transport Result Codes”.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTUseSyncIdleEvents (
   ProviderRef ref,
   Boolean useEvents
);

/*OTBind

Assigns an address to an endpoint. (Deprecated in Mac OS X v10.4.)

OSStatus OTBind (
   EndpointRef ref,
   TBind * reqAddr,
   TBind * retAddr
);
Parameters
ref
reqAddr

If you specify NIL for the reqAddr parameter, Open Transport chooses a protocol address for you and requests 0 as the endpoint’s maximum number of concurrent outstanding connect indications.

If you want Open Transport to assign an address for you, setthe addr.len field of the TBind structure to 0.
retAddr

You can set this parameter to nil if you do not care to know what address the endpoint is bound to or what the negotiated value of qlen is.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTBind function to request an address that an endpoint be bound to. You can either use the reqAddr parameter to request that the endpoint be bound to a specific address or allow the endpoint provider to assign an address dynamically by passing nil for this parameter. Consult the documentation for the top-level protocol you are using to determine whether it is preferable to have the address assigned dynamically. The function returns the address to which the endpoint is actually bound in the retAddr parameter. This might be different from the address you requested, if you requested a specific address.

If you are binding a connection-oriented endpoint, you must use the reqAddr->qlen field to specify the number of connection requests that may be outstanding for this endpoint. The retAddr->qlen field specifies, on return, the actual number of connection requests allowed for the endpoint. This number might be smaller than the number you requested. Note that when the endpoint is actually connected, the number might be further decreased by negotiations taking place at that time.

If you call the OTBind function asynchronously and you have not installed a notifier function, the only way to determine when the function completes is to poll the endpoint using the OTGetEndpointState function. This function returns a kOTStateChangeErr until the bind completes. When the endpoint is bound, the state is either T_UNBND if the bind failed, or T_IDLE if it succeeded.

You can cancel an asynchronous bind that is still in progress by calling the OTUnbind function.

You must not bind more than one connectionless endpoint to a single address. Some connection-oriented protocols let you bind two or more endpoints to the same address. In such instances, you must use only one of the endpoints to listen for connection requests for that address. When binding the endpoint listening for a connection, you must set the reqAddr->qlen field of the OTBind function to a value greater than or equal to 1. When binding the other endpoints, you must set the reqAddr->qlen field to 0.

If you accept a connection for an endpoint that is also listening for connection requests, the address of that endpoint is deemed “busy” for the duration of the connection, and you must not bind another endpoint for listening to that same address. This requirement prevents more than one endpoint bound to the same address from accepting connection requests. If you have to bind another listening endpoint to the same address, you must first use the OTUnbind function to unbind the first endpoint or use the OTCloseProvider function to close it.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTBind (
   EndpointRef ref,
   TBind * reqAddr,
   TBind * retAddr
);

/*OTRcv

Reads data sent using a connection-oriented transactionless protocol. (Deprecated in Mac OS X v10.4.)

OTResult OTRcv (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags * flags
);
Parameters
ref
buf

A pointer to a memory location where the incoming data is to be copied. You must allocate this buffer before you call the function.
nbytes
flags
Return Value

See the description of the OTResult data type.
Discussion

You call the OTRcv function to read data sent by the peer to which you are connected. If the OTRcv function succeeds, it returns an integer (OTStatus) specifying the number of bytes received. The function places the data read into the buffer referenced by the buf parameter. If the function fails, it returns a negative integer corresponding to a result code that indicates the reason for the failure. You can call this function to receive either normal or expedited data. If the data is expedited, the T_EXPEDITED flag is set in the flags parameter.

If T_MORE is set in the flags parameter when the function returns, this means that the buffer you allocated is too small to contain the data to be read and that you must call the OTRcv function again. If you have read x bytes with the first call, the next call to the OTRcv function begins to read at the (x + 1) byte. Of course, if you need it, you must copy the data in the buffer to another location before calling the function again. Each call to this function that returns with the T_MORE flag set means that you must call the function again to get more data. When you have read all the data, the OTRcv function returns with the T_MORE flag not set. If the endpoint does not support the concept of a TSDU (Transport Service Data Unit), the T_MORE flag is not meaningful and should be ignored. To determine whether the endpoint supports TSDUs, examine the tsdu field of the TEndpointInfo structure. A value of T_INVALID means that the endpoint does not support it.

Some protocols allow you to send zero-length data to signal the end of a logical unit. In this case, if you request more than 0 bytes when calling the OTRcv function, the function returns 0 bytes only to signal the end of a TSDU.

If the OTRcv function returns and the T_EXPEDITED bit is set in the flags parameter, this means that you are about to read expedited data. If the number of bytes of expedited data exceeds the number of bytes you specified in the reqCount parameter, both the T_EXPEDITED and the T_MORE bits are set. You must call the OTRcv function until the T_MORE flag is not set to retrieve the rest of the expedited data.

If you are calling the OTRcv function repeatedly to read normal data and a call to the function returns T_EXPEDITED in the flags parameter, the next call to the OTRcv function that returns without the T_EXPEDITED flag set returns normal data at the place it was interrupted. It is your responsibility to remember where that was and to continue processing normal data. You can determine how much normal data you read by maintaining a running total of the number of bytes returned in the OTStatus result.

If the endpoint is in asynchronous mode or is not blocking, the function returns with the kOTNoDataErr result if no data is available. If you have installed a notifier, the endpoint provider calls your notifier and passes T_DATA or T_EXDATA for the code parameter when there is data available. If you have not installed a notifier, you may poll for these events using the OTLook function. Once you receive a T_DATA or T_EXDATA event, you should continue in a loop, calling the OTRcv function until it returns with the kOTNoDataErr result.

If the endpoint is in synchronous mode and is blocking, the endpoint waits for data if none is currently available. You should avoid calling the OTRcv function this way because it might cause processing to hang if no data is available. If you are doing other operations in synchronous mode, you should put the endpoint in nonblocking mode before calling the OTRcv function.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTRcv (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags * flags
);

/*OTSnd

Sends data to a remote peer. (Deprecated in Mac OS X v10.4.)

OTResult OTSnd (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags flags
);
Parameters
ref
buf

A pointer to the data being sent. If you are sending data that is not stored contiguously, this is a pointer to an OTData structure that describes the first data fragment.
nbytes
flags
Return Value

See the description of the OTResult data type.
Discussion

You use the OTSnd function to send data to a remote peer. Before you use this function, you must establish a connection with the peer.

If the OTSnd function succeeds, it returns an integer (OSStatus) specifying the number of bytes that were actually sent. If it fails, it returns a negative integer corresponding to a result code that indicates the reason for the failure.

You specify the data to be sent by passing a pointer to the data (buf) and byspecifying the size of the data (nbytes). The maximum size of the data you can send is specified by the tsdu field of the TEndpointInfo structure for the endpoint.

Some protocols use expedited data for control or attention messages. To determine whether the endpoint supports this service, examine the etsdu field of the TEndpointInfo structure. A positive integer for the etsdu field indicates the maximum size in bytes of expedited data that you can send. To send expedited data, you must set the T_EXPEDITED bit of the flags parameter.

If you want to break up the data sent into smaller logical units, you can set the T_MORE bit of the flags parameter to indicate that you are using additional calls to the OTSnd function to send more data that belongs to the same logical unit. To indicate that the last data unit is being sent, you must specify 0 for nbytes and turn off the T_MORE flag. This is the only circumstance under which it is permitted to send a zero-length data unit. If the endpoint does not support the sending of zero-length data, the OTSnd function fails with the kOTBadDataErr result.

If the endpoint is in blocking mode, the OTSnd function returns after it actually sends the data. If flow-control restrictions prevent its sending the data, it retries the operation until it is able to send it. If the endpoint is in nonblocking mode, the OTSnd function returns with the kOTFlowErr result if flow-control restrictions prevent the data from being sent. When the endpoint provider is able to send the data, it returns a T_GODATA event to let you know that it is possible to send data.

The following table shows how the endpoint’s mode of execution and blocking status affects the behavior of the OTSnd function.
Table A-1  
	
Blocking	
Nonblocking

Synchronous	
The function returns when the provider lifts flow-control restrictions The kOTFlowErr result is never returned.	
The function returns immediately. The kOTFlowErr result might be returned.

Asynchronous	
The function returns immediately. The kOTFlowErr result is never returned.	
The function returns immediately. The kOTFlowErr result might be returned.

Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTResult OTSnd (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags flags
);

/*OTConnect

Requests a connection to a remote peer. (Deprecated in Mac OS X v10.4.)

OSStatus OTConnect (
   EndpointRef ref,
   TCall * sndCall,
   TCall * rcvCall
);
Parameters
ref
sndCall
rcvCall

This parameter is only meaningful for synchronous calls to the OTConnect function. See TCall data type.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If the endpoint is in synchronous mode, the OTConnect function returns after the connection is established and fills in the fields of the TCall structure (referenced by the rcvCall parameter) with the actual values associated with this connection. These might be different from the values you specified using the sndCall parameter.

If the OTConnect function returns with the kOTLookErr result, this might be either because of a pending T_LISTEN or T_DISCONNECT event. That is, either a connection request from another endpoint has interrupted execution of the function, or the remote endpoint has rejected the connection. If you don’t have a notifier installed, you can call the OTLook function to identify the event that caused the kOTLookErr result. If the event is T_LISTEN, you must accept or reject the incoming request and then continue processing the OTConnect function by calling OTRcvConnect. If the event is T_DISCONNECT, you must call the OTRcvDisconnect function to clear the error condition—that is, to deallocate memory and place the endpoint in the correct state.

If the endpoint is in asynchronous mode, the OTConnect function returns before the connection is established with a kOTNoDataErr result to indicate that the connection is in progress. When the connection is established, the endpoint provider calls your notifier, passing T_CONNECT for the code parameter. In response, you must call the OTRcvConnect function to read the connection parameters that would have been returned using the rcvCall parameter if the endpoint were in synchronous mode.

It is possible that the remote address returned in the addr field of the rcvCall parameter is not the same as the address you requested using the sndCall->addr field. This happens when the connection is accepted for a different endpoint than the one receiving the connection request.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTConnect (
   EndpointRef ref,
   TCall * sndCall,
   TCall * rcvCall
);

/*OTSetBlocking

Allows a provider to wait or block until it is able to send or receive data. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetBlocking (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetBlocking function causes provider functions that send or receive data to wait if current conditions prevent them from completing an operation. By default, a provider is in nonblocking mode, in which case, if a provider function were unable to complete sending or receiving data, it would return immediately with a result that would tell you why the operation was unable to complete.

If a provider is in blocking mode and you call the OTCloseProvider function to close the provider, Open Transport gives each Streams module up to 15 seconds to process outgoing commands. It is recommended that you call the OTSetNonBlocking function before you call the OTCloseProvider function.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetBlocking (
   ProviderRef ref
);

/*NewOTNotifyUPP

Creates a new universal procedure pointer (UPP) to a notification callback. (Deprecated in Mac OS X v10.4.)

OTNotifyUPP NewOTNotifyUPP (
   OTNotifyProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the OTNotifyUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTNotifyUPP NewOTNotifyUPP (
   OTNotifyProcPtr userRoutine
);

/*OTMemzero

Initializes the specified memory range to 0. (Deprecated in Mac OS X v10.4.)

void OTMemzero (
   void * dest,
   OTByteCount nBytes
);
Parameters
dest
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

void OTMemzero (
   void * dest,
   OTByteCount nBytes
);


/*OTAtomicAdd32

Atomically adds a 32-bit value to a memory location. (Deprecated in Mac OS X v10.4.)

SInt32 OTAtomicAdd32 (
   SInt32 toAdd,
   SInt32 * dest
);
Parameters
toAdd
dest
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
SInt32 OTAtomicAdd32 (
   SInt32 toAdd,
   SInt32 * dest
);

/*OTGetTimeStamp

Obtains the current timestamp. (Deprecated in Mac OS X v10.4.)

void OTGetTimeStamp (
   OTTimeStamp * currentTime
);
Parameters
currentTime
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTGetTimeStamp (
   OTTimeStamp * currentTime
);

/*OTLIFOEnqueue

Places a link at the front of a LIFO list. (Deprecated in Mac OS X v10.4.)

void OTLIFOEnqueue (
   OTLIFO * list,
   OTLink * link
);
Parameters
list
link
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTLIFOEnqueue (
   OTLIFO * list,
   OTLink * link
);

/*OTLIFODequeue

Removes the first link in a LIFO list and returns a pointer to it. (Deprecated in Mac OS X v10.4.)

OTLink * OTLIFODequeue (
   OTLIFO * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTLink * OTLIFODequeue (
   OTLIFO * list
);

/*OTLIFOStealList

Removes all links in a LIFO list and returns a pointer to the first link in the list. (Deprecated in Mac OS X v10.4.)

OTLink * OTLIFOStealList (
   OTLIFO * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTLink * OTLIFOStealList (
   OTLIFO * list
);

/*OTReverseList

Reverses the order in which entries are linked in a list. (Deprecated in Mac OS X v10.4.)

OTLink * OTReverseList (
   OTLink * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTLink * OTReverseList (
   OTLink * list
);


#ifdef __cplusplus
}
#endif

#endif