#ifndef QUICKDRAWTEXT_H
#define QUICKDRAWTEXT_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#include <HYS/QD/QuickdrawText.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Truncation Positions

Specify where to truncate a string.

typedef  TruncCode;
enum {
   truncEnd = 0,
   truncMiddle = 0x4000,
   smTruncEnd = 0,
   smTruncMiddle = 0x4000
};
Constants
truncEnd

Truncate at end.

Available in Mac OS X v10.0 and later.
truncMiddle

Truncate in middle.

Available in Mac OS X v10.0 and later.
smTruncEnd

Truncate at end. This is obsolete.

Available in Mac OS X v10.0 and later.
smTruncMiddle

Truncate in middle. This is obsolete.

Available in Mac OS X v10.0 and later.*/
typedef  TruncCode;
enum {
   truncEnd = 0,
   truncMiddle = 0x4000,
   smTruncEnd = 0,
   smTruncMiddle = 0x4000
};


/*FontInfo

Contains font metric information.

struct FontInfo {
   short ascent;
   short descent;
   short widMax;
   short leading;
};
typedef struct FontInfo FontInfo;
Fields
ascent

The measurement, in pixels, from the baseline to the ascent line of the font.
descent

The measurement, in pixels, from the baseline to the descent line of the font.
widMax

The width, in pixels, of the largest glyph in the font.
leading

The measurement, in pixels, from the descent line to the ascent line below it.
Discussion

The FontInfo data type defines a font information structure. The GetFontInfo function uses the font information structure to return measurement information based on the font of the current graphics port. If the current font has an associated font, as do Arabic and Hebrew, GetFontInfo returns information based on both fonts. The font information structure contains the ascent, the descent, the width of the largest glyph, and the leading for a given font. The StdTxMeas function also uses a structure of type FontInfo to return information about the current font. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FontInfo {
   short ascent;
   short descent;
   short widMax;
   short leading;
};
typedef struct FontInfo FontInfo;


/*GetFontInfo

Returns information about the current graphics port’s font, taking into account the style and size in which the glyphs are to be drawn. (Deprecated in Mac OS X v10.4. Use ATSUI instead.)

void GetFontInfo (
   FontInfo * info
);
Parameters
info

Pointer to a font information structure that contains the font measurement information, in integer values. 
Discussion

The GetFontInfo function returns the ascent, descent, leading, and width of the largest glyph of the font in the text font, size, and style specified in the current graphics port. If the script system specified by the current graphics port txFont field has an associated font, as do Hebrew and Arabic, GetFontInfo returns combined information based on both fonts. This is to accommodate text written in the Roman script when the primary script system is non-Roman. However, even if all of the text is written in a non-Roman script, if there is an associated font, GetFontInfo always bases its information on the combined fonts. You can determine the line height, in pixels, by adding the values of the ascent, descent, and leading fields.

The GetFontInfo function is similar to the Font Manager’s FontMetrics function, except that the GetFontInfo function returns integer values. See FontInfo for a description of the structure and its fields. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/

void GetFontInfo (
   FontInfo * info
);

/*StringWidth

Returns the length, in pixels, of the specified text string. (Deprecated in Mac OS X v10.4. Use ATSUI instead.)

short StringWidth (
   ConstStr255Param s
);
Parameters
s

A Pascal string containing the text to be measured.
Return Value

The length, in pixels, of the specified text string. 
Discussion

You should not call StringWidth to measure scaled text. Although StringWidth takes into account the graphics port structure settings, it does not accept scaling parameters, and therefore cannot determine the correct text width result for text to be drawn using scaling factor parameters.

If you specify values in the graphics port spExtra or chExtra fields to change the width of space or nonspace characters, StringWidth takes these values into account.

Because this function measures text in the font, style, and size of the current graphics port, you need to call it once for each individual style run in any line of text that contains multiple style runs.

The StringWidth function works with all script systems. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/
short StringWidth (
   ConstStr255Param s
);

/*CharWidth

Returns the width (horizontel extension), in pixels, of the specified character. (Deprecated in Mac OS X v10.4. Use ATSUI instead.)

short CharWidth (
   CharParameter ch
);
Parameters
ch

The character whose width is to be measured. 
Return Value

The width (horizontel extension), in pixels, of the specified character. 
Discussion

The CharWidth function includes the effects of the stylistic variations for the text set in the current graphics port. If you change any of these attributes after determining the glyph width but before actually drawing it, the predetermined width may not be correct. For a space character, CharWidth also includes the effect of SpaceExtra. For a nonspace character, CharWidth includes the effect of CharExtra.

Because it takes a single-byte value as the ch parameter, CharWidth works only for 1-byte simple script systems.

A series of calls to CharWidth in a contextual 1-byte font may give incorrect results, because the width of a text segment may be different from the sum of its individual character widths. In that case, to measure a line of text you should call TextWidth.

Do not use the CharWidth function for 2-byte script systems. If you want to measure the width of a single glyph in a 2-byte font, you should use TextWidth. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/
short CharWidth (
   CharParameter ch
);

/*TextMode

Sets the transfer mode for drawing text in the current graphics port. (Deprecated in Mac OS X v10.4. Use ATSUI or Quartz instead.)

void TextMode (
   short mode
);
Parameters
mode

The transfer mode to be used to draw the text. 
Discussion

The TextMode function sets the transfer mode in the graphics port txMode field. The transfer mode determines the interplay between what an application is drawing (the source) and what already exists on the display device (the destination), resulting in the text display.

There are two basic kinds of modes: pattern (pat) and source (src). Source is the kind that you use for drawing text. There are four basic Boolean operations: Copy, Or, Xor, and Bic (bit clear), each of which has an inverse variant in which the source is inverted before the transfer, yielding eight operations in all. Original QuickDraw supports these eight transfer modes. Color QuickDraw enables your application to achieve color effects within those basic transfer modes, and offers an additional set of transfer modes that perform arithmetic operations on the RGB values of the source and destination pixels. Other transfer modes are grayishTextOr, transparent mode, and text mask mode.

To ensure future compatibility and benefit from any enhancements, always use this function to modify the txMode field, rather than directly change the field value. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/

void TextMode (
   short mode
);

/*DrawText

Draws the specified text at the current pen location in the current graphics port. (Deprecated. Use ATSUI or Quartz instead.)

void DrawText (
   const void * textBuf,
   short firstByte,
   short byteCount
);
Parameters
textBuf

A pointer to a buffer containing the text to be drawn. 
firstByte

An offset from the start of the text buffer (textBuf) to the first byte of the text to be drawn. 
byteCount

The number of bytes of text to be drawn. Inside a picture definition, DrawText cannot have a byteCount greater than 255.

For 2-byte script systems, note that byteCount is the number of bytes to be drawn, not the number of glyphs. Because 2-byte script systems also include characters consisting of only 1 byte, do not simply multiply the number of characters by 2 to determine this value; you must determine and specify the correct number of bytes.
Discussion

The DrawText function draws the text with the leftmost glyph at the current pen location, extending right. After QuickDraw draws the text, it sets the pen location to the right of the rightmost glyph.

QuickDraw temporarily stores on the stack all of the text you ask it to draw, even if the text is to be clipped. When drawing a range of text, it’s best to draw only what is visible on the screen. If an entire text string does not fit on a line, truncate the text at a word boundary. If possible, avoid truncating within a style run. You can determine the number of characters whose glyphs actually fit on the screen by calling the TextWidth function before calling DrawText.

If you specify values in the graphics port spExtra and chExtra fields to change the width of nonspace and space characters, both TextWidth and DrawText take these values into account.

For 1-byte complex script systems, DrawText substitutes the proper ligatures, reversals, and compound characters as needed.

For right-to-left text, such as Hebrew or Arabic, QuickDraw draws the final (leftmost) glyph first, then moves to the right through all the characters, drawing the initial (rightmost) glyph last. 
Declared In
QuickdrawText.h*/

void DrawText (
   const void * textBuf,
   short firstByte,
   short byteCount
);

/*TextWidth

Returns the length, in pixels, of the specified text. (Deprecated in Mac OS X v10.4. Use ATSUI instead.)

short TextWidth (
   const void * textBuf,
   short firstByte,
   short byteCount
);
Parameters
textBuf

A pointer to a buffer that contains the text to be measured. 
firstByte

An offset from textBuf to the first byte of the text to be measured. 
byteCount

The number of bytes of text to be measured.
Return Value

The length, in pixels, of the specified text. 
Discussion

You can use TextWidth to measure the screen pixel width of any text segment that has uniform character attributes. You can use it to measure the style runs in a line of text, whether you intend to draw the line using DrawText or DrawJustified. The TextWidth function takes into account the character attributes set in the graphics port. If you change any of these attributes after determining the text width but before actually drawing the text, the predetermined width may not be correct. For a space character, TextWidth also includes the effect of SpaceExtra. For a nonspace character, TextWidth includes the effect of CharExtra.

Because this function measures text in the font, style, and size of the current graphics port, you need to call it once for each individual style run in any line of text that contains multiple style runs.

The TextWidth function works with text in all script systems because the script management system modifies the function if necessary to give the proper results.

To draw justified lines of text that include multiple style runs, you calculate the amount of extra pixels, or slop, that remains to be distributed throughout the line. This process entails measuring the screen pixel width of each style run on the line: you can use TextWidth for this purpose.

For 1-byte complex script systems, TextWidth calculates the widths of any ligatures, reversals, and compound characters that need to be drawn.

Note that byteCount is the number of bytes to be measured, not the number of characters. Because 2-byte script systems also include characters consisting of only one byte, you should not simply multiply the number of characters by 2 to determine this value; you must determine and specify the correct number of bytes. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/
short TextWidth (
   const void * textBuf,
   short firstByte,
   short byteCount
);

/*TruncString

Ensures that a Pascal string fits into the specified pixel width, by truncating the string as necessary. This function makes use of the current script and font. (Deprecated in Mac OS X v10.4. Use CFString instead.)

short TruncString (
   short width,
   Str255 theString,
   TruncCode truncWhere
);
Parameters
width

The number of pixels in which the string must be displayed in the current script and font. 
theString

The Pascal string to be displayed. On output, contains a version of the string that has been truncated (if necessary) to fit in the number of pixels specified by width.
truncWhere

A constant that indicates where the string should be truncated. If you supply the truncEnd value, characters are truncated off the end of the string. If you supply the truncMiddle value, characters are truncated from the middle of the string; this is useful when displaying pathnames. 

See “Truncation Positions” for a list of the constants you can supply.
Discussion

The TruncString function ensures that a Pascal string fits into the pixel width specified by the width parameter by modifying the string, if necessary, through truncation. TruncString uses the font script to determine how to perform truncation. If truncation occurs, TruncString inserts a truncation indicator, which is the ellipsis (…) in the Roman script system. You can specify which token to use for indicating truncation as the tokenEllipsis token type in the untoken table of a tokens ('itl4') resource.

To determine the width of a string in the current font and script, use the QuickDraw StringWidth function. 
Special Considerations

TruncString may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/
short TruncString (
   short width,
   Str255 theString,
   TruncCode truncWhere
);

/*TextFace

Sets the style of the font in which the text is to be drawn in the current graphics port. (Deprecated in Mac OS X v10.4. Use ATSUI or Quartz instead.)

void TextFace (
   StyleParameter face
);
Parameters
face

The style for text to be drawn in the current graphics port.
Discussion

The TextFace function sets the value for the style of the font in the text face ( txFace) field of the current graphics port. The Style data type allows you to specify a set of one or more of the following predefined constants: bold, italic, underline, outline, shadow, condense, and extend. In Pascal, you specify the constants within square brackets. For example:TextFace([bold]);
{bold}TextFace([bold,italic]);
{bold and italic}


The style is set to the empty set ( []) by default, which specifies plain.

To ensure future compatibility and benefit from any enhancements, always use this function to modify the txFace field, rather than directly change the field value. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QuickdrawText.h*/

void TextFace (
   StyleParameter face
);


#ifdef __cplusplus
}
#endif

#endif