#ifndef IMAGECODEC_H
#define IMAGECODEC_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef IMAGECOMPRESSION_H
#include <QuickTime/ImageCompression.h>
#endif

#ifndef MOVIES_H
#include <QuickTime/Movies.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


typedef Fixed fixed;

#include <HYS/QuickTime/ImageCodec.h>
#include <ADD/QuickTime/ImageCodec.h>

/*ImageSubCodecDecompressCapabilities

Returned by an image decompressor component in response to ImageCodecInitialize.

struct ImageSubCodecDecompressCapabilities {
   long       recordSize;
   long       decompressRecordSize;
   Boolean    canAsync;
   UInt8      pad0;
Fields
recordSize
Discussion

The size of this structure in bytes.
decompressRecordSize
Discussion

The size of the ImageSubCodecDecompressRecord structure that your image decompressor component requires. This structure is used to pass information from ImageCodecBeginBand to ImageCodecDrawBand and ImageCodecEndBand.
canAsync
Discussion

Specifies whether your image decompressor component can perform asynchronous scheduled decompression. This should be TRUE unless your image decompressor component calls functions that cannot be called during interrupt time.
pad0
Discussion

Unused.
Discussion

The first function call that your image decompressor component receives from the base image decompressor is always a call to ImageCodecInitialize. In response to this call, your image decompressor component returns an ImageSubCodecDecompressCapabilities structure that specifies its capabilities.
Related Functions
ImageCodecInitialize 
Declared In
ImageCodec.h*/

struct ImageSubCodecDecompressCapabilities {
   long       recordSize;
   long       decompressRecordSize;
   Boolean    canAsync;
   UInt8      pad0;
 int baseCodecShouldCallDecodeBandForAllFrames; //hys
int subCodecIsMultiBufferAware; //hys
int subCodecSupportsOutOfOrderDisplayTimes; //hys
};


/*Functions

This section lists the functions that image compressor components must support. It also lists the utility functions that the Image Compression Manager provides for use by compressors and decompressors. For details of these functions, see the QuickTime API Reference.

The function list is divided into two parts. “Direct Functions” lists image compressor component functions that are called by the Image Compression Manager in response to application requests. “Indirect Functions” lists image compressor component functions that may be called by the Image Compression Manager at any time. The next section, “Image Compression Manager Utility Functions” lists Image Compression Manager utility functions that are available to image compressor components.

You can use the following constants to refer to the request codes for each of the functions that your component must support.
#define kImageCodecGetCodecInfoSelect             0x00   
#define kImageCodecGetCompressionTimeSelect       0x01   
#define kImageCodecGetMaxCompressionSizeSelect    0x02   
#define kImageCodecPreCompressSelect              0x03   
#define kImageCodecBandCompressSelect             0x04   
#define kImageCodecPreDecompressSelect            0x05   
#define kImageCodecBandDecompressSelect           0x06  
#define kImageCodecBusySelect                     0x07   
#define kImageCodecGetCompressedImageSizeSelect   0x08   
#define kImageCodecGetSimilaritySelect            0x09   
#define kImageCodecTrimImageSelect                0x0A  


Note:  Code selectors 0 through 127 are reserved for use by Apple. Code selectors 128 through 191 are subtype specific. Code selectors 192 through 255 are vendor specific. Code selectors 256 through 32767 are available for general use. Negative selectors are reserved by the Component Manager. 

In this section:

Direct Functions 
Indirect Functions 
Image Compression Manager Utility Functions*/
enum {
 kImageCodecGetCodecInfoSelect     =        0x00   ,
kImageCodecGetCompressionTimeSelect      = 0x01   ,
kImageCodecGetMaxCompressionSizeSelect  =  0x02 ,  
kImageCodecPreCompressSelect              =0x03   ,
kImageCodecBandCompressSelect             =0x04  , 
kImageCodecPreDecompressSelect            =0x05   ,
kImageCodecBandDecompressSelect           =0x06  ,
kImageCodecBusySelect                     =0x07   ,
kImageCodecGetCompressedImageSizeSelect=   0x08   ,
kImageCodecGetSimilaritySelect            =0x09   ,
kImageCodecTrimImageSelect               = 0x0A  
};

/*Codec Properties

Constants that represent the properties of codecs.

enum {
   / The minimum data size for spooling in or out data *
   codecMinimumDataSize          = 32768L
};
enum {
   codecConditionFirstBand       = 1L << 0,
   codecConditionLastBand        = 1L << 1,
   codecConditionFirstFrame      = 1L << 2,
   codecConditionNewDepth        = 1L << 3,
   codecConditionNewTransform    = 1L << 4,
   codecConditionNewSrcRect      = 1L << 5,
   codecConditionNewMask         = 1L << 6,
   codecConditionNewMatte        = 1L << 7,
   codecConditionNewTransferMode = 1L << 8,
   codecConditionNewClut         = 1L << 9,
   codecConditionNewAccuracy     = 1L << 10,
   codecConditionNewDestination  = 1L << 11,
   codecConditionFirstScreen     = 1L << 12,
   codecConditionDoCursor        = 1L << 13,
   codecConditionCatchUpDiff     = 1L << 14,
   codecConditionMaskMayBeChanged = 1L << 15,
   codecConditionToBuffer        = 1L << 16,
   codecConditionCodecChangedMask = 1L << 31
};
enum {
   codecInfoResourceType         = 'cdci',
   / codec info resource type *
   codecInterfaceVersion         = 2     / high word returned in component GetVersion *
};
enum {
   codecSuggestedBufferSentinel  = 'sent' / codec public resource containing suggested data pattern to put past end of data buffer *
};
enum {
   codecUsesOverlaySurface       = 1L << 0,
   /codec uses overlay surface *
   codecImageBufferIsOverlaySurface = 1L << 1,
   / codec image buffer is overlay surface,
   the bits in the buffer are on the screen *
   codecSrcMustBeImageBuffer     = 1L << 2,
   /codec can only source data from an image buffer *
   codecImageBufferIsInAGPMemory = 1L << 4,
   / Codec image buffer is in AGP space,
   byte writes are OK *
   codecImageBufferIsInPCIMemory = 1L << 5,
   /*codec image buffer is across a PCI bus; byte writes are bad *
   codecImageBufferMemoryFlagsValid = 1L << 6,
   /*set by ImageCodecNewImageBufferMemory/NewImageGWorld to indicate that it set the AGP/PCI flags (supported in QuickTime 6.0 and later) *
   codecDrawsHigherQualityScaled = 1L << 7,
   / codec will draw higher-quality image if it performs scaling (eg,
   wipe effect with border) *
   codecSupportsOutOfOrderDisplayTimes = 1L << 8,
   / codec supports frames queued in one order for display in a different order,
   eg,
   IPB content *
   codecSupportsScheduledBackwardsPlaybackWithDifferenceFrames = 1L << 9 / codec can use additional buffers to minimise redecoding during backwards playback *
};
Constants
codecConditionFirstBand

An input flag that indicates if this is the first band in the frame. If this flag is set to 1, then your component is being called for the first time for the current frame. 

Available in Mac OS X v10.0 and later.
codecConditionLastBand

An input flag that indicates if this is the last band in the frame. If this flag is set to 1, then your component is being called for the last time for the current frame. If the codecConditionFirstBand flag is also set to 1, this is the only time the Image Compression Manager is calling your component for the current frame. 

Available in Mac OS X v10.0 and later.
codecConditionFirstFrame

An input flag that indicates that this is the first frame to be decompressed for this image sequence. 

Available in Mac OS X v10.0 and later.
codecConditionNewDepth

An input flag that indicates that the depth of the destination has changed for this image sequence. 

Available in Mac OS X v10.0 and later.
codecConditionNewTransform

An input flag that indicates that the transformation matrix has changed for this sequence. 

Available in Mac OS X v10.0 and later.
codecConditionNewSrcRect

An input flag that indicates that the source rectangle has changed for this sequence. 

Available in Mac OS X v10.0 and later.
codecConditionNewMatte

An input flag that indicates that the matte pixel map has changed for this sequence. 

Available in Mac OS X v10.0 and later.
codecConditionNewTransferMode

An input flag that indicates that the transfer mode has changed for this sequence. 

Available in Mac OS X v10.0 and later.
codecConditionNewClut

An input flag that indicates that the color lookup table has changed for this sequence. 

Available in Mac OS X v10.0 and later.
codecConditionNewAccuracy

An input flag that indicates to the component that the accuracy parameter has changed for this sequence. 

Available in Mac OS X v10.0 and later.
codecConditionNewDestination

An input flag that indicates to the component that the destination pixel map has changed for this sequence. 

Available in Mac OS X v10.0 and later.
codecConditionFirstScreen

Indicates when the codec is decompressing an image to the first of multiple screens. That is, if the decompressed image crosses multiple screens, then the codec can look at this flag to determine if this is the first time an image is being decompressed for each of the screens to which it is being decompressed. A codec that depends on the maskBits field of this structure being a valid RgnHandle on ImageCodecPreDecompress needs to know that in this case it is not able to clip images since the region handle is only passed for the first of the screens; clipping would be incorrect for the subsequent screen for that image. 

Available in Mac OS X v10.0 and later.
codecConditionDoCursor

Set to 1 if the decompressor component should shield and unshield the cursor for the current decompression operation. This flag should be set only if the codec has indicated its ability to handle cursor shielding by setting the codecCanShieldCursor flag in the capabilities field during ImageCodecPreDecompress. 

Available in Mac OS X v10.0 and later.
codecConditionCatchUpDiff

Indicates if the current frame is a "catch-up" frame. Set this flag to 1 if the current frame is a catch-up frame. Note that you must also set the codecFlagCatchUpDiff flag to 1. This may be useful to decompressors that can drop frames when playback is falling behind. 

Available in Mac OS X v10.0 and later.
codecConditionMaskMayBeChanged

The Image Compression Manager has always included support for decompressors that could provide a bit mask of pixels that were actually drawn when a particular frame was decompressed. If a decompressor can provide a bit mask of pixels that changed, the Image Compression Manager transfers to the screen only the pixels that actually changed. QuickTime 2.1 extended this capability by adding this new condition flag. The decompressor should write back the mask only if this flag is set. This flag is used only by ImageCodecFlush. 

Available in Mac OS X v10.0 and later.
codecConditionToBuffer

Set to 1 if the current decompression operation is decompressing into an offscreen buffer. 

Available in Mac OS X v10.0 and later.
codecConditionCodecChangedMask

An output flag that indicates that the component has changed the mask bits. If your image decompressor component can mask decompressed images and if some of the image pixels should not be written to the screen, set to 0 the corresponding bits in the mask defined by the maskBits field in the decompression parameter structure. In addition, set this flag to 1. Otherwise, set this flag to 0. 

Available in Mac OS X v10.0 and later.
codecInfoResourceType

Codec info resource type. 

Available in Mac OS X v10.0 and later.
codecInterfaceVersion

High word returned in component GetVersion. 

Available in Mac OS X v10.0 and later.
codecSuggestedBufferSentinel

Codec public resource containing suggested data pattern to put past end of data buffer. 

Available in Mac OS X v10.2 and later.
codecUsesOverlaySurface

Undocumented 

Available in Mac OS X v10.0 and later.
codecImageBufferIsOverlaySurface

Indicates that the codec's image buffer is an overlay surface; the bits in the buffer appear on the screen. 

Available in Mac OS X v10.0 and later.
codecSrcMustBeImageBuffer

Indicates that the codec can accept source data only from an image buffer. 

Available in Mac OS X v10.0 and later.
codecImageBufferIsInAGPMemory

Indicates that the codec's image buffer resides in AGP address space and accepts byte writes. 

Available in Mac OS X v10.0 and later.
codecImageBufferIsInPCIMemory

Codec image buffer is across a PCI bus; byte writes are bad. 

Available in Mac OS X v10.0 and later.
codecImageBufferMemoryFlagsValid

Set by ImageCodecNewImageBufferMemory or NewImageGWorld to indicate that the codecImageBufferIsInAGPMemory and codecImageBufferIsInPCIPMemory flags have been set correctly. 

Available in Mac OS X v10.2 and later.
codecDrawsHigherQualityScaled

Indicates that the codec will draw a higher quality image if it performs scaling; for example, while drawing a wipe effect with a border. 

Available in Mac OS X v10.2 and later.
codecSupportsOutOfOrderDisplayTimes

Codec supports frames queued in one order for display in a different order, for example IPB content. 

Available in Mac OS X v10.3 and later.
Declared In
ImageCodec.h*/


//enum {
   /* The minimum data size for spooling in or out data */
  // codecMinimumDataSize          = 32768L
//};
enum {
   codecConditionFirstBand       = 1L << 0,
   codecConditionLastBand        = 1L << 1,
   codecConditionFirstFrame      = 1L << 2,
   codecConditionNewDepth        = 1L << 3,
   codecConditionNewTransform    = 1L << 4,
   codecConditionNewSrcRect      = 1L << 5,
//   codecConditionNewMask         = 1L << 6,
   codecConditionNewMatte        = 1L << 7,
   codecConditionNewTransferMode = 1L << 8,
   codecConditionNewClut         = 1L << 9,
   codecConditionNewAccuracy     = 1L << 10,
   codecConditionNewDestination  = 1L << 11,
   codecConditionFirstScreen     = 1L << 12,
   codecConditionDoCursor        = 1L << 13,
   codecConditionCatchUpDiff     = 1L << 14,
   codecConditionMaskMayBeChanged = 1L << 15,
   codecConditionToBuffer        = 1L << 16,
   codecConditionCodecChangedMask = 1L << 31
};
//enum {
  // codecInfoResourceType         = 'cdci',
   /* codec info resource type */
 //  codecInterfaceVersion         = 2     /* high word returned in component GetVersion */
//};
//enum {
//   codecSuggestedBufferSentinel  = 'sent' /* codec public resource containing suggested data pattern to put past end of data buffer */
//};
enum {
//   codecUsesOverlaySurface       = 1L << 0,
   /* codec uses overlay surface */
   codecImageBufferIsOverlaySurface = 1L << 1,
   /* codec image buffer is overlay surface,
   the bits in the buffer are on the screen */
   codecSrcMustBeImageBuffer     = 1L << 2,
   /* codec can only source data from an image buffer */
   codecImageBufferIsInAGPMemory = 1L << 4,
   /* codec image buffer is in AGP space,
   byte writes are OK */
  // codecImageBufferIsInPCIMemory = 1L << 5,
   /* codec image buffer is across a PCI bus; byte writes are bad */
   codecImageBufferMemoryFlagsValid = 1L << 6,
   /* set by ImageCodecNewImageBufferMemory/NewImageGWorld to indicate that it set the AGP/PCI flags (supported in QuickTime 6.0 and later) */
   codecDrawsHigherQualityScaled = 1L << 7,
   /* codec will draw higher-quality image if it performs scaling (eg,
   wipe effect with border) */
  // codecSupportsOutOfOrderDisplayTimes = 1L << 8,
   /* codec supports frames queued in one order for display in a different order,
   eg,
   IPB content */
 //  codecSupportsScheduledBackwardsPlaybackWithDifferenceFrames = 1L << 9 /* codec can use additional buffers to minimise redecoding during backwards playback */
};


/*EffectSource Values

Constants passed to EffectSource.

enum {
   kEffectRawSource              = 0,
   /*the source is raw image data*
   kEffectGenericType            = 'geff' / generic effect for combining others*
};
Constants
kEffectRawSource

The source is raw Image Compression Manager data. 

Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
enum {
   kEffectRawSource              = 0,
   /* the source is raw image data*/
   kEffectGenericType            = 'geff' /* generic effect for combining others*/
};


/*SMPTEFlags

Represents a type used by the Image Codec API.

typedef long SMPTEFlags;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
typedef long SMPTEFlags;

/*SMPTEWipeType

Represents a type used by the Image Codec API.

typedef unsigned long SMPTEWipeType;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
typedef unsigned long SMPTEWipeType;

/*SMPTEFrameReference

Represents a type used by the Image Codec API.

typedef long SMPTEFrameReference;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
typedef long SMPTEFrameReference;

/*QTParameterValidationOptions

Represents a type used by the Image Codec API.

typedef long QTParameterValidationOptions;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
typedef long QTParameterValidationOptions;


/*QTParameterValidationOptions

Represents a type used by the Image Codec API.

typedef long QTParameterValidationOptions;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
typedef long QTParameterValidationOptions;

/*ImageSubCodecDecompressRecord Values

Constants passed to ImageSubCodecDecompressRecord.

enum {
   kCodecFrameTypeUnknown        = 0,
   kCodecFrameTypeKey            = 1,
   kCodecFrameTypeDifference     = 2,
   kCodecFrameTypeDroppableDifference = 3
};
Constants
kCodecFrameTypeUnknown

The frame type is unknown. 

Available in Mac OS X v10.0 and later.
kCodecFrameTypeKey

This is a key frame. 

Available in Mac OS X v10.0 and later.
kCodecFrameTypeDifference

This is a difference frame. 

Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/

enum {
   kCodecFrameTypeUnknown        = 0,
   kCodecFrameTypeKey            = 1,
   kCodecFrameTypeDifference     = 2,
   kCodecFrameTypeDroppableDifference = 3
};


/*Codec Properties

Constants that represent the properties of codecs.

codecImageBufferIsInPCIMemory = 1L << 5
codecSupportsOutOfOrderDisplayTimes = 1L << 8
codecSupportsScheduledBackwardsPlaybackWithDifferenceFrames = 1L << 9
codecConditionNewMask         = 1L << 6
codecInfoResourceType         = 'cdci'
codecInterfaceVersion         = 2
codecSuggestedBufferSentinel  = 'sent'
codecMinimumDataSize          = 32768L
codecImageBufferIsInPCIMemory

Codec image buffer is across a PCI bus; byte writes are bad. 

Available in Mac OS X v10.0 and later.
codecSupportsOutOfOrderDisplayTimes

Codec supports frames queued in one order for display in a different order, for example IPB content. 

Available in Mac OS X v10.3 and later.
codecSupportsScheduledBackwardsPlaybackWithDifferenceFrames

Codec can use additional buffers to minimize redecoding during backwards playback. 

Available in Mac OS X v10.3 and later.
codecInfoResourceType

Codec info resource type. 

Available in Mac OS X v10.0 and later.
codecInterfaceVersion

High word returned in component GetVersion. 

Available in Mac OS X v10.0 and later.
codecSuggestedBufferSentinel

Codec public resource containing suggested data pattern to put past end of data buffer. 

Available in Mac OS X v10.2 and later.*/
enum {
codecImageBufferIsInPCIMemory = 1L << 5 ,
codecSupportsOutOfOrderDisplayTimes = 1L << 8,
codecSupportsScheduledBackwardsPlaybackWithDifferenceFrames = 1L << 9,
codecConditionNewMask         = 1L << 6,
codecInfoResourceType         = 'cdci',
codecInterfaceVersion         = 2,
codecSuggestedBufferSentinel  = 'sent',
codecMinimumDataSize          = 32768L
};

////typedef

/*ImageSubCodecDecompressRecord

Contains information needed for decompressing a frame.

struct ImageSubCodecDecompressRecord {
   Ptr                      baseAddr;
   long                     rowBytes;
   Ptr                      codecData;
   ICMProgressProcRecord    progressProcRecord;
   ICMDataProcRecord        dataProcRecord;
   void *                   userDecompressRecord;
   UInt8                    frameType;
   UInt8                    pad[3];
   long                     priv[2];
};
Fields
baseAddr
Discussion

The address of the destination pixel map, which includes adjustment for the offset. Note that if the bit depth of the pixel map is less than 8, your image decompressor component must adjust for the bit offset.
rowBytes
Discussion

The offset in bytes from one row of the destination pixel map to the next. The value of the rowBytes field must be less than 0x4000.
codecData
Discussion

A pointer to the data to be decompressed.
progressProcRecord
Discussion

An ICMProgressProcRecord structure that specifies a progress function. This function reports on the progress of a decompression operation. If there is no progress function, the Image Compression Manager sets the progressProc field in the ICMProgressProcRecord structure to NIL.
dataProcRecord
Discussion

An ICMDataProcRecord structure that specifies a data-loading function. If the data to be decompressed is not all in memory, your component can call this function to load more data. If there is no data-loading function, the Image Compression Manager sets the dataProc field in the ICMDataProcRecord structure to NIL, and the entire image must be in memory at the location specified by the codecData field of the ImageSubCodecDecompressRecord structure.
userDecompressRecord
Discussion

A pointer to storage for the decompression operation. The storage is allocated by the base image decompressor after it calls ImageCodecInitialize. The size of the storage is determined by the decompressRecordSize field of the ImageSubCodecDecompressCapabilities structure that is returned by ImageCodecInitialize. Your image decompressor component should use this storage to store any additional information needed about the frame in order to decompress it.
frameType
Discussion

A constant (see below) that indicates the frame type. See these constants: 
kCodecFrameTypeUnknown
kCodecFrameTypeKey
kCodecFrameTypeDifference
kCodecFrameTypeDroppableDifference
pad
Discussion

Unused.
priv
Discussion

Private to QuickTime; do not use.
Related Functions
ImageCodecBeginBand
ImageCodecDrawBand
ImageCodecEndBand
ImageCodecMPDrawBandProc 
Declared In
ImageCodec.h*/
struct ImageSubCodecDecompressRecord {
   Ptr                      baseAddr;
   long                     rowBytes;
   Ptr                      codecData;
   ICMProgressProcRecord    progressProcRecord;
   ICMDataProcRecord        dataProcRecord;
   void *                   userDecompressRecord;
   UInt8                    frameType;
   UInt8                    pad[3];
   long                     priv[2];
};

typedef struct ImageSubCodecDecompressRecord ImageSubCodecDecompressRecord;

/*CodecDecompressParams

The basic parameter block that is passed to a decompressor.

struct CodecDecompressParams {
   ImageSequence              sequenceID;
   ImageDescriptionHandle     imageDescription;
   Ptr                        data;
   long                       bufferSize;
   long                       frameNumber;
   long                       startLine;
   long                       stopLine;
   long                       conditionFlags;
   CodecFlags                 callerFlags;
   CodecCapabilities *        capabilities;
   ICMProgressProcRecord      progressProcRecord;
   ICMCompletionProcRecord    completionProcRecord;
   ICMDataProcRecord          dataProcRecord;
   CGrafPtr                   port;
   PixMap                     dstPixMap;
   BitMapPtr                  maskBits;
   PixMapPtr                  mattePixMap;
   Rect                       srcRect;
   MatrixRecord *             matrix;
   CodecQ                     accuracy;
   short                      transferMode;
   ICMFrameTimePtr            frameTime;
   long                       reserved[1];
   SInt8                      matrixFlags;
   SInt8                      matrixType;
   Rect                       dstRect;
   UInt16                     majorSourceChangeSeed;
   UInt16                     minorSourceChangeSeed;
   CDSequenceDataSourcePtr    sourceData;
   RgnHandle                  maskRegion;
   OSType **                  wantedDestinationPixelTypes;
   long                       screenFloodMethod;
   long                       screenFloodValue;
   short                      preferredOffscreenPixelSize;
   ICMFrameTimeInfoPtr        syncFrameTime;
   Boolean                    needUpdateOnTimeChange;
   Boolean                    enableBlackLining;
   Boolean                    needUpdateOnSourceChange;
   Boolean                    pad;
   long                       unused;
   CGrafPtr                   finalDestinationPort;
   long                       requestedBufferWidth;
   long                       requestedBufferHeight;
   Rect                       displayableAreaOfRequestedBuffer;
   Boolean                    requestedSingleField;
   Boolean                    needUpdateOnNextIdle;
   Boolean                    pad2[2];
   fixed                      bufferGammaLevel;
   UInt32                     taskWeight;
   OSType                     taskName;
};
Fields
sequenceID
Discussion

Contains the unique sequence identifier. If the image to be decompressed is part of a sequence, this field contains the sequence identifier that was assigned by DecompressSequenceBegin. If the image is not part of a sequence, this field is set to 0.
imageDescription
Discussion

Contains a handle to the ImageDescription that describes the image to be decompressed.
data
Discussion

Points to the compressed image data. This must be a 32-bit clean address. The bufferSize field indicates the size of this data buffer. If the entire compressed image does not fit in memory, the application should provide a data-loading function, identified by the dataProc field of the data-loading function structure stored in the dataProcRecord field. This field is used only by ImageCodecBandDecompress.
bufferSize
Discussion

Specifies the size of the image data buffer. This field is used only by ImageCodecBandDecompress.
frameNumber
Discussion

Contains a frame identifier. Indicates the relative frame number within the sequence. The Image Compression Manager increments this value for each frame in the sequence. This field is used only by ImageCodecBandDecompress.
startLine
Discussion

Specifies the starting line for the band. The line number refers to the pixel row in the image, starting from the top of the image. The first row in the image is row number 0. This field is used only by ImageCodecBandDecompress.
stopLine
Discussion

Specifies the ending line for the band. The line number refers to the pixel row in the image, starting from the top of the image. The first row is row number 0. The image band includes the row specified by this field. So, to define a band that contains one row of pixels at the top of an image, you set the startLine field to 0 and the stopLine field to 1. This field is used only by ImageCodecBandDecompress.
conditionFlags
Discussion

Contains flags (see below) that identify the condition under which your component has been called (in order to save the component some work). The flags in this field are passed to the component by ImageCodecBandCompress and ImageCodecPreDecompress when conditions change, to save it some work. In addition, these fields contain information about actions taken by your component. See these constants: 
codecConditionFirstBand
codecConditionLastBand
codecConditionFirstFrame
codecConditionNewDepth
codecConditionNewTransform
codecConditionNewSrcRect
codecConditionNewMatte
codecConditionNewTransferMode
codecConditionNewClut
codecConditionNewAccuracy
codecConditionNewDestination
codecConditionCodecChangedMask
codecConditionFirstScreen
codecConditionDoCursor
codecConditionCatchUpDiff
codecConditionMaskMayBeChanged
codecConditionToBuffer
callerFlags
Discussion

Contains flags (see below) that provide further control information. This field is used only by ImageCodecBandCompress. See these constants: 
codecFlagUpdatePrevious
codecFlagWasCompressed
codecFlagUpdatePreviousComp
codecFlagLiveGrab
capabilities
Discussion

Points to a CodecCapabilities structure. The Image Compression Manager uses this parameter to determine the capabilities of your decompressor component. This field is used only by ImageCodecPreDecompress.
progressProcRecord
Discussion

Contains a ICMProgressProcRecord structure. During the decompression operation, your decompressor may occasionally call a function that the application provides in order to report your progress. This field contains a structure that identifies the progress function. If the progressProc field of this structure is set to NIL, the application did not provide a progress function. This field is used only by ImageCodecBandDecompress.
completionProcRecord
Discussion

Contains an ICMCompletionProcRecord structure. This field governs whether you perform the decompression asynchronously. If the completionProc field in this structure is set to NIL, perform the decompression synchronously. If this field is not NIL, it specifies an application completion function. Perform the decompression asynchronously and call that completion function when your component is finished. If this field has a value of -1, perform the operation asynchronously but do not call the application's completion function. This field is used only by ImageCodecBandDecompress.
dataProcRecord
Discussion

Contains an ICMDataProcRecord structure. If the data stream is not all in memory, your component may call an application function that loads more compressed data. This field contains a structure that identifies that data-loading function. If the application did not provide a data-loading function, the dataProc field in this structure is set to NIL. In this case, the entire image must be in memory at the location specified by the data field. This field is used only by ImageCodecBandDecompress.
port
Discussion

Points to the color graphics port that receives the decompressed image.
dstPixMap
Discussion

Points to the pixel map where the decompressed image is to be displayed. The GDevice global variable is set to the destination graphics device. The contents of this pixel map differ from a standard pixel map in two ways. First, the rowBytes field is a full 16-bit value; the high-order bit is not necessarily set to 1. Second, the baseAddr field must contain a 32-bit clean address.
maskBits
Discussion

Contains an update mask. If your component can mask result data, use this mask to indicate which pixels in the destination pixel map to update. Your component indicates whether it can mask with the codecCanMask flag in the flags field of the CodecCapabilities structure referred to by the capabilities field. This field is updated in response to the ImageCodecPreDecompress request. If the mask has not changed since the last ImageCodecBandDecompress request, the codecConditionCodecChangedMask flag in the conditionFlags field is set to 0. This field is used only by ImageCodecBandDecompress.
mattePixMap
Discussion

Points to a pixel map that contains a blend matte. The matte can be defined at any supported pixel depth; the matte depth need not correspond to the source or destination depths. The matte must be in the coordinate system of the source image. If the application does not want to apply a blend matte, this field is set to NIL. The contents of this pixel map differ from a standard pixel map in two ways. First, the rowBytes field is a full 16-bit value; the high-order bit is not necessarily set to 1. Second, the baseAddr field must contain a 32-bit clean address. This field is used only by ImageCodecBandDecompress.
srcRect
Discussion

Points to a rectangle defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the compressed image, which is defined by the width and height fields of the image description structure referred to by the imageDescription field.
matrix
Discussion

Points to a matrix structure that specifies how to transform the image during decompression.
accuracy
Discussion

Constant (see below) that specifies the accuracy desired in the decompressed image. Values for this parameter are on the same scale as compression quality; see CompressImage. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
transferMode
Discussion

Specifies the QuickDraw transfer mode for the operation; see Graphics Transfer Modes.
frameTime
Discussion

Contains a pointer to an ICMFrameTimeRecord structure. This structure contains a frame's time information for scheduled asynchronous decompression operations.
matrixFlags
Discussion

Flag (see below) specifying the transformation matrix. Set to 0 for no transformation. See these constants: 
matrixFlagScale2x
matrixFlagScale1x
matrixFlagScaleHalf
matrixType
Discussion

Contains the type of the transformation matrix, as returned by GetMatrixType.
dstRect
Discussion

The destination rectangle. It is the result of transforming the source rectangle (the srcRect parameter) by the transformation matrix (the matrix parameter).
majorSourceChangeSeed
Discussion

Contains an integer value that is incremented each time a data source is added or removed. This provides a fast way for a codec to know when it needs to redetermine which data source inputs are available.
minorSourceChangeSeed
Discussion

Contains an integer value that is incremented each time a data source is added or removed, or the data contained in any of the data sources changes. This provides a way for a codec to know if the data available to it has changed.
sourceData
Discussion

Contains a pointer to a CDSequenceDataSource structure. This structure contains a linked list of all data sources. Because each data source contains a link to the next data source, a codec can access all data sources from this field.
maskRegion
Discussion

If the maskRegion field is not NIL, it contains a QuickDraw region that is equivalent to the bit map contained in the maskBits field. For some codecs, using the QuickDraw region may be more convenient than the mask bit map.
wantedDestinationPixelTypes
Discussion

Filled in by the codec during the execution of ImageCodecPreDecompress. Contains a handle to a zero-terminated list of non-RGB pixels that the codec can decompress to. Leave set to NIL if the codec does not support non-RGB pixel spaces. The ICM copies this data structure, so it is up to the codec to dispose of it later. Since the predecompress call can be called often, it is suggested that codecs allocate this handle during the Open function and dispose of it during the Close function.
screenFloodMethod
Discussion

A constant (see below) for codecs that require key-color flooding. See these constants: 
kScreenFloodMethodNone
kScreenFloodMethodKeyColor
kScreenFloodMethodAlpha
screenFloodValue
Discussion

If screenFloodMethod is kScreenFloodMethodKeyColor, contains the index of the color that should be used to flood the image area on screen when a refresh occurs. This is valid for both indexed and direct screen devices (e.g., for devices with 16 bit depth, it should contain the 5-5-5 RGB value). If screenFloodMethod is kScreenFloodMethodAlpha, contains the value that the alpha channel should be flooded with.
preferredOffscreenPixelSize
Discussion

Should be filled in ImageCodecPreDecompress with the preferred depth of an offscreen buffer should the ICM have to create one. It is not guaranteed that an offscreen buffer will actually be of this depth. A codec should still be sure to specify what depths it can decompress to by using the capabilities field. A codec might use this field if if was capable of decompressing to several depths, but was faster decompressing to a particular depth.
syncFrameTime
Discussion

A pointer to an ICMFrameTimeInfo structure. This structure contains timing information about the display of the frame.
needUpdateOnTimeChange
Discussion

Undocumented
enableBlackLining
Discussion

If TRUE, indicates that the client has requested blacklining (displaying every other line of the image). Blacklining increases the speed of movie playback while decreasing the image quality.
needUpdateOnSourceChange
Discussion

Undocumented
pad
Discussion

Unused.
unused
Discussion

Unused.
finalDestinationPort
Discussion

Undocumented
requestedBufferWidth
Discussion

Specifies the width of the image buffer to use, in pixels. For this value to be used, the codecWantsSpecialScaling flag in CodecCapabilities must be set.
requestedBufferHeight
Discussion

Specifies the height of the image buffer to use, in pixels. For this value to be used, the codecWantsSpecialScaling flag in CodecCapabilities must be set.
displayableAreaOfRequestedBuffer
Discussion

This field can be used to prevent parts of the requested buffer from being displayed. When the codecWantsSpecialScaling flag is set, this rectangle can be filled in to indicate what portion of the requested buffer's width and height should be used. The buffer rectangle created by the requested buffer is always based at (0,0), so this coordinate system is also used by displayableAreaOfRequestedBuffer. If this field is not filled in, a default value of (0,0,0,0) is used, and the entire buffer is displayed. Use this field if you are experiencing edge problems with FlashPix images.
requestedSingleField
Discussion

Undocumented
needUpdateOnNextIdle
Discussion

Undocumented
pad2
Discussion

Unused.
bufferGammaLevel
Discussion

The gamma level of the data buffer.
taskWeight
Discussion

The preferred weight for multiprocessing tasks implementing this operation. You should assign a value by means of the Mac OS function MPSetTaskWeight.
taskName
Discussion

The preferred type for multiprocessing tasks implementing this operation. You should assign a value by means of the Mac OS function MPSetTaskType.
Discussion

The Image Compression Manager creates the decompression parameters structure, and your image decompressor component is required only to provide values for the wantedDestinationPixelSize and wantedDestinationPixelTypes fields of the structure. Your image decompressor component can also modify other fields if necessary. For example, if it can scale images, it must set the codecCapabilityCanScale flag in the capabilities field of the structure.
Version Notes

Some of the fields in CodecDecompressParams were added for various versions of QuickTime starting with version 2.1. See comments in the C interface file for details.
Related Functions
ImageCodecBandDecompress
ImageCodecBeginBand
ImageCodecEffectBegin
ImageCodecEffectSetup
ImageCodecNewImageBufferMemory
ImageCodecNewImageGWorld
ImageCodecPreDecompress
ImageCodecPreflight 
Declared In
ImageCodec.h*/
struct CodecDecompressParams {
   ImageSequence              sequenceID;
   ImageDescriptionHandle     imageDescription;
   Ptr                        data;
   long                       bufferSize;
   long                       frameNumber;
   long                       startLine;
   long                       stopLine;
   long                       conditionFlags;
   CodecFlags                 callerFlags;
   CodecCapabilities *        capabilities;
   ICMProgressProcRecord      progressProcRecord;
   ICMCompletionProcRecord    completionProcRecord;
   ICMDataProcRecord          dataProcRecord;
   CGrafPtr                   port;
   PixMap                     dstPixMap;
   BitMapPtr                  maskBits;
   PixMapPtr                  mattePixMap;
   Rect                       srcRect;
   MatrixRecord *             matrix;
   CodecQ                     accuracy;
   short                      transferMode;
   ICMFrameTimePtr            frameTime;
   long                       reserved[1];
   SInt8                      matrixFlags;
   SInt8                      matrixType;
   Rect                       dstRect;
   UInt16                     majorSourceChangeSeed;
   UInt16                     minorSourceChangeSeed;
   CDSequenceDataSourcePtr    sourceData;
   RgnHandle                  maskRegion;
   OSType **                  wantedDestinationPixelTypes;
   long                       screenFloodMethod;
   long                       screenFloodValue;
   short                      preferredOffscreenPixelSize;
   ICMFrameTimeInfoPtr        syncFrameTime;
   Boolean                    needUpdateOnTimeChange;
   Boolean                    enableBlackLining;
   Boolean                    needUpdateOnSourceChange;
   Boolean                    pad;
   long                       unused;
   CGrafPtr                   finalDestinationPort;
   long                       requestedBufferWidth;
   long                       requestedBufferHeight;
   Rect                       displayableAreaOfRequestedBuffer;
   Boolean                    requestedSingleField;
   Boolean                    needUpdateOnNextIdle;
   Boolean                    pad2[2];
   fixed                      bufferGammaLevel;
   UInt32                     taskWeight;
   OSType                     taskName;
};
typedef struct CodecDecompressParams CodecDecompressParams;

/*DataRateParams

Communicates information to compressors that can constrain compressed data to a specific data rate.

struct DataRateParams {
   long      dataRate;
   long      dataOverrun;
   long      frameDuration;
   long      keyFrameRate;
   CodecQ    minSpatialQuality;
   CodecQ    minTemporalQuality;
};
Fields
dataRate
Discussion

Specifies the bytes per second to which the data rate must be constrained.
dataOverrun
Discussion

Indicates the current number of bytes above or below the desired data rate. A value of 0 means that the data rate is being met exactly. If your application doesn't know the data overrun, it should set this field to 0.
frameDuration
Discussion

Specifies the duration of the current frame in milliseconds.
keyFrameRate
Discussion

Indicates the frequency of key frames. This frequency is normally identical to the key frame rate passed to the CompressSequenceBegin.
minSpatialQuality
Discussion

A constant (see below) that specifies the minimum spatial quality the compressor should use to meet the requested data rate. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
minTemporalQuality
Discussion

A constant (see below) that specifies the minimum temporal quality the compressor should use to meet the requested data rate.
Discussion

The CodecQ data type defines a field that identifies the quality characteristics of a given image or sequence. Note that individual components may not implement all the quality levels shown here. In addition, components may implement other quality levels in the range from codecMinQuality to codecMaxQuality. Relative quality should scale within the defined value range. Values above codecLosslessQuality are reserved for use by individual components.
Related Functions
GetCSequenceDataRateParams
SetCSequenceDataRateParams 
Declared In
ImageCompression.h*/
struct DataRateParams {
   long      dataRate;
   long      dataOverrun;
   long      frameDuration;
   long      keyFrameRate;
   CodecQ    minSpatialQuality;
   CodecQ    minTemporalQuality;
};
typedef struct DataRateParams DataRateParams;

/*DataRateParamsPtr

Represents a type used by the Compression and Decompression API.

typedef DataRateParams * DataRateParamsPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef DataRateParams * DataRateParamsPtr;

/*CodecCompressParams

Contains parameters that govern a compression operation.

struct CodecCompressParams {
   ImageSequence              sequenceID;
   ImageDescriptionHandle     imageDescription;
   Ptr                        data;
   long                       bufferSize;
   long                       frameNumber;
   long                       startLine;
   long                       stopLine;
   long                       conditionFlags;
   CodecFlags                 callerFlags;
   CodecCapabilities *        capabilities;
   ICMProgressProcRecord      progressProcRecord;
   ICMCompletionProcRecord    completionProcRecord;
   ICMFlushProcRecord         flushProcRecord;
   PixMap                     srcPixMap;
   PixMap                     prevPixMap;
   CodecQ                     spatialQuality;
   CodecQ                     temporalQuality;
   Fixed                      similarity;
   DataRateParamsPtr          dataRateParams;
   long                       reserved;
   UInt16                     majorSourceChangeSeed;
   UInt16                     minorSourceChangeSeed;
   CDSequenceDataSourcePtr    sourceData;
   long                       preferredPacketSizeInBytes;
   long                       requestedBufferWidth;
   long                       requestedBufferHeight;
   OSType                     wantedSourcePixelType;
   long                       compressedDataSize;
   UInt32                     taskWeight;
   OSType                     taskName;
};
Fields
sequenceID
Discussion

Contains a unique sequence identifier. If the image to be compressed is part of a sequence, this field contains the sequence identifier that was assigned by CompressSequenceBegin. If the image is not part of a sequence, this field is set to 0.
imageDescription
Discussion

Contains a handle to the image description structure that describes the image to be compressed.
data
Discussion

Points to a location to receive the compressed image data. This is a 32-bit clean address. If there is not sufficient memory to store the compressed image, the application may choose to write the compressed data to mass storage during the compression operation. The flushProcRecord field identifies the data-unloading function that the application provides for this purpose. This field is used only by ImageCodecBandCompress.
bufferSize
Discussion

Contains the size of the buffer specified by the data field. Your component sets the value of the bufferSize field to the number of bytes of compressed data written into the buffer. Your component should not return more data than the buffer can hold; it should return a nonzero result code instead. This field is used only by ImageCodecBandCompress.
frameNumber
Discussion

Contains a frame identifier. Indicates the relative frame number within the sequence. The Image Compression Manager increments this value for each frame in the sequence. This field is used only by ImageCodecBandCompress.
startLine
Discussion

Contains the starting line for the band. This field indicates the starting line number for the band to be compressed. The line number refers to the pixel row in the image, starting from the top of the image. The first row is row number 0. This field is used only by ImageCodecBandCompress.
stopLine
Discussion

Contains the ending line for the band. This field indicates the ending line number for the band to be compressed. The line number refers to the pixel row in the image, starting from the top of the image. The first row in the image is row number 0. The image band includes the row specified by this field. So, to define a band that contains one row of pixels at the top of an image, you set the startLine field to 0 and the stopLine field to 1.
conditionFlags
Discussion

Contains flags (see below) that identify the condition under which your component has been called. This field is used only by ImageCodecBandCompress. In addition, these fields contain information about actions taken by your component. See these constants: 
codecConditionFirstBand
codecConditionLastBand
codecConditionCodecChangedMask
callerFlags
Discussion

Flags that provide further control information. This field is used only by ImageCodecBandCompress. See these constants: 
codecFlagUpdatePrevious
codecFlagWasCompressed
codecFlagUpdatePreviousComp
codecFlagLiveGrab
capabilities
Discussion

Points to a compressor capability structure. The Image Compression Manager uses this field to determine the capabilities of your compressor component. This field is used only by ImageCodecPreCompress.
progressProcRecord
Discussion

Contains an ICMProgressProcRecord structure. During the compression operation, your compressor may occasionally call a function that the application provides in order to report your progress. This field contains a structure that identifies the progress function. If the progressProc field in this structure is set to NIL, the application has not supplied a progress function. This field is used only by ImageCodecBandCompress.
completionProcRecord
Discussion

Contains an ICMCompletionProcRecord structure. This structure governs whether you perform the compression asynchronously. If the completionProc field in this structure is set to NIL, perform the compression synchronously. If this field is not NIL, it specifies an application completion function. Perform the compression asynchronously and call that completion function when your component is finished. If the completionProc field in this structure has a value of -1, perform the operation asynchronously but do not call the application's completion function. This field is used only by ImageCodecBandCompress.
flushProcRecord
Discussion

Contains an ICMFlushProcRecord structure. If there is not enough memory to store the compressed image, the application may provide a function that unloads some of the compressed data. This field contains a structure that identifies that data-unloading function. If the application did not provide a data-unloading function, the flushProc field in this structure is set to NIL. In this case, your component writes the entire compressed image into the memory location specified by the data field. The data-unloading function structure is used only by ImageCodecBandCompress.
srcPixMap
Discussion

Points to the image to be compressed. The image must be stored in a pixel map structure. The contents of this pixel map differ from a standard pixel map in two ways. First, the rowBytes field is a full 16-bit value; the high-order bit is not necessarily set to 1. Second, the baseAddr field must contain a 32-bit clean address. This field is used only by ImageCodecBandCompress.
prevPixMap
Discussion

Points to a pixel map containing the previous image. If the image to be compressed is part of a sequence that is being temporally compressed, this field defines the previous image for temporal compression. Your component should then use this previous image as the basis of comparison for the image to be compressed. If the temporalQuality field is set to 0, do not perform temporal compression. If the codecFlagUpdatePrevious flag or the codecFlagUpdatePreviousComp flag in the flags field is set to 1, update the previous image at the end of the compression operation. The contents of this pixel map differ from a standard pixel map in two ways. First, the rowBytes field is a full 16-bit value; the high-order bit is not necessarily set to 1. Second, the baseAddr field must contain a 32-bit clean address. This field is used only by ImageCodecBandCompress.
spatialQuality
Discussion

Specifies the desired compressed image quality. This field is used only by ImageCodecBandCompress.
temporalQuality
Discussion

Specifies the desired sequence temporal quality. This field governs the level of compression the application desires with respect to information in successive frames in the sequence. If this field is set to 0, do not perform temporal compression on this frame. This field is used only by ImageCodecBandCompress.
similarity
Discussion

Indicates the relative similarity between the frame just compressed and the previous frame when performing temporal compression. Fixed-point value, ranges from 0 (0x00000000), indicating a key frame, to 255 (0x00FF0000), indicating an identical frame that can be discarded without damage. If bad video would result from discarding a frame, the compressor should limit similarity to 254 (0x00FE0000). The Image Compression Manager may request a compressor to recompress a frame as a key frame if its similarity to its predecessor is very low (a value of 1 or 2, for example). The Image Compression Manager will not do this if the codecFlagLiveGrab flag is set, or if an asynchronous completion proc is supplied. This field is used only by ImageCodecBandCompress.
dataRateParams
Discussion

Points to the parameters used when performing data rate constraint.
reserved
Discussion

Reserved.
majorSourceChangeSeed
Discussion

Contains an integer value that is incremented each time a data source is added or removed. This provides a fast way for a codec to know when it needs to redetermine which data source inputs are available.
minorSourceChangeSeed
Discussion

Contains an integer value that is incremented each time a data source is added or removed, or the data contained in any of the data sources changes. This provides a way for a codec to know if the data available to it has changed.
sourceData
Discussion

Contains a pointer to a CDSequenceDataSource structure. This structure contains a linked list of all data sources. Because each data source contains a link to the next data source, a codec can access all data sources from this field.
preferredPacketSizeInBytes
Discussion

Specifies the preferred packet size for data.
requestedBufferWidth
Discussion

Specifies the the width of the image buffer to use, in pixels. For this value to be used, the codecWantsSpecialScaling flag in the CodecCapabilities structure must be set.
requestedBufferHeight
Discussion

Specifies the the height of the image buffer to use, in pixels. For this value to be used, the codecWantsSpecialScaling flag in the CodecCapabilities structure must be set.
wantedSourcePixelType
Discussion

Undocumented
compressedDataSize
Discussion

The size of the compressed image, in bytes. If this field is nonzero, it overrides the dataSize field of the ImageDescription structure. This provides a safer way for asynchronous compressors to return the size of the compressed frame data, because the dataSize field of ImageDescription may be referenced by an unlocked handle.
taskWeight
Discussion

The preferred weight for multiprocessing tasks implementing this operation. You should assign a value by means of the Mac OS function MPSetTaskWeight.
taskName
Discussion

The preferred type for multiprocessing tasks implementing this operation. You should assign a value by means of the Mac OS function MPSetTaskType.
Discussion

Compressor components accept the parameters that govern a compression operation in the form of the CodecCompressParams structure. This structure is used by ImageCodecBandCompress and ImageCodecPreCompress.
Version Notes

Some of the fields in CodecCompressParams were added for various versions of QuickTime starting with version 2.1. See comments in the C interface file for details.
Related Functions
ImageCodecBandCompress
ImageCodecPreCompress 
Declared In
ImageCodec.h*/

struct CodecCompressParams {
   ImageSequence              sequenceID;
   ImageDescriptionHandle     imageDescription;
   Ptr                        data;
   long                       bufferSize;
   long                       frameNumber;
   long                       startLine;
   long                       stopLine;
   long                       conditionFlags;
   CodecFlags                 callerFlags;
   CodecCapabilities *        capabilities;
   ICMProgressProcRecord      progressProcRecord;
   ICMCompletionProcRecord    completionProcRecord;
   ICMFlushProcRecord         flushProcRecord;
   PixMap                     srcPixMap;
   PixMap                     prevPixMap;
   CodecQ                     spatialQuality;
   CodecQ                     temporalQuality;
   Fixed                      similarity;
   DataRateParamsPtr          dataRateParams;
   long                       reserved;
   UInt16                     majorSourceChangeSeed;
   UInt16                     minorSourceChangeSeed;
   CDSequenceDataSourcePtr    sourceData;
   long                       preferredPacketSizeInBytes;
   long                       requestedBufferWidth;
   long                       requestedBufferHeight;
   OSType                     wantedSourcePixelType;
   long                       compressedDataSize;
   UInt32                     taskWeight;
   OSType                     taskName;
};
typedef struct CodecCompressParams CodecCompressParams;

/*ImageCodecMPDrawBandProc

Undocumented

typedef ComponentResult (*ImageCodecMPDrawBandProcPtr) (void *refcon, ImageSubCodecDecompressRecord *drp);

If you name your function MyImageCodecMPDrawBandProc, you would declare it this way:

ComponentResult MyImageCodecMPDrawBandProc (
   void                             *refcon,
   ImageSubCodecDecompressRecord    *drp );
Parameters
refcon

Pointer to a reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
drp

Pointer to an ImageSubCodecDecompressRecord structure.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
ImageCodec.h*/

typedef ComponentResult (*ImageCodecMPDrawBandProcPtr) (void *refcon, ImageSubCodecDecompressRecord *drp);


/*ImageCodecMPDrawBandUPP

Represents a type used by the Image Codec API.

typedef STACK_UPP_TYPE(ImageCodecMPDrawBandProcPtr) ImageCodecMPDrawBandUPP;
Declared In
ImageCodec.h*/
typedef STACK_UPP_TYPE(ImageCodecMPDrawBandProcPtr) ImageCodecMPDrawBandUPP;

/*ImageCodecTimeTriggerProc

Undocumented

typedef void (*ImageCodecTimeTriggerProcPtr) (void *refcon);

If you name your function MyImageCodecTimeTriggerProc, you would declare it this way:

void MyImageCodecTimeTriggerProc (
   void    *refcon );
Parameters
refcon

Pointer to a reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Declared In
ImageCodec.h*/
typedef void (*ImageCodecTimeTriggerProcPtr) (void *refcon);

/*ImageCodecTimeTriggerUPP

Represents a type used by the Image Codec API.

typedef STACK_UPP_TYPE(ImageCodecTimeTriggerProcPtr) ImageCodecTimeTriggerUPP;
Declared In
ImageCodec.h*/
typedef STACK_UPP_TYPE(ImageCodecTimeTriggerProcPtr) ImageCodecTimeTriggerUPP;

/*EffectSourcePtr

Represents a type used by the Image Codec API.

typedef EffectSource * EffectSourcePtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
typedef struct EffectSource EffectSource;
typedef EffectSource * EffectSourcePtr;

/*Effect Source Descriptors

These data structures describe the sources to an effect. The SourceData data structure contains a pointer to raw image compression manager image data, if the effect is being executed outside of a QuickTime movie, or to an effect that acts as the source, if the effect is being executed as part of an effect track in a QuickTime movie. The EffectSourcePtr data structure holds information about the type of source, as well as pointers to the track data of the effect and to the next source in the input chain.typedef struct EffectSource     EffectSource;
typedef EffectSource            *EffectSourcePtr;
union SourceData {
    CDSequenceDataSourcePtr image;
    EffectSourcePtr     effect;
};
typedef union SourceData SourceData;

Term	
Definition

image	
A pointer to the raw source image data.

effect	
A pointer to the effect.
struct EffectSource {
    long                effectType;
    Ptr                 data;
    SourceData          source;
    EffectSourcePtr     next;
};

Term	
Definition

effectType	
The type of the effect or the constant kEffectRawSource if the source is raw image compression manager data.

data	
A pointer to the track data for the effect.

source	
The source itself.

next	
A pointer to the next source in the input chain.*/
typedef EffectSource            * EffectSourcePtr;
union SourceData {
    CDSequenceDataSourcePtr image;
    EffectSourcePtr     effect;
};
typedef union SourceData SourceData;

/*EffectSource

Provides data for the EffectsFrameParams structure.

struct EffectSource {
   long               effectType;
   Ptr                data;
   SourceData         source;
   EffectSourcePtr    next;
Fields
effectType
Discussion

The type of the effect or a default effect type constant (see below). Enter kEffectRawSource if the source is raw image compression manager data. See these constants: 
kEffectRawSource
kEffectGenericType
data
Discussion

A pointer to the track data for the effect.
source
Discussion

The source itself.
next
Discussion

A pointer to the next source in the input chain.
lastTranslatedFrameTime
Discussion

The start frame time of last converted frame; this value may be -1.
lastFrameDuration
Discussion

The duration of the last converted frame; this value may be 0.
lastFrameTimeScale
Discussion

The time scale of this source frame; this field has meaning only if the lastTranslatedFrameTime and lastFrameDuration fields are valid.
Related Functions
ImageCodecEffectConvertEffectSourceToFormat 
Declared In
ImageCodec.h*/

struct EffectSource {
   long               effectType;
   Ptr                data;
   SourceData         source;
   EffectSourcePtr    next};
typedef struct EffectSource EffectSource;

/*EffectSourcePtr

Represents a type used by the Image Codec API.

typedef EffectSource * EffectSourcePtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
typedef EffectSource * EffectSourcePtr;

/*EffectsFrameParams

Contains information about the current frame of a video effect.

struct EffectsFrameParams {
   ICMFrameTimeRecord    frameTime;
   long                  effectDuration;
   Boolean               doAsync;
   unsigned char         pad[3];
   EffectSourcePtr       source;
   void *                refCon;
};
Fields
frameTime
Discussion

Timing data for the current frame. This structure includes information such as the total number of frames being rendered in this sequence, and the current frame number.
effectDuration
Discussion

The duration of a single effect frame.
doAsync
Discussion

This field contains TRUE if the effect can process asynchronously.
pad
Discussion

Unused.
source
Discussion

A pointer to the input sources; see the EffectSource structure.
refCon
Discussion

A pointer to storage for this instantiation of the effect.
Related Functions
ImageCodecEffectBegin
ImageCodecEffectCancel
ImageCodecEffectRenderFrame 
Declared In
ImageCodec.h*/

struct EffectsFrameParams {
   ICMFrameTimeRecord    frameTime;
   long                  effectDuration;
   Boolean               doAsync;
   unsigned char         pad[3];
   EffectSourcePtr       source;
   void *                refCon;
};
typedef struct  EffectsFrameParams EffectsFrameParams;

/*EffectsFrameParamsPtr

Represents a type used by the Image Codec API.

typedef EffectsFrameParams * EffectsFrameParamsPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
typedef EffectsFrameParams * EffectsFrameParamsPtr;

/*CDSequenceDataSource

Contains a linked list of all data sources for a decompression sequence.

struct CDSequenceDataSource {
   long                       recordSize;
   void *                     next;
   ImageSequence              seqID;
   ImageSequenceDataSource    sourceID;
   OSType                     sourceType;
   long                       sourceInputNumber;
   void *                     dataPtr;
   Handle                     dataDescription;
   long                       changeSeed;
   ICMConvertDataFormatUPP    transferProc;
   void *                     transferRefcon;
   long                       dataSize;
   QHdrPtr                    dataQueue;
   void *                     originalDataPtr;
   long                       originalDataSize;
   Handle                     originalDataDescription;
   long                       originalDataDescriptionSeed;
};
Fields
recordSize
Discussion

The size of this structure.
next
Discussion

A pointer to the next source entry. If it is NIL, there are no more entries.
seqID
Discussion

The image sequence that this source is associated with.
sourceID
Discussion

The source reference identifying this source.
sourceType
Discussion

A four-character code describing how the input will be used. This value is passed to this parameter by CDSequenceNewDataSource when the source is created.
sourceInputNumber
Discussion

A value is passed to this parameter by CDSequenceNewDataSource when the source is created.
dataPtr
Discussion

A pointer to the actual source data.
dataDescription
Discussion

A handle to a data structure describing the data format. This is often a handle to an ImageDescription structure.
changeSeed
Discussion

An integer that is incremented each time the dataPtr field changes or that data that the dataPtr field points to changes. By remembering the value of this field and comparing to the value the next time the decompressor or compressor component is called, the component can determine if new data is present.
transferProc
Discussion

Reserved.
transferRefcon
Discussion

Reserved.
dataSize
Discussion

The size of the data pointed to by the dataPtr field.
dataQueue
Discussion

A pointer to a QHdr structure that contains a queue of CDSequenceDataSourceQueueEntry structures.
originalDataPtr
Discussion

The original value of dataPtr.
originalDataSize
Discussion

The original value of dataSize.
originalDataDescription
Discussion

The original value of dataDescription.
originalDataDescriptionSeed
Discussion

The original value of changeSeed.
Discussion

Because each data source is associated with a link to the next data source, a codec can access all data sources using this structure.
Version Notes

Fields from dataQueue onward were introduced in QuickTime 3.
Related Functions
ImageCodecGetMaxCompressionSizeWithSources
ImageCodecSourceChanged 
Declared In
ImageCodec.h*/

struct CDSequenceDataSource {
   long                       recordSize;
   void *                     next;
   ImageSequence              seqID;
   ImageSequenceDataSource    sourceID;
   OSType                     sourceType;
   long                       sourceInputNumber;
   void *                     dataPtr;
   Handle                     dataDescription;
   long                       changeSeed;
   ICMConvertDataFormatUPP    transferProc;
   void *                     transferRefcon;
   long                       dataSize;
   QHdrPtr                    dataQueue;
   void *                     originalDataPtr;
   long                       originalDataSize;
   Handle                     originalDataDescription;
   long                       originalDataDescriptionSeed;
};
typedef struct CDSequenceDataSource CDSequenceDataSource;

//function


/*ImageCodecGetParameterList

Returns a parameter description atom container for a specified effect component instance.

ComponentResult ImageCodecGetParameterList (
   ComponentInstance    ci,
   QTAtomContainer      *parameterDescription );
Parameters
ci

An effect component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
parameterDescription

The returned atom container for this component instance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns the parameter description for the effect specified by the component instance ci, as a handle containing an 'atms' resource of ID 1. The handle should be detached if it has been read in from a resource. Each parameter of the effect is described in the parameter description, with details of its name, type, legal values and hints about how a user interface to the parameter should be constructed.
Special Considerations

The calling application is responsible for disposing of the QT atom container returned in parameterDescription. The application should do this by calling QTDisposeAtomContainer once it has finished using the parameter description.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/

ComponentResult ImageCodecGetParameterList (
   ComponentInstance    ci,
   QTAtomContainer      *parameterDescription );


/*ImageCodecEffectConvertEffectSourceToFormat

Undocumented

ComponentResult ImageCodecEffectConvertEffectSourceToFormat (
   ComponentInstance         effect,
   EffectSourcePtr           sourceToConvert,
   ImageDescriptionHandle    requestedDesc );
Parameters
effect

An effect component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
sourceToConvert

Undocumented
requestedDesc

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/

ComponentResult ImageCodecEffectConvertEffectSourceToFormat (
   ComponentInstance         effect,
   EffectSourcePtr           sourceToConvert,
   ImageDescriptionHandle    requestedDesc );


#ifdef __cplusplus
}
#endif
#endif