#ifndef QUICKTIMEVRFORMAT_H
#define QUICKTIMEVRFORMAT_H

#ifndef __QUICKTIMEVRFORMAT__
#define __QUICKTIMEVRFORMAT__

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef MOVIES_H
#include <QuickTime/Movies.h>
#endif

#ifndef QUICKTIMEVR_H
#include <QuickTime/QuickTimeVR.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

/*VR Media

This section describes the QuickTime VR world and node information atom containers, which can be obtained by calling the QuickTime VR Manager routines QTVRGetVRWorld and QTVRGetNodeInfo. Those routines, as well as a complete discussion of QuickTime VR and how your application can create QuickTime VR movies, are described in detail in Programming With QuickTime VR, available at http://developer.apple.com/documentation/Quicktime/Quicktime.html. 

Many atom types contained in the VR world and node information atom containers are unique within their container. For example, each has a single header atom. Most parent atoms within an atom container are unique as well, such as the node parent atom in the VR world atom container or the hot spot parent atom in the node information atom container. For these one-time-only atoms, the atom ID is always set to 1. Unless otherwise mentioned in the descriptions of the atoms that follow, assume that the atom ID is 1.

Note that many atom structures contain two version fields, majorVersion and minorVersion. The values of these fields correspond to the constants kQTVRMajorVersion and kQTVRMinorVersion found in the header file QuickTimeVRFormat.h. For QuickTime 2.0 files, these values are 2 and 0.

QuickTime provides a number of routines for both creating and accessing atom containers. 

Some of the leaf atoms within the VR world and node information atom containers contain fields that specify the ID of string atoms that are siblings of the leaf atom. For example, the VR world header atom contains a field for the name of the scene. The string atom is a leaf atom whose atom type is kQTVRStringAtomType ('vrsg'). Its atom ID is that specified by the referring leaf atom. 

A string atom contains a string. The structure of a string atom is defined by the QTVRStringAtom data type:
typedef struct QTVRStringAtom {
    UInt16                              stringUsage;
    UInt16                              stringLength;
    unsigned char                       theString[4];
} QTVRStringAtom, *QTVRStringAtomPtr;

Field descriptions
stringUsage

The string usage. This field is unused.
stringLength

The length, in bytes, of the string.
theString

The string. The string atom structure is extended to hold this string.

Each string atom may also have a sibling leaf atom called the string encoding atom. The string encoding atom’s atom type is kQTVRStringEncodingAtomType ('vrse'). Its atom ID is the same as that of the corresponding string atom. The string encoding atom contains a single variable, TextEncoding, a UInt32, as defined in the header file TextCommon.h. The value of TextEncoding is handed, along with the string, to the routine QTTextToNativeText for conversion for display on the current machine. The routine QTTextToNativeText is found in the header file Movies.h.

Note: The header file TextCommon.h contains constants and routines for generating and handling text encodings. <8bat>u*/
typedef struct QTVRStringAtom {
    UInt16                              stringUsage;
    UInt16                              stringLength;
    unsigned char                       theString[4];
} QTVRStringAtom, *QTVRStringAtomPtr;


/*VR World Header Atom Structuretypedef 
struct QTVRWorldHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    QTAtomID                            nameAtomID;
    UInt32                              defaultNodeID;
    UInt32                              vrWorldFlags;
    UInt32                              reserved1;
    UInt32                              reserved2;
} QTVRWorldHeaderAtom, *QTVRWorldHeaderAtomPtr;*/
struct QTVRWorldHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    QTAtomID                            nameAtomID;
    UInt32                              defaultNodeID;
    UInt32                              vrWorldFlags;
    UInt32                              reserved1;
    UInt32                              reserved2;
};
typedef struct  QTVRWorldHeaderAtom QTVRWorldHeaderAtom;
typedef QTVRWorldHeaderAtom *QTVRWorldHeaderAtomPtr;


/*VR World Atom Types
enum {
    kQTVRWorldHeaderAtomType    = FOUR_CHAR_CODE('vrsc'),
    kQTVRImagingParentAtomType  = FOUR_CHAR_CODE('imgp'),
    kQTVRPanoImagingAtomType    = FOUR_CHAR_CODE('impn'),
    kQTVRObjectImagingAtomType  = FOUR_CHAR_CODE('imob'),
    kQTVRNodeParentAtomType     = FOUR_CHAR_CODE('vrnp'),
    kQTVRNodeIDAtomType         = FOUR_CHAR_CODE('vrni'),
    kQTVRNodeLocationAtomType   = FOUR_CHAR_CODE('nloc')
};*/
enum {
    kQTVRWorldHeaderAtomType    = FOUR_CHAR_CODE('vrsc'),
    kQTVRImagingParentAtomType  = FOUR_CHAR_CODE('imgp'),
    kQTVRPanoImagingAtomType    = FOUR_CHAR_CODE('impn'),
    kQTVRObjectImagingAtomType  = FOUR_CHAR_CODE('imob'),
    kQTVRNodeParentAtomType     = FOUR_CHAR_CODE('vrnp'),
    kQTVRNodeIDAtomType         = FOUR_CHAR_CODE('vrni'),
    kQTVRNodeLocationAtomType   = FOUR_CHAR_CODE('nloc')
};



/*VR World Header Atom Structure

The VR world header atom is a leaf atom. Its atom type is kQTVRWorldHeaderAtomType ('vrsc'). It contains the name of the scene and the default node ID to be used when the file is first opened as well as fields reserved for future use. 

The structure of a VR world header atom is defined by the QTVRWorldHeaderAtom data type:
typedef struct VRWorldHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    QTAtomID                            nameAtomID;
    UInt32                              defaultNodeID;
    UInt32                              vrWorldFlags;
    UInt32                              reserved1;
    UInt32                              reserved2;
} VRWorldHeaderAtom, *QTVRWorldHeaderAtomPtr;
QT
QT

Field descriptions
majorVersion

The major version number of the file format.
minorVersion

The minor version number of the file format.
nameAtomID

The ID of the string atom that contains the name of the scene. That atom should be a sibling of the VR world header atom. The value of this field is 0 if no name string atom exists.
defaultNodeID

The ID of the default node (that is, the node to be displayed when the file is first opened).
vrWorldFlags

A set of flags for the VR world. This field is unused.
reserved1

Reserved. This field must be 0.
reserved2

Reserved. This field must be 0.*/

struct VRWorldHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    QTAtomID                            nameAtomID;
    UInt32                              defaultNodeID;
    UInt32                              vrWorldFlags;
    UInt32                              reserved1;
    UInt32                              reserved2;
};
typedef struct  VRWorldHeaderAtom VRWorldHeaderAtom;
typedef VRWorldHeaderAtom *VRWorldHeaderAtomPtr;

/*Node Header Atom Structuretypedef 
struct QTVRNodeHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    OSType                              nodeType;
    QTAtomID                            nodeID;
    QTAtomID                            nameAtomID;
    QTAtomID                            commentAtomID;
    UInt32                              reserved1;
    UInt32                              reserved2;
} QTVRNodeHeaderAtom, *QTVRNodeHeaderAtomPtr;*/
struct QTVRNodeHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    OSType                              nodeType;
    QTAtomID                            nodeID;
    QTAtomID                            nameAtomID;
    QTAtomID                            commentAtomID;
    UInt32                              reserved1;
    UInt32                              reserved2;
};

typedef struct QTVRNodeHeaderAtom QTVRNodeHeaderAtom;
typedef QTVRNodeHeaderAtom  *QTVRNodeHeaderAtomPtr;


/*Hot Spot Information Atom Structuretypedef 
struct QTVRHotSpotInfoAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    OSType                              hotSpotType;
    QTAtomID                            nameAtomID;
    QTAtomID                            commentAtomID;
    SInt32                              cursorID[3];
    Float32                             bestPan;
    Float32                             bestTilt;
    Float32                             bestFOV;
    FloatPoint                          bestViewCenter;
    Rect                                hotSpotRect;
    UInt32                              flags;
    UInt32                              reserved1;
    UInt32                              reserved2;
} QTVRHotSpotInfoAtom, *QTVRHotSpotInfoAtomPtr;*/

struct QTVRHotSpotInfoAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    OSType                              hotSpotType;
    QTAtomID                            nameAtomID;
    QTAtomID                            commentAtomID;
    SInt32                              cursorID[3];
    Float32                             bestPan;
    Float32                             bestTilt;
    Float32                             bestFOV;
    FloatPoint                          bestViewCenter;
    Rect                                hotSpotRect;
    UInt32                              flags;
    UInt32                              reserved1;
    UInt32                              reserved2;
};
typedef struct QTVRHotSpotInfoAtom  QTVRHotSpotInfoAtom;
typedef QTVRHotSpotInfoAtom  *QTVRHotSpotInfoAtomPtr;


#endif
#endif