#ifndef MACH_O_LOADER_H
#define MACH_O_LOADER_H


#include <stdint.h>
#include <mach/machine.h>
#include <mach/vm_prot.h>
#include <mach/machine/thread_status.h>
#include <architecture/byte_order.h>
#include <HYS/mach-o/loader.h>

/*mach_header_64

Defines the general attributes of a file targeted for a 64-bit architecture. Declared in /usr/include/mach-o/loader.h.

struct mach_header_64
   {
   uint32_t magic;
   cpu_type_t cputype;
   cpu_subtype_t cpusubtype;
   uint32_t filetype;
   uint32_t ncmds;
   uint32_t sizeofcmds;
   uint32_t flags;
   uint32_t reserved;
};
Fields
magic

An integer containing a value identifying this file as a 64-bit Mach-O file. Use the constant MH_MAGIC_64 if the file is intended for use on a CPU with the same endianness as the computer on which the compiler is running. The constant MH_CIGAM_64 can be used when the byte ordering scheme of the target machine is the reverse of the host CPU.
cputype

An integer indicating the architecture you intend to use the file on. The only appropriate value for this structure is:
CPU_TYPE_POWERPC64 to target 64-bit PowerPC–based Macintosh computers.
cpusubtype

An integer specifying the exact model of the CPU. To run on all PowerPC processors supported by the Mac OS X kernel, this should be set to CPU_SUBTYPE_POWERPC_ALL.
filetype

An integer indicating the usage and alignment of the file. Valid values for this field include:
The MH_OBJECT file type is the format used for intermediate object files. It is a very compact format containing all its sections in one segment. The compiler and assembler usually create one MH_OBJECT file for each source code file. By convention, the file name extension for this format is .o.
The MH_EXECUTE file type is the format used by standard executable programs.
The MH_BUNDLE file type is the type typically used by code that you load at runtime (typically called bundles or plug-ins). By convention, the file name extension for this format is .bundle.
The MH_DYLIB file type is for dynamic shared libraries. It contains some additional tables to support multiple modules. By convention, the file name extension for this format is .dylib, except for the main shared library of a framework, which does not usually have a file name extension.
The MH_PRELOAD file type is an executable format used for special-purpose programs that are not loaded by the Mac OS X kernel, such as programs burned into programmable ROM chips. Do not confuse this file type with the MH_PREBOUND flag, which is a flag that the static linker sets in the header structure to mark a prebound image.
The MH_CORE file type is used to store core files, which are traditionally created when a program crashes. Core files store the entire address space of a process at the time it crashed. You can later run gdb on the core file to figure out why the crash occurred.
The MH_DYLINKER file type is the type of a dynamic linker shared library. This is the type of the dyld file.
The MH_DSYM file type designates files that store symbol information for a corresponding binary file.
ncmds

An integer indicating the number of load commands following the header structure.
sizeofcmds

An integer indicating the number of bytes occupied by the load commands following the header structure.
flags

An integer containing a set of bit flags that indicate the state of certain optional features of the Mach-O file format. These are the masks you can use to manipulate this field:
MH_NOUNDEFS—The object file contained no undefined references when it was built.
MH_INCRLINK—The object file is the output of an incremental link against a base file and cannot be linked again.
MH_DYLDLINK—The file is input for the dynamic linker and cannot be statically linked again.
MH_TWOLEVEL—The image is using two-level namespace bindings.
MH_BINDATLOAD—The dynamic linker should bind the undefined references when the file is loaded.
MH_PREBOUND—The file’s undefined references are prebound.
MH_PREBINDABLE—This file is not prebound but can have its prebinding redone. Used only when MH_PREBEOUND is not set.
MH_NOFIXPREBINDING—The dynamic linker doesn’t notify the prebinding agent about this executable.
MH_ALLMODSBOUND—Indicates that this binary binds to all two-level namespace modules of its dependent libraries. Used only when MH_PREBINDABLE and MH_TWOLEVEL are set.
MH_CANONICAL—This file has been canonicalized by unprebinding—clearing prebinding information from the file. See the redo_prebinding man page for details.
MH_SPLIT_SEGS—The file has its read-only and read-write segments split.
MH_FORCE_FLAT—The executable is forcing all images to use flat namespace bindings.
MH_SUBSECTIONS_VIA_SYMBOLS—The sections of the object file can be divided into individual blocks. These blocks are dead-stripped if they are not used by other code. See “Linking” in Xcode 2 User Guide for details.
MH_NOMULTIDEFS—This umbrella guarantees there are no multiple definitions of symbols in its subimages. As a result, the two-level namespace hints can always be used.
reserved

Reserved for future use.
Special Considerations

See comment in mach_header*/

struct mach_header_64
   {
   uint32_t magic;
   cpu_type_t cputype;
   cpu_subtype_t cpusubtype;
   uint32_t filetype;
   uint32_t ncmds;
   uint32_t sizeofcmds;
   uint32_t flags;
   uint32_t reserved;
};

/*mach_header

Specifies the general attributes of a file. Appears at the beginning of object files targeted to 32-bit architectures. Declared in /usr/include/mach-o/loader.h. See also mach_header_64.

struct mach_header
   {
   uint32_t magic;
   cpu_type_t cputype;
   cpu_subtype_t cpusubtype;
   uint32_t filetype;
   uint32_t ncmds;
   uint32_t sizeofcmds;
   uint32_t flags;
};
Fields
magic

An integer containing a value identifying this file as a 32-bit Mach-O file. Use the constant MH_MAGIC if the file is intended for use on a CPU with the same endianness as the computer on which the compiler is running. The constant MH_CIGAM can be used when the byte ordering scheme of the target machine is the reverse of the host CPU.
cputype

An integer indicating the architecture you intend to use the file on. Appropriate values include:
CPU_TYPE_POWERPC to target PowerPC-based Macintosh computers
CPU_TYPE_I386 to target the Intel-based Macintosh computers
cpusubtype

An integer specifying the exact model of the CPU. To run on all PowerPC or x86 processors supported by the Mac OS X kernel, this should be set to CPU_SUBTYPE_POWERPC_ALL or CPU_SUBTYPE_I386_ALL.
filetype

An integer indicating the usage and alignment of the file. Valid values for this field include:
The MH_OBJECT file type is the format used for intermediate object files. It is a very compact format containing all its sections in one segment. The compiler and assembler usually create one MH_OBJECT file for each source code file. By convention, the file name extension for this format is .o.
The MH_EXECUTE file type is the format used by standard executable programs.
The MH_BUNDLE file type is the type typically used by code that you load at runtime (typically called bundles or plug-ins). By convention, the file name extension for this format is .bundle.
The MH_DYLIB file type is for dynamic shared libraries. It contains some additional tables to support multiple modules. By convention, the file name extension for this format is .dylib, except for the main shared library of a framework, which does not usually have a file name extension.
The MH_PRELOAD file type is an executable format used for special-purpose programs that are not loaded by the Mac OS X kernel, such as programs burned into programmable ROM chips. Do not confuse this file type with the MH_PREBOUND flag, which is a flag that the static linker sets in the header structure to mark a prebound image.
The MH_CORE file type is used to store core files, which are traditionally created when a program crashes. Core files store the entire address space of a process at the time it crashed. You can later run gdb on the core file to figure out why the crash occurred.
The MH_DYLINKER file type is the type of a dynamic linker shared library. This is the type of the dyld file.
The MH_DSYM file type designates files that store symbol information for a corresponding binary file.
ncmds

An integer indicating the number of load commands following the header structure.
sizeofcmds

An integer indicating the number of bytes occupied by the load commands following the header structure.
flags

An integer containing a set of bit flags that indicate the state of certain optional features of the Mach-O file format. These are the masks you can use to manipulate this field:
MH_NOUNDEFS—The object file contained no undefined references when it was built.
MH_INCRLINK—The object file is the output of an incremental link against a base file and cannot be linked again.
MH_DYLDLINK—The file is input for the dynamic linker and cannot be statically linked again.
MH_TWOLEVEL—The image is using two-level namespace bindings.
MH_BINDATLOAD—The dynamic linker should bind the undefined references when the file is loaded.
MH_PREBOUND—The file’s undefined references are prebound.
MH_PREBINDABLE—This file is not prebound but can have its prebinding redone. Used only when MH_PREBEOUND is not set.
MH_NOFIXPREBINDING—The dynamic linker doesn’t notify the prebinding agent about this executable.
MH_ALLMODSBOUND—Indicates that this binary binds to all two-level namespace modules of its dependent libraries. Used only when MH_PREBINDABLE and MH_TWOLEVEL are set.
MH_CANONICAL—This file has been canonicalized by unprebinding—clearing prebinding information from the file. See the redo_prebinding man page for details.
MH_SPLIT_SEGS—The file has its read-only and read-write segments split.
MH_FORCE_FLAT—The executable is forcing all images to use flat namespace bindings.
MH_SUBSECTIONS_VIA_SYMBOLS—The sections of the object file can be divided into individual blocks. These blocks are dead-stripped if they are not used by other code. See “Linking” in Xcode User Guide for details.
MH_NOMULTIDEFS—This umbrella guarantees there are no multiple definitions of symbols in its subimages. As a result, the two-level namespace hints can always be used.
Special Considerations

For all file types, except MH_OBJECT, segments must be aligned on page boundaries for the given CPU architecture: 4096 bytes for PowerPC and x86 processors. This allows the kernel to page virtual memory directly from the segment into the address space of the process. The header and load commands must be aligned as part of the data of the first segment stored on disk (which would be the __TEXT segment, in the file types described in filetype).*/

struct mach_header
   {
   uint32_t magic;
   cpu_type_t cputype;
   cpu_subtype_t cpusubtype;
   uint32_t filetype;
   uint32_t ncmds;
   uint32_t sizeofcmds;
   uint32_t flags;
};

#endif