#ifndef AUDIOTOOLBOX_H
#include <AudioToolbox/AudioToolbox.h>
#endif

/*AudioFileReadPackets

Reads in a certain number of packets from the input file.

extern OSStatus AudioFileReadPackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 *outNumBytes,
AudioStreamPacketDescription *outPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *outBuffer
);
Discussion

This function reads in the contents of the file by packet, starting at inStartingPoint. The packets that have been read are described in outPacketDescriptions, while the number of packets is specified in ioNumPackets (with the actual number of packets read being the return value), and the size, in bytes, of the read in packets returned in outNumBytes. If the read should be cached, set inUseCache to true.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioFileReadPackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 *outNumBytes,
AudioStreamPacketDescription *outPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *outBuffer){
//TODO
};



/*AudioFileGetProperty

Returns the data for the specified property.

extern OSStatus AudioFileGetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *ioDataSize,
void *outPropertyData
);
Discussion

The file and property being queried should be specified in inAudioFile and inPropertyID, respectively, with the size retrieved with AudioFileGetPropertyInfo() passed into ioDataSize, and the resulting data being placed in outPropertyData.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioFileGetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *ioDataSize,
void *outPropertyData){
//TODO
};


/*AudioFileGetPropertyInfo

Returns the size of the data that will be returned for the property.

extern OSStatus AudioFileGetPropertyInfo(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *outDataSize,
UInt32 *isWritable
);
Discussion

The file being queried should be passed in as inAudioFile, while the property being queried is passed in as inPropertyID. The size of the resulting data is returned in outDataSize, and isWritable will reflect if the data is modifiable.
Availability
Available in Mac OS X v10.2 and later.*/
extern OSStatus AudioFileGetPropertyInfo(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *outDataSize,
UInt32 *isWritable){
//TODO
};


/*AudioFileWritePackets

Writes the buffer to the file, by packets.

extern OSStatus AudioFileWritePackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 inNumBytes,
AudioStreamPacketDescription *inPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *inBuffer
);
Discussion

When writing to inAudioFile, specify the starting index as inStartingPacket, the format of the packet as defined in inPacketDescrptions, the size of the write as inNumBytes, and the number of packets to be written in ioNumPackets. If the write should be cached, set inUseCache to true.
Availability
Available in Mac OS X v10.2 and later.
Property Access*/
OSStatus AudioFileWritePackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 inNumBytes,
AudioStreamPacketDescription *inPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *inBuffer){
//TODO
};



/*AudioFileCreate

Creates a new file using the descriptions provided.

extern OSStatus AudioFileCreate(
const FSRef *inParentRef,
CFStringRef inFileName,
UInt32 inFileType,
const AudioStreamBasicDescription *inFormat,
UInt32 inFlags,
FSRef *outNewFileRef,
AudioFileID *outAudioFile
);
Discussion

The directory that the file to be place into is provided with inParentRef, the name of the file is contained within inFileName, a File Type constant must be provided with inFileType, the format must be specified using inFormat, inFlag contains flags for opening and creating the file (currently undefined; should be set to 0), and outNewFileRef is provided for file system use, while outAudioFile is for use with other audio file functions.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus AudioFileCreate(
const FSRef *inParentRef,
CFStringRef inFileName,
UInt32 inFileType,
const AudioStreamBasicDescription *inFormat,
UInt32 inFlags,
FSRef *outNewFileRef,
AudioFileID *outAudioFile){
//TODO
};



/*AudioFileSetProperty

Sets the data for the respective property.

extern OSStatus AudioFileSetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 inDataSize,
const void *inPropertyData
);
Discussion

The file and property being set should be specified in inAudioFile and inPropertyID, respectively, with the size of the data being written passed into ioDataSize, and the data being written coming from inPropertyData.
Availability
Available in Mac OS X v10.2 and later.
Global Info Access*/
extern OSStatus AudioFileSetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 inDataSize,
const void *inPropertyData){
//TODO
};


/*AudioFileClose

Closes the file.

extern OSStatus AudioFileClose(AudioFileID inAudioFile);
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioFileClose(AudioFileID inAudioFile){
//TODO
};


/*AudioFileOpen

Opens a file while preserving its contents.

extern OSStatus AudioFileOpen (
const FSRef *inFileRef,
SInt8 inPermissions,
UInt32 inFlags,
AudioFileID *outAudioFile
);
Discussion

The inFileRef should be a reference to an existing file, inPermissions being the permissions for the file, as used by FSOpenFork(), and inFlags, currently undefined, should be set to 0; outAudioFile is a file instance that will be returned for use in other audio file functions.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus AudioFileOpen (
const FSRef *inFileRef,
SInt8 inPermissions,
UInt32 inFlags,
AudioFileID *outAudioFile){
//TODO
};


/*AudioFormatGetPropertyInfo

Retrieves the size of the data to be returned by the property.

extern OSStatus AudioFormatGetPropertyInfo(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* outPropertyDataSize
);
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus AudioFormatGetPropertyInfo(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* outPropertyDataSize){
//TODO
};


/*AudioFormatGetProperty

Retrieves the property information for the given property ID and selected specifier.

extern OSStatus AudioFormatGetProperty(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* ioPropertyDataSize,
void* outPropertyData
);
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus AudioFormatGetProperty(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* ioPropertyDataSize,
void* outPropertyData){
//TODO
};


//function
/*AudioConverterSetProperty

Sets the property data to inPropertyData.

extern OSStatus AudioConverterSetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 inPropertyDataSize,
const void* inPropertyData
);
Discussion

The inPropertyDataSize should be the size of data being input, and inPropertyData should point to the data to be set for inPropertyID.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterSetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 inPropertyDataSize,
const void* inPropertyData
){};


/*AudioConverterGetProperty

Returns the requested property data.

extern OSStatus AudioConverterGetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* ioPropertyDataSize,
void* outPropertyData
);
Discussion

The ioPropertyDataSize parameter should be the value obtained from calling AudioConverterGetPropertyInfo(); the output value of ioPropertyDataSize will be the actual data size of the returned data, for reference.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterGetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* ioPropertyDataSize,
void* outPropertyData
){};



/*AudioConverterGetPropertyInfo

Retrieves the size and writable state of the data belonging to the queried property.

extern OSStatus AudioConverterGetPropertyInfo(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* outSize,
Boolean* outWritable
);
Discussion

The outSize value returned reflects the size, in bytes, of the data returned by calling AudioConverterGetProperty() with the respective property.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterGetPropertyInfo(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 * outSize,
Boolean * outWritable
){};


/*AudioConverterFillComplexBuffer

Fills the AudioBufferList with converted data.

extern OSStatus AudioConverterFillComplexBuffer(
AudioConverterRef inAudioConverter,
AudioConverterComplexInputDataProc inInputDataProc,
void* inInputDataProcUserData,
UInt32* ioOutputDataPacketSize,
AudioBufferList* outOutputData,
AudioStreamPacketDescription* outPacketDescription
);
Discussion

Using the callback provided in inInputDataProc, this function will convert input data using inAudioConverter and will place the resulting converted data in outOutputData. Any relevant data for the callback should be passed in via inInputDataProcUserData, while outPacketDescription will contain the format of the returned data. On input, ioOutDataPacketSize should contain the number of packets requested, and as output, will contain the number of packets returned.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioConverterFillComplexBuffer(
AudioConverterRef inAudioConverter,
AudioConverterComplexInputDataProc inInputDataProc,
void* inInputDataProcUserData,
UInt32* ioOutputDataPacketSize,
AudioBufferList* outOutputData,
AudioStreamPacketDescription* outPacketDescription
){};


/*AudioConverterDispose

Destroys an audio converter.

extern OSStatus AudioConverterDispose(AudioConverterRef inAudioConverter);
Discussion

This function deallocates the memory used by inAudioConverter.
Availability
Available in Mac OS X v10.1 and later.*/
 OSStatus AudioConverterDispose(AudioConverterRef inAudioConverter){};

/*AudioConverterNew

Creates a new audio converter.

extern OSStatus AudioConverterNew(
const AudioStreamBasicDescription* inSourceFormat,
const AudioStreamBasicDescription* inDestinationFormat, AudioConverterRef* outAudioConverter
);
Discussion

This function takes in two AudioStreamBasicDescription instances, one for the source, and one for the destination, sets up all of the internal links needed for the conversion, and returns a pointer for the new converter. Note that if the setup fails, an error is returned which specifies the error that was encountered.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterNew(
const AudioStreamBasicDescription* inSourceFormat,
const AudioStreamBasicDescription* inDestinationFormat, AudioConverterRef* outAudioConverter
){};







