#include <OSServices/OSServices.h>

int DisposeNSLClientNotifyUPP(int a){};
int NewNSLClientNotifyUPP(int a){};


/*OTInetHostToString

Converts an an address in InetHost format into a character string in dotted-decimal notation. (Deprecated in Mac OS X v10.4.)

void OTInetHostToString (
   InetHost host,
   char * str
);
Parameters
host
str

A pointer to a C string containing an IP address in dotteddecimal notation (for example, “12.13.14.15”). You must allocate storage for this string and provide the pointer to the function.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

void OTInetHostToString (
   InetHost host,
   char * str
){};


/*OTInetGetInterfaceInfo

Returns internet address information about the local host. (Deprecated in Mac OS X v10.4.)

OSStatus OTInetGetInterfaceInfo (
   InetInterfaceInfo * info,
   SInt32 val
);
Parameters
info
val

An index into the local host’s array of configured IP interfaces. Specify 0 for information about the first interface. Specify kDefaultInetInterface to get information about the primary interface.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

Because the architecture of Open Transport TCP/IP provides for multihoming, in principle a given host can receive packets simultaneously through more than one network interface. For each IP interface configured for the local host, the OTInetGetInterfaceInfo function provides the internet address and subnet mask, a default gateway (that is, a gateway, if any exists, that can be used to route any packet to all destinations outside the locally connected subnet), and a domain name server, if any is known. The function also returns the version number of the OTInetGetInterfaceInfo function and, if available, the broadcast address for each interface. If the broadcast address is not available, you can determine it from the internet address and subnet mask.

Because multihoming has not been implemented in the initial release of Open Transport, the OTInetGetInterfaceInfo function never returns information for more than one interface.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

OSStatus OTInetGetInterfaceInfo (
   InetInterfaceInfo * info,
   SInt32 val
){};


/*InitOpenTransportInContext

Initializes the parts of Open Transport for use by the application or code resource. (Deprecated in Mac OS X v10.4.)

OSStatus InitOpenTransportInContext (
   OTInitializationFlags flags,
   OTClientContextPtr * outClientContext
);
Parameters
flags

Tells Open Transport whether your code is an application or a plug-in.
outClientContext

Returns the client context pointer. 
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

In Carbon, the InitOpenTransportInContext function acts like the pre-Carbon InitOpenTransport function, except that it takes parameters that specify initialization context explicitly.

Use the flags parameter to tell Open Transport whether your code is an application or some other target (for example, a plug-in that runs in an application context but is not the application itself). The second parameter returns the client context pointer, which you must pass to other asset-creation routines. For more information, see Understanding Open Transport Asset Tracking at http://developer.apple.com/technotes/tn/tn1173.html.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus InitOpenTransportInContext (
   OTInitializationFlags flags,
   OTClientContextPtr * outClientContext
){};

/*OTOpenEndpointInContext

Opens an endpoint that operates synchronously. (Deprecated in Mac OS X v10.4.)

EndpointRef OTOpenEndpointInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   TEndpointInfo * info,
   OSStatus * err,
   OTClientContextPtr clientContext
);
Parameters
config
oflag
info
err
clientContext
Return Value

See the description of the EndpointRef data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
EndpointRef OTOpenEndpointInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   TEndpointInfo * info,
   OSStatus * err,
   OTClientContextPtr clientContext
){};


/*OTCreateConfiguration

Creates a structure defining a provider’s configuration. (Deprecated in Mac OS X v10.4.)

Modified

OTConfigurationRef OTCreateConfiguration (
   const char * path
);
Parameters
path

A pointer to a character string describing the provider.
Return Value

See the description of the OTConfigurationRef data type.
Discussion

The OTCreateConfiguration function creates a configuration structure that defines the software modules, hardware ports, and options that Open Transport is to use when you call a function to open a provider. This is a private structure, defined by the OTConfiguration data type . To create one, you use the path parameter to pass the OTCreateConfiguration function a string describing the provider service desired.

The simplest possible value of the path parameter is a single protocol module name of the highest-level protocol you want to use; for example, “tcp.” If you do not specify a complete communications path, the Open Transport software uses default settings to construct the rest of the path. For example, if you specify “adsp” for the path parameter, Open Transport defaults to using the AppleTalk DataStream Protocol (ADSP) protocol module layered above the Datagram Delivery Protocol (DDP) protocol module and with LocalTalk on the default port, which is the printer port.

If you want to identify a particular port in the configuration string, you use the port name to do so (described in the section “About Port Information,” beginning on page 6-5). More typically, however, you leave this value blank— for example, using a string with only “adsp” or “adsp, ddp,” which configures the provider with whatever port is specified in the control panel.

To specify more than one protocol module, separate the module names with commas. You can also specify values for options by putting them in parentheses after the protocol name; for example, “adsp, ddp (Checksum=1)” specifies that ADSP is to run on top of DDP and that the checksum option is enabled.

If Open Transport cannot parse the list that you pass in the path parameter, the OTCreateConfiguration function returns ((OTConfiguration*)-1L). If there is insufficient memory to create an OTConfiguration structure, the OTCreateConfiguration function returns NULL.

The OTCreateConfiguration function returns a pointer to the configuration structure it creates. You pass this pointer as a parameter to the open-provider functions such as the OTOpenEndpoint or OTOpenMapper functions.
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Passing inline options to OTCreateConfiguration-for example, OTCreateConfiguration("tcp(NoDelay=1)")-is not supported on Mac OS X. Instead, you should explicitly set any options using the function OTOptionManagement.

Declared In
OpenTransport.h*/

OTConfigurationRef OTCreateConfiguration (
   const char * path
){};


/*OTCloseProvider

Closes a provider of any type—endpoint, mapper, or service provider. (Deprecated in Mac OS X v10.4.)

OSStatus OTCloseProvider (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTCloseProvider function closes the provider that you specify in the ref parameter. Closing the provider deletes all memory reserved for it in the system heap, deletes its resources, and cancels any provider functions that are currently executing.

Open Transport does not guarantee that all outstanding functions have completed before it closes the provider. It is ultimately your responsibility to make sure that all provider functions that you care about have finished executing, before you close and delete a provider.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTCloseProvider (
   ProviderRef ref
){};



/*CloseOpenTransportInContext

Unregisters your application or code resource connection to Open Transport. (Deprecated in Mac OS X v10.4.)

void CloseOpenTransportInContext (
   OTClientContextPtr clientContext
);
Parameters
clientContext
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

The CloseOpenTransportinContext function acts like the pre-Carbon CloseOpenTransport function except that it takes an additional parameter, an OTClientContextPtr, which can be NULL for applications. Other types of clients must provide a valid client context pointer.
Declared In
OpenTransport.h*/
void CloseOpenTransportInContext (
   OTClientContextPtr clientContext
){};

/*OTGetEndpointInfo

Obtains information about an endpoint that has been opened. (Deprecated in Mac OS X v10.4.)

OSStatus OTGetEndpointInfo (
   EndpointRef ref,
   TEndpointInfo * info
);
Parameters
ref
info
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTGetEndpointInfo function returns information about
the maximum size of buffers used to specify an endpoint’s address and option values
the maximum size of normal and expedited data you can transfer using this endpoint or, for transaction-based endpoints, the maximum size of requests and replies
the size of data you can transfer when initiating or tearing down a connection
the services supported by the endpoint
any additional characteristics of this endpoint
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTGetEndpointInfo (
   EndpointRef ref,
   TEndpointInfo * info
){};



/*OTAllocMemInContext

Allocates memory using an explicit client context. (Deprecated in Mac OS X v10.4.)

void * OTAllocMemInContext (
   OTByteCount size,
   OTClientContextPtr clientContext
);
Parameters
size
clientContext
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void * OTAllocMemInContext (
   OTByteCount size,
   OTClientContextPtr clientContext
){};


/*OTOptionManagement

Determines an endpoint’s current or default option values or changes these values. (Deprecated in Mac OS X v10.4.)

OSStatus OTOptionManagement (
   EndpointRef ref,
   TOptMgmt * req,
   TOptMgmt * ret
);
Parameters
ref
req
ret
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

To use the OTOptionManagement function, you must have opened an endpoint using the OTOpenEndpoint or OTAsyncOpenEndpoint functions.

You use the OTOptionManagement function to negotiate, retrieve, or verify an endpoint’s protocol options. If the endpoint is in asynchronous mode and you have not installed a notifier function, it is not possible to determine when the function completes.

The action taken by the OTOptionManagement function is determined by the setting of the req->flags field. The following bulleted items describe the different operations that you can perform and the flag settings that you use to specify these operations.
To negotiate values for the endpoint, you must call the OTOptionManagement function, specifying T_NEGOTIATE for the req->flags field. The endpoint provider evaluates the requested options, negotiates the values, and returns the resulting values in the option management structure pointed to by the ret->opt.buf field. The status field of each returned option is set to a constant that indicates the result of the negotiation. These constants are described by the “Open Transport Flags and Status Codes” enumeration.

For any protocol specified, you can negotiate for the default values of all options supported by the endpoint by specifying the value T_ALLOPT for the name field of the TOption structure. This might be useful if you want to change current settings or if negotiations for other values have failed. The success of the negotiations depends partly on the state of the endpoint—that is, simply because these are default values does not guarantee a completely successful negotiation. When the function returns, the resulting values are returned, option by option, in the buffer pointed to by the ret->opt.buf field.
To retrieve an endpoint’s default option values, call the OTOptionManagement function, specifying T_DEFAULT for the req->flags field. You must also specify the name of the option (but not its value) in the TOption structure that you create for each of the options you are interested in.

When the function returns, it passes the default values for the options back to you in the buffer pointed to by the ret->opt.buf field. For each option, the status field contains T_NOTSUPPORT if the protocol does not support the option, T_READONLY if the option is read-only, and T_SUCCESS in all other cases. The overall result of the request is returned in the ret->flags field. The meaning of this result is described by the Open Transport Flags and Status Codes enumeration.

When getting an endpoint’s default option values, you can specify T_ALLOPT for the option name. This returns all supported options for the specified level with their default values. In this case, you must set the opt.maxlen field to the maximum size required to hold an endpoint’s option information. The info.opt field of the TEndpointInfo structure specifies the maximum size of a buffer used to hold option information for an endpoint.
To retrieve an endpoint’s current option values, call the OTOptionManagement function, specifying T_CURRENT for the req->flags field. For each option in the buffer referenced by the req->opt.buf field, specify the name of the option you are interested in. The function ignores any option valuesyou specify.

When the function returns, it passes the current values for the options back to you in the buffer referenced by the ret->opt.buf field. For each option, the status field contains T_NOTSUPPORT if the protocol does not support the option, T_READONLY if the option is read-only, and T_SUCCESS in all other cases. The overall result of the request is returned in the ret->flags field. The meaning of this result is described by the “Open Transport Flags and Status Codes” enumeration.

When retrieving an endpoint’s current option values, you can specify T_ALLOPT for the option name. The function returns all supported options for the specified protocol, with their current values. In this case, you must set the opt.maxlen field to the maximum size required to hold an endpoint’s option information. The info.opt field of the TEndpointInfo structure specifies the maximum size of a buffer used to hold option information for an endpoint.
To check whether an endpoint provider supports certain options or option values, you must call the OTOptionManagement function, specifying T_CHECK for the req->flags field. Checking options or their values does not change the current settings of an endpoint’s options.
To check whether an option is supported, set the name field of the TOption structure to the option name, but do not specify an option value. When the function returns, the status field for the corresponding TOption structure in the buffer pointed to by the ret->opt.buf field is set to T_SUCCESS if the option is supported, T_NOTSUPPORT if it is not supported or needs additional client privileges, and T_READONLY if it is read-only.
To check whether an option value is supported, set the name field of the TOption structure to the option name, and set the value field to the value you want to check. When the function returns, the status field for the corresponding TOption structure in the buffer pointed to by the ret->opt.buf field is set as it would be if you had specified the T_NEGOTIATE flag. The overall result of the option checks is returned in the ret->flags field, which contains the single worst result of the option checks. The meaning of this result is described by the Open Transport Flags and Status Codes enumeration.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTOptionManagement (
   EndpointRef ref,
   TOptMgmt * req,
   TOptMgmt * ret
){};



/*OTFreeMem

Frees memory allocated with the OTAllocMem function. (Deprecated in Mac OS X v10.4.)

void OTFreeMem (
   void * mem
);
Parameters
mem
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTFreeMem (
   void * mem
){};


/*OTNextOption

Locates the next TOption structure in a buffer. (Deprecated in Mac OS X v10.4.)

OSStatus OTNextOption (
   UInt8 * buffer,
   UInt32 buflen,
   TOption ** prevOptPtr
);
Parameters
buffer

A pointer to the buffer containing the option to be found.
buflen

A long specifying the size of the buffer containing the option to be found.
prevOptPtr
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTNextOption function allows you to parse through a buffer containing TOption structures describing an endpoint’s option values. Within the buffer, TOption structures are aligned to long-word boundaries. This function takes into account this padding when it calculates the beginning address of the next TOption structure and it returns that address in the prevOptPtr parameter.

The first time you call the option, set the prevOptPtr parameter to the beginning address of the buffer. When the function returns, the prevOptPtr parameter points to the next (second) option in the buffer. You can continue this process, specifying the value returned for the prevOptPtr parameter by the previous invocation of the function, each time you call the function to obtain the beginning address of each option in the buffer.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTNextOption (
   UInt8 * buffer,
   UInt32 buflen,
   TOption ** prevOptPtr
){};


/*OTBufferDataSize

Obtains the size of the no-copy receive buffer. (Deprecated in Mac OS X v10.4.)

OTByteCount OTBufferDataSize (
   OTBuffer * buffer
);
Parameters
buffer
Return Value

See the description of the OTByteCount data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProtocol.h*/
OTByteCount OTBufferDataSize (
   OTBuffer * buffer
){};


/*OTStrLength

Returns the length of a C string. (Deprecated in Mac OS X v10.4.)

OTByteCount OTStrLength (
   const char * str
);
Parameters
str
Return Value

See the description of the OTByteCount data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTByteCount OTStrLength (
   const char * str
){};


/*OTInstallNotifier

Installs a notifier function. (Deprecated in Mac OS X v10.4.)

OSStatus OTInstallNotifier (
   ProviderRef ref,
   OTNotifyUPP proc,
   void * contextPtr
);
Parameters
ref
proc

For C++ applications, the proc parameter must point to either a C function or a static member function. See OTNotifyUPP data type.
contextPtr

A context pointer for your use. The provider passes this value unchanged to your notifier function when it calls the function.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTInstallNotifier function installs a notifier function for the provider that you specify. Changing a provider’s mode of execution does not affect the notifier function. The notifier function remains installed until you remove it using the OTRemoveNotifier function or until you close the provider.

Before calling the OTInstallNotifier function, you must open the provider for which you want to install the notifier. If you open a provider asynchronously (for example, with the OTAsyncOpenEndpoint function), you must pass a pointer to a notifier function as a parameter to the function used to open the provider. In this case, you don’t need to call the OTInstallNotifier function unless you want to install a different notifier function. If you do, you must call the OTRemoveNotifier function before calling the OTInstallNotifier function.

Opening a provider synchronously (for example, with the OTOpenEndpoint function) opens the provider but does not install a notifier function for it. If you need a notifier function for a provider opened synchronously, you must call the OTInstallNotifier function. This notifier would not return completion events, but would return asynchronous events advising you of the arrival of data, of changes in flow-control restrictions, and so on.

Call the OTInstallNotifier function only when no provider functions are executing for the provider that you specify. Otherwise, the OTInstallNotifier function returns the result code kOTStateChangeErr.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTInstallNotifier (
   ProviderRef ref,
   OTNotifyUPP proc,
   void * contextPtr
){};

/*OTReleaseBuffer

Returns the no-copy receive buffer to the system. (Deprecated in Mac OS X v10.4.)

void OTReleaseBuffer (
   OTBuffer * buffer
);
Parameters
buffer
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProtocol.h*/
void OTReleaseBuffer (
   OTBuffer * buffer
){};

/*OTSetSynchronous

Sets a provider’s mode of execution to synchronous. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetSynchronous (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetSynchronous function causes all provider functions to run synchronously when using the provider that you specify.

Changing a provider’s mode of execution does not affect its notifier function, if any is installed for this provider; the notifier function remains installed.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetSynchronous (
   ProviderRef ref
){};



/*OTInitDNSAddress

Fills in a DNSAddress structure with the data you provide. (Deprecated in Mac OS X v10.4.)

OTByteCount OTInitDNSAddress (
   DNSAddress * addr,
   char * str
);
Parameters
addr
str

A pointer to a domain name string. This string can be just a host name (otteam), a partially qualified domain name (for example, “otteam.ssw”), a fully qualified domain name (for example, “otteam.ssw.apple.com.”), or an internet address in dotteddecimal format (for example, “17.202.99.99”), and can optionally include the port number (for example, “otteam.ssw.apple.com:25” or “17.202.99.99:25”).
Return Value

See the description of the OTByteCount data type.
Discussion

This function fills in the fAddressType field of the DNSAddress structure with the value AF_DNS, fills in the fName field with the address string you specify, and returns the size of the resulting DNSAddress structure as an unsigned integer. You can use the DNSAddress structure to provide an address when you use a UDP or TCP endpoint. If you do so, the domain name resolver resolves the address for you automatically.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

OTByteCount OTInitDNSAddress (
   DNSAddress * addr,
   char * str
){};



/*OTSetNonBlocking

Disallows a provider from waiting if it cannot currently complete a function that sends or receives data. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetNonBlocking (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetNonBlocking function causes provider functions to return a result code immediately, instead of waiting for a function that sends or receives data to complete. When you open a provider, its mode of operation is set to nonblocking by default.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetNonBlocking (
   ProviderRef ref
){};


/*OTUseSyncIdleEvents

Allows synchronous idle events to be sent to your notifier. (Deprecated in Mac OS X v10.4.)

OSStatus OTUseSyncIdleEvents (
   ProviderRef ref,
   Boolean useEvents
);
Parameters
ref
useEvents
Return Value

A result code. See “Open Transport Result Codes”.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTUseSyncIdleEvents (
   ProviderRef ref,
   Boolean useEvents
){};


/*OTReadBuffer

Copies data out of a no-copy receive buffer. (Deprecated in Mac OS X v10.4.)

Boolean OTReadBuffer (
   OTBufferInfo * buffer,
   void * dest,
   OTByteCount * len
);
Parameters
buffer
dest
len
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProtocol.h*/
Boolean OTReadBuffer (
   OTBufferInfo * buffer,
   void * dest,
   OTByteCount * len
){};

/*OTBind

Assigns an address to an endpoint. (Deprecated in Mac OS X v10.4.)

OSStatus OTBind (
   EndpointRef ref,
   TBind * reqAddr,
   TBind * retAddr
);
Parameters
ref
reqAddr

If you specify NIL for the reqAddr parameter, Open Transport chooses a protocol address for you and requests 0 as the endpoint’s maximum number of concurrent outstanding connect indications.

If you want Open Transport to assign an address for you, setthe addr.len field of the TBind structure to 0.
retAddr

You can set this parameter to nil if you do not care to know what address the endpoint is bound to or what the negotiated value of qlen is.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTBind function to request an address that an endpoint be bound to. You can either use the reqAddr parameter to request that the endpoint be bound to a specific address or allow the endpoint provider to assign an address dynamically by passing nil for this parameter. Consult the documentation for the top-level protocol you are using to determine whether it is preferable to have the address assigned dynamically. The function returns the address to which the endpoint is actually bound in the retAddr parameter. This might be different from the address you requested, if you requested a specific address.

If you are binding a connection-oriented endpoint, you must use the reqAddr->qlen field to specify the number of connection requests that may be outstanding for this endpoint. The retAddr->qlen field specifies, on return, the actual number of connection requests allowed for the endpoint. This number might be smaller than the number you requested. Note that when the endpoint is actually connected, the number might be further decreased by negotiations taking place at that time.

If you call the OTBind function asynchronously and you have not installed a notifier function, the only way to determine when the function completes is to poll the endpoint using the OTGetEndpointState function. This function returns a kOTStateChangeErr until the bind completes. When the endpoint is bound, the state is either T_UNBND if the bind failed, or T_IDLE if it succeeded.

You can cancel an asynchronous bind that is still in progress by calling the OTUnbind function.

You must not bind more than one connectionless endpoint to a single address. Some connection-oriented protocols let you bind two or more endpoints to the same address. In such instances, you must use only one of the endpoints to listen for connection requests for that address. When binding the endpoint listening for a connection, you must set the reqAddr->qlen field of the OTBind function to a value greater than or equal to 1. When binding the other endpoints, you must set the reqAddr->qlen field to 0.

If you accept a connection for an endpoint that is also listening for connection requests, the address of that endpoint is deemed “busy” for the duration of the connection, and you must not bind another endpoint for listening to that same address. This requirement prevents more than one endpoint bound to the same address from accepting connection requests. If you have to bind another listening endpoint to the same address, you must first use the OTUnbind function to unbind the first endpoint or use the OTCloseProvider function to close it.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTBind (
   EndpointRef ref,
   TBind * reqAddr,
   TBind * retAddr
){};


/*OTRcv

Reads data sent using a connection-oriented transactionless protocol. (Deprecated in Mac OS X v10.4.)

OTResult OTRcv (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags * flags
);
Parameters
ref
buf

A pointer to a memory location where the incoming data is to be copied. You must allocate this buffer before you call the function.
nbytes
flags
Return Value

See the description of the OTResult data type.
Discussion

You call the OTRcv function to read data sent by the peer to which you are connected. If the OTRcv function succeeds, it returns an integer (OTStatus) specifying the number of bytes received. The function places the data read into the buffer referenced by the buf parameter. If the function fails, it returns a negative integer corresponding to a result code that indicates the reason for the failure. You can call this function to receive either normal or expedited data. If the data is expedited, the T_EXPEDITED flag is set in the flags parameter.

If T_MORE is set in the flags parameter when the function returns, this means that the buffer you allocated is too small to contain the data to be read and that you must call the OTRcv function again. If you have read x bytes with the first call, the next call to the OTRcv function begins to read at the (x + 1) byte. Of course, if you need it, you must copy the data in the buffer to another location before calling the function again. Each call to this function that returns with the T_MORE flag set means that you must call the function again to get more data. When you have read all the data, the OTRcv function returns with the T_MORE flag not set. If the endpoint does not support the concept of a TSDU (Transport Service Data Unit), the T_MORE flag is not meaningful and should be ignored. To determine whether the endpoint supports TSDUs, examine the tsdu field of the TEndpointInfo structure. A value of T_INVALID means that the endpoint does not support it.

Some protocols allow you to send zero-length data to signal the end of a logical unit. In this case, if you request more than 0 bytes when calling the OTRcv function, the function returns 0 bytes only to signal the end of a TSDU.

If the OTRcv function returns and the T_EXPEDITED bit is set in the flags parameter, this means that you are about to read expedited data. If the number of bytes of expedited data exceeds the number of bytes you specified in the reqCount parameter, both the T_EXPEDITED and the T_MORE bits are set. You must call the OTRcv function until the T_MORE flag is not set to retrieve the rest of the expedited data.

If you are calling the OTRcv function repeatedly to read normal data and a call to the function returns T_EXPEDITED in the flags parameter, the next call to the OTRcv function that returns without the T_EXPEDITED flag set returns normal data at the place it was interrupted. It is your responsibility to remember where that was and to continue processing normal data. You can determine how much normal data you read by maintaining a running total of the number of bytes returned in the OTStatus result.

If the endpoint is in asynchronous mode or is not blocking, the function returns with the kOTNoDataErr result if no data is available. If you have installed a notifier, the endpoint provider calls your notifier and passes T_DATA or T_EXDATA for the code parameter when there is data available. If you have not installed a notifier, you may poll for these events using the OTLook function. Once you receive a T_DATA or T_EXDATA event, you should continue in a loop, calling the OTRcv function until it returns with the kOTNoDataErr result.

If the endpoint is in synchronous mode and is blocking, the endpoint waits for data if none is currently available. You should avoid calling the OTRcv function this way because it might cause processing to hang if no data is available. If you are doing other operations in synchronous mode, you should put the endpoint in nonblocking mode before calling the OTRcv function.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTRcv (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags * flags
){};



/*OTSnd

Sends data to a remote peer. (Deprecated in Mac OS X v10.4.)

OTResult OTSnd (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags flags
);
Parameters
ref
buf

A pointer to the data being sent. If you are sending data that is not stored contiguously, this is a pointer to an OTData structure that describes the first data fragment.
nbytes
flags
Return Value

See the description of the OTResult data type.
Discussion

You use the OTSnd function to send data to a remote peer. Before you use this function, you must establish a connection with the peer.

If the OTSnd function succeeds, it returns an integer (OSStatus) specifying the number of bytes that were actually sent. If it fails, it returns a negative integer corresponding to a result code that indicates the reason for the failure.

You specify the data to be sent by passing a pointer to the data (buf) and byspecifying the size of the data (nbytes). The maximum size of the data you can send is specified by the tsdu field of the TEndpointInfo structure for the endpoint.

Some protocols use expedited data for control or attention messages. To determine whether the endpoint supports this service, examine the etsdu field of the TEndpointInfo structure. A positive integer for the etsdu field indicates the maximum size in bytes of expedited data that you can send. To send expedited data, you must set the T_EXPEDITED bit of the flags parameter.

If you want to break up the data sent into smaller logical units, you can set the T_MORE bit of the flags parameter to indicate that you are using additional calls to the OTSnd function to send more data that belongs to the same logical unit. To indicate that the last data unit is being sent, you must specify 0 for nbytes and turn off the T_MORE flag. This is the only circumstance under which it is permitted to send a zero-length data unit. If the endpoint does not support the sending of zero-length data, the OTSnd function fails with the kOTBadDataErr result.

If the endpoint is in blocking mode, the OTSnd function returns after it actually sends the data. If flow-control restrictions prevent its sending the data, it retries the operation until it is able to send it. If the endpoint is in nonblocking mode, the OTSnd function returns with the kOTFlowErr result if flow-control restrictions prevent the data from being sent. When the endpoint provider is able to send the data, it returns a T_GODATA event to let you know that it is possible to send data.

The following table shows how the endpoint’s mode of execution and blocking status affects the behavior of the OTSnd function.
Table A-1  
	
Blocking	
Nonblocking

Synchronous	
The function returns when the provider lifts flow-control restrictions The kOTFlowErr result is never returned.	
The function returns immediately. The kOTFlowErr result might be returned.

Asynchronous	
The function returns immediately. The kOTFlowErr result is never returned.	
The function returns immediately. The kOTFlowErr result might be returned.

Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTResult OTSnd (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags flags
){};

/*OTConnect

Requests a connection to a remote peer. (Deprecated in Mac OS X v10.4.)

OSStatus OTConnect (
   EndpointRef ref,
   TCall * sndCall,
   TCall * rcvCall
);
Parameters
ref
sndCall
rcvCall

This parameter is only meaningful for synchronous calls to the OTConnect function. See TCall data type.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If the endpoint is in synchronous mode, the OTConnect function returns after the connection is established and fills in the fields of the TCall structure (referenced by the rcvCall parameter) with the actual values associated with this connection. These might be different from the values you specified using the sndCall parameter.

If the OTConnect function returns with the kOTLookErr result, this might be either because of a pending T_LISTEN or T_DISCONNECT event. That is, either a connection request from another endpoint has interrupted execution of the function, or the remote endpoint has rejected the connection. If you don’t have a notifier installed, you can call the OTLook function to identify the event that caused the kOTLookErr result. If the event is T_LISTEN, you must accept or reject the incoming request and then continue processing the OTConnect function by calling OTRcvConnect. If the event is T_DISCONNECT, you must call the OTRcvDisconnect function to clear the error condition—that is, to deallocate memory and place the endpoint in the correct state.

If the endpoint is in asynchronous mode, the OTConnect function returns before the connection is established with a kOTNoDataErr result to indicate that the connection is in progress. When the connection is established, the endpoint provider calls your notifier, passing T_CONNECT for the code parameter. In response, you must call the OTRcvConnect function to read the connection parameters that would have been returned using the rcvCall parameter if the endpoint were in synchronous mode.

It is possible that the remote address returned in the addr field of the rcvCall parameter is not the same as the address you requested using the sndCall->addr field. This happens when the connection is accepted for a different endpoint than the one receiving the connection request.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTConnect (
   EndpointRef ref,
   TCall * sndCall,
   TCall * rcvCall
){};

/*OTSetBlocking

Allows a provider to wait or block until it is able to send or receive data. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetBlocking (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetBlocking function causes provider functions that send or receive data to wait if current conditions prevent them from completing an operation. By default, a provider is in nonblocking mode, in which case, if a provider function were unable to complete sending or receiving data, it would return immediately with a result that would tell you why the operation was unable to complete.

If a provider is in blocking mode and you call the OTCloseProvider function to close the provider, Open Transport gives each Streams module up to 15 seconds to process outgoing commands. It is recommended that you call the OTSetNonBlocking function before you call the OTCloseProvider function.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetBlocking (
   ProviderRef ref
){};


/*NewOTNotifyUPP

Creates a new universal procedure pointer (UPP) to a notification callback. (Deprecated in Mac OS X v10.4.)

OTNotifyUPP NewOTNotifyUPP (
   OTNotifyProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the OTNotifyUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTNotifyUPP NewOTNotifyUPP (
   OTNotifyProcPtr userRoutine
){};


/*OTMemzero

Initializes the specified memory range to 0. (Deprecated in Mac OS X v10.4.)

void OTMemzero (
   void * dest,
   OTByteCount nBytes
);
Parameters
dest
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

void OTMemzero (
   void * dest,
   OTByteCount nBytes
){};


/*OTAtomicAdd32

Atomically adds a 32-bit value to a memory location. (Deprecated in Mac OS X v10.4.)

SInt32 OTAtomicAdd32 (
   SInt32 toAdd,
   SInt32 * dest
);
Parameters
toAdd
dest
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
SInt32 OTAtomicAdd32 (
   SInt32 toAdd,
   SInt32 * dest
){};

/*OTGetTimeStamp

Obtains the current timestamp. (Deprecated in Mac OS X v10.4.)

void OTGetTimeStamp (
   OTTimeStamp * currentTime
);
Parameters
currentTime
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTGetTimeStamp (
   OTTimeStamp * currentTime
){};



/*OTLIFOEnqueue

Places a link at the front of a LIFO list. (Deprecated in Mac OS X v10.4.)

void OTLIFOEnqueue (
   OTLIFO * list,
   OTLink * link
);
Parameters
list
link
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTLIFOEnqueue (
   OTLIFO * list,
   OTLink * link
){};


/*OTLIFODequeue

Removes the first link in a LIFO list and returns a pointer to it. (Deprecated in Mac OS X v10.4.)

OTLink * OTLIFODequeue (
   OTLIFO * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTLink * OTLIFODequeue (
   OTLIFO * list
){};


/*OTLIFOStealList

Removes all links in a LIFO list and returns a pointer to the first link in the list. (Deprecated in Mac OS X v10.4.)

OTLink * OTLIFOStealList (
   OTLIFO * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTLink * OTLIFOStealList (
   OTLIFO * list
){};


/*OTReverseList

Reverses the order in which entries are linked in a list. (Deprecated in Mac OS X v10.4.)

OTLink * OTReverseList (
   OTLink * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTLink * OTReverseList (
   OTLink * list
){};

/*NSLGetServiceFromURL

Gets the service portion of a URL.

OSStatus NSLGetServiceFromURL (
char* theURL,
char** svcString,
UInt16* svcLen);
Parameters
theURL

On input, a pointer to a null-terminated string containing a URL.
svcString

On input, a pointer to the address of a string in memory. On output, svcString points to the service portion of the URL specified by theURL.
svcLen

On input, a pointer to an unsigned 16-bit value. On output, svcLen points to the length in bytes of svcString.
function result

A value of noErr indicates that svcString points to the service portion of the URL specified by theURL.
Discussion

This utility function gets the service portion of a URL. For example, if the URL is http://www.apple.com, the service portion of that URL is http.
Availability
Available in Mac OS X v10.0 and later.*/

OSStatus NSLGetServiceFromURL (
char* theURL,
char** svcString,
UInt16* svcLen){};

/*NSLLibraryPresent

Determines whether the Network Services Location Manager is present.

Boolean NSLLibraryPresent (void);
Parameters
function result

TRUE if the Network Services Location Manager is present.
Discussion

This utility function returns TRUE when the Network Services Location Manager is available. The Network Services Location Manager is always present in Mac OS X, so for applications that only run on Mac OS X do not need to call this function.
Availability
Available in Mac OS X v10.0 and later.*/
Boolean NSLLibraryPresent (void){};

/*NSLCloseNavigationAPI

Closes a session with the Network Services Location Manager.

void NSLCloseNavigationAPI (NSLClientRef theClient);
Parameters
theClient

On input, a value of type NSLClientRef, obtained by previously calling NSLOpenNavigationAPI, that identifies the session that is to be closed.
Discussion

This function closes the Network Services Location Manager session identified by theClient. If your application calls this function while a search is in progress, any data that would have been returned is lost.
Special Considerations

Your application is responsible for reclaiming memory that it allocates for services lists, parameter blocks, and search request references. Your application should reclaim memory by calling NSLDisposeServicesList, NSLDeleteRequest, and NSLFreeTypedDataPtr, respectively.
Availability
Available in Mac OS X v10.0 and later.*/
void NSLCloseNavigationAPI (NSLClientRef theClient){};

/*NSLMakeNewNeighborhood

Creates a neighborhood for use in searches.

NSLNeighborhood NSLMakeNewNeighborhood (
char * name,
char * protocolList);
Parameters
name

On input, NULL to create a neighborhood that can be used to obtain a list of default neighborhoods when calling NSLStartNeighborhoodLookup, or a pointer to a null-terminated string containing the name of a neighborhood in which searches are to be conducted.
protocolList

On input, NULL, which creates a neighborhood that will cause all available protocols to participate in any search that uses it. For compatibility with earlier versions of the Network Services Location Manager, protocolList can be a pointer to a comma-separated, null-terminated list of protocols (such as NBP,SLP) that are to participate in a search conducted with the resulting neighborhood. The constants kDSProtocolType, kNBPProtocolType, and kSLPProtocolType can be used to build a protocol list. However, searches conducted using the resulting neighborhood will not be limited to the protocols that were specified.
function result

An NSLNeighborhood value that can be used in subsequent calls to Network Services Location Manager functions, or NULL if a neighborhood value could not be created. This might happen, for example, if there is not enough memory.
Discussion

This utility function creates a neighborhood that can be provided as a parameter to other Network Services Location Manager functions such as NSLStartNeighborhoodLookup, NSLStartServicesLookup, NSLStandardRegisterURL, and NSLStandardDeregisterURL.

When you have no further use for a neighborhood, you can reclaim the memory allocated to it by calling NSLFreeNeighborhood.
Special Considerations

Specifying protocols in the protocolList parameter is deprecated. If you specify protocols when other protocols are available, any use of the resulting neighborhood will not be limited to the protocols you specified.
Availability
Available in Mac OS X v10.0 and later.*/
NSLNeighborhood NSLMakeNewNeighborhood (
char * name,
char * protocolList){};


/*NSLGetNextURL

Gets the position of the next URL in a result buffer.

Boolean NSLGetNextUrl (
NSLClientAsyncInfoPtr infoPtr,
char ** urlPtr,
long * urlLength);
Parameters
infoPtr

On input, a pointer to an NSLClientAsyncInfo structure whose resultBuffer field may contain another URL.
urlPtr

On output, if another URL was found in the resultBuffer field, a pointer to the beginning of the URL.
urlLength

On output, the length of the URL pointed to by urlPtr.
function result

A Boolean value. A value of TRUE indicates that urlPtr points to the next URL in the resultBuffer field pointed to by infoPtr. A value of FALSE indicates that there are no more URLs in the resultBuffer field.
Discussion

This utility function obtains the starting position and the length of the next URL in a result buffer. Typically, the URLs were placed in the result buffer by a previous call to NSLStartServicesLookup.*/
Boolean NSLGetNextUrl (
NSLClientAsyncInfoPtr infoPtr,
char ** urlPtr,
long * urlLength){};

/*NSLHexDecodeText

Decodes the encoded portion of a URL.

OSStatus NSLHexDecodeText (
char* encodedText,
UInt16 encodedTextLen,
char* decodedTextBuffer,
UInt16* decodedTextBufferLen,
Boolean* textChanged);
Parameters
encodedText

On input, a pointer to a buffer containing the portion of a URL that has been encoded.
encodedTextLen

On input, a value of type UInt16 that specifies the length of the buffer pointed to by encodedText.
decodedTextBuffer

On input, a pointer to a buffer in which the decoded text is to be stored. On output, the buffer contains the decoded text.
decodedTextBufferLen

On input, a pointer to a value of type UInt16 containing the maximum length of decodedTextBuffer. On output, decodedTextBufferLen points to the length of the decoded text pointed to by decodedTextBuffer.
textChanged

On input, a pointer to a Boolean value. On output, textChanged points to a value that is TRUE if decoding occurred or that is FALSE if no decoding was required.
function result

A value of noErr indicates that this utility function returned successfully. See “Network Services Location Manager Result Codes” for other possible result codes.
Discussion

This utility function decodes the portion of a URL that was previously encoded by NSLHexEncodeText. If this utility function returns noErr, the buffer pointed to by decodedTextBuffer contains the decoded copy of the buffer pointed to by encodedTextBuffer, or it contains an exact copy of the buffer pointed to by encodedTextBuffer. Use the textChanged parameter to determine whether any decoding actually took place.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLHexDecodeText (
char* encodedText,
UInt16 encodedTextLen,
char* decodedTextBuffer,
UInt16* decodedTextBufferLen,
Boolean* textChanged){};


/*NSLOpenNavigationAPI

Opens a session with the Network Services Location Manager.

OSStatus NSLOpenNavigationAPI (
NSLClientRef * newRef);
Parameters
newRef

On input, a pointer to a value of type NSLClientRef in which the Network Services Location Manager places a client reference. Pass the client reference to NSLPrepareRequest and NSLCloseNavigationAPI.
function result

A value of noErr indicates that the session was opened successfully. If NSLOpenNavigationAPI returns any of the following error codes, your application should not call any other Network Services Location Manager functions: kNSLNotInitialized, kNSLInsufficientSysVer, kNSLInsufficientOTVer, kNSLPluginLoadFailed, or kNSL68kContextNotSupported.
Discussion

This function opens a session with the Network Services Location Manager and returns a client reference that your application later uses to prepare search requests and to close the Network Services Location Manager session. You must call NSLOpenNavigationAPI before calling any other Network Services Location Manager functions.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLOpenNavigationAPI (
NSLClientRef * newRef){};

/*NSLContinueLookup

Continues a search.

NSLError NSLContinueLookup (
NSLClientAsyncInfo *asyncInfo);
Parameters
asyncInfo

On input, a pointer to the NSLClientAsyncInfo structure for this search.
function result

An NSLError structure whose theErr field contains the result code. If the value of NSLError.theErr is noErr, NSLContinueLookip returned successfully. Possible errors include kNSLNotInitialized, kNSLNoContextAvailable, kNSLBadClientInfoPtr, kNSLCannotContinueLookup, and kNSLBufferTooSmallForData. Call NSLErrorToString to get a problem and a solution string.
Discussion

This function is deprecated in Mac OS X and returns without performing any work. In Mac OS X, asynchronous searches continue automatically when the application’s notification routine returns. For compatibility with earlier versions of the Network Services Location Manager, applications can continue to call this function, but doing so is not necessary.
Availability
Available in Mac OS X v10.0 and later.*/
NSLError NSLContinueLookup (
NSLClientAsyncInfo *asyncInfo){};


/*NSLFreeTypedDataPtr

Frees memory allocated for a request parameter block.

NSLTypedDataPtr NSLFreeTypedDataPtr (
NSLTypedDataPtr nslTypeData);
Parameters
nslTypeData

On input, a value of type NSLTypedDataPtr, obtained by previously calling NSLMakeServicesRequestPB.
function result

A value of type NSLTypedDataPtr whose value is NULL.
Discussion

This utility function frees memory that was allocated when your application previously called NSLMakeServicesRequestPB. Your application should free the memory allocated for a request parameter block when it has no further use for the parameter block.
Availability
Available in Mac OS X v10.0 and later.*/
NSLTypedDataPtr NSLFreeTypedDataPtr (
NSLTypedDataPtr nslTypeData){};



/*NSLGetNextNeighborhood

Gets the position of the next neighborhood in a result buffer.

Boolean NSLGetNextNeighborhood (
NSLClientAsyncInfoPtr infoPtr,
NSLNeighborhood * neighborhood,
long * neighborhoodLength);
Parameters
infoPtr

On input, a pointer to an NSLClientAsyncInfo structure whose resultBuffer field may contain another neighborhood.
neighborhood

On input, a pointer to a value of type NSLNeighborhood. On output, neighborhood points to the next neighborhood in the resultBuffer field of the NSLClientAsyncInfo structure pointed to by infoPtr.
neighborhoodLength

On output, the length of the neighborhood pointed to by neighborhood.
function result

A Boolean value. A value of TRUE indicates that neighborhood points to the next neighborhood in the resultBuffer field pointed to by infoPtr. A value of FALSE indicates that there are no more neighborhoods in the resultBuffer field.
Discussion

This utility function provides the starting position and the length of the next neighborhood in a result buffer. Typically, the neighborhoods were placed in the result buffer by a previous call to NSLStartNeighborhoodLookup.

If you want to get a copy of the neighborhood, call NSLCopyNeighborhood. If you want to get the name from the neighborhood, call NSLGetNameFromNeighborhood.
Availability
Available in Mac OS X v10.0 and later.*/
Boolean NSLGetNextNeighborhood (
NSLClientAsyncInfoPtr infoPtr,
NSLNeighborhood * neighborhood,
long * neighborhoodLength){};



/*NSLDisposeServicesList

Disposes of a services list.

void NSLDisposeServicesList (
NSLServicesList theList);
Parameters
theList

On input, a value of type NSLServicesList, previously created by calling NSLMakeNewServicesList, that is to be disposed of.
Discussion

This utility function reclaims memory by disposing of a services list. Once you’ve incorporated the information in a services list into a request parameter block by passing the services list to NSLMakeServicesRequestPB, you can dispose of the services list. 

Calling NSLCloseNavigationAPI does not reclaim memory allocated for services lists, so your application should dispose of services lists before it closes a Network Services Location Manager session.
Availability
Available in Mac OS X v10.0 and later.*/
void NSLDisposeServicesList (
NSLServicesList theList){};

/*NSLGetNameFromNeighborhood

Locates the name in a neighborhood.

void NSLGetNameFromNeighborhood (
NSLNeighborhood neighborhood,
char ** name,
long * length);
Parameters
neighborhood

On input, a value of type NSLNeighborhood containing the name that is to be located.
name

On input, the address of a pointer. On output, name contains the address of a pointer to the name in the neighborhood parameter.
length

On input, a pointer to a location in memory. On output, length points to the length in bytes of the name in the neighborhood parameter.
Discussion

This utility function locates the null-terminated name in the neighborhood specified by the neighborhood parameter so that your application can, for example, display the name. Use the value pointed to by length to determine the length of the name.
Availability
Available in Mac OS X v10.0 and later.*/
void NSLGetNameFromNeighborhood (
NSLNeighborhood neighborhood,
char ** name,
long * length){};



/*NSLDeleteRequest

Deletes a request reference.

NSLError NSLDeleteRequest (
NSLRequestRef ref);
Parameters
ref

On input, the value of type NSLRequestRef, obtained by previously calling NSLPrepareRequest, that is to be deleted.
function result

An NSLError structure whose theErr field contains the result code. If the value of the theErr field is noErr, the request reference was deleted. Other possible values are kNSLNotInitialized and kNSLBadReferenceErr. Call NSLErrorToString to get a problem and a solution string.
Discussion

This function deletes the specified request reference and deallocates memory associated with it, including the NSLClientAsyncInfo structure associated with the request reference. If a search using the specified request reference is in progress when this function is called, the search is canceled and any outstanding I/O is lost.

This function does not deallocate memory associated with services lists or request parameter blocks. To deallocate memory for services lists, call NSLDisposeServicesList; to deallocate memory for parameter blocks, call NSLFreeTypedDataPtr.
Availability
Available in Mac OS X v10.0 and later.*/

NSLError NSLDeleteRequest (
NSLRequestRef ref){};


/*NSLPrepareRequest

Creates a search request.

NSLError NSLPrepareRequest (
NSLClientNotifyUPP notifier,
void * contextPtr,
NSLClientRef theClient,
NSLRequestRef * ref,
char * bufPtr,
unsigned long bufLen,
NSLClientAsyncInfoPtr * infoPtr);
Parameters
notifier

On input, a value of type NSLClientNotifyUPP that points to your application’s notification routine, or NULL. Your notification routine will be called when data is available, when the search is complete, or when an error occurs.
contextPtr

On input, an untyped pointer to arbitrary data that the Network Services Location Manager will pass to your application’s notification routine when that routine is called. Your application can use contextPtr to associate any particular execution of your notification routine with any particular search request.
theClient

On input, a value of type NSLClientRef obtained by previously calling NSLOpenNavigationAPI that identifies the Network Services Location Manager session for which this request is being prepared.
ref

On input, a pointer to a value of type NSLRequestRef in which the resulting search request reference is to be placed.
bufPtr

On input, a pointer to the buffer in which search results are to be placed.
bufLen

On input, the length of the buffer pointed to by bufPtr.
infoPtr

On output, the NSLClientAsyncInfo structure pointed to by infoPtr contains default instructions for how the search is to be conducted. Your application can change the defaults before it starts the search.
function result

An NSLError structure whose theErr field contains the result code. If the value of NSLError.theErr is noErr, the request was created. Other possible values include kNSLNotInitialized, kNSLDuplicateSearchInProgress, kNSLBadClientInfoPtr, and kNSLErrNullPtrError (if the value of infoPtr is NULL). Call NSLErrorToString to get a problem and a solution string.
Discussion

This function creates a search request that your application later provides as a parameter when it calls NSLStartNeighborhoodLookup or NSLStartServicesLookup. Searches are conducted asynchronously.

Your application’s notification routine will be called when the result buffer contains data, the result buffer is full, when the search is complete, or when an error occurs. Your application can cause your application’s notification routine to be called at a specified interval, when a specified number of items is in the result buffer, or when a specified amount of time has elapsed by modifying the value of the alertInterval, alertThreshold, and maxSearchTime fields, respectively, of the NSLClientAsyncInfo structure pointed to by infoPtr.

If this function returns a result code of kNSLDuplicateSearchInProgress, a search is in progress that is using a request reference that is identical to the newly created request reference. Your application can ignore this warning and use the newly created request reference, delete the newly created request reference, or cancel the search that is using the identical request reference.
Special Considerations

When your application no longer needs the request reference, it should call NSLDeleteRequest to reclaim memory associated with it.
Availability
Available in Mac OS X v10.0 and later.*/
NSLError NSLPrepareRequest (
NSLClientNotifyUPP notifier,
void * contextPtr,
NSLClientRef theClient,
NSLRequestRef * ref,
char * bufPtr,
unsigned long bufLen,
NSLClientAsyncInfoPtr * infoPtr){};


/*NSLStartNeighborhoodLookup

Starts a search for neighborhoods.

NSLError NSLStartNeighborhoodLookup (
NSLRequestRef ref,
NSLNeighborhood neighborhood,
NSLClientAsyncInfo *asyncInfo);
Parameters
ref

On input, a value of type NSLRequestRef created by previously calling NSLPrepareRequest.
neighborhood

On input, NULL or an NSLNeighborhood value created by previously calling NSLMakeNewNeighborhood. Passing NULL or a neighborhood parameter that was created with a name parameter whose value was NULL causes this function to get the default neighborhoods. If neighborhood was created with a value of name that is the name of a neighborhood, this function gets names related to that neighborhood. For example, if neighborhood was created with name set to “apple.com”, this function gets the subdomains of apple.com.
asyncInfo

On input, a pointer to an NSLClientAsyncInfo structure. Neighborhoods that are found will be stored in the structure’s resultBuffer field.
function result

An NSLError structure whose theErr field contains the result code. If the value of NSLError.theErr is noErr, this function successfully started a neighborhood search. Possible errors are kNSLNotInitialized, kNSLSearchAlreadyInProgress, kNSLNoPluginsForSearch, kNSLBufferTooSmallForData, and kNSLNullNeighborhoodPtr. Call NSLErrorToString to get a problem and a solution string.
Discussion

This function starts a search for neighborhoods that your application can use to define the scope of a subsequent service search. The result of the search is returned to your application in the resultBuffer field of the NSLClientAsyncInfo structure pointed to by the asyncInfo parameter when the Network Services Location Manager calls your application’s notification routine. Call NSLGetNextNeighborhood to process the data in the result buffer. To cancel an ongoing search, call NSLCancelRequest. To delete a search request reference, call NSLDeleteRequest.

When the Network Services Location Manager calls your application’s notification routine, it should check the value of the searchState field of the NSLClientAsyncInfo structure pointed to by the asyncInfo parameter. The searchState field will contain one of these values: kNSLSearchStateBufferFull, kNSLSearchStateOnGoing, kNSLSearchStateComplete, or kNSLSearchStateStalled.

If the value of the searchState field is kNSLSearchStatausBufferFull, your application’s notification routine should process the data returned in the resultBuffer field of the NSLClientAsyncInfo structure and return.

If the value of the searchState field is kNSLSearchStateOnGoing, the threshold set by the value of the alertInterval field or the alertThreshold field of the NSLClientAsyncInfo structure has been reached. Your application’s notification routine should process the data returned in the resultBuffer field of the NSLClientAsyncInfo structure and return.

If the value of the searchState field is kNSLSearchStateComplete and the value of NSLError.theErr returned by NSLStartNeighborhoodLookup is noErr, the search is complete. Your application’s notification routine should process the data returned in resultBuffer and return. If the value of the searchState field is kNSLSearchStateComplete and the value of NSLError.theErr returned by NSLStartNeighborhoodLookup is not noErr, the error is a fatal error and the search has ended.

If the value of the searchState field is kNSLSearchStateStalled, the threshold set by the value of the alertInterval field or the maxSearchTime field of the NSLClientAsyncInfo structure has been reached and there is no data in the result buffer. The Network Services Location Manager plug-ins that are processing this neighborhood search request are waiting to receive data from a server and may eventually time out. You can cancel the request by calling NSLCancelRequest.

If the value of NSLError.theErr returned by this function is kNSLBufferTooSmallForData, the value of the maxBufferSize field of the NSLClientAsyncInfo structure is too small to hold data that would otherwise have been returned. Your notification routine can cancel the search, modify the size of the buffer, and restart the search, or it can ignore the error and return, thereby resuming the search even though some data has been lost.
Special Considerations

For any request reference, only one neighborhood or service search can be in progress at any one time.

If this function returns an error, the resultBuffer field of the NSLClientAsyncInfo structure may still contain valid data that was collected before the error occurred. Your notification routine should process the data in the result buffer and return, thereby continuing the search.
Availability
Available in Mac OS X v10.0 and later.*/
NSLError NSLStartNeighborhoodLookup (
NSLRequestRef ref,
NSLNeighborhood neighborhood,
NSLClientAsyncInfo *asyncInfo){};

/*NSLErrorToString

Obtains information about an error.

OSStatus NSLErrorToString (
NSLError theErr,
char * errorString,
char * solutionString);
Parameters
theErr

On input, an NSLError structure whose theErr field contains a Network Services Location Manager result code.
errorString

On input, a pointer to the buffer in which this function is to place a null-terminated string containing a description of the problem that caused the error. The length of errorString should be 256 bytes.
solutionString

On input, a pointer to the buffer in which this function is to place a null-terminated string containing a possible solution to the problem. The length of solutionString should be 256 bytes.
function result

A value of noErr indicates that this function returned successfully. If the value of the theContext field of the NSLError structure that was passed to this function is zero and the theErr field contains a result code that is not within the range of Network Services Location Manager result codes, this function returns kNSLBadReferenceErr.
Discussion

This function obtains the error and solution strings for the result code stored in the theErr field of an NSLError structure.Your application can use the strings to display an appropriate error message.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLErrorToString (
NSLError theErr,
char * errorString,
char * solutionString){};

/*NSLMakeNewServicesList

Creates a services list.

NSLServicesList NSLMakeNewServicesList (
char* initialServiceList);
Parameters
initialServiceList

On input, a pointer to a comma-delimited, null-terminated string of service names, such as http,ftp.
function result

A value of type NSLServicesList. This function returns NULL if it can’t create the services list because, for example, there is not enough memory or because the Network Services Location Manager is not initialized.
Discussion

This function creates a services list and fills it with the names of the services specified by the initialServiceList parameter. After creating the services list, you can add the names of additional services by calling NSLAddServiceToServicesList.
Special Considerations

When you have no further use for the services list, you should reclaim the memory allocated to it by calling NSLDisposeServicesList.
Availability
Available in Mac OS X v10.0 and later.*/
NSLServicesList NSLMakeNewServicesList (
char* initialServiceList){};



/*NSLStandardDeregisterURL

Deregisters a service.

OSStatus NSLStandardDeregisterURL (
NSLPath urlToDeregister,
NSLNeighborhood neighborhoodToDeregisterIn);
Parameters
urlToDeregister

On input, a value of type NSLPath specifying the URL that is to be deregistered.
neighborhoodToDeregisterIn

On input, a value of type NSLNeighborhood specifying the neighborhood in which to deregister the service, or NULL. If NULL is specified, the Network Services Location Manager determines the neighborhood from which the service is deregistered.
function result

A value of noErr indicates that the service was deregistered. A value of kNSLBadURLSyntax indicates that the URL contains characters that are not allowed, such as spaces. To encode characters that are not allowed, call NSLHexEncodeText.
Discussion

This function deregisters the service specified by urlToDeregister. An application that registers services by calling NSLStandardRegisterURL should call this function as part of its standard shutdown procedure.
Special Considerations

You do not have to call NSLOpenNavigationAPI before calling this function.

This function is available in version 1.1 of the Network Services Location Manager and later, and supersedes the NSLDeRegisterService function, which was provided in version 1.0.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLStandardDeregisterURL (
NSLPath urlToDeregister,
NSLNeighborhood neighborhoodToDeregisterIn){};

/*NSLMakeServicesRequestPB

Creates a request parameter block.

OSStatus NSLMakeServicesRequestPB (
NSLServicesList serviceList,
NSLTypedDataPtr * newDataPtr);
Parameters
serviceList

On input, a value of type NSLServicesList created by previously calling NSLMakeNewServicesList.
newDataPtr

On input, the address of the NSLTypedDataPtr at which the resulting parameter block is to be placed.
function result

A value of noErr indicates that the parameter block was created successfully. Possible errors include kNSLBadDomainErr.
Discussion

This utility function creates a parameter block formatted properly for use with subsequent calls to NSLStartServicesLookup.
Availability
Available in Mac OS X v10.0 and later.*/

OSStatus NSLMakeServicesRequestPB (
NSLServicesList serviceList,
NSLTypedDataPtr * newDataPtr){};

/*NSLFreeNeighborhood

Disposes of an NSLNeighborhood value.

NSLNeighborhood NSLFreeNeighborhood (NSLNeighborhood neighborhood);
Parameters
neighborhood

On input, the NSLNeighborhood value, obtained by previously calling NSLMakeNewNeighborhood, that is to be disposed of.
function result

An NSLNeighborhood whose value is NULL.
Discussion

This utility function disposes of an NSLNeighborhood value and reclaims the memory that was allocated to it.
Availability
Available in Mac OS X v10.0 and later.*/
NSLNeighborhood NSLFreeNeighborhood (NSLNeighborhood neighborhood){};


/*NSLStartServicesLookup

Starts a search for services.

NSLError NSLStartServicesLookup (
NSLRequestRef ref,
NSLNeighborhood neighborhood,
NSLTypedDataPtr requestData,
NSLClientAsyncInfo *asyncInfo);
Parameters
ref

On input, a value of type NSLRequestRef containing a request reference obtained by previously calling NSLPrepareRequest.
neighborhood

On input, NULL or an NSLNeighborhood value created by previously calling NSLMakeNewNeighborhood. Passing NULL or a neighborhood created with a name parameter whose value was NULL causes this function to start a search for top-level services.
requestData

On input, a value of type NSLTypedDataPtr that describes the search parameters. To format requestData properly, call NSLMakeServicesRequestPB.
asyncInfo

On input, a pointer to a NSLClientAsyncInfo structure obtained by previously calling NSLPrepareRequest.
function result

An NSLError structure whose theErr field contains the result code. If the value of NSLError.theErr is noErr, this function successfully started a service search. Other possible values are kNSLNotInitialized, kNSLSearchAlreadyInProgress, kNSLNoPluginsForSearch, kNSLNullNeighborhoodPtr, and kNSLBufferTooSmallForData. Call NSLErrorToString to get a problem and a solution string.
Discussion

This function starts a service search. The result of the search is returned to your application in the resultBuffer field of the NSLClientAsyncInfo structure pointed to by the asyncInfo parameter when the Network Services Location Manager calls your application’s notification routine. Call NSLGetNextURL to process the data in the result buffer. To cancel an ongoing search, call NSLCancelRequest. To delete a search request reference, call NSLDeleteRequest.

When the Network Services Location Manager calls your application’s notification routine, it should check the value of the searchState field of the NSLClientAsyncInfo structure pointed to by the asyncInfo parameter. The searchState field will contain one of these values: kNSLSearchStateBufferFull, kNSLSearchStateOnGoing, kNSLSearchStateComplete, or kNSLSearchStateStalled.

If the value of the searchState field is kNSLSearchStatausBufferFull, your application’s notification routine should process the data in the resultBuffer field of the NSLClientAsyncInfo structure and return.

If the value of the searchState field is kNSLSearchStateOnGoing, the threshold set by the value of the alertInterval field or the alertThreshold field of the NSLClientAsyncInfo structure has been reached. Your application’s notification routine should process the data in the resultBuffer field and return.

If the value of the searchState field is kNSLSearchStateComplete and the value of NSLError.theErr returned by NSLStartServicesLookup is noErr, the search is complete. Your application’s notification routine should process the data returned in resultBuffer and return. If the value of the searchState field is kNSLSearchStateComplete and the value of NSLError.theErr returned by NSLStartServicesLookup is not noErr, the error is a fatal error and the search has ended.

If the value of the searchState field is kNSLSearchStateStalled, the threshold set by the value of the alertInterval field or the maxSearchTime field of the NSLClientAsyncInfo structure has been reached and there is no data in the result buffer. The Network Services Location Manager plug-ins that are processing this request are waiting to receive data from a server and may eventually time out. You can cancel the request by calling NSLCancelRequest. If the value of the searchState field is noErr, your application’s notification routine should ignore the notification and return immediately, thereby resuming the search.

If the value of NSLError.theErr returned by this function is kNSLBufferTooSmallForData, the value of the maxBufferSize field of the NSLClientAsyncInfo structure is too small to hold data that would otherwise have been placed in the result buffer. Your application’s notification routine can cancel the search, modify the size of the buffer, and start the lookup again, or it can ignore the error and return, thereby resuming the search even though some data has been lost.
Special Considerations

For any request reference, only one neighborhood or service search can be ongoing at any one time.

If this function returns an error, the resultBuffer field of the NSLClientAsyncInfo structure may still contain valid data that was collected before the error occurred. Your notification routine should process the data in the result buffer and return, thereby continuing the search.
Availability
Available in Mac OS X v10.0 and later.*/
NSLError NSLStartServicesLookup (
NSLRequestRef ref,
NSLNeighborhood neighborhood,
NSLTypedDataPtr requestData,
NSLClientAsyncInfo *asyncInfo){};


/*NSLStandardRegisterURL

Registers the URL of a service.

OSStatus NSLStandardRegisterURL (
NSLPath urlToRegister,
NSLNeighborhood neighborhoodToRegisterIn);
Parameters
urlToRegister

On input, a value of type NSLPath specifying the URL to register.
neighborhoodToRegisterIn

On input, a value of type NSLNeighborhood specifying the neighborhood in which to register the service, or NULL. If NULL is specified, the Network Services Location Manager determines the neighborhood in which the URL is registered.
function result

A value of noErr indicates that the service was registered. A value of kNSLBadURLSyntax indicates that the URL contains characters that are not allowed, such as spaces. To encode characters that are not allowed, call NSLHexEncodeText.
Discussion

This function registers the specified URL with the Network Services Location Manager.

Applications that provide a network service typically call this function as part of their startup procedure. They also call NSLStandardDeregisterURL as part of their shutdown procedure.
Special Considerations

You do not have to call NSLOpenNavigationAPI before calling this function.

This function is available in version 1.1 and later of the Network Services Location Manager, and supersedes the NSLRegisterService function, which was provided in version 1.0.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLStandardRegisterURL (
NSLPath urlToRegister,
NSLNeighborhood neighborhoodToRegisterIn){};

/*NSLHexEncodeText

Encodes a portion of a URL.

OSStatus NSLHexEncodeText (
char* rawText,
UInt16 rawTextLen,
char* newTextBuffer,
UInt16* newTextBufferLen,
Boolean* textChanged);
Parameters
rawText

On input, a pointer to a character array containing the portion of a URL that is to be encoded. For example, if the URL is afp://17.221.40.66?NAME=Kevs G3, the portion of the URL that contains a character that is not allowed is Kevs G3. In this example, the space character is not allowed.
rawTextLen

On input, a value of type UInt16 containing the length in bytes of the rawText parameter.
newTextBuffer

On input, a pointer to a buffer. On output, the buffer contains the encoded text.
newTextBufferLen

On input, a pointer to a value of type UInt16. On output, newTextBufferLen points to the length of the encoded text in the buffer pointed to by newTextBuffer.
textChanged

On input, a pointer to a Boolean value. On output, textChanged points to a value that is TRUE if encoding occurred or that is FALSE if no encoding was required.
function result

A value of noErr indicates that this utility function returned successfully. See “Network Services Location Manager Result Codes” for other possible result codes.
Discussion

This utility function uses the US ASCII character set to encode characters that are not allowed in URLs. Hexadecimal values from 01 to 1F, from 80 to FF, and 7F are not allowed. In addition, the following characters are not allowed:

< > " # { } | \ ^ ~ [ ]

This utility function also encodes the following characters that are reserved for URL syntax:

; / ? : @ = % &

If this utility function returns noErr, the buffer pointed to by newTextBuffer contains the encoded copy of the buffer pointed to by rawText, or it contains an exact copy of the buffer pointed to by rawText. Use the textChanged parameter to determine whether any encoding actually took place.

Call NSLHexDecodeText to decode a string that has been encoded.
Special Considerations

The NSLStandardRegisterURL function returns an error if a URL you try to register contains characters that need to be encoded.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLHexEncodeText (
char* rawText,
UInt16 rawTextLen,
char* newTextBuffer,
UInt16* newTextBufferLen,
Boolean* textChanged){};


