#import <QTKit/QTMovieView.h>

@implementation   QTMovieView
/*pause:

-(IBAction)pause:(id)sender
Discussion

This action method pauses the movie playback. This method does nothing if the movie is already paused.
Availability
Available in Mac OS X v10.3 and later.*/
-(IBAction)pause:(id)sender{}

/*setMovie:

-(void)setMovie:(id)movie
Discussion

Sets the QTMovie object in a QTMovieView to movie. The currently set QuickTime movie is disposed of using DisposeMovie, unless the QTMovie was created with a call to initWithQuickTimeMovie and the disposeWhenDone flag was NO.
Availability
Available in Mac OS X v10.3 and later.*/
-(void)setMovie:(id)movie{}
/*controllerBarHeight

-(float)controllerBarHeight
Discussion

Returns the height of the controller bar.
Availability
Available in Mac OS X v10.3 and later.*/
-(float)controllerBarHeight{}


/*movie

-(QTMovie *)movie
Discussion

Returns the QTMovie object associated with the QTMovieView.
Availability
Available in Mac OS X v10.3 and later.*/
-(QTMovie *)movie{}


/*isControllerVisible

-(BOOL)isControllerVisible
Discussion

Returns YES if the movie controller bar of the QTMovieView object is visible. The default is YES.
Availability
Available in Mac OS X v10.3 and later.
isEditable

-(BOOL)isEditable
Discussion

Returns YES if the QTMovieView object is editable. When editable, a movie can be modified using editing methods and associated key commands. The default is NO.
Availability
Available in Mac OS X v10.3 and later.*/
-(BOOL)isControllerVisible{}
/*preservesAspectRatio

-(BOOL)preservesAspectRatio
Discussion

Returns YES if the QTMovieView object maintains the aspect ratio of the movie when drawing it in the view. The remainder is filled with fillColor. 
Availability
Available in Mac OS X v10.3 and later.*/
-(BOOL)preservesAspectRatio{}


/*movieControllerBounds

-(NSRect)movieControllerBounds
Discussion

Returns the rectangle currently occupied by the movie controller bar (if it’s visible) in a QTMovieView.
Availability
Available in Mac OS X v10.3 and later.*/
-(NSRect)movieControllerBounds{}


/*fillColor

- (NSColor* )fillColor
Discussion

Returns the fill color of the QTMovieView.
Availability
Available in Mac OS X v10.3 and later.*/
- (NSColor* )fillColor{}


/*setControllerVisible:

-(void)setControllerVisible:(BOOL)controllerVisible
Discussion

Sets the visibility state of the movie controller bar in a QTMovieView to controllerVisible.
Availability
Available in Mac OS X v10.3 and later.*/
-(void)setControllerVisible:(BOOL)controllerVisible{}


/*setPreservesAspectRatio:

-(void)setPreservesAspectRatio:(BOOL)preservesAspectRatio
Discussion

Sets the aspect ratio state of a QTMovieView to preservesAspectRatio. If preservesAspectRatio is YES, the longer side of the movie rectangle is scaled to exactly fit into the view’s frame and the other side is centered in the view frame; the remaining area is filled with the view’s fill color. Note that the movie view may be redrawn, but not resized.
Availability
Available in Mac OS X v10.3 and later.*/
-(void)setPreservesAspectRatio:(BOOL)preservesAspectRatio{}

/*setFillColor:

-(void)setFillColor:(NSColor *)fillColor
Discussion

Sets the fill color of a QTMovieView to fillColor. Note that this may cause a redraw.
Availability
Available in Mac OS X v10.3 and later.*/
-(void)setFillColor:(NSColor *)fillColor{}


@end