<?php
/***************************************************************************
 *                             easymod_install.php
 *                            -------------------
 *   begin                : Wednesday, March 15, 2002
 *   copyright            : (C) 2002-2004 by Nuttzy - Craig Nuttall
 *   email                : nuttzy@blizzhackers.com
 *
 *   $Id: easymod_install.php,v 0.1.13 2004/08/08 00:00:00 nuttzy Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);
$phpbb_root_path = './../../../';
$script_path = 'admin/mods/easymod' ;
////
$easymod_install_version = '0.1.13' ;
////

include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'config.'.$phpEx);
include($phpbb_root_path . 'includes/constants.'.$phpEx);
include($phpbb_root_path . 'includes/functions.'.$phpEx);
include($phpbb_root_path . 'includes/functions_admin.'.$phpEx);
include($phpbb_root_path . 'includes/db.'.$phpEx);

include( './em_includes/em_ftp.'.$phpEx);
include( './em_includes/em_modio.'.$phpEx);
include( './em_includes/em_functions.'.$phpEx);

include( './easymod_display_functions.'.$phpEx);



//
// set teh language (typo intentional ;-) )
//

// include the lang file
$lang = array();
if(isset($HTTP_GET_VARS['language']) || isset($HTTP_POST_VARS['language']))
{
	$language = (isset($HTTP_POST_VARS['language'])) ? htmlspecialchars($HTTP_POST_VARS['language']) : htmlspecialchars($HTTP_GET_VARS['language']);
}
else
{
	$language = 'english' ;
}

// remember the lang in case we hit an error that send us back to step 1
$hidden = "<input type=\"hidden\" name=\"language\" value=\"$language\">\n" ;


// load the appropriate lang pack
if ($language == 'english')
{
	// make sure the lang file exists
	if (!file_exists('./lang_easymod.'.$phpEx))
	{
		// display error message (obviously we can't use the lang system for this error) ;-)
		echo "<b>CRITICAL ERROR:</b> the lang_easymod.$phpEx file could not be found in the easymod directory.  EasyMOD cannot be installed without this file present.\n" ;
		exit ;
	}

	include( './lang_easymod.'.$phpEx);
}
else
{
	// make sure the lang file exists
	if (!file_exists('./lang_easymod.'.$phpEx))
	{
		// display error message (obviously we can't use the lang system from this ;-)
		echo "<b>CRITICAL ERROR:</b> the lang_easymod.$phpEx file could not be found in the easymod directory.  EasyMOD cannot be installed without this file present.\n" ;
		exit ;
	}

	include( './lang_easymod.'.$phpEx);
}





// ---------
// FUNCTIONS
//


function wrapper_find( &$file_list, &$find_array, $search_array)
{
	global $lang ;

	echo '<b>' . $lang['EM_finding'] . ':</b> ' ;
	for ( $i=0; $i<count($search_array); $i++)
	{
		echo htmlspecialchars($search_array[$i]) . "<br>" ;
	}

	$result = perform_find( $file_list, $find_array, $search_array) ;
	handle_error($result, $file_list, true) ;
}


function wrapper_insert( &$file_list, &$find_array, $insert, $before)
{
	global $lang ;

	echo '<b>' . $lang['EM_insert'] . ' ' . (($before) ? $lang['EM_before'] : $lang['EM_after']) . ":</b></br>" ;

	$insert_string = '' ;
	for ($i=0; $i<count($insert); $i++)
	{
		echo htmlspecialchars($insert[$i]) . "<br>\n" ;
		$insert_string .= $insert[$i] . "\r\n" ;
	}

	if ( $before)
	{
		write_files( $file_list, $insert_string) ;
		write_find_array( $find_array, $file_list) ;
	}
	else
	{
		write_find_array( $find_array, $file_list) ;
		write_files( $file_list, $insert_string) ;
	}
	$insert = array() ;
}


// special test for lang_admin.php to make sure the EM lines are already loaded
function find_lang_admin( $find_str, &$fin, $close = false)
{
	global $phpEx ;

	// if we've not opened the file yet, then do so
	if ($fin == NULL)
	{
		// if we can't open the file then we are in trouble, but we'll let the wrapper_find handle it
		if (!($fin = fopen( '../../../language/lang_english/lang_admin.'.$phpEx,'r')))
		{
			return false ;
		}
	}

	// loop through file looking for match
	while (!feof($fin))
	{
		// read a line and see if it contains our key
		$line = fgets( $fin, 4096) ;
		if (strstr($line, $find_str))
		{
			// got a match so return true; close the file if we are supposed to
			if ($close)
			{
				fclose($fin) ;
			}
			return true ;
		}
	}

	// no match, close the file
	fclose($fin) ;
	return false ;
}


// performs a querry and returns a result, is able to draw dots, but not really needed here
function _sql($sql, &$errored, &$error_ary, $echo_dot = true)
{
	global $db;

	if( !($result = $db->sql_query($sql)) )
	{  
		$errored = true;
		$error_ary['sql'][] = ( is_array($sql) ) ? $sql[$i] : $sql;
		$error_ary['error_code'][] = $db->sql_error();
	}

	if ( $echo_dot )
	{
		echo '.';
		flush();
	}

	return $result;
}







///
/// start program proper
///

$install_step = (isset($HTTP_POST_VARS['install_step'])) ? intval( $HTTP_POST_VARS['install_step']) : 1 ;
$rescan = (isset($HTTP_POST_VARS['rescan'])) ? TRUE : FALSE ;
if ( $rescan)
{
	$install_step = 1 ;
}

// Mode setting
if(isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']))
{
	$mode = (isset($HTTP_POST_VARS['mode'])) ? htmlspecialchars($HTTP_POST_VARS['mode']) : htmlspecialchars($HTTP_GET_VARS['mode']);
}
else
{
	$mode = '' ;
}

// check the case where display file on screen is sending a GET VAR
if (($install_step == 1) && (isset($HTTP_GET_VARS['install_step'])))
{
	// make sure the vars seem to match
	if (($HTTP_GET_VARS['install_step'] == 6) && (($mode == 'backup') || ($mode == 'file')))
	{
		// check the password to make sure this is not someone getting around security
		$pw = (isset($HTTP_GET_VARS['pw'])) ? htmlspecialchars( $HTTP_GET_VARS['pw']) : '' ;
		$install_step = (md5($pw) == get_em_pw()) ? 6 : 1 ;
	}
}


// file access permissions
$read_access = (isset($HTTP_POST_VARS['read_access'])) ? intval( $HTTP_POST_VARS['read_access']) : false ;
$write_access = (isset($HTTP_POST_VARS['write_access'])) ? intval( $HTTP_POST_VARS['write_access']) : false ;
$root_write = (isset($HTTP_POST_VARS['root_write'])) ? intval( $HTTP_POST_VARS['root_write']) : false ;
$tmp_write = (isset($HTTP_POST_VARS['tmp_write'])) ? intval( $HTTP_POST_VARS['tmp_write']) : false ;
$chmod_access = (isset($HTTP_POST_VARS['chmod_access'])) ? intval( $HTTP_POST_VARS['chmod_access']) : false ;
$unlink_access = (isset($HTTP_POST_VARS['unlink_access'])) ? intval( $HTTP_POST_VARS['unlink_access']) : false ;
$mkdir_access = (isset($HTTP_POST_VARS['mkdir_access'])) ? intval( $HTTP_POST_VARS['mkdir_access']) : false ;
$copy_access = (isset($HTTP_POST_VARS['copy_access'])) ? intval( $HTTP_POST_VARS['copy_access']) : false ;

// file access settings
$em_pass = (isset($HTTP_POST_VARS['em_pass'])) ? htmlspecialchars( $HTTP_POST_VARS['em_pass']) : '' ;
$read = (isset($HTTP_POST_VARS['sel_read'])) ? htmlspecialchars( $HTTP_POST_VARS['sel_read']) : '' ;
$write = (isset($HTTP_POST_VARS['sel_write'])) ? htmlspecialchars( $HTTP_POST_VARS['sel_write']) : '' ;
$move = (isset($HTTP_POST_VARS['sel_move'])) ? htmlspecialchars( $HTTP_POST_VARS['sel_move']) : '' ;

// ftp settings
$ftp_user = (isset($HTTP_POST_VARS['ftp_user'])) ? htmlspecialchars( $HTTP_POST_VARS['ftp_user']) : '' ;
$ftp_pass = (isset($HTTP_POST_VARS['ftp_pass'])) ? htmlspecialchars( $HTTP_POST_VARS['ftp_pass']) : '' ;
$ftp_host = (isset($HTTP_POST_VARS['ftp_host'])) ? htmlspecialchars( $HTTP_POST_VARS['ftp_host']) : 'localhost' ;
$ftp_debug = (isset($HTTP_POST_VARS['ftp_debug'])) ? intval( $HTTP_POST_VARS['ftp_debug']) : false ;
$ftp_type = (isset($HTTP_POST_VARS['ftp_type'])) ? htmlspecialchars( $HTTP_POST_VARS['ftp_type']) : 'fsock' ;
$ftp_cache = (isset($HTTP_POST_VARS['ftp_cache'])) ? intval( $HTTP_POST_VARS['ftp_cache']) : 0 ;
$ftp_dir = (isset($HTTP_POST_VARS['ftp_dir'])) ? htmlspecialchars( $HTTP_POST_VARS['ftp_dir']) : '/' ;
$ftp_dir = ( $ftp_dir == '') ? '/' : $ftp_dir ;

$file_list = array() ;
$phpBB_version = get_phpbb_version( $db) ;
if ($phpBB_version == '')
{
	handle_error( OPEN_FAIL_CRITICAL, $file_list, false, '<b>' . $lang['EM_err_critical_error'] . ':</b> ' . $lang['EM_err_phpbb_ver']) ;
}






///
/// display help in the new window requested
///
if ( $mode == 'help')
{

	page_header('moo', true) ;
?>

<table class="forumline" width="100%" cellspacing="1" cellpadding="3" border="0" align="center">
	<tr> 
		<td class="catHead" height="28" align="center"><span class="cattitle">EasyMOD Installer Help</span></td>
	</tr>
	<tr> 
		<td class="row1" align="left" valign="top"><span class="postbody"><a name="topic1"></a><b>Ummm...</b> - Still need to write the help ;-)<br /></span></td>
	</tr>
	<tr>
		<td class="spaceRow" height="1"><img src="../../../templates/subSilver/images/spacer.gif" alt="" width="1" height="1" /></td>
	</tr>
</table>

<br clear="all" />

<!--
<div align="center"><span class="copyright">CatDB {CATDB_VERSION} by <a href="http://www.phpbb.com/phpBB/profile.php?mode=viewprofile&u=190" target="_phpbb" class="copyright">Nuttzy</a><br /></span></div>
-->

<?php
	page_footer() ;
	exit ;
}


//
// display expanded debug screen; there isn't error though, someone just clicked "Display Debug Info" link
//
else if ($mode == 'debug')
{
	$install_step = (isset($HTTP_GET_VARS['install_step'])) ? intval( $HTTP_GET_VARS['install_step']) : $install_step ;
	$write = (isset($HTTP_GET_VARS['write'])) ? htmlspecialchars( $HTTP_GET_VARS['write']) : $write ;
	$move = (isset($HTTP_GET_VARS['move'])) ? htmlspecialchars( $HTTP_GET_VARS['move']) : $move ;
	$ftp_dir = (isset($HTTP_GET_VARS['ftp_dir'])) ? htmlspecialchars( $HTTP_GET_VARS['ftp_dir']) : $ftp_dir ;
	$ftp_user = (isset($HTTP_GET_VARS['ftp_user'])) ? htmlspecialchars( $HTTP_GET_VARS['ftp_user']) : $ftp_user ;
	$ftp_pass = (isset($HTTP_GET_VARS['ftp_pass'])) ? htmlspecialchars( $HTTP_GET_VARS['ftp_pass']) : $ftp_pass ;
	$ftp_host = (isset($HTTP_GET_VARS['ftp_host'])) ? htmlspecialchars( $HTTP_GET_VARS['ftp_host']) : $ftp_host ;
	$ftp_debug = (isset($HTTP_GET_VARS['ftp_debug'])) ? intval( $HTTP_GET_VARS['ftp_debug']) : $ftp_debug ;
	$ftp_type = (isset($HTTP_GET_VARS['ftp_type'])) ? htmlspecialchars( $HTTP_GET_VARS['ftp_type']) : $ftp_type ;

////////////////////// what about ? and &
	// fix the password and put any # symbols back they may belong
	$ftp_pass = str_replace('~pound~', '#', $ftp_pass) ;

	page_header( $lang['EM_debug_header']) ;
	display_debug_info() ;
	echo "<br>\n" ;
	page_footer() ;
	exit ;
}


//
// download the modified files if that is what we are supposed to be doing
//
else if ( $mode == 'download')
{
	$install_step = (isset($HTTP_POST_VARS['filename'])) ? htmlspecialchars( $HTTP_POST_VARS['filename']) : '' ;
	$body = (isset($HTTP_POST_VARS['body'])) ? htmlspecialchars( $HTTP_POST_VARS['body']) : '' ;

	header('Content-Type: text/x-delimtext; name="' . $filename . '"');
	header('Content-disposition: attachment; filename=' . $filename . '"');

	echo $body . "\n" ;

	exit;
}


///
/// gather setup parameters
///
else if ( $install_step == 1)
{
	$install_style = (isset($HTTP_GET_VARS['setup'])) ? ($HTTP_GET_VARS['setup'] == 'advanced') ? 'advanced' : 'simple' : 'simple' ;
	$substep = (isset($HTTP_POST_VARS['substep'])) ? htmlspecialchars( $HTTP_POST_VARS['substep']) : '' ;
	if ($substep != 'a' && $substep != 'b' && $substep != 'c')
	{
		$substep = '' ;
	}
	$option = (isset($HTTP_POST_VARS['option'])) ? htmlspecialchars( $HTTP_POST_VARS['option']) : '' ;
	if ($option != 'ftp' && $option != 'windoze' && $option != 'idunno' && $option != 'write_copy' && $option != 'post_process' && $option != 'manual' && $option != 'download' && $option != 'advanced')
	{
		$option = '' ;
	}

	// handle selection from main install screen (simple mode)
	if ( $substep == 'a')
	{
		// they said they have FTP, get the FTP settings
		if ( $option == 'ftp')
		{
			display_step1b_ftp() ;
		}

		// they said they have a window box, go straight to getting empw
		else if ( $option == 'windoze')
		{
			$read = 'server' ;
			$write = 'server' ;
			$move = 'copy' ;

			display_step1c_empw() ;
		}

		// they dunno... duh! duh! duh!
		else if ( $option == 'idunno')
		{
			display_step1b_idunno() ;
		}

		// should never happen
		else
		{
			display_step1_classic() ;
		}
	}
	else if ( $substep == 'b')
	{
		if ( $option == 'ftp')
		{
			display_step1b_ftp() ;
		}
		else if ( $option == 'write_copy')
		{
			$read = 'server' ;
			$write = 'server' ;
			$move = 'copy' ;

			display_step1c_empw() ;
		}
		else if ( $option == 'idunno')
		{
			display_step1_substep_b() ;
		}
		else if ( $option == 'post_process')
		{
			$read = 'server' ;
			$write = 'server' ;
			$move = 'exec' ;

			display_step1c_empw() ;
		}
		else if ( $option == 'manual')
		{
			$read = 'server' ;
			$write = 'server' ;
			$move = 'ftpm' ;

			display_step1c_empw() ;
		}
		else if ( $option == 'download')
		{
			$read = 'server' ;
			$write = 'local' ;
			$move = 'ftpm' ;

			display_step1c_empw() ;
		}
		else if ( $option == 'advanced')
		{
			display_step1_classic() ;
		}
		else
		{
			display_step1_classic() ;
		}
	}
	else if ( $substep == 'c')
	{
		display_step1c_empw() ;
	}
	else if ($install_style == 'advanced')
	{
		display_step1_classic() ;
	}
	else
	{
		display_step1_simple() ;
	}
	exit ;
}


//
// confirm the file access settings
//

else if ( $install_step == 2)
{
	page_header( $lang['EM_step2']) ;

	// confirm passwords match
	$em_pass_confirm = (isset($HTTP_POST_VARS['em_pass_confirm'])) ? htmlspecialchars( $HTTP_POST_VARS['em_pass_confirm']) : '' ;
	if ( $em_pass != $em_pass_confirm)
	{
		echo $lang['EM_err_pw_match'] . "<br>\n" ;
		form_settings( $hidden, 3, '', true) ;
		exit ;
	}

	//
	// verify write access
	//
	echo '<h2>' . $lang['EM_test_write'] . "</h2>\n" ;
	$has_error = true ;

	// test writing to the server
	if ( $write == 'server')
	{
		// duh! they don't have write access!
		if (!$write_access)
		{
			echo $lang['EM_err_acc_write'] . "\n" ;
		}

		// they can't make dirs, so this is no good
		else if (!$mkdir_access)
		{
			echo $lang['EM_err_acc_mkdir'] . "\n" ;
		}

		// ok!
		else
		{
			$has_error = false ;
		}

		if ($has_error)
		{
////////////
////////////
////////////
			echo "<p>Write stuff about checking permissions and how to.</p>\n" ;
			form_settings( $hidden, 3, '', true) ;
			exit ;
		}
	}

	// if buffer+ftp write we need to test FTP to make sure we can move the files into place
	else if ( $write == 'ftpb')
	{
		// test the FTP connection
		if (!test_ftp( $ftp_user, $ftp_pass, $ftp_dir, $ftp_host, $ftp_debug, $ftp_type, $ftp_cache))
		{
			// FTP failed; print RESCAN button and then exit
			form_settings( $hidden, 3, '', true) ;
			exit ;
		}
	}


	// test to make sure the download feature will work; privmsg.php is the largest file so test with that
	else if ( $write == 'local')
	{
		// this will create a download button
		echo $lang['EM_confirm_download'] . "<br>\n" ;
		echo '<form action="easymod_install.' . $phpEx . '" name="install" method="post">' . "\n" ;
		$button  = '<input type="hidden" name="install_step" value="5">' . "\n" ;
		$button .= '<input class="mainoption" type="submit" name="download" value="' . $lang['EM_pp_download'] . '" />' . "\n" ;
		echo $button ;
		echo "</form>\n" ;
	}
	else if ( $write == '')
	{
//////// hard coded lang
//////// also... what is the "3" in the error??  should be a defined constant
		echo "<p>Undefined write method.</p>\n" ;
		form_settings( $hidden, 3, '', true) ;
		exit ;
	}


	echo '<b class="ok">' . $lang['EM_confirm_write'] . "</b><br>\n" ;
	if ($write == 'server')
	{
		echo $lang['EM_confirm_write_server'] . "<br />\n" ;
	}
	else if ($write == 'ftpb')
	{
		echo $lang['EM_confirm_write_ftp'] . "<br />\n" ;
	}
	else if ($write == 'local')
	{
		echo $lang['EM_confirm_write_local'] . "<br />\n" ;
	}
	else if ($write == 'screen')
	{
		echo $lang['EM_confirm_write_screen'] . "<br />\n" ;
	}



	//
	// verify move access
	//
	echo '<h2>' . $lang['EM_test_move'] . "</h2>\n" ;
	$has_error = true ;


	// if they are doing an automated server move method, make sure they are writing to the server!
	if ( (($move == 'ftpa') || ($move == 'copy')) && !(($write == 'ftpb') || ($write == 'server')) )
	{
		echo '<p>' . $lang['EM_err_no_write'] . "</p>\n" ;
		form_settings( $hidden, 3, '', true) ;
		exit ;
	}

	// if they are using FTP to write the files, then make sure they are using it move as well
	else if (($write == 'ftpb') && ($move != 'ftpa'))
	{
		echo '<p>' . $lang['EM_ftp_sync1'] . "</p>\n" ;
		form_settings( $hidden, 3, '', true) ;
		exit ;		
	}

	else if (($write != 'ftpb') && ($move == 'ftpa'))
	{
		echo '<p>' . $lang['EM_ftp_sync2'] . "</p>\n" ;
		form_settings( $hidden, 3, '', true) ;
		exit ;		
	}

	// if they want automated FTP, make sure it works
	else if ( $move == 'ftpa')
	{
		// test the FTP connection
		if (!test_ftp( $ftp_user, $ftp_pass, $ftp_dir, $ftp_host, $ftp_debug, $ftp_type, $ftp_cache))
		{
			// FTP failed; print RESCAN button and then exit
			form_settings( $hidden, 3, '', true) ;
			exit ;
		}
	}

	// if they selected copy access, make sure they actually have it (tards!!!)
	else if (( $move == 'copy') && ((!$copy_access) || (!$root_write)))
	{
		echo $lang['EM_err_copy'] . "<br>\n" ;
////////////
////////////
////////////
////////////
		echo "<p>Write stuff about checking permissions and how to.</p>\n" ;
		form_settings( $hidden, 3, '', true) ;
		exit ;
	}
	else if ( $move == '')
	{
//////// hard coded lang
//////// also... what is the "3" in the error??  should be a defined constant
		echo "<p>Undefined move method.</p>\n" ;
		form_settings( $hidden, 3, '', true) ;
		exit ;
	}


	echo '<b class="ok">' . $lang['EM_confirm_move'] . "</b><br>\n" ;
	if ($move == 'ftpa')
	{
		echo $lang['EM_confirm_move_ftp'] . "<br />\n" ;
	}
	else if ($move == 'copy')
	{
		echo $lang['EM_confirm_move_copy'] . "<br />\n" ;
	}
	else if ($move == 'exec')
	{
		echo $lang['EM_confirm_move_exec'] . "<br />\n" ;
	}
	else if ($move == 'ftpm')
	{
		echo $lang['EM_confirm_move_ftpm'] . "<br />\n" ;
	}


	$hidden  = "<input type=\"hidden\" name=\"sel_read\" value=\"$read\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"sel_write\" value=\"$write\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"sel_move\" value=\"$move\">\n" ;

	$hidden .= "<input type=\"hidden\" name=\"read_access\" value=\"$read_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"write_access\" value=\"$write_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"root_write\" value=\"$root_write\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"tmp_write\" value=\"$tmp_write\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"chmod_access\" value=\"$chmod_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"unlink_access\" value=\"$unlink_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"mkdir_access\" value=\"$mkdir_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"copy_access\" value=\"$copy_access\">\n" ;

	$hidden .= "<input type=\"hidden\" name=\"em_pass\" value=\"$em_pass\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_user\" value=\"$ftp_user\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_pass\" value=\"$ftp_pass\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_host\" value=\"$ftp_host\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_dir\" value=\"$ftp_dir\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_debug\" value=\"$ftp_debug\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_type\" value=\"$ftp_type\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_cache\" value=\"$ftp_cache\">\n" ;

	$hidden .= "<input type=\"hidden\" name=\"language\" value=\"$language\">\n" ;

	form_settings( $hidden, 3, $lang['EM_install_EM'], true) ;

	page_footer() ;
	exit ;
}


///
/// process files
///

else if ( $install_step == 3)
{
	page_header( $lang['EM_step3'] ) ;
	echo "<br clear=\"all\" />" ;
	echo '<h2>' . $lang['EM_processing_files'] . "</h2>" ;

	//
	// setup the command file
	//

	// we will keep the command file as an array for now and then write it out later; we will reuse the settings data
	$command_file = new mod_io( 'post_process.sh', '', $read, $write, $move, $ftp_user, $ftp_pass, $ftp_dir, $ftp_host, $ftp_type, $ftp_cache) ;


	//
	// parse the admin language file and add module names
	//
	echo '<b>' . $lang['EM_parsing'] . ':</b> language/lang_english/lang_admin.php</br>' ;


	$file_list = array() ;
	// this is really more about moving the other files than is about the command file; establish the FTP connection
	//  for moving files if necessary
	if (!$command_file->modio_prep('write', $ftp_debug))
	{
		$command_file->err_msg = $lang['EM_trace'] . ': main[1]->' . $command_file->err_msg ;
		$error = '<b>' . $lang['EM_err_critical_error'] . ':</b><br> ' . $command_file->err_msg . "<br>\n" ;
		handle_error( OPEN_FAIL_CRITICAL, $file_list, false, $error) ;
	}

	$result = open_files( 'lang_admin.'.$phpEx, 'language/lang_english/', $file_list, $command_file) ;

	// check for lang_german from Attachment MOD
	for ($i=0; $i<count($file_list); $i++)
	{
		if (strstr( $file_list[$i]->err_msg, 'lang_german'))
		{
/// hard coded lang
			display_error('The file language/lang_german/lang_admin.php was not found.  Do you have the German language pack installed? If not, then you should simply delete the language/lang_german directory and all the files inside of it. This problem is frequently caused by the popular Attachment MOD which can create a lang_german folder regardless of whether the language is present or not. If this is not the case, then visit our support forum for more help.') ;
		}
	}

	// bail if there is a problem
	handle_error($result, $file_list, false) ;


//////////////
////////////// once we get some translations, we can write the appropriate text per lang
//////////////

	$find_array = array() ;
	$search_array['module'] = array() ;
	$search_array['entries'] = array() ;
	$insert['module'] = array() ;
	$insert['entries'] = array() ;
	$inline_find = '' ;
	$inline_after = '' ;
	$fin = NULL ;

	// see if we need to add the main "MOD Center" module heading for the ACP
	if ( !find_lang_admin( '$lang[\'Modifications\']', $fin))
	{
		$add_module = true ;

		$search_array['module'][] = "\$lang['Styles']" ;
		$insert['module'][] = '// EASYMOD-start' ;
		$insert['module'][] = "\$lang['Modifications'] = 'MOD Center';" ;
		$insert['module'][] = '// EASYMOD-end' ;

		$search_array['entries'][] = "\$lang['Restore_DB']" ;
		$insert['entries'][] = '// EASYMOD-start' ;
		$insert['entries'][] = "\$lang['MOD_ainstall'] = 'Install MODs';" ;
		$insert['entries'][] = "\$lang['MOD_settings'] = 'EasyMOD Settings';" ;
		$insert['entries'][] = "\$lang['MOD_history'] = 'EasyMOD History';" ;
		$insert['entries'][] = "\$lang['MOD_control_tag'] = '$easymod_install_version';" ;
		$insert['entries'][] = '// EASYMOD-end' ;
	}

	// we know at least the module entry exists; see which MOD Center options we need to add
	else
	{
		$fin = NULL ;

		// see if we need to add all the entires
		if (!find_lang_admin( '// EASYMOD-start', $fin))
		{
			$search_array['entries'][0] = "\$lang['Restore_DB']" ;

			$insert['entries'][] = '// EASYMOD-start' ;
			$insert['entries'][] = "\$lang['MOD_ainstall'] = 'Install MODs';" ;
			$insert['entries'][] = "\$lang['MOD_settings'] = 'EasyMOD Settings';" ;
			$insert['entries'][] = "\$lang['MOD_history'] = 'EasyMOD History';" ;
			$insert['entries'][] = "\$lang['MOD_control_tag'] = '" . $easymod_install_version . "';" ;
			$insert['entries'][] = '// EASYMOD-end' ;
		}

//////									//////
////// check for subsquent lang_admin modifications here	//////
//////									//////

		// we know we have some entries, let's make sure the 0.0.8 ones are there
		else if (!find_lang_admin( '$lang[\'MOD_history\']', $fin))
		{
			// didn't find the entry so add the four 0.0.8 entries (plus control tag)
			$search_array['entries'][0] = '// EASYMOD-start' ;

			$insert['entries'][] = "\$lang['MOD_ainstall'] = 'Install MODs';" ;
			$insert['entries'][] = "\$lang['MOD_settings'] = 'EasyMOD Settings';" ;
			$insert['entries'][] = "\$lang['MOD_history'] = 'EasyMOD History';" ;
			$insert['entries'][] = "\$lang['MOD_control_tag'] = '" . $easymod_install_version . "';" ;
		}

		// if the control tag is not there then add it
		else if (!find_lang_admin( '$lang[\'MOD_control_tag\']', $fin, true))
		{
			$search_array['entries'][0] = '$lang[\'MOD_history\']' ;
			$insert['entries'][] = "\$lang['MOD_control_tag'] = '" . $easymod_install_version . "';" ;
		}

		// we'll modify the control to include this version
		else
		{
			$search_array['entries'][0] = '$lang[\'MOD_control_tag\']' ;
			$inline_find = '= \'' ;
			$inline_after =  $easymod_install_version . ', ' ;
		}
	}



	// insert the module entry if necessary ("MOD Center")
	if (count($search_array['module']) > 0)
	{
		wrapper_find( $file_list, $find_array, $search_array['module']) ;
		wrapper_insert( $file_list, $find_array, $insert['module'], false) ;
	}
	echo "<br>\n" ;

	// insert the entries or atleast update the control tag
	$find_array = array() ;
	wrapper_find( $file_list, $find_array, $search_array['entries']) ;

	// add the lines
	if (count($insert['entries']) > 0)
	{
		wrapper_insert( $file_list, $find_array, $insert['entries'], false) ;
	}

	// update just the control tag line
	else
	{
		echo '<b>' . $lang['EM_ifinding'] . ":</b> $inline_find<br>\n" ;
		echo '<b>' . $lang['EM_iafter'] . ":</b> $inline_after<br>\n" ;
		$result = perform_inline_add( $find_array, $file_list, $inline_find, $inline_after, 'after');
		handle_error($result, $file_list, true) ;
		write_find_array( $find_array, $file_list) ;
	}


	// finish writing the file
	if (!complete_file_reproduction( $file_list))
	{
		// print an error and will halt processing; don't close files b/c we already have
		handle_error( OPEN_FAIL_CRITICAL, $file_list, false) ;
	}

	// create the admin/em_includes directory
	$command_file->modio_mkdirs_copy( 'admin/em_includes/') ;

	// terminate the FTP connection
	$command_file->modio_cleanup('write') ;	
	


	echo "<br />" ;
	echo "<br clear=\"all\" />" ;
	echo '<h2>' . $lang['EM_build_post'] . "</h2>\n" ;


	$command_file->afile[] = 'copy includes/admin_easymod.php.txt ../../../admin/admin_easymod.php' ;
	$command_file->afile[] = 'copy em_includes/em_functions.php ../../../admin/em_includes/em_functions.php' ;
	$command_file->afile[] = 'copy em_includes/em_cipher.php ../../../admin/em_includes/em_cipher.php' ;
	$command_file->afile[] = 'copy em_includes/em_schema.php ../../../admin/em_includes/em_schema.php' ;
	$command_file->afile[] = 'copy em_includes/em_modio.php ../../../admin/em_includes/em_modio.php' ;
	$command_file->afile[] = 'copy em_includes/em_ftp.php ../../../admin/em_includes/em_ftp.php' ;
	$command_file->afile[] = 'copy em_includes/index.htm ../../../admin/em_includes/index.htm' ;

//////////////
////////////// once we get some translations, we can copy the proper files to where they should go
//////////////
	$lang_path =  $phpbb_root_path . 'language/' ;
	$lang_files = get_lang_files( 'lang_main.' . $phpEx, 'language/lang_english/', $lang_path) ;
	for ($i=0; $i<count($lang_files); $i++)
	{
		$command_file->afile[] = "copy lang_easymod.$phpEx ../../../" . $lang_files[$i]['path'] . 'lang_easymod.' . $phpEx ;
	}


	$files = get_theme_files( 'index_body.tpl', 'templates/subSilver/admin/') ;
	$pics = get_theme_files( 'cellpic.gif', 'templates/subSilver/images/') ;
	for ($i=0; $i<count($files); $i++)
	{
		$command_file->afile[] = 'copy includes/mod_complete.tpl ../../../' . $files[$i]['path'] . 'mod_complete.tpl' ;
		$command_file->afile[] = 'copy includes/mod_header.tpl ../../../' . $files[$i]['path'] . 'mod_header.tpl' ;
		$command_file->afile[] = 'copy includes/mod_history.tpl ../../../' . $files[$i]['path'] . 'mod_history.tpl' ;
		$command_file->afile[] = 'copy includes/mod_install.tpl ../../../' . $files[$i]['path'] . 'mod_install.tpl' ;
		$command_file->afile[] = 'copy includes/mod_login.tpl ../../../' . $files[$i]['path'] . 'mod_login.tpl' ;
		$command_file->afile[] = 'copy includes/mod_process.tpl ../../../' . $files[$i]['path'] . 'mod_process.tpl' ;
		$command_file->afile[] = 'copy includes/mod_settings.tpl ../../../' . $files[$i]['path'] . 'mod_settings.tpl' ;
		$command_file->afile[] = 'copy includes/mod_sql_body.tpl ../../../' . $files[$i]['path'] . 'mod_sql_body.tpl' ;
		$command_file->afile[] = 'copy includes/mod_preview.tpl ../../../' . $files[$i]['path'] . 'mod_preview.tpl' ;

		$command_file->afile[] = 'copy easymod.gif ../../../' . $pics[$i]['path'] . 'easymod.gif' ;
		$command_file->afile[] = 'copy includes/emc.gif ../../../' . $pics[$i]['path'] . 'emc.gif' ;
	}


	$hidden  = "<input type=\"hidden\" name=\"sel_read\" value=\"$read\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"sel_write\" value=\"$write\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"sel_move\" value=\"$move\">\n" ;

	$hidden .= "<input type=\"hidden\" name=\"read_access\" value=\"$read_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"write_access\" value=\"$write_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"root_write\" value=\"$root_write\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"tmp_write\" value=\"$tmp_write\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"chmod_access\" value=\"$chmod_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"unlink_access\" value=\"$unlink_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"mkdir_access\" value=\"$mkdir_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"copy_access\" value=\"$copy_access\">\n" ;

	$hidden .= "<input type=\"hidden\" name=\"em_pass\" value=\"$em_pass\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_user\" value=\"$ftp_user\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_pass\" value=\"$ftp_pass\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_dir\" value=\"$ftp_dir\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_host\" value=\"$ftp_host\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_debug\" value=\"$ftp_debug\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_type\" value=\"$ftp_type\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_cache\" value=\"$ftp_cache\">\n" ;

	$hidden .= "<input type=\"hidden\" name=\"language\" value=\"$language\">\n" ;

	echo '<b>' . $lang['EM_build_post_desc'] . ":</b>\n" ;
	for ($i=0; $i<count( $command_file->afile); $i++)
	{
		echo $command_file->afile[$i] . "<br>\n" ;
		$hidden .= "<input type=\"hidden\" name=\"command_step$i\" value=\"" . $command_file->afile[$i] . "\">\n" ;
	}
	$hidden .= "<input type=\"hidden\" name=\"num_command_steps\" value=\"$i\">\n" ;


	form_settings( $hidden, 4, $lang['EM_complete_processing'], '') ;
	page_footer() ;
}


//
// move the files into place and we are done!
//

else if ( $install_step == 4)
{
	// if adding an option to a select field, get the field number
	$num_command_steps = ( isset($HTTP_POST_VARS['num_command_steps'])) ? intval($HTTP_POST_VARS['num_command_steps']) : 0 ;
	$command = array() ;
	for ( $i=0; $i<$num_command_steps; $i++)
	{
		$var_name = 'command_step' . $i ;
		if ( isset($HTTP_POST_VARS[$var_name]))
		{
			$command[] = htmlspecialchars( $HTTP_POST_VARS[$var_name]) ;
		}
	}


	page_header( $lang['EM_step4'] ) ;
	helpwin( 600, 500) ;


	///
	/// Add the easymod table
	///
	$sql = array();
	switch ( SQL_LAYER )
	{
		case 'mysql':
		case 'mysql4':
			$sql[] = "CREATE TABLE " . EASYMOD_TABLE . " (
				mod_id mediumint(8) NOT NULL DEFAULT '0' auto_increment,
				mod_title varchar(50) NULL DEFAULT '',
				mod_file varchar(255) NULL DEFAULT '',
				mod_version varchar(15) NULL DEFAULT '',
				mod_author_handle varchar(25) NULL DEFAULT '',
				mod_author_email varchar(100) NULL DEFAULT '',
				mod_author_name varchar(100) NULL DEFAULT '',
				mod_author_url varchar(100) NULL DEFAULT '',
				mod_description text NULL DEFAULT '',
				mod_process_date int(11) NULL DEFAULT '0',
				mod_phpBB_version varchar(15) NULL DEFAULT '',
				mod_processed_themes varchar(200) NULL DEFAULT '',
				mod_processed_langs varchar(200) NULL DEFAULT '',
				mod_files_edited mediumint(8) NULL DEFAULT '0',
				mod_tables_added mediumint(8) NULL DEFAULT '0',
				mod_tables_altered mediumint(8) NULL DEFAULT '0',
				mod_rows_inserted mediumint(8) NULL DEFAULT '0',
				PRIMARY KEY (mod_id))" ;
			break ;

		case 'postgresql':
			$sql[] = "CREATE SEQUENCE " . EASYMOD_TABLE . "_mod_id_seq start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1" ;

			$sql[] = "CREATE TABLE " . EASYMOD_TABLE . " (
				mod_id int4 NOT NULL DEFAULT nextval('phpbb_easymod_mod_id_seq'::text),
				CONSTRAINT PK_phpbb_easymod PRIMARY KEY (mod_id),
				mod_title varchar(50) NULL DEFAULT '',
				mod_file varchar(255) NULL DEFAULT '',
				mod_version varchar(15) NULL DEFAULT '',
				mod_author_handle varchar(25) NULL DEFAULT '',
				mod_author_email varchar(100) NULL DEFAULT '',
				mod_author_name varchar(100) NULL DEFAULT '',
				mod_author_url varchar(100) NULL DEFAULT '',
				mod_description text NULL DEFAULT '',
				mod_process_date int4 NULL DEFAULT '0',
				mod_phpBB_version varchar(15) NULL DEFAULT '',
				mod_processed_themes varchar(200) NULL DEFAULT '',
				mod_processed_langs varchar(200) NULL DEFAULT '',
				mod_files_edited int4 NULL DEFAULT '0',
				mod_tables_added int4 NULL DEFAULT '0',
				mod_tables_altered int4 NULL DEFAULT '0',
				mod_rows_inserted int4 NULL DEFAULT '0' )" ;
			break ;

		case 'mssql-odbc':
		case 'mssql':
/*
			$sql[] = "
BEGIN TRANSACTION
GO" ;
*/
			$sql[] = "CREATE TABLE [" . EASYMOD_TABLE . "] (
				  [mod_id] [int] IDENTITY (1, 1) NOT NULL,
				  [mod_title] [varchar] (50) NULL,
				  [mod_file] [varchar] (255) NULL,
				  [mod_version] [varchar] (15) NULL,
				  [mod_author_handle] [varchar] (25) NULL,
				  [mod_author_email] [varchar] (100) NULL,
				  [mod_author_name] [varchar] (100) NULL,
				  [mod_author_url] [varchar] (100) NULL,
				  [mod_description] [varchar] (255) NULL,
				  [mod_process_date] [int] NULL,
				  [mod_phpBB_version] [varchar] (15) NULL,
				  [mod_processed_themes] [varchar] (200) NULL,
				  [mod_processed_langs] [varchar] (200) NULL,
				  [mod_files_edited] [int] NULL,
				  [mod_tables_added] [int] NULL,
				  [mod_tables_altered] [int] NULL,
				  [mod_rows_inserted] [int] NULL
				) ON [PRIMARY];" ;
//GO" ;

			$sql[] = "ALTER TABLE [" . EASYMOD_TABLE . "] WITH NOCHECK ADD
				  CONSTRAINT [PK_phpbb_easymod] PRIMARY KEY CLUSTERED
				  (
				    [mod_id]
				  ) ON [PRIMARY]" ;
//GO" ;


//				CONSTRAINT [DF_phpbb_easymod_mod_id] DEFAULT ('0') FOR [mod_id],
			$sql[] = "ALTER TABLE [" . EASYMOD_TABLE . "] WITH NOCHECK ADD
				CONSTRAINT [DF_phpbb_easymod_mod_title] DEFAULT ('') FOR [mod_title],
				CONSTRAINT [DF_phpbb_easymod_mod_file] DEFAULT ('') FOR [mod_file],
				CONSTRAINT [DF_phpbb_easymod_mod_version] DEFAULT ('') FOR [mod_version],
				CONSTRAINT [DF_phpbb_easymod_mod_author_handle] DEFAULT ('') FOR [mod_author_handle],
				CONSTRAINT [DF_phpbb_easymod_mod_author_email] DEFAULT ('') FOR [mod_author_email],
				CONSTRAINT [DF_phpbb_easymod_mod_author_name] DEFAULT ('') FOR [mod_author_name],
				CONSTRAINT [DF_phpbb_easymod_mod_author_url] DEFAULT ('') FOR [mod_author_url],
				CONSTRAINT [DF_phpbb_easymod_mod_description] DEFAULT ('') FOR [mod_description],
				CONSTRAINT [DF_phpbb_easymod_mod_process_date] DEFAULT ('0') FOR [mod_process_date],
				CONSTRAINT [DF_phpbb_easymod_mod_phpBB_version] DEFAULT ('') FOR [mod_phpBB_version],
				CONSTRAINT [DF_phpbb_easymod_mod_processed_themes] DEFAULT ('') FOR [mod_processed_themes],
				CONSTRAINT [DF_phpbb_easymod_mod_processed_langs] DEFAULT ('') FOR [mod_processed_langs],
				CONSTRAINT [DF_phpbb_easymod_mod_files_edited] DEFAULT ('0') FOR [mod_files_edited],
				CONSTRAINT [DF_phpbb_easymod_mod_tables_added] DEFAULT ('0') FOR [mod_tables_added],
				CONSTRAINT [DF_phpbb_easymod_mod_tables_altered] DEFAULT ('0') FOR [mod_tables_altered],
				CONSTRAINT [DF_phpbb_easymod_mod_rows_inserted] DEFAULT ('0') FOR [mod_rows_inserted]" ;
//				GO" ;

/*
			$sql[] = "COMMIT
					GO" ;
*/

			break ;

		case 'msaccess':
			$sql[] = "CREATE TABLE " . EASYMOD_TABLE . " (
				mod_id COUNTER NOT NULL CONSTRAINT PK_phpbb_easymod PRIMARY KEY,
				mod_title TEXT(50) NULL,
				mod_file TEXT(255) NULL,
				mod_version TEXT(15) NULL,
				mod_author_handle TEXT(25) NULL,
				mod_author_email TEXT(100) NULL,
				mod_author_name TEXT(100) NULL,
				mod_author_url TEXT(100) NULL,
				mod_description MEMO NULL,
				mod_process_date INTEGER NULL,
				mod_phpBB_version TEXT(15) NULL,
				mod_processed_themes TEXT(200) NULL,
				mod_processed_langs TEXT(200) NULL,
				mod_files_edited INTEGER NULL,
				mod_tables_added INTEGER NULL,
				mod_tables_altered INTEGER NULL,
				mod_rows_inserted INTEGER NULL )" ;
			break ;

		default:
			die("No DB LAYER found!");
			break;
	}


	echo '<h2>' . $lang['EM_add_db'] . "</h2>\n";


	// if the EM table already exists, then don't bother making it again
	$test_sql = "SELECT * FROM " . EASYMOD_TABLE ;
	if ( $result = $db->sql_query($test_sql))
	{
		echo '<p>' . $lang['EM_progress'] . ' :: <b class="ok">' . $lang['EM_done'] . '</b> - ' . $lang['EM_already_exist'] . "<br>\n" ;
	}

	// we need to create the table
	else
	{
		echo '<b>' . $lang['EM_exec_sql'] . ': </b>' ;
		for($i = 0; $i < count($sql); $i++)
		{
			echo "$sql[$i]<br>\n" ;
		}

		echo '<p>' . $lang['EM_progress'] . ' :: <b>';
		flush();

		$error_ary = array();
		$errored = false;
		for($i = 0; $i < count($sql); $i++)
		{
			_sql($sql[$i], $errored, $error_ary);
		}

		echo '</b> <b class="ok">' . $lang['EM_done'] . '</b><br />' . $lang['EM_result'] . " &nbsp; :: \n";

		if ( $errored )
		{
			echo ' <b>' . $lang['EM_failed_sql'] . "</b>\n<ul>";

			for($i = 0; $i < count($error_ary['sql']); $i++)
			{
				echo '<li>' . $lang['EM_err_error'] . ' :: <b>' . $error_ary['error_code'][$i]['message'] . "</b><br />\n";
				echo "SQL &nbsp; :: <b>" . $error_ary['sql'][$i] . "</b><br /><br /></li>\n";
			}
			echo "</ul>\n<p>" . $lang['EM_no_worry'] . "</p>\n";
		}
		else
		{
			echo '<b>' . $lang['EM_no_errors'] . "</b>\n";
		}
	}

	echo "<br />" ;
	echo "<br />" ;
	echo "<br />\n" ;


	//
	// move the files into place and create the manual post-process script
	//
	echo '<h2>' . $lang['EM_complete_post'] . "</h2>\n";

	// we will keep the command file as an array for now and then write it out later; we will reuse the settings data
	$command_file = new mod_io( 'post_process.sh', '', $read, $write, $move, $ftp_user, $ftp_pass, $ftp_dir, $ftp_host, $ftp_type, $ftp_cache) ;
	$command_bat = new mod_io( 'post_process.bat', '', $read, $write, $move, $ftp_user, $ftp_pass, $ftp_dir, $ftp_host, $ftp_type, $ftp_cache) ;

	// open the command file: config=true,command=true
	if (( !$command_file->modio_open(true)) || ( !$command_bat->modio_open(true)))
	{
		$command_file->err_msg = $lang['EM_trace'] . ': main[1b]->' . $command_file->err_msg ;
		$error = '<br>' . $lang['EM_err_open_pp'] . '<br> ' . $command_file->err_msg . "<br>\n" ;
//		handle_error( OPEN_FAIL_CRITICAL, $file_list, false, '<br>' . $lang['EM_err_open_pp'] . "<br>\n") ;
		handle_error( OPEN_FAIL_CRITICAL, $file_list, false, $error) ;
	}

	// this is really more about moving the other files than is about the command file; establish the FTP connection
	//  for moving files if necessary
	if (!$command_file->modio_prep('move', $ftp_debug))
	{
		$command_file->err_msg = $lang['EM_trace'] . ': main[2]->' . $command_file->err_msg ;
		handle_error( OPEN_FAIL_CRITICAL, $file_list, false, '<b>' . $lang['EM_err_critical_error'] . ':</b><br> ' . $command_file->err_msg . "<br>\n") ;
	}

	// transfer FTP attributes to the bat file
	$command_bat->emftp = $command_file->emftp ;

	$bu_list = array() ;
	$mv_list = array() ;
	$mod_count = 0 ;
	// execute the move!
	for ($i=0; $i<$num_command_steps; $i++)
	{
		$parms = explode(' ', $command[$i]) ;
		if ( $parms[0] == 'copy')
		{
			// write to the post-process script
			$command_file->modio_write( 'cp ' . $parms[1] . ' ' . $parms[2] . "\n") ;
			$command_bat->modio_write( str_replace('/', "\\", $command[$i]) . "\r\n") ;

			$split_from = explode('/', $parms[1]) ;
			$split_to = explode('/', $parms[2]) ;

			// set vars depending if this is a backup or a download file
			if ($split_to[0] == 'backups')
			{
				$from = $parms[1] ;
				$to = $parms[2] ;
				$type = $lang['EM_pp_backup'] ;
				$is_backup = true ;
				$link = 'easymod_install.' . $phpEx . '?install_step=6&mode=backup&pw=' . $em_pass . '&file=' . $parms[1] ;
			}
			else
			{
				$from = (strstr($parms[1],$install_path . 'processed/')) ? substr($parms[1],strlen($install_path . 'processed/')) : $parms[1] ;
				$to = $parms[2] ;
				$type = $lang['EM_pp_download'] ;
				$is_backup = false ;
				$link = 'easymod_install.' . $phpEx . '?install_step=6&mode=file&pw=' . $em_pass . '&file=' . $parms[2] ;
			}


///////////////////////
/////////////////////// using the $installer hack to get around a problem; need to fix correctly
///////////////////////
			// now the magic happens ;-)
			$ret_value = $command_file->modio_move( $parms[2], $parms[1], $mod_count, $link, $type, true) ;
			$mod_count++ ;

			// if there is no return value then that means it didn't work; print the err_msg and bail
			if ($ret_value == '')
			{
				$command_file->err_msg = $lang['EM_trace'] . ': main[3]->' . $command_file->err_msg ;
				
				// if this is the first file in the chain and it fails, then halt processing altogether
				if ($i == 1)
				{
					handle_error( OPEN_FAIL_CRITICAL, $file_list, false, '<b>' . $lang['EM_err_critical_error'] . ':</b><br> ' . $command_file->err_msg ) ;
				}

				// otherwise print and error and continue on
				else
				{
					echo '<b>' . $lang['EM_err_critical_error'] . ':</b><br> ' . $command_file->err_msg . '<br>' . $lang['EM_err_attempt_remainder'] . "<br><br><br>\n" ;
				}
			}

			// move was a success, display the output
			else
			{
				// if the destination is a backup, then list it as such
				if ($is_backup)
				{
					$ret_value .= '<input type="hidden" name="mode' .($mod_count-1). '" value="backup">' . "\n" ;
					$bu_list[] = '<tr><td class="row1"  width="33%">' . $lang['EM_pp_backup'] . '</td><td class="row2" width="57%">' . $from . '</td><td class="row1" align="center" width="10%">' . $ret_value . "</td></tr>\n" ;
				}

				// list the file
				else
				{
					// we are only downloading modified files; not ones included with the MOD
					if (!(strstr($parms[1],$install_path . 'processed/')) && ($ret_value != '<b>' . $lang['EM_pp_complete'] . '</b>') && ($ret_value != '<b>' . $lang['EM_pp_ready'] . '</b>'))
					{
						$ret_value = '<b>' . $lang['EM_pp_manual'] . '</b>' ;
					}

					// if its a download then append the mode
					else if (strstr($ret_value, '<input'))
					{
						$ret_value .= '<input type="hidden" name="mode'.($mod_count-1).'" value="file">'."\n" ;
					}

					$mv_list[] = '<tr><td class="row1" width="33%">' . $from . '</td><td class="row2" width="57%">' . $to . '</td><td class="row1" align="center" width="10%">' . $ret_value . "</td></tr>\n" ;
				}
			}
		}
	}

	// setup the form (whether needed or not)
	echo '<form action="easymod_install.' . $phpEx . '" name="install" method="post">' . "\n" ;

	// print the backup list
	echo '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline">' . "\n" ;
	echo '<tr><th colspan="3">' . sprintf( $lang['EM_pp_backups'], $install_path . 'backups/') . '</th></tr>' . "\n" ;
	for ($i=0; $i<count($bu_list); $i++)
	{
		echo $bu_list[$i] ;
	}
	echo "</table><br>\n" ;

	// print the move list
	echo '<table width="100%" cellpadding="2" cellspacing="1" border="0" class="forumline">' . "\n" ;
	echo '<tr><th>' . sprintf( $lang['EM_pp_from'], $install_path . 'processed/') . '</th><th>' . $lang['EM_pp_to'] . '</th><th>' . $lang['EM_pp_status'] . "</th></tr>\n" ;
	for ($i=0; $i<count($mv_list); $i++)
	{
		echo $mv_list[$i] ;
	}
	echo "</table>\n" ;

	// finish the form
	echo '<input type="hidden" name="install_step" value="6">' . "\n" ;
	echo '<input type="hidden" name="mod_count" value="' . $mod_count . '">' . "\n" ;
	echo "</form>\n" ;


	// finish the script generation
	if ((!$command_file->modio_close( true)) || (!$command_bat->modio_close( true)))
	{
		$command_file->err_msg = $lang['EM_trace'] . ': main[4]->' . $command_file->err_msg ;
		$error = '<br>' . $lang['EM_err_write_pp'] . '<br> ' . $command_file->err_msg . "<br>\n" ;
//		handle_error( OPEN_FAIL_CRITICAL, $file_list, false, $lang['EM_err_write_pp'] ) ;
		handle_error( OPEN_FAIL_CRITICAL, $file_list, false, $error ) ;
	}

	// cleanup, this is really just for FTP so far
	$command_file->modio_cleanup('move') ;


	$hidden  = "<input type=\"hidden\" name=\"sel_read\" value=\"$read\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"sel_write\" value=\"$write\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"sel_move\" value=\"$move\">\n" ;

	$hidden .= "<input type=\"hidden\" name=\"read_access\" value=\"$read_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"write_access\" value=\"$write_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"root_write\" value=\"$root_write\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"tmp_write\" value=\"$tmp_write\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"chmod_access\" value=\"$chmod_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"unlink_access\" value=\"$unlink_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"mkdir_access\" value=\"$mkdir_access\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"copy_access\" value=\"$copy_access\">\n" ;

	$hidden .= "<input type=\"hidden\" name=\"em_pass\" value=\"$em_pass\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_user\" value=\"$ftp_user\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_pass\" value=\"$ftp_pass\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_dir\" value=\"$ftp_dir\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_host\" value=\"$ftp_host\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_debug\" value=\"$ftp_debug\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_type\" value=\"$ftp_type\">\n" ;
	$hidden .= "<input type=\"hidden\" name=\"ftp_cache\" value=\"$ftp_cache\">\n" ;

	$hidden .= "<input type=\"hidden\" name=\"language\" value=\"$language\">\n" ;

	echo "<br>\n" ;
	// print a warning if they aren't using an automated move method
	if (($move != 'copy') && ($move != 'ftpa'))
	{
		echo $lang['EM_move_files'] . "<br>\n" ;
	}
	form_settings( $hidden, 7, $lang['EM_confirm'], false) ;

	page_footer() ;
	exit ;

}


// test download file capability
else if ( $install_step == 5)
{
	header('Content-Type: text/x-delimtext; name="privmsg.'.$phpEx . '"');
	header('Content-disposition: attachment; filename="privmsg.'.$phpEx . '"');

	$file_test = new mod_io( 'privmsg.'.$phpEx, '', 'server', 'local', 'ftpm', '', '', '', $ftp_host, $ftp_type, $ftp_cache) ;
	$file_test->modio_open() ;

	// replicate the file
	while (!feof($file_test->pread_file))
	{
		echo fgets( $file_test->pread_file, 4096);
	}

	// close the file
	$file_test->modio_close() ;
	exit ;
}

//
// download a file or backup
//
else if ( $install_step == 6)
{
	$on_screen = false ;

	// if we have a proper mode through GET VAR, then we are displaying to screen
	if (($mode == 'backup') || ($mode == 'file'))
	{
		$file = ( isset($HTTP_GET_VARS['file'])) ? htmlspecialchars($HTTP_GET_VARS['file']) : '' ;
		$on_screen = true ;
	}

	// otherwise we are downloading a file
	else
	{
		// they clicked a form button; we need to figure out which one so we know what file they are looking for
		$num_files = ( isset($HTTP_POST_VARS['mod_count'])) ? intval($HTTP_POST_VARS['mod_count']) : 0 ;

		// loop through all the submit buttons to see which one was pressed
		for ( $i=0; $i<=$num_files; $i++)
		{
			// if this is the button that was pressed then we are all set!  get the file name
			$var_name = 'submitfile' . $i ;
			if ( isset($HTTP_POST_VARS[$var_name]))
			{
				$file = ( isset($HTTP_POST_VARS['file'.$i])) ? htmlspecialchars($HTTP_POST_VARS['file'.$i]) : '' ;
				$mode = ( isset($HTTP_POST_VARS['mode'.$i])) ? htmlspecialchars($HTTP_POST_VARS['mode'.$i]) : '' ;
				break ;
			}
		}
	}


	// we'll need to look at the path and filename so split things up
	$split = explode('/', $file) ;

	// if a file, then make sure we have the filename correct
	if ($mode == 'file')
	{
		// by default the filename sent will match the one in the MOD script
		$process_file = (substr($file, 0, 9) == '../../../') ? substr($file, 9) : '' ;
		$orig_file = $process_file ;

		// handle the special cases of a template file to download; only subSilver will appear in the MOD script
		if (($split[3] == 'templates') && ($split[4] != 'subSilver'))
		{
			$process_file = str_replace( $split[4], 'subSilver', $process_file) ;
		}

		// handle the special cases of a language file to download; only english will appear in the MOD script
		else if (($split[3] == 'language') && ($split[4] != 'lang_english'))
		{
			$process_file = str_replace( $split[4], 'lang_english', $process_file) ;
		}
	}

	// if a backup then we can assume the filename is valid
	else
	{
		$process_file = $file ;
		$orig_file = $process_file ;
	}


	// if there is no file to process then we are in trouble!
	if ( $process_file == '')
	{
		// just print a Plain Jane error, not all the debug info
		echo $lang['EM_err_no_process_file'] . "\n" ;
		exit ;
	}


	// set up the screen for display
	if ($on_screen)
	{
		echo "<PRE>\n" ;
	}

	// set up the redirects so we will download a file, the contents of which we will echo out
	else
	{
		header('Content-Type: text/x-delimtext; name="' . $split[count($split)-1] . '"');
		header('Content-disposition: attachment; filename="' . $split[count($split)-1] . '"');
	}


	// for a backup just dump out the file
	if ($mode == 'backup')
	{
		// open the core file
		if (!$read_file = fopen ( $process_file, 'r'))
		{
			// gotta echo out the message since message_die is not an option
			echo sprintf( $lang['EM_err_backup_open'], $process_file) . "\n" ;
			exit ;
		}

		// write out the lines
		while (!feof($read_file))
		{
			$newline = fgets( $read_file, 4096);
			if ($on_screen)
			{
				echo htmlspecialchars($newline) ;
			}
			else
			{
				echo $newline ;
			}
		}
		fclose( $read_file) ;
	}
	else
	{
		$command_file = new mod_io( 'temp.sh', '', 'server', 'local', 'ftpm', '', '', '', $ftp_host, $ftp_type, $ftp_cache) ;


		//
		// parse the admin language file and add module names
		//

		$file_list = array() ;
		$result = open_files( 'lang_admin.php', 'language/lang_english/', $file_list, $command_file) ;
		handle_error($result, $file_list, false) ;
//////////////
////////////// once we get some translations, we can write the appropriate text per lang
//////////////


		$find_array = array() ;
		$search_array = array() ;
		$search_array[] = "\$lang['Styles']" ;
		$result = perform_find( $file_list, $find_array, $search_array) ;
		handle_error($result, $file_list, true) ;

		$insert  = "// EASYMOD-start\n" ;
		$insert .= "\$lang['Modifications'] = 'MOD Center';\n" ;
		$insert .= "// EASYMOD-end\n" ;
		write_find_array( $find_array, $file_list) ;
		write_files( $file_list, $insert) ;


		$find_array = array() ;
		$search_array = array() ;
		$search_array[] = "\$lang['Restore_DB']" ;
		$result = perform_find( $file_list, $find_array, $search_array) ;
		handle_error($result, $file_list, true) ;

///////////////
/////////////// this should be doing all the checks done when building the lines
///////////////
		$insert  = "// EASYMOD-start\n" ;
		$insert .= "\$lang['MOD_ainstall'] = 'Install MODs';\n" ;
		$insert .= "\$lang['MOD_settings'] = 'EasyMOD Settings';\n" ;
		$insert .= "\$lang['MOD_history'] = 'EasyMOD History';\n" ;
		$insert .= "\$lang['MOD_control_tag'] = '" . $easymod_install_version . "';\n" ;
		$insert .= "// EASYMOD-end\n" ;
		write_find_array( $find_array, $file_list) ;
		write_files( $file_list, $insert) ;

		// unlikely that we will get a close error
		complete_file_reproduction( $file_list) ;

		// make sure we have the right file
		for ($file=0; $file<count($file_list); $file++)
		{
			// make sure this is what we are looking for, otherwise keep looking
			if ($orig_file != ($file_list[$file]->path . $file_list[$file]->filename))
			{
				continue ;
			}

			// write out the lines
			for ($i=0; $i<count($file_list[$file]->afile); $i++)
			{
				if ($on_screen)
				{
					echo htmlspecialchars($file_list[$file]->afile[$i]) ;
				}
				else
				{
					echo $file_list[$file]->afile[$i] ;
				}
			}

			// done! done! done!
			exit ;
		}

		// didn't find the file!  OH CRAP!
		echo $lang['EM_err_modify'] . "\n" ;
	}

	// do a little clean up
	if ($on_screen)
	{
		echo "</PRE>\n" ;
	}

	exit ;
}

// confirmation
else if ($install_step == 7)
{
	page_header( $lang['EM_step5']) ;


	// if the error message is not empty after our tests, then we won't complete the install
	$error = '' ;


	//
	// confirm additions to lang_admin.php; the control tag ensures the changes from THIS version are present
	//
	echo '<h2>' . $lang['EM_confirming_mod'] . "</h2>\n";

	// let 'em know what we are doing
	echo '<b>' . $lang['EM_confirm_lang'] . ':</b> $lang[\'MOD_control_tag\'] = \'' . $easymod_install_version . "<br>\n" ;

	// open lang_admin.php for reading
	$found = false ;
	if ($fin = fopen('../../../language/lang_english/lang_admin.'.$phpEx, 'r'))
	{
		// loop through file looking for key
		while (!feof( $fin))
		{
			// read a line and see if it contains our key
			$line = fgets( $fin, 4096) ;
			if (strstr($line, '$lang[\'MOD_control_tag\'] = \'' . $easymod_install_version))
			{
				// print success and break out
				$found = true ;
				echo '<span class="ok"><b>' . $lang['EM_confirmed'] . "</b></span><br>\n" ;
				break ;
			}
		}
		fclose( $fin) ;

		// if failed mark it and display error
		if (!$found)
		{
			$error = $lang['EM_err_find'] . ' <b>$lang[\'MOD_control_tag\'] = \'' . $easymod_install_version . '</b> in [language/lang_english/lang_admin.php].' ;
			display_error( $error) ;
		}
	}
	else
	{
		$error = sprintf( $lang['EM_modio_open_read'], 'language/lang_english/lang_admin.php') ;
		display_error( $error) ;
	}

	

	//
	// confirm admin_easymod.php is in place and correct version
	//
	
	// let 'em know what we are doing
	echo '<br><br><b>' . $lang['EM_confirm_admin'] . ':</b> admin_easymod.php,v ' . $easymod_install_version . "<br>\n" ;

	// open admin_easymod.php for reading
	$found = false ;
	if ($fin = fopen('../../admin_easymod.'.$phpEx, 'r'))
	{
		// loop through file looking for key
		while (!feof( $fin))
		{
			// read a line and see if it contains our key
			$line = fgets( $fin, 4096) ;
			if (strstr($line, 'admin_easymod.php,v ' . $easymod_install_version))
			{
				// print success and break out
				$found = true ;
				echo '<span class="ok"><b>' . $lang['EM_confirmed'] . "</b></span><br>\n" ;
				break ;
			}
		}
		fclose( $fin) ;

		// if failed mark it and display error
		if (!$found)
		{
			$error = $lang['EM_err_find'] . ' <b>admin_easymod.php,v ' . $easymod_install_version . '</b> in [admin/admin_easymod.php].' ;
			display_error( $error) ;
		}
	}
	else
	{
		$error = sprintf( $lang['EM_modio_open_read'], 'admin/admin_easymod.php') ;
		display_error( $error) ;
	}


	//
	// confirm mod_install.tpl is in place
	//
	
	// let 'em know what we are doing
	echo '<br><br><b>mod_install.tpl:</b> ' . $lang['EM_confirm_exist'] . "<br>\n" ;

	// see if the file exists
	if (file_exists('../../../templates/subSilver/admin/mod_install.tpl'))
	{
		// print success
		echo '<span class="ok"><b>' . $lang['EM_confirmed'] . "</b></span><br>\n" ;
	}
	else
	{
		// if failed mark it and display error
		$error = $lang['EM_err_find'] . ' [templates/subSilver/admin/mod_install.tpl].' ;
		display_error( $error) ;
	}


	//
	// if failed, display debug info and break out
	//

	if ($error != '')
	{
		// tell them that EM is not properly installed and they will need to fix the above errors
		echo '<br><br><h2>' . $lang['EM_confirm_failed'] . "</h2>\n" ;
		echo '<b>' . $lang['EM_confirm_fix'] . "</b><br><br><br>\n" ;

		// display debug
		display_debug_info( $error) ;
		echo "<br>\n" ;

		// get us out of here!
		exit ;
	}


	//
	// if all in order, update the db to reflect that
	//

	echo "<br>\n" ;
	echo "<br>\n" ;
	echo "<br>\n" ;
	echo '<h2>' . $lang['EM_update_db'] . "</h2>\n";


	// update our EM config info
	echo '<b>' . $lang['EM_store_entries'] . ": </b>" ;

	// see if we have already made the EM entries
	$sql = "SELECT * 
		FROM " . CONFIG_TABLE . " 
		WHERE config_name = 'EM_version'" ;
	if ( !($result = $db->sql_query($sql)) )
	{
		handle_error( OPEN_FAIL_CRITICAL, $file_list, false, $lang['EM_err_config_table']) ;
	}
	$rows = $db->sql_numrows($result);
	$db->sql_freeresult($result);


	// added security starting in 0.0.11, md5 the em pass
	$em_md5 = md5($em_pass) ;

	// added security starting in 0.0.11, blowfish encrypt the ftp_pass
	include($phpbb_root_path . $script_path . '/em_includes/em_cipher.php') ;
	$cipher = new Cipher_BlockMode_cbc();
	$cipher->blowfish->setKey( $em_pass);
	$ftp_cipher = $cipher->encrypt($ftp_pass) ;

	// if not, add the fields
	if ( $rows == 0)
	{
		em_db_insert( 'EM_version', $easymod_install_version) ;
		em_db_insert( 'EM_password', $em_md5) ;
		em_db_insert( 'EM_read', $read) ;
		em_db_insert( 'EM_write', $write) ;
		em_db_insert( 'EM_move', $move) ;
		em_db_insert( 'EM_ftp_dir', $ftp_dir) ;
		em_db_insert( 'EM_ftp_user', $ftp_user) ;
		em_db_insert( 'EM_ftp_pass', $ftp_cipher) ;
		em_db_insert( 'EM_ftp_host', $ftp_host) ;
		em_db_insert( 'EM_ftp_type', $ftp_type) ;
		em_db_insert( 'EM_ftp_cache', $ftp_cache) ;
	}

	// if so, update the settings
	else
	{
		em_db_update( 'EM_version', $easymod_install_version) ;
		em_db_update( 'EM_password', $em_md5) ;
		em_db_update( 'EM_read', $read) ;
		em_db_update( 'EM_write', $write) ;
		em_db_update( 'EM_move', $move) ;
		em_db_update( 'EM_ftp_dir', $ftp_dir) ;
		em_db_update( 'EM_ftp_user', $ftp_user) ;
		em_db_update( 'EM_ftp_pass', $ftp_cipher) ;

		// 0.0.10a and later see if we have already made the EM_ftp_host field
		if (!add_new_config('EM_ftp_host', $ftp_host))
		{
			handle_error( OPEN_FAIL_CRITICAL, $file_list, false, $lang['EM_err_config_table']) ;
		}

		// 0.0.10c and later see if we have already made the EM_ftp_type field
		if (!add_new_config('EM_ftp_type', $ftp_type))
		{
			handle_error( OPEN_FAIL_CRITICAL, $file_list, false, $lang['EM_err_config_table']) ;
		}

		// 0.0.12 and later see if we have already made the EM_ftp_cache field
		if (!add_new_config('EM_ftp_cache', $ftp_cache))
		{
			handle_error( OPEN_FAIL_CRITICAL, $file_list, false, $lang['EM_err_config_table']) ;
		}
	}
	echo '<span class="OK"><b>' . $lang['EM_done'] . "</b></span><br>\n" ;
	echo "<br>\n" ;


	///
	/// Make an update to the EM table
	///

	unset($sql);
	$error_ary = array();
	$errored = false;
	
	$sql = 'INSERT INTO ' . EASYMOD_TABLE . " ( mod_title, mod_file, mod_version, mod_author_handle, mod_author_email, mod_author_name, mod_author_url, mod_description, mod_process_date, mod_phpBB_version, mod_processed_themes, mod_processed_langs, mod_files_edited, mod_tables_added, mod_tables_altered, mod_rows_inserted)
		VALUES ( 'EasyMOD', 'easymod/easymod_install." . $phpEx . "', '$easymod_install_version', 'Nuttzy', 'pktoolkit@blizzhackers.com', 'n/a', 'http://www.blizzhackers.com', 'EasyMOD automatically perfoms in seconds which previously required the tedious task of manually editing files.', " . time() . ", '$phpBB_version', '" . get_themes() . "', '" . get_languages( '../../../language') . "', 0, 1, 0, 1)";

	echo '<b>' . $lang['EM_exec_sql'] . ": </b>$sql<br>\n" ;
	echo '<p>' . $lang['EM_progress'] . ' :: <b>';
	flush();

	_sql($sql, $errored, $error_ary);

	echo '</b> <b class="ok">' . $lang['EM_done'] . '</b><br />' . $lang['EM_result'] . " &nbsp; :: \n";

	if ( $errored )
	{
		echo ' <b>' . $lang['EM_failed_sql'] . "</b>\n<ul>";

		for($i = 0; $i < count($error_ary['sql']); $i++)
		{
			echo '<li>' . $lang['EM_err_error'] . ' :: <b>' . $error_ary['error_code'][$i]['message'] . "</b><br />\n";
			echo "SQL &nbsp; :: <b>" . $error_ary['sql'][$i] . "</b><br /><br /></li>\n";
		}
		echo "</ul>\n" ; 
		handle_error( OPEN_FAIL_CRITICAL, $file_list, false, "<p>" . $lang['EM_do_worry'] . "</p>\n") ;
	}
	else
	{
		echo '<b>' . $lang['EM_no_errors'] . "</b>\n";
	}



	//
	// congratufuckinglations
	//
	echo "<br>\n" ;
	echo "<br>\n" ;
	echo '<br><br><h2><span class="ok"><b>' . $lang['EM_install_completed'] . "</b></span></h2>\n" ;
	echo '<p>' . $lang['EM_admin_panel'] . "</p><br>" ;


	page_footer() ;
	exit ;
}


// this should never happen!!
else
{
	echo $lang['EM_err_no_step'] . "<br>\n" ;
	exit ;
}

?>
