/*
 * Ʈ: TLE2Framework
 * ϸ: TLEFramework.java
 * ۼ: 2004. 10. 12.
 */
package tle.framework;

import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.ComponentNotFoundException;
import tle.framework.component.ComponentState;
import tle.framework.component.spi.aamanager.AAManager;
import tle.framework.component.spi.aamanager.AAManagerProxy;
import tle.framework.component.spi.ra.RequestAnalyzer;
import tle.framework.component.spi.rp.RequestProcessor;
import tle.framework.component.spi.uicreator.UICreator;
import tle.framework.configuration.TLEConfig;
import tle.framework.configuration.TLEConfigDigester;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

/**
 * Ʋ ӿũ Ŭ     ۾ Ѵ.
 * <ol>
 *   <li>ӿũ ʱȭ: ӿ ϴ  ʿ Ʈ </li>
 *   <li>ӿũ : ϵ Ʈ </li>
 *   <li>Ŭ̾Ʈ û ޾ TLEController </li>
 * </ol>
 * 
 * @author ֹ
 * @since 2.0
 */
public class TLEFramework {
	private static ComponentState cm = new ComponentState();
	
	/**
	 * Ʋ  
	 */
	private static TLEConfig tleConfig;
	/**
	 * TLEController ۷
	 */
	private static TLEController controller;
	
	/**
	 * configFilePath Ÿ Ϸκ Ʋӿũ   о
	 * Ʈ   ϰ TLEController ʱȭѴ.
	 * 
	 * @param configFilePath   
	 * @throws TLEFrameworkException
	 */
	public static void openFramework(String configFilePath) throws TLEFrameworkException {
		Logger.info("TLEFramework.openFramework():entry");
		
		cm.event(ComponentState.CREATE_EVENT);
		cm.event(ComponentState.INIT_EVENT);
		try {
			ComponentManager componentManager = ComponentManager.getInstance();
			
			// 1- Ϸκ TLEConfig ü 
			TLEConfig config = TLEConfigDigester.create(TLEConfigPathUtil.replace(configFilePath));
			// 2- κ ComponentConfig  о
			Iterator iter = config.getComponentConfigs();
			while (iter.hasNext()) {
				// 3- Ʈ 
				ComponentConfig componentConfig = (ComponentConfig)iter.next();
				componentManager.registComponent(componentConfig);
				
				Logger.info("TLEFramework.openFramework():Regist Component:"+componentConfig.getComponentID());
			}
			// 4-TLEController Ʈ 
			TLEController controller = new TLEController();
			// 5-TLEController 4 ھ Ʈ ˸ 
			controller.setCoreComponents(
					(RequestAnalyzer)componentManager.getComponent(config.getRequestAnalyzerID()),
					(RequestProcessor)componentManager.getComponent(config.getRequestProcessorID()),
					(AAManager)componentManager.getComponent(config.getAAManagerID()),
					(UICreator)componentManager.getComponent(config.getUICreatorID()) );
			// 6-TLEController Ʈ 
			componentManager.registComponent(controller, null);
			Logger.info("TLEFramework.openFramework():Regist TLEController:"+controller.getID());
			Logger.info("TLEFramework.openFramework():RequestAnalyzer:"+controller.getRequestAnalyzerID());
			Logger.info("TLEFramework.openFramework():RequestProcessor:"+controller.getRequestProcessorID());
			Logger.info("TLEFramework.openFramework():AAmanagerID:"+controller.getAAmanagerID());
			Logger.info("TLEFramework.openFramework():UICreator:"+controller.getUICreatorID());
			// 7-TLEController useWrapper Ƽ 
			controller.setUseWrapper(config.getUseWrapper());
			Logger.info("TLEFramework.openFramework():TLEController.useWrapper:"+controller.isUseWrapper());
			
			TLEFramework.tleConfig = tleConfig;
			TLEFramework.controller = controller;
		} catch (Throwable e) {
			cm.event(ComponentState.ERROR_EVENT);
			throw new TLEFrameworkException(e.getMessage(), e);
		}
		cm.event(ComponentState.COMPLETE_EVENT);
		
		cm.event(ComponentState.START_EVENT);
		cm.event(ComponentState.COMPLETE_EVENT);
		
		Logger.info("TLEFramework.openFramework():exit");
	}
	
	/**
	 * ھ Ʈ, TLEController    Ʈ Ѵ.
	 */
	public static void closeFramework() {
		Logger.info("TLEFramework.closeFramework():entry");
		
		if (cm.isRunning()) {
			cm.event(ComponentState.STOP_EVENT);
			
			// ƲƮѷ 4 ھ Ʈ ۷ Ѵ.
			ComponentManager componentManager = ComponentManager.getInstance();
			
			try {
				componentManager.unregistComponent(controller.getRequestAnalyzerID());
				Logger.info("TLEFramework.closeFramework():Unregist RequestAnalyzer");
				componentManager.unregistComponent(controller.getRequestProcessorID());
				Logger.info("TLEFramework.closeFramework():Unregist RequestProcessor");
				componentManager.unregistComponent(controller.getAAmanagerID());
				Logger.info("TLEFramework.closeFramework():Unregist AAManager");
				componentManager.unregistComponent(controller.getUICreatorID());
				Logger.info("TLEFramework.closeFramework():Unregist UICreator");
			} catch (ComponentNotFoundException e) {
				Logger.error("TLEFramework.closeFramework():Fail to Unregist Core Components", e);
			} catch (ComponentException e) {
				Logger.error("TLEFramework.closeFramework():Fail to Unregist Core Components", e);
			}
			try {
				// ƲƮѷ //Ѵ.
				componentManager.unregistComponent(controller.getID());
				Logger.info("TLEFramework.closeFramework():Unregist TLEController");
			} catch (ComponentException e) {
				Logger.error("TLEFramework.closeFramework():Fail to Unregist TLEController", e);
			}
			
			componentManager.unregistAllComponent();
			
			cm.event(ComponentState.COMPLETE_EVENT);
			
			cm.event(ComponentState.CLOSE_EVENT);
			cm.event(ComponentState.COMPLETE_EVENT);
		}
		Logger.info("TLEFramework.closeFramework():exit");
	}
	
	/**
	 * Ŭ̾Ʈ û TLEController Ѵ.
	 * <p>
	 * openFramework() ùٸ   ¿  ޼ҵ带 ȣϸ
	 * ܰ ߻Ѵ.
	 * 
	 * @param request
	 * @param response
	 * @throws TLEFrameworkException TLEFramework (running) ° ƴ   ޼ҵ带 ȣϸ ߻Ѵ.
	 */
	public static void processingRequest(HttpServletRequest request, HttpServletResponse response) throws TLEFrameworkException {
		if (cm.isRunning()) {
			controller.processingRequest(request, response);
		} else {
			throw new TLEFrameworkException("TLEFramework.processingRequest():TLEFramework is not running");
		}
	}
	
	/**
	 * ӿũ ϴ AAManager Ͻø Ѵ.
	 * AAManager ϴ   Ϻθ ؾ ϴ 쿡 
	 *  ޼ҵ尡  AAManagerProxy ؼ  ϸ ȴ.
	 *  
	 * @return  Ʈѷ  AAManager Ͻ
	 */
	public static AAManagerProxy getAAManagerProxy() {
		return controller.getAAManager().getAAManagerProxy();
	}
}