/*
 * Ʈ: TLE2Framework
 * ϸ: ServiceManager.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager;

import tle.framework.component.ComponentConfig;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.Role;
import tle.framework.component.spi.aamanager.Service;
import tle.framework.component.spi.ra.RequestInfo;

/**
 * 񽺸  ϴ Ŵ Ŭ ־  ̽.
 * 
 * @author ֹ
 * @since 2.0
 */
public interface ServiceManager {

	/**
	 * ServiceManager ʱȭѴ.
	 * 
	 * @param config Ʈ ʱȭ 
	 * @throws AAManagerException
	 */
	public void init(ComponentConfig config) throws AAManagerException;
	
	/**
	 * û  شϴ Service ü Ѵ. 
	 * <p>
	 *    null Ѵ.
	 * 
	 * @param ri û 
	 * @return Service
	 */
	public Service getService(RequestInfo ri) throws AAManagerException;
	
	/**
	 * Ư   񽺸   ִ  θ Ѵ.
	 *  
	 * @param role 
	 * @param service 
	 * @return     true
	 */
	public boolean hasGrant(Role role, Service service) throws AAManagerException;
	
	/**
	 *    ٽ о´.
	 * 
	 * @param config Ʈ ʱȭ 
	 * @throws AAManagerException
	 */
	public void reloadConfiguration(ComponentConfig config) throws AAManagerException;
}
