/*
 * Ʈ: TLE2Framework
 * ϸ: ServiceGroupChain.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager.service;

import java.util.List;

import tle.framework.component.spi.aamanager.Role;
import tle.framework.component.spi.aamanager.Service;

/**
 * &lt;service> ±׷ õǾ   û  ߿
 * &lt;group>   ׷ Ϳ ϰ Ǵ û 񽺸 
 * ĳϱ ؼ Ǵ Service.
 *  
 * ServiceGroupChain 
 * 
 * @author ֹ
 * @since 2.0
 */
public class ServiceGroupChain implements Service, HasGrant {
	private String commandID;
	private boolean needAuthentication = false;
	private boolean allRolesUsable = true;
	private List chain = new java.util.ArrayList(5);
	
	void setCommandID(String commandID) {
		this.commandID = commandID;
	}
	
	/**
	 * @see tle.framework.component.spi.aamanager.Service#getCommandID()
	 */
	public String getCommandID() {
		return commandID;
	}

	/**
	 * null Ѵ.
	 * 
	 * @see tle.framework.component.spi.aamanager.Service#getName()
	 */
	public String getName() {
		return null;
	}

	/**
	 * null Ѵ.
	 * 
	 * @see tle.framework.component.spi.aamanager.Service#getDescription()
	 */
	public String getDescription() {
		return null;
	}

	/**
	 * üο ִ   ׷ α ʿ  ʴ 쿡
	 * false ϸ,  ܿ true Ѵ.
	 * 
	 * @see tle.framework.component.spi.aamanager.Service#isNeedAuthentication()
	 */
	public boolean isNeedAuthentication() {
		return needAuthentication;
	}

	/**
	 * üο ִ   ׷  ҿ ؼ 밡 쿡 true ϰ
	 *    false Ѵ.
	 * 
	 * @see tle.framework.component.spi.aamanager.Service#isAllRolesUsable()
	 */
	public boolean isAllRolesUsable() {
		return allRolesUsable;
	}
	
	/**
	 * 񽺱׷쿡 üο ο ׷ ߰Ѵ.
	 * 
	 * @param group
	 */
	public void addServiceGroup(ServiceGroup group) {
		if (group.isNeedAuthentication()) {
			needAuthentication = true;
		}
		if (!group.isAllRolesUsable()) {
			allRolesUsable = false;
		}
		chain.add(group);
	}
	
	/**
	 * üο ִ   ׷쿡 ؼ role    true Ѵ.
	 *  
	 * @param role
	 * @return  ü   ׷   ִ  true
	 */
	public boolean hasGrant(Role role) {
		for (int i = 0 ; i < chain.size() ; i++) {
			ServiceGroup group = (ServiceGroup)chain.get(i);
			if (!group.hasGrant(role.getID())) {
				return false;
			}
		}
		return true;
	}
}
