/*
 * Ʈ: TLE2Framework
 * ϸ: ClientType.java
 * ۼ: 2004. 11. 1
 */
package tle.framework.component.impl.uicreator.client;

import javax.servlet.http.HttpServletRequest;

/**
 * HTTP û  User-Agent мϿ    Ѵ. 
 * 
 * @author ֹ
 * @since 2.0
 */
public class ClientType {
	public static final String MOZILLA = "MOZILLA";
	/**
	 * MS IE
	 */
	public static final String MSIE = "MSIE";
	/**
	 * Netsacpe
	 */
	public static final String NETSCAPE = "NETSCAPE";
	/**
	 * Lynx
	 */
	public static final String LYNX = "LYNX";
	/**
	 * CE MSIE
	 */
	public static final String MSIE_WINCE = "MSIE_CE";
	/**
	 * PC MSIE
	 */
	public static final String MSIE_WINCE_PPC = "MSIE_CE_PPC";
	/**
	 * PC 240X320 Ʈ MSIE
	 */
	public static final String MSIE_WINCE_PPC_240X320 = "MSIE_CE_PPC_240X320";
	
	public static String getClientType(HttpServletRequest request) {
		String userAgent = request.getHeader("User-Agent");
		if (userAgent == null) return null;
		int msieIdx = userAgent.indexOf("MSIE");
		int netscapeIdx = userAgent.indexOf("Netscape");
		int lynxIdx = userAgent.indexOf("Lynx");
		if (msieIdx != -1) {
			boolean wince = userAgent.indexOf("Windows CE") > -1;
			boolean ppc = userAgent.indexOf("PPC") > -1;
			boolean ppc240x320 = userAgent.indexOf("240x320") > -1;
			if (wince && ppc && ppc240x320) {
				return ClientType.MSIE_WINCE_PPC_240X320;
			} else if (wince && ppc) {
				return ClientType.MSIE_WINCE_PPC;
			} else if (wince) {
				return ClientType.MSIE_WINCE;
			} else {
				return ClientType.MSIE;
			}
		} else if (netscapeIdx != -1) {
			return ClientType.NETSCAPE;
		} else if (lynxIdx != -1) {
			return ClientType.LYNX;
		} else {
			return ClientType.MOZILLA;
		}
	}
}
