/*
 * Ʈ: TLE2Framework
 * ϸ: ViewConfig.java
 * ۼ: 2004. 10. 29
 */
package tle.framework.component.impl.uicreator.config;

import java.util.Map;

/**
 * &lt;view> ±  Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class ViewConfig {
	private String viewID;
	private String page;
	private String parentViewID;
	private Map subpageMap;
	private boolean redirect;
	
	private ViewSetConfig viewSet;
	
	public void setViewSetConfig(ViewSetConfig viewSet) {
		this.viewSet = viewSet;
	}
	
	public String getPage() {
		return page;
	}
	public void setPage(String page) {
		this.page = page;
	}
	public String getParentViewID() {
		return parentViewID;
	}
	public void setParentViewID(String parentViewID) {
		this.parentViewID = parentViewID;
	}
	public String getViewID() {
		return viewID;
	}
	public void setViewID(String viewID) {
		this.viewID = viewID;
	}
	public void addSubpage(String name, String page) {
		if (subpageMap == null) subpageMap = new java.util.HashMap();
		subpageMap.put(name, page);
	}
	public String getSubpage(String name) {
		String subPage = null;
		
		if (subpageMap != null) {
			subPage = (String)subpageMap.get(name);
		}
		if (subPage == null && parentViewID != null) {
			ViewConfig parentView = viewSet.getViewConfig(parentViewID);
			subPage = parentView.getSubpage(name);
		}
		return subPage;
	}
	
	/**
	 *   õ page Ѵ.   䰡 page  ʾҰ parent  ִٸ
	 * parent page Ѵ.
	 * <p>
	 * redirect Ƽ true̸, page Ӽ  ϰ Ǹ parent  õȴ. 
	 */
	public String getRelatedPage() {
		if (this.page != null) return this.page;
		if (parentViewID != null && !redirect) {
			ViewConfig parentView = viewSet.getViewConfig(parentViewID);
			return parentView.getRelatedPage();
		}
		return null;
	}
	
	public void setRedirect(boolean redirect) {
		this.redirect = redirect; 
	}
	
	public boolean isRedirect() {
		return redirect;
	}
}
