/*
 * Ʈ: TLE2Framework
 * ϸ: MBeanServerWrapper.java
 * ۼ: 2004. 10. 14
 */
package tle.framework.jmx;

import java.util.Map;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

import tle.framework.component.Component;

/**
 * MBean    Ŭ̴.
 * <p>
 * MBean  ϴ Ŭ  Ŭ ؼ MBean  ϰ ȴ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class MBeanServerWrapper {
	/**
	 * ̱ νϽ
	 */
	private static MBeanServerWrapper instance = new MBeanServerWrapper();

	/**
	 * MBeanServerWrapper Ŭ ̱ νϽ Ѵ.
	 * 
	 * @return MBeanServerWrapper
	 */
	public static MBeanServerWrapper getInstance() {
		return instance;
	}

	/**
	 * MBeanServer ۷
	 */
	private MBeanServer mbeanServer = null;

	/**
	 * &lt;Ʈ, ObjectName>  
	 */
	private Map objectNameMap = new java.util.HashMap();

	/**
	 * MBeanServerFactory.newMBeanServer() ޼ҵ带 Ͽ ο MBean  Ѵ.
	 */
	private MBeanServerWrapper() {
		mbeanServer = MBeanServerFactory.newMBeanServer();
	}
	
	/**
	 *  ΰ ִ MBeanServer Ѵ.
	 * 
	 * @return MBeanServer
	 */
	public MBeanServer getMBeanServer() {
		return mbeanServer;
	}
	
	/**
	 *  Ʈ MBean  Ѵ.
	 * <p>
	 * MBean ü ̸ "TLE:type=Ŭ̸,ID=ƮID" ¸ .
	 * 
	 * @param comp  MBean Ʈ
	 * @throws NotCompliantMBeanException
	 * @throws MBeanRegistrationException
	 * @throws InstanceAlreadyExistsException
	 * @throws MalformedObjectNameException
	 */
	public void registComponent(Component comp)
			throws InstanceAlreadyExistsException, MBeanRegistrationException,
			NotCompliantMBeanException, MalformedObjectNameException {
		ObjectName uniqueID = new ObjectName("TLE:type="
				+ comp.getClass().getName() + ",ID=" + comp.getID());
		mbeanServer.registerMBean(comp, uniqueID);
		
		objectNameMap.put(comp, uniqueID);
	}
	
	/**
	 *  Ʈ MBean  Ѵ.
	 * 
	 * @param comp  Ʈ
	 * @throws MBeanRegistrationException
	 * @throws InstanceNotFoundException ϵ MBean ƴ 쿡 ߻Ѵ.
	 */
	public void unregistComponent(Component comp)
			throws InstanceNotFoundException, MBeanRegistrationException {
		ObjectName uniqueID = (ObjectName) objectNameMap.get(comp);
		mbeanServer.unregisterMBean(uniqueID);
		objectNameMap.remove(comp);
	}
}