/*
 * Decompiled with CFR 0.152.
 */
package tle.webcache;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogSystem;
import tle.webcache.Cache;
import tle.webcache.CacheUtil;
import tle.webcache.CreateCacheEngineException;
import tle.webcache.FailToGetCacheException;
import tle.webcache.MakeCacheException;

public class CacheEngine {
    private static Map engineRepository = new HashMap();
    private String engineName;
    private VelocityEngine ve;
    private String cachePath;
    private String templatePath;
    private String encoding;
    private Map cacheRepository = new HashMap();
    private Object repositorySync = new Object();

    public static void createCacheEngine(String engineName, Properties property) throws CreateCacheEngineException {
        CacheEngine engine = new CacheEngine(engineName, property);
        engineRepository.put(engineName, engine);
    }

    public static CacheEngine getCacheEngine(String engineName) {
        CacheEngine engine = (CacheEngine)engineRepository.get(engineName);
        return engine;
    }

    private CacheEngine(String engineName, Properties property) throws CreateCacheEngineException {
        this.engineName = engineName;
        String templatePath = property.getProperty("tle.webcache.template.path");
        String cachePath = property.getProperty("tle.webcache.cache.path");
        if (templatePath == null) {
            throw new IllegalArgumentException("property not found:tle.webcache.template.path");
        }
        if (cachePath == null) {
            throw new IllegalArgumentException("property not found:tle.webcache.cache.path");
        }
        this.cachePath = cachePath;
        this.templatePath = templatePath;
        this.encoding = property.getProperty("tle.webcache.template.encoding");
        this.ve = new VelocityEngine();
        this.ve.setProperty("runtime.log.logsystem", (Object)new NullLogSystem());
        this.ve.setProperty("resource.loader", (Object)"file");
        this.ve.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        this.ve.setProperty("file.resource.loader.path", (Object)templatePath);
        this.ve.setProperty("file.resource.loader.cache", (Object)"true");
        this.ve.setProperty("file.resource.loader.modificationCheckInterval", (Object)"2");
        try {
            this.ve.init();
        }
        catch (Exception e) {
            throw new CreateCacheEngineException(e.getMessage(), e);
        }
    }

    public String getEngineName() {
        return this.engineName;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String cacheID) throws FailToGetCacheException {
        File cachedFile;
        Cache cache = (Cache)this.cacheRepository.get(cacheID);
        if (cache == null && (cachedFile = CacheUtil.getFile(this.cachePath, cacheID)).exists() && cachedFile.canRead()) {
            try {
                cache = CacheUtil.readFile(this.cachePath, cacheID, this.encoding);
                Object object = this.repositorySync;
                synchronized (object) {
                    this.cacheRepository.put(cache.getCacheID(), cache);
                }
                return cache;
            }
            catch (IOException e) {
                throw new FailToGetCacheException("fail to read cache file:" + cacheID, e);
            }
        }
        if (cache != null) {
            File cacheFile = CacheUtil.getFile(cache);
            if (!cacheFile.exists()) {
                Object e = this.repositorySync;
                synchronized (e) {
                    this.cacheRepository.remove(cacheID);
                }
                cache = null;
            } else if (cache.getLastModified() < cacheFile.lastModified()) {
                try {
                    cache = CacheUtil.readFile(this.cachePath, cacheID, this.encoding);
                    Object e = this.repositorySync;
                    synchronized (e) {
                        this.cacheRepository.put(cache.getCacheID(), cache);
                    }
                }
                catch (IOException e) {
                    throw new FailToGetCacheException("fail to read cache file:" + cacheID, e);
                }
            }
        }
        return cache;
    }

    public void makeCache(String cacheID, Map data) throws MakeCacheException {
        this.makeCache(cacheID, cacheID, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCache(String cacheID, String templateID, Map data) throws MakeCacheException {
        try {
            Template template = null;
            template = this.encoding == null ? this.ve.getTemplate(templateID + ".vm") : this.ve.getTemplate(templateID + ".vm", this.encoding);
            VelocityContext context = new VelocityContext();
            Iterator iter = data.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                context.put(name, data.get(name));
            }
            StringWriter sw = new StringWriter();
            template.merge((Context)context, (Writer)sw);
            Cache cache = new Cache(this.cachePath, cacheID, sw.toString());
            CacheUtil.writeFile(cache, this.encoding);
            Object object = this.repositorySync;
            synchronized (object) {
                this.cacheRepository.put(cache.getCacheID(), cache);
            }
        }
        catch (Exception e) {
            throw new MakeCacheException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String cacheID) {
        if (this.cacheRepository.containsKey(cacheID)) {
            Object object = this.repositorySync;
            synchronized (object) {
                Cache cache = (Cache)this.cacheRepository.remove(cacheID);
                CacheUtil.removeFile(cache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCacheInMemory() {
        Object object = this.repositorySync;
        synchronized (object) {
            this.cacheRepository.clear();
        }
    }
}

