/*
 * $Id: setup.S,v 1.1.1.1 2002/09/19 00:37:09 halite Exp $
 * 
 * Created by Halite on 2002.08.20
 *
 * Many part of setup.S was copied from Linux's.
 */

#include <arch/setup.h>
#include <arch/segment.h>

.code16
.global	_start, begtext, begdata, begbss, endtext, enddata, endbss

.text
begtext:
.data
begdata:
.bss
begbss:

/*
 * toykernel memory map is like this
 *
 * +-------------+ 0
 * |             |
 * +-------------+ 0x10000
 * |             |
 * |   32 bit    |
 * |   kernel    |
 * |             |
 * +-------------+ 0x90000
 * |  bootsect   |	512B
 * +-------------+ 0x90200
 * |    setup    |	2KB
 * +-------------+ 0x90a00
 * | parameters  |	4KB
 * +-------------+ 0x91a00
 * |    stack    |	9.5KB
 * +-------------+ 0x94000
 * |             |
 * |             |
 * +-------------+ 0xfffff
 *
 * After grub boots toykernel, the bootsect is discarded by grub and
 * setup is placed at 0x90000 instead of bootsect.
 * But I reserved 512B for future use.
 * And real 32bit kernel is placed at 0x10000. After running setup,
 * 32bit kernel header executes moving itself to 0x100000 and then
 * jump to there.
 */

.text
_start:
	jmp		setup_start
	
sys_size:	.word 0

setup_start:
	movw	%cs, %ax
	movw	%ax, %ds
	movw	%ax, %ss			# stack is from 0x9000:0x1a00
	movw	$0x4000, %sp		# to 0x9000:0x4000

 	movw	$start_msg, %si
 	call	print_str

/*----------------------------------------------------------------------------
 * get memory information by E802H
 *--------------------------------------------------------------------------*/
 	movw	$get_e820_msg, %si
 	call	print_str

 	xorl	%eax, %eax
	movl	%eax, (E820NR)

	xorl	%ebx, %ebx
	movw	$E820MAP, %di
again_e820:
	movl	$0x0000e820, %eax
	movl	$20, %ecx
	movl	$SMAP, %edx
	pushw	%ds
	popw	%es
	int		$0x15

	jc		e820_error
	cmpl	$SMAP, %eax
	jne		e820_error

	movb	$'.', %al			# print '.' whenever calling e820 function
	call	print_char

good_e820:
	movb	(E820NR), %al
	cmpb	$E820MAX, %al
	jnl		e820_error

	incb	(E820NR)
	movw	%di, %ax
	addw	$20, %ax
	movw	%ax, %di

	cmpl	$0, %ebx
	jne		again_e820

e820_error:
	movw	$new_line, %si
	call	print_str

/*----------------------------------------------------------------------------
 * get memory size by E801H
 *--------------------------------------------------------------------------*/
meme801:
	stc					# fix to work around buggy
	xorw	%cx,%cx		# BIOSes which dont clear/set
	xorw	%dx,%dx		# carry on pass/error of
						# e801h memory size call
						# or merely pass cx,dx though
						# without changing them.
	movw	$0xe801, %ax
	int		$0x15
	jc		mem88

	cmpw	$0x0, %cx			# Kludge to handle BIOSes
	jne		e801usecxdx			# which report their extended
	cmpw	$0x0, %dx			# memory in AX/BX rather than
	jne		e801usecxdx			# CX/DX.  The spec I have read
	movw	%ax, %cx			# seems to indicate AX/BX 
	movw	%bx, %dx			# are more reasonable anyway...

e801usecxdx:
	andl	$0xffff, %edx			# clear sign extend
	shll	$6, %edx				# and go from 64k to 1k chunks
	movl	%edx, (E801MEM)			# store extended memory size
	andl	$0xffff, %ecx			# clear sign extend
 	addl	%ecx, (E801MEM)			# and add lower memory into
									# total size.
/*----------------------------------------------------------------------------
 * old traditional method to get memory.
 * returns 16MB or 64MB only, depending on the bios.
 *--------------------------------------------------------------------------*/
mem88:
	movb	$0x88, %ah
	int		$0x15
	movw	%ax, (MEM88)

/*----------------------------------------------------------------------------
 * copy boot parameters to 32bit kernel's empty_zero_page (4KB)
 *--------------------------------------------------------------------------*/
	movw	$0x1000, %ax
	movw	%ax, %es
	movw	$0x4000, %di
	movw	$E820MAP, %si
	movl	$4096, %ecx
	cld
	rep
	movsb	

#ifdef 0
/*
 * Display all information in E820MAP
 */
 	pushw	%ds
	popw	%es
	xorl	%ecx, %ecx
	movw	$E820NR, %si
	movb	%es:(%si), %cl
	movw	$E820MAP, %si
1:
	pushl	%ecx
	movl	$10, %ecx
2:
	movw	%es:(%si), %dx
	addw	$2, %si
	pushw	%cx
	call	print_hex
	popw	%cx
	loop	2b

	pushw	%si
	movw	$new_line, %si
	call	print_str
	popw	%si
	popl	%ecx
	loop	1b

	movw	(E820NR), %dx
	call	print_hex
	movw	(E801MEM), %dx
	call	print_hex
	movw	(MEM88), %dx
	call	print_hex
	movw	$new_line, %si
	call	print_str

/*
 * Display all information in E820MAP
 */
 	movw	$0x1000, %ax
	movw	%ax, %es
	movl	$5, %ecx
	movw	$0x4000, %si
3:
	pushl	%ecx
	movl	$10, %ecx
4:
	movw	%es:(%si), %dx
	addw	$2, %si
	pushw	%cx
	call	print_hex
	popw	%cx
	loop	4b

	pushw	%si
	movw	$new_line, %si
	call	print_str
	popw	%si
	popl	%ecx
	loop	3b

	movw	%es:(0x4280), %dx
	call	print_hex
	movw	%es:(0x4284), %dx
	call	print_hex
	movw	%es:(0x4288), %dx
	call	print_hex
	movw	$new_line, %si
	call	print_str
5:
	jmp		5b
#endif
/*----------------------------------------------------------------------------
 * set the keyboard repeat rate to maximum
 *--------------------------------------------------------------------------*/
 	movw	$0x0305, %ax
	xorw	%bx, %bx
	int		$0x16

/*----------------------------------------------------------------------------
 * change to protected mode
 * no interrupt allowed, nmi disabled
 *--------------------------------------------------------------------------*/
 	cli
	movb	$0x80, %al
	outb	%al, $0x70

/*----------------------------------------------------------------------------
 * enable A20 line
 * This was adopted from Linux's setup.S
 *--------------------------------------------------------------------------*/
A20_TEST_LOOPS		=  32		# Iterations per wait
A20_ENABLE_LOOPS	= 255		# Total loops to try		

a20_try_loop:

	# First, see if we are on a system with no A20 gate.
a20_none:
	call	a20_test
	jnz	a20_done

	# Next, try the BIOS (INT 0x15, AX=0x2401)
a20_bios:
	movw	$0x2401, %ax
	pushfl					# Be paranoid about flags
	int	$0x15
	popfl

	call	a20_test
	jnz	a20_done

	# Try enabling A20 through the keyboard controller
a20_kbc:
	call	empty_8042

	call	a20_test			# Just in case the BIOS worked
	jnz	a20_done			# but had a delayed reaction.

	movb	$0xD1, %al			# command write
	outb	%al, $0x64
	call	empty_8042

	movb	$0xDF, %al			# A20 on
	outb	%al, $0x60
	call	empty_8042

	# Wait until a20 really *is* enabled; it can take a fair amount of
	# time on certain systems; Toshiba Tecras are known to have this
	# problem.
a20_kbc_wait:
	xorw	%cx, %cx
a20_kbc_wait_loop:
	call	a20_test
	jnz	a20_done
	loop	a20_kbc_wait_loop

	# Final attempt: use "configuration port A"
a20_fast:
	inb	$0x92, %al			# Configuration Port A
	orb	$0x02, %al			# "fast A20" version
	andb	$0xFE, %al			# don't accidentally reset
	outb	%al, $0x92

	# Wait for configuration port A to take effect
a20_fast_wait:
	xorw	%cx, %cx
a20_fast_wait_loop:
	call	a20_test
	jnz	a20_done
	loop	a20_fast_wait_loop

	# A20 is still not responding.  Try frobbing it again.
	# 
	decb	(a20_tries)
	jnz	a20_try_loop
	
	movw	$a20_err_msg, %si
	call	print_str

a20_die:
	hlt
	jmp	a20_die

a20_tries:
	.byte	A20_ENABLE_LOOPS

a20_err_msg:
	.ascii	"fatal error: A20 gate not responding!"
	.byte	13, 10, 0

	# If we get here, all is good
a20_done:

/*---------------------------------------------------------------------
 * set up gdt and idt
 *--------------------------------------------------------------------*/
	movw	$set_gidtr_msg, %si
	call	print_str

	lidt	idt_48
	xorl	%eax, %eax
	movw	%ds, %ax
	shll	$4, %eax
	addl	$gdt, %eax
	movl	%eax, (gdt_48+2)
	lgdt	gdt_48

/*---------------------------------------------------------------------
 * mask all interrupts and irqs
 *--------------------------------------------------------------------*/
 	movb	$0xff, %al
	outb	%al, $0xa1		# mask all interrupts
	call	delay
	movb	$0xfb, %al		# mask all irqs but irq2(cascaded)
	outb	%al, $0x21

/*---------------------------------------------------------------------
 * enable protected mode
 *--------------------------------------------------------------------*/
	movw	$1, %ax
	lmsw	%ax
	jmp		flush_instr

flush_instr:
/*---------------------------------------------------------------------
 * jump to 32bit kernel code
 *--------------------------------------------------------------------*/
 	xorl	%ecx, %ecx
 	movw	sys_size, %cx
	.byte	0x66, 0xea
	.long	0x10000
	.word	__KERNEL_CS

new_line:
	.asciz	"\n\r"
start_msg:
	.asciz	"Starting toykernel...\n\r"
get_e820_msg:
	.asciz	"Get e820 memory information"
set_gidtr_msg:
	.asciz	"Set up gdtr and idtr\n\r"

# print 4 digit hex value
# dx : word value to print
print_hex:
	movw	$0, %bx
	movw	$4, %cx			# 4 hex digits
print_digit:
	rolw	$4, %dx			# rotate to use low 4 bits
	movw	$0xe0f, %ax		# %ah = request
	andb	%dl, %al		# %al = mask for nybble
	addb	$0x90, %al		# convert %al to ascii hex
	daa				# in only four instructions!
	adc	$0x40, %al
	daa
	int	$0x10
	loop	print_digit
	ret

# ds:si - string pointer. string must be end with EOF char
print_str:
	lodsb
	orb		%al, %al
	jz		1f
	call	print_char
	jmp		print_str
1:
	ret
# al : char code to print
print_char:
	pushw	%bx
	xorb	%bh, %bh
	movb	$0x0e, %ah
	int		$0x10
	popw	%bx
	ret

# This routine tests whether or not A20 is enabled.  If so, it
# exits with zf = 0.
#
# The memory address used, 0x200, is the int $0x80 vector, which
# should be safe.

A20_TEST_ADDR = 4*0x80

a20_test:
	pushw	%cx
	pushw	%ax
	xorw	%cx, %cx
	movw	%cx, %fs			# Low memory
	decw	%cx
	movw	%cx, %gs			# High memory area
	movw	$A20_TEST_LOOPS, %cx
	movw	%fs:(A20_TEST_ADDR), %ax
	pushw	%ax
a20_test_wait:
	incw	%ax
	movw	%ax, %fs:(A20_TEST_ADDR)
	call	delay				# Serialize and make delay constant
	cmpw	%gs:(A20_TEST_ADDR+0x10), %ax
	loope	a20_test_wait

	popw	%fs:(A20_TEST_ADDR)
	popw	%ax
	popw	%cx
	ret	

# This routine checks that the keyboard command queue is empty
# (after emptying the output buffers)
#
# Some machines have delusions that the keyboard buffer is always full
# with no keyboard attached...
#
# If there is no keyboard controller, we will usually get 0xff
# to all the reads.  With each IO taking a microsecond and
# a timeout of 100,000 iterations, this can take about half a
# second ("delay" == outb to port 0x80). That should be ok,
# and should also be plenty of time for a real keyboard controller
# to empty.
#

empty_8042:
	pushl	%ecx
	movl	$100000, %ecx

empty_8042_loop:
	decl	%ecx
	jz	empty_8042_end_loop

	call	delay

	inb	$0x64, %al			# 8042 status port
	testb	$1, %al				# output buffer?
	jz	no_output

	call	delay
	inb	$0x60, %al			# read it
	jmp	empty_8042_loop

no_output:
	testb	$2, %al				# is input buffer full?
	jnz	empty_8042_loop			# yes - loop
empty_8042_end_loop:
	popl	%ecx
	ret

# Read the cmos clock. Return the seconds in al
gettime:
	pushw	%cx
	movb	$0x02, %ah
	int	$0x1a
	movb	%dh, %al			# %dh contains the seconds
	andb	$0x0f, %al
	movb	%dh, %ah
	movb	$0x04, %cl
	shrb	%cl, %ah
	aad
	popw	%cx
	ret

# Delay is needed after doing I/O
delay:
	outb	%al,$0x80
	ret

# Descriptor tables
# adopted from Linux's setup.S
gdt:
	.word	0, 0, 0, 0			# dummy
	.word	0, 0, 0, 0			# unused

	.word	0xFFFF				# 4Gb - (0x100000*0x1000 = 4Gb)
	.word	0					# base address = 0
	.word	0x9A00				# code read/exec
	.word	0x00CF				# granularity = 4096, 386
								#  (+5th nibble of limit)

	.word	0xFFFF				# 4Gb - (0x100000*0x1000 = 4Gb)
	.word	0					# base address = 0
	.word	0x9200				# data read/write
	.word	0x00CF				# granularity = 4096, 386
								#  (+5th nibble of limit)
/* 
 * 48 means the size of gdtr and idtr. 48 bit long
 */
idt_48:
	.word	0					# idt limit = 0
	.word	0, 0				# idt base = 0L
gdt_48:
	.word	0x8000				# gdt limit=32768,
								# 4096 GDT entries
	.word	0, 0				# gdt base (filled in later)

.text
endtext:
.data
enddata:
.bss
endbss:

