/*
 * $Id: time.c,v 1.1.1.1 2002/09/19 00:37:09 halite Exp $
 */

#include <toykernel/kernel.h>
#include <toykernel/init.h>
#include <toykernel/time.h>
#include <toykernel/timex.h>
#include <toykernel/sched.h>
#include <toykernel/interrupt.h>
#include <toykernel/irq.h>
#include <arch/ptrace.h>
#include <arch/io.h>
#include <arch/signal.h>

static long last_rtc_update;
int timer_ack;

static inline void do_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	do_timer(regs);
}

static int use_tsc = 0;

static void timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
#if 0
	int count;

	/*
	 * Here we are in the timer irq handler. We just have irqs locally
	 * disabled but we don't know if the timer_bh is running on the other
	 * CPU. We need to avoid to SMP race with it. NOTE: we don' t need
	 * the irq version of write_lock because as just said we have irq
	 * locally disabled. -arca
	 */
	//write_lock(&xtime_lock);

	if (use_tsc)
	{
		/*
		 * It is important that these two operations happen almost at
		 * the same time. We do the RDTSC stuff first, since it's
		 * faster. To avoid any inconsistencies, we need interrupts
		 * disabled locally.
		 */

		/*
		 * Interrupts are just disabled locally since the timer irq
		 * has the SA_INTERRUPT flag set. -arca
		 */
	
		/* read Pentium cycle counter */

		rdtscl(last_tsc_low);

		//spin_lock(&i8253_lock);
		outb_p(0x00, 0x43);     /* latch the count ASAP */

		count = inb_p(0x40);    /* read the latched count */
		count |= inb(0x40) << 8;
		//spin_unlock(&i8253_lock);

		count = ((LATCH-1) - count) * TICK_SIZE;
		delay_at_last_interrupt = (count + LATCH/2) / LATCH;
	}
#endif
 
	do_timer_interrupt(irq, NULL, regs);

	//write_unlock(&xtime_lock);
}

static struct irqaction irq0  = { timer_interrupt, SA_INTERRUPT, 0, "timer", NULL, NULL};

void __init time_init(void)
{
	if (cpu_has_tsc)
		use_tsc = 1;

	setup_irq(0, &irq0);
}

